/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.utils;

import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.CallActivityNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.Button;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmSignDataService;
import com.hotent.bpm.persistence.manager.BpmProStatusManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.persistence.util.BpmStackRelationUtil;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.runtime.params.TaskToRejectVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

public class RejectUtil {
    private static Logger logger = LoggerFactory.getLogger(RejectUtil.class);

    public static TaskToRejectVo toReject(String taskId, String backMode) throws Exception {
        BpmTaskManager bpmTaskManager = (BpmTaskManager)AppUtil.getBean(BpmTaskManager.class);
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        boolean canRejectToStart = false;
        boolean canRejectToAnyNode = false;
        boolean canReject = false;
        boolean canRejectPreAct = false;
        String rejectRecallMode = "normal,direct";
        String defaultRejectMode = "backToStart";
        String defaultRejectRecallMode = "normal";
        DefaultBpmTask task = (DefaultBpmTask)bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)task)) {
            throw new WorkFlowException("\u5f53\u524d\u4efb\u52a1\u5df2\u529e\u7406\uff0c\u4e0d\u53ef\u91cd\u590d\u529e\u7406\uff01");
        }
        RejectUtil.checkTargetNode(null, (BpmTask)task);
        String defId = task.getProcDefId();
        String nodeId = task.getNodeId();
        BpmNodeDef taskNodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        BpmProcessDef bpmProcessDef = bpmDefinitionAccessor.getBpmProcessDef(defId);
        List buttons = BpmUtil.getButtons((BpmNodeDef)taskNodeDef, (DefaultBpmTask)task);
        String backNode = "";
        for (Button button : buttons) {
            if (!"reject".equals(button.getAlias())) continue;
            String rejectMode = button.getRejectMode();
            if (StringUtil.isNotEmpty((String)rejectMode)) {
                List<String> rejectModeList = Arrays.asList(rejectMode.split(","));
                if (rejectModeList.contains("backToStart")) {
                    canRejectToStart = true;
                }
                if (rejectModeList.contains("rejectPre")) {
                    canRejectPreAct = true;
                }
                if (rejectModeList.contains("reject")) {
                    canRejectToAnyNode = true;
                }
            }
            backNode = button.getRejectNode();
            if (button.getRejectRecallMode() != null) {
                rejectRecallMode = button.getRejectRecallMode();
            }
            if (button.getDefaultRejectMode() != null) {
                defaultRejectMode = button.getDefaultRejectMode();
            }
            if (button.getDefaultRejectRecallMode() == null) continue;
            defaultRejectRecallMode = button.getDefaultRejectRecallMode();
        }
        String procInstId = task.getProcInstId();
        String parentDefKey = "";
        BpmProcessInstanceManager processInstanceManager = (BpmProcessInstanceManager)AppUtil.getBean(BpmProcessInstanceManager.class);
        BpmProcessInstance topInstance = processInstanceManager.getTopBpmProcessInstance(procInstId);
        if (BeanUtils.isNotEmpty((Object)topInstance) && !topInstance.getId().equals(procInstId)) {
            parentDefKey = topInstance.getProcDefKey();
        }
        NodeProperties nodeProperties = taskNodeDef.getPropertiesByParentDefKey(parentDefKey);
        if (StringUtil.isEmpty((String)backMode) && StringUtil.isEmpty((String)(backMode = nodeProperties.getBackMode()))) {
            backMode = "normal";
        }
        if (StringUtil.isEmpty((String)backNode)) {
            backNode = nodeProperties.getBackNode();
        }
        TaskToRejectVo taskToRejectVo = new TaskToRejectVo();
        taskToRejectVo.setTaskId(taskId);
        taskToRejectVo.setBackMode(backMode);
        taskToRejectVo.setBackNode(backNode);
        taskToRejectVo.setCanReject(canReject);
        taskToRejectVo.setCanRejectPreAct(canRejectPreAct);
        taskToRejectVo.setCanRejectToStart(canRejectToStart);
        taskToRejectVo.setCanRejectToAnyNode(canRejectToAnyNode);
        taskToRejectVo.setRejectRecallMode(rejectRecallMode);
        taskToRejectVo.setDefaultRejectMode(defaultRejectMode);
        taskToRejectVo.setDefaultRejectRecallMode(defaultRejectRecallMode);
        RejectUtil.setAllowNodes(taskToRejectVo, defId, procInstId, nodeId, backNode);
        HashMap<String, Set<BpmIdentity>> signTaskHisAssignMap = new HashMap<String, Set<BpmIdentity>>();
        ArrayList<BpmNodeDef> allRejectNodes = new ArrayList<BpmNodeDef>();
        allRejectNodes.addAll(taskToRejectVo.getAllowDirectNode());
        allRejectNodes.addAll(taskToRejectVo.getAllowNormalNode());
        if (BeanUtils.isNotEmpty(allRejectNodes)) {
            BpmSignDataService bpmSignDataService = (BpmSignDataService)AppUtil.getBean(BpmSignDataService.class);
            for (BpmNodeDef n : allRejectNodes) {
                if (!NodeType.SIGNTASK.equals((Object)n.getType()) || !"assignHistory".equals(n.getPropertiesByParentDefKey(parentDefKey).getBackUserMode())) continue;
                signTaskHisAssignMap.put(n.getNodeId(), bpmSignDataService.getHistoryAuditorByInstId(task.getProcInstId(), n.getNodeId()));
            }
        }
        taskToRejectVo.setSignTaskHisAssignMap(signTaskHisAssignMap);
        return taskToRejectVo;
    }

    public static TaskToRejectVo setAllowNodes(TaskToRejectVo taskToRejectVo, String defId, String procInstId, String nodeId, String backNode) throws Exception {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("\u83b7\u53d6\u53ef\u9a73\u56de\u8282\u70b9\u8017\u65f6");
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        List bpmnNodeDefs = new ArrayList();
        BpmNodeDef taskNodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        if (BeanUtils.isNotEmpty((Object)taskNodeDef.getParentBpmNodeDef()) && taskNodeDef.getParentBpmNodeDef() instanceof SubProcessNodeDef) {
            SubProcessNodeDef subProcessNodeDef = (SubProcessNodeDef)taskNodeDef.getParentBpmNodeDef();
            bpmnNodeDefs = subProcessNodeDef.getChildBpmProcessDef().getBpmnNodeDefs();
        }
        Set innerSubNodeIds = bpmnNodeDefs.stream().map(n -> n.getNodeId()).collect(Collectors.toSet());
        BpmProStatusManager bpmProStatusManager = (BpmProStatusManager)AppUtil.getBean(BpmProStatusManager.class);
        List nodeIds = bpmProStatusManager.getByInstIdAndRecycleNode(procInstId, "0");
        List<BpmNodeDef> beforeAllNodes = RejectUtil.getBeforeAllNodes(defId, nodeId, nodeIds);
        List nodeDefs = bpmDefinitionAccessor.getNodeDefs(defId);
        List nodeInMultis = BpmUtil.getNodeInMulti((List)nodeDefs);
        ArrayList<BpmNodeDef> allowNormalNode = new ArrayList<BpmNodeDef>();
        ArrayList<BpmNodeDef> allowDirectNode = new ArrayList<BpmNodeDef>();
        ArrayList excludeNormalNode = new ArrayList();
        if (BeanUtils.isNotEmpty((Object)nodeInMultis)) {
            nodeInMultis.stream().filter(nodeInMulti -> nodeInMulti != null).forEach(nodeInMulti -> {
                if (!nodeInMulti.getAllNodeIdInMulti().contains(nodeId)) {
                    excludeNormalNode.addAll(nodeInMulti.getAllNodeIdInMulti());
                }
            });
        }
        List<Object> backNodeList = new ArrayList();
        if (StringUtil.isNotEmpty((String)backNode)) {
            String[] split = backNode.split(",");
            backNodeList = Arrays.asList(split);
        }
        ArrayList finalBackNodeList = backNodeList;
        beforeAllNodes.stream().forEach(bpmNodeDef -> {
            String rejectNodeId = bpmNodeDef.getNodeId();
            RejectUtil.addCanRejectNode(finalBackNodeList, rejectNodeId, allowDirectNode, bpmNodeDef);
            if (excludeNormalNode.contains(rejectNodeId)) {
                return;
            }
            RejectUtil.addCanRejectNode(finalBackNodeList, rejectNodeId, allowNormalNode, bpmNodeDef);
        });
        taskToRejectVo.setAllowDirectNode(allowDirectNode);
        if (BeanUtils.isNotEmpty(innerSubNodeIds)) {
            taskToRejectVo.setAllowNormalNode(allowNormalNode.stream().filter(n -> innerSubNodeIds.contains(n.getNodeId())).collect(Collectors.toList()));
        } else {
            taskToRejectVo.setAllowNormalNode(allowNormalNode);
        }
        taskToRejectVo.setBackNode(backNode);
        RejectUtil.canRejectPreAct(taskToRejectVo, taskNodeDef);
        if (allowDirectNode.size() == 0 && allowNormalNode.size() == 0) {
            taskToRejectVo.setCanRejectToAnyNode(false);
        }
        stopWatch.stop();
        logger.info(stopWatch.getLastTaskName() + "': running time = " + stopWatch.getTotalTimeMillis() + "\u6beb\u79d2");
        return taskToRejectVo;
    }

    private static void canRejectPreAct(TaskToRejectVo taskToRejectVo, BpmNodeDef taskNodeDef) {
        if (taskToRejectVo.isCanRejectPreAct() && BeanUtils.isNotEmpty((Object)taskNodeDef.getParentBpmNodeDef())) {
            taskToRejectVo.setInSubProcess(true);
            boolean canRejectPreAct = true;
            BpmNodeDef parentBpmNodeDef = taskNodeDef.getParentBpmNodeDef();
            if (!(parentBpmNodeDef instanceof SubProcessNodeDef) || ((SubProcessNodeDef)parentBpmNodeDef).isParallel()) {
                // empty if block
            }
            if (parentBpmNodeDef instanceof CallActivityNodeDef && ((CallActivityNodeDef)parentBpmNodeDef).isParallel()) {
                canRejectPreAct = false;
            }
            taskToRejectVo.setCanRejectPreAct(canRejectPreAct);
        }
    }

    private static void addCanRejectNode(List<String> finalBackNodeList, String rejectNodeId, List<BpmNodeDef> allowNode, BpmNodeDef bpmNodeDef) {
        if (BeanUtils.isEmpty(finalBackNodeList) || finalBackNodeList.contains(rejectNodeId)) {
            try {
                allowNode.add((BpmNodeDef)BeanUtils.cloneBean((Object)bpmNodeDef));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseException("\u83b7\u53d6\u53ef\u9a73\u56de\u8282\u70b9\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public static List<BpmNodeDef> getBeforeAllNodes(String defId, String nodeId, List<String> nodeIds) throws Exception {
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean((String)"bpmDefinitionAccessor");
        BpmNodeDef bpmNodeDef = bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        ArrayList<String> findNodeIds = new ArrayList<String>();
        List<Object> resultBeforeNodes = new ArrayList<BpmNodeDef>();
        RejectUtil.collectBeforeNodes(bpmNodeDef, resultBeforeNodes, findNodeIds, nodeIds);
        resultBeforeNodes = resultBeforeNodes.stream().filter(n -> !n.getNodeId().equals(nodeId)).collect(Collectors.toList());
        return RejectUtil.reorderBeforeAllNodes(resultBeforeNodes, nodeIds);
    }

    private static List<BpmNodeDef> reorderBeforeAllNodes(List<BpmNodeDef> resultBeforeNodes, List<String> nodeIds) {
        ArrayList<BpmNodeDef> reorderBeforeAllNodes = new ArrayList<BpmNodeDef>();
        Map nodeId2BpmNodeDef = resultBeforeNodes.stream().collect(Collectors.toMap(BpmNodeDef::getNodeId, Function.identity()));
        nodeIds.stream().forEach(nodeId -> {
            if (nodeId2BpmNodeDef.containsKey(nodeId)) {
                reorderBeforeAllNodes.add((BpmNodeDef)nodeId2BpmNodeDef.get(nodeId));
            }
        });
        return reorderBeforeAllNodes;
    }

    private static void collectBeforeNodes(BpmNodeDef bpmNodeDef, List<BpmNodeDef> resultBeforeNodes, List<String> findNodeIds, List<String> nodeIds) {
        List incomeNodes = bpmNodeDef.getIncomeNodes();
        if (BeanUtils.isEmpty((Object)incomeNodes)) {
            return;
        }
        ArrayList<String> userTaskTypes = new ArrayList<String>();
        userTaskTypes.add(NodeType.USERTASK.getKey());
        userTaskTypes.add(NodeType.SIGNTASK.getKey());
        incomeNodes.stream().forEach(incomeNode -> {
            if (userTaskTypes.contains(incomeNode.getType().getKey()) && !findNodeIds.contains(incomeNode.getNodeId()) && nodeIds.contains(incomeNode.getNodeId())) {
                resultBeforeNodes.add((BpmNodeDef)incomeNode);
            }
            if (!findNodeIds.contains(incomeNode.getNodeId())) {
                findNodeIds.add(incomeNode.getNodeId());
                RejectUtil.collectBeforeNodes(incomeNode, resultBeforeNodes, findNodeIds, nodeIds);
            }
            BpmNodeDef parentBpmNodeDef = incomeNode.getParentBpmNodeDef();
            if (NodeType.START.equals((Object)incomeNode.getType()) && BeanUtils.isNotEmpty((Object)incomeNode.getParentBpmNodeDef())) {
                RejectUtil.collectBeforeNodes(parentBpmNodeDef, resultBeforeNodes, findNodeIds, nodeIds);
            }
        });
    }

    public static void checkTargetNode(String actionName, BpmTask bpmTask) {
        String targetNode = bpmTask.getTargetNode();
        if (StringUtil.isNotEmpty((String)targetNode) && ("reject".equals(actionName) || "backToStart".equals(actionName) || StringUtil.isEmpty((String)actionName))) {
            throw new BaseException("\u5f53\u524d\u4efb\u52a1\u4e0d\u5141\u8bb8\u518d\u6b21\u9a73\u56de");
        }
    }

    public static BpmTask findTaskFromRevokeNodeId(String revokeId, List<DefaultBpmTask> runningTasks) throws Exception {
        DefaultBpmTask findTask = runningTasks.get(0);
        if (runningTasks.size() > 1) {
            List after = BpmStackRelationUtil.getAllAfterListNodeAndTargetNode((String)findTask.getProcDefId(), (String)findTask.getProcInstId(), (String)revokeId);
            Set fromStartNodeIds = after.stream().map(BpmNodeDef::getNodeId).collect(Collectors.toSet());
            Optional<DefaultBpmTask> first = runningTasks.stream().filter(predicate -> fromStartNodeIds.contains(predicate.getNodeId())).findFirst();
            if (first.isPresent()) {
                findTask = first.get();
            }
        }
        return findTask;
    }

    public static void canRevoke(BpmNodeDef node, List<String> nodeIds, String revokeNodeId) {
        HashMap nodeDefHashMap = new HashMap();
        BpmUtil.getBetweenNodes((BpmNodeDef)node, nodeDefHashMap, (String)revokeNodeId);
        if (nodeDefHashMap.isEmpty()) {
            throw new BaseException("\u4e0d\u5141\u8bb8\u64a4\u56de");
        }
        Set entries = nodeDefHashMap.entrySet();
        ArrayList<NodeType> nodeTypeList = new ArrayList<NodeType>();
        nodeTypeList.add(NodeType.USERTASK);
        nodeTypeList.add(NodeType.SIGNTASK);
        nodeTypeList.add(NodeType.SUBPROCESS);
        nodeTypeList.add(NodeType.CALLACTIVITY);
        Set collect = entries.stream().filter(e -> nodeIds.contains(e.getKey()) && nodeTypeList.contains(((BpmNodeDef)e.getValue()).getType()) && !((String)e.getKey()).equals(revokeNodeId)).collect(Collectors.toSet());
        if (collect.size() >= 1) {
            throw new BaseException("\u53ea\u5141\u8bb8\u4e0a\u4e00\u6b65\u64a4\u56de");
        }
    }

    public static String getRejectPreDestination(String taskId, String backHandMode) throws Exception {
        TaskToRejectVo taskToRejectVo = RejectUtil.toReject(taskId, backHandMode);
        if ("direct".equals(taskToRejectVo.getBackMode())) {
            return taskToRejectVo.getAllowDirectNode().get(0).getNodeId();
        }
        return taskToRejectVo.getAllowNormalNode().get(0).getNodeId();
    }
}

