/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.aop;

import com.hotent.base.context.BaseContext;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.runtime.annotation.TaskTransDesensitizeHandle;
import com.hotent.runtime.params.AssignParamObject;
import com.hotent.runtime.params.TaskTransParamObject;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class TaskTransDesensitizeHandleAspect {
    @Resource
    BaseContext baseContext;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Around(value="execution(* *..*Controller.*(..)) && @annotation(com.hotent.runtime.annotation.TaskTransDesensitizeHandle)")
    public Object desensitizeHandle(ProceedingJoinPoint joinPoint) throws Throwable {
        TaskTransDesensitizeHandle taskTransDesensitizeHandle;
        Class<?> targetClass = joinPoint.getTarget().getClass();
        String methodName = joinPoint.getSignature().getName();
        Method[] methods = targetClass.getMethods();
        Object[] args = joinPoint.getArgs();
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            method = methods[i];
            break;
        }
        if (BeanUtils.isNotEmpty((Object)(taskTransDesensitizeHandle = method.getAnnotation(TaskTransDesensitizeHandle.class)))) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof TaskTransParamObject) {
                    TaskTransParamObject params = (TaskTransParamObject)args[i];
                    if (!BeanUtils.isNotEmpty((Object)params.getPermission())) break;
                    ContextThreadUtil.putCommonVars((String)"formPermission", (Object)Base64.getFromBase64((String)params.getPermission()));
                    break;
                }
                if (!(args[i] instanceof AssignParamObject)) continue;
                AssignParamObject params = (AssignParamObject)args[i];
                if (!BeanUtils.isNotEmpty((Object)params.getPermission())) break;
                ContextThreadUtil.putCommonVars((String)"formPermission", (Object)Base64.getFromBase64((String)params.getPermission()));
                break;
            }
        }
        return joinPoint.proceed();
    }
}

