/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.bpm.persistence.manager.BpmReportActManager;
import com.hotent.bpm.persistence.manager.BpmReportListManager;
import com.hotent.bpm.persistence.model.BpmReportAct;
import com.hotent.bpm.persistence.model.BpmReportActVo;
import com.hotent.bpm.persistence.model.BpmReportList;
import com.hotent.bpm.persistence.model.vo.FlowOrgCountVo;
import com.hotent.bpm.persistence.model.vo.FlowUserCountVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import poi.util.ExcelUtil;

@RestController
@RequestMapping(value={"/runtime/report/v1/"})
@Api(tags={"\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790"})
@ApiGroup(group={"group_bpm"})
public class ReportController
extends BaseController<BpmReportListManager, BpmReportList> {
    @Resource
    BpmReportListManager bpmReportListManager;
    @Resource
    BpmReportActManager bpmReportActManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<BpmReportList> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BpmReportList> queryFilter, @ApiParam(name="isPublic", value="\u53ea\u83b7\u53d6\u5df2\u53d1\u5e03\u7684", required=true) @RequestParam Optional<Boolean> isPublic) throws Exception {
        boolean is = isPublic.orElse(false);
        if (is) {
            queryFilter.addFilter("type", (Object)"1", QueryOP.EQUAL);
        }
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("ID_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return this.bpmReportListManager.query(queryFilter);
    }

    @RequestMapping(value={"getList"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public BpmReportList getList(@ApiParam(name="id", value="\u6d41\u7a0b\u5206\u6790id", required=true) @RequestParam String id) throws Exception {
        if (StringUtil.isEmpty((String)id)) {
            return new BpmReportList();
        }
        BpmReportList bpmReportList = (BpmReportList)this.bpmReportListManager.get((Serializable)((Object)id));
        return bpmReportList;
    }

    @RequestMapping(value={"getAct"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u62a5\u8868\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u62a5\u8868\u660e\u7ec6\u9875\u9762")
    @ResponseBody
    public BpmReportAct getAct(@ApiParam(name="id", value="\u62a5\u8868id", required=true) @RequestParam String id) throws Exception {
        if (StringUtil.isEmpty((String)id)) {
            return new BpmReportAct();
        }
        BpmReportAct bpmReportAct = (BpmReportAct)this.bpmReportActManager.get((Serializable)((Object)id));
        return bpmReportAct;
    }

    @RequestMapping(value={"saveList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u4fe1\u606f")
    public CommonResult<String> saveList(@ApiParam(name="bpmReportList", value="\u8ba1\u5212\u540d\u79f0") @RequestBody BpmReportList bpmReportList) throws Exception {
        CommonResult res = this.bpmReportListManager.saveList(bpmReportList);
        return res;
    }

    @RequestMapping(value={"saveAct"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u62a5\u8868\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u62a5\u8868\u4fe1\u606f")
    public CommonResult<String> saveAct(@ApiParam(name="bpmReportAct", value="\u8ba1\u5212\u540d\u79f0") @RequestBody BpmReportActVo bpmReportAct) throws Exception {
        return this.bpmReportActManager.saveAct(bpmReportAct);
    }

    @RequestMapping(value={"removeList"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u8bb0\u5f55")
    public CommonResult<String> removeList(@ApiParam(name="ids", value="\u8054\u7cfb\u4ebaids", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            this.bpmReportListManager.removeByIds(aryIds);
            return new CommonResult(true, "\u5220\u9664\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u6210\u529f", null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u5931\u8d25", null);
        }
    }

    @RequestMapping(value={"removeAct"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u62a5\u8868\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u62a5\u8868\u8bb0\u5f55")
    public CommonResult<String> removeAct(@ApiParam(name="ids", value="\u8054\u7cfb\u4ebaids", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            this.bpmReportActManager.removeByIds(aryIds);
            return new CommonResult(true, "\u5220\u9664\u62a5\u8868\u6210\u529f", null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u62a5\u8868\u5931\u8d25", null);
        }
    }

    @RequestMapping(value={"getEchartsData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7edf\u8ba1\u56fe\u8868\u6570\u636e", httpMethod="GET", notes="\u62a5\u83b7\u53d6\u7edf\u8ba1\u56fe\u8868\u6570\u636e")
    public CommonResult<JsonNode> getEchartsData(@ApiParam(name="reportId", value="\u7edf\u8ba1\u56fe\u8868id", required=true) @RequestParam String reportId) throws Exception {
        return this.bpmReportActManager.getEchartsData(reportId);
    }

    @RequestMapping(value={"getSingleEchartsData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7edf\u8ba1\u56fe\u8868\u6570\u636e", httpMethod="GET", notes="\u62a5\u83b7\u53d6\u7edf\u8ba1\u56fe\u8868\u6570\u636e")
    public CommonResult<JsonNode> getSingleEchartsData(@ApiParam(name="id", value="\u7edf\u8ba1\u56fe\u8868id", required=true) @RequestParam String id) throws Exception {
        return this.bpmReportActManager.getSingleEchartsData(id);
    }

    @RequestMapping(value={"publish"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d1\u5e03\u56fe\u8868\u8bbe\u8ba1", httpMethod="POST", notes="\u53d1\u5e03\u56fe\u8868\u8bbe\u8ba1")
    public CommonResult<String> publish(@ApiParam(name="id", value="\u56fe\u8868ID") @RequestParam String id) throws Exception {
        try {
            BpmReportList bpmReportList = (BpmReportList)this.bpmReportListManager.get((Serializable)((Object)id));
            if (!BeanUtils.isNotEmpty((Object)bpmReportList)) {
                return new CommonResult(true, "\u53d1\u5e03\u5931\u8d25\uff1aID\u4e3a\u3010" + id + "\u3011\u7684\u7edf\u8ba1\u5206\u6790\u4e0d\u5b58\u5728\uff01");
            }
            bpmReportList.setType("1");
            this.bpmReportListManager.update((Model)bpmReportList);
            return new CommonResult(true, "\u53d1\u5e03\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u53d1\u5e03\u5931\u8d25\uff1a" + e.getCause().toString());
        }
    }

    @RequestMapping(value={"listAll"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u5217\u8868\u6570\u636e", httpMethod="GET", notes="\u83b7\u53d6\u6240\u6709\u6d41\u7a0b\u7edf\u8ba1\u5206\u6790\u5217\u8868\u6570\u636e")
    public PageList<BpmReportList> listAll() throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter.addFilter("type", (Object)"1", QueryOP.EQUAL);
        return this.bpmReportListManager.query(queryFilter);
    }

    @RequestMapping(value={"flowOrgCountList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u6309\u90e8\u95e8\u7edf\u8ba1\u53d1\u8d77\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u6309\u90e8\u95e8\u7edf\u8ba1\u53d1\u8d77\u6570\u636e")
    public PageList<FlowOrgCountVo> flowOrgCountList(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.bpmReportActManager.flowOrgCountList(queryFilter);
    }

    @RequestMapping(value={"flowOrgCountListExport"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u6309\u90e8\u95e8\u7edf\u8ba1\u53d1\u8d77\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u6309\u90e8\u95e8\u7edf\u8ba1\u53d1\u8d77\u6570\u636e")
    public void flowOrgCountListExport(HttpServletResponse response, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        try {
            List list = this.bpmReportActManager.getFlowOrgSelectList(queryFilter);
            String tempName = "\u6d41\u7a0b\u6309\u90e8\u95e8\u7edf\u8ba1\u53d1\u8d77\u6570\u636e";
            LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
            exportMaps.put("procDefKey", "\u5de5\u5355key");
            exportMaps.put("procDefName", "\u5de5\u5355\u7c7b\u578b");
            exportMaps.put("instances", "\u5de5\u5355\u6570\u91cf");
            exportMaps.put("hourLong", "\u8fd0\u884c\u65f6\u957f\uff08\u5c0f\u65f6\uff09");
            exportMaps.put("incomplete", "\u672a\u5b8c\u6210\u5de5\u5355\u6570");
            HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, (List)list);
            ExcelUtil.downloadExcel((Workbook)book, (String)tempName, (HttpServletResponse)response);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"flowUserCountList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u6309\u4eba\u5458\u7edf\u8ba1\u53d1\u8d77\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u6309\u4eba\u5458\u7edf\u8ba1\u53d1\u8d77\u6570\u636e")
    public PageList<FlowUserCountVo> flowUserCountList(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.bpmReportActManager.flowUserCountList(queryFilter);
    }

    @RequestMapping(value={"flowUserCountListExport"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u6309\u4eba\u5458\u7edf\u8ba1\u53d1\u8d77\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u6309\u4eba\u5458\u7edf\u8ba1\u53d1\u8d77\u6570\u636e")
    public void flowUserCountListExport(HttpServletResponse response, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        try {
            List list = this.bpmReportActManager.getFlowUserSelectList(queryFilter);
            String tempName = "\u6d41\u7a0b\u6309\u4eba\u5458\u7edf\u8ba1\u53d1\u8d77\u6570\u636e";
            LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
            exportMaps.put("procDefKey", "\u5de5\u5355key");
            exportMaps.put("procDefName", "\u5de5\u5355\u7c7b\u578b");
            exportMaps.put("userId", "\u5904\u7406\u4ebaID");
            exportMaps.put("userName", "\u5904\u7406\u4eba");
            exportMaps.put("avgLong", "\u5e73\u5747\u65f6\u957f\uff08\u5c0f\u65f6\uff09");
            exportMaps.put("overtime", "\u903e\u671f\u5de5\u5355\u6570");
            exportMaps.put("closingRate", "\u95ed\u5355\u7387\uff08%\uff09");
            HSSFWorkbook book = ExcelUtil.exportExcel((String)tempName, (int)24, exportMaps, (List)list);
            ExcelUtil.downloadExcel((Workbook)book, (String)tempName, (HttpServletResponse)response);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"exportXml"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6d41\u7a0b\u56fe\u8868xml", httpMethod="GET", notes="\u5bfc\u51fa\u6d41\u7a0b\u56fe\u8868xml")
    public void exportXml(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="ids", value="\u6d41\u7a0b\u56fe\u8868id", required=true) @RequestParam String ids) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        if (BeanUtils.isNotEmpty((Object)ids)) {
            String[] stringsIds = ids.split(",");
            List<String> list = Arrays.asList(stringsIds);
            String zipName = "ht_bpmReport_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmmss");
            Map strXml = ((BpmReportListManager)this.baseService).exportData(list);
            HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (Map)strXml, (String)zipName);
        }
    }

    @RequestMapping(value={"importCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5\u6d41\u7a0b\u56fe\u8868\u5bfc\u5165\u662f\u5426\u91cd\u590d", httpMethod="POST", notes="\u68c0\u67e5\u6d41\u7a0b\u56fe\u8868\u5bfc\u5165\u662f\u5426\u91cd\u590d")
    public CommonResult<String> importDataCheck(MultipartHttpServletRequest request, HttpServletResponse response) {
        return this.bpmReportListManager.importDataCheck(request, response);
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u56fe\u8868\u5bfc\u5165", httpMethod="POST", notes="\u6570\u636e\u56fe\u8868\u5bfc\u5165")
    public CommonResult<String> importData(Optional<String> cacheFileId) throws Exception {
        return this.bpmReportListManager.importData(cacheFileId);
    }

    @RequestMapping(value={"checkAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u68c0\u67e5\u522b\u540d\u662f\u5426\u5b58\u5728", httpMethod="GET", notes="\u68c0\u67e5\u522b\u540d\u662f\u5426\u5b58\u5728")
    public boolean checkAlias(@ApiParam(name="alias", value="\u6d41\u7a0b\u56fe\u8868\u522b\u540d") @RequestParam String alias) throws Exception {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"alias_", (Object)alias);
        List bpmReports = this.bpmReportListManager.getBaseMapper().selectList((Wrapper)wrapper);
        return bpmReports.size() > 0;
    }
}

