/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.jms;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BadRequestException;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.jms.FlowMessage;
import com.hotent.base.jms.JmsTodoProducer;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bpm.api.constant.ProcessInstanceStatus;
import com.hotent.bpm.api.constant.TaskType;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmPushTodoLogManager;
import com.hotent.bpm.persistence.model.BpmPushTodoLog;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.service.FlowMessageService;
import com.hotent.bpm.todo.util.FlowMessageConvertUtil;
import com.hotent.bpm.todo.vo.InsertCallyTaskVo;
import com.hotent.bpm.todo.vo.InsertDoneTaskVo;
import com.hotent.bpm.todo.vo.OperatorCallyTasksVo;
import com.hotent.bpm.todo.vo.PortalDelTodo;
import com.hotent.bpm.todo.vo.PortalInstance;
import com.hotent.bpm.todo.vo.PortalTaskVo;
import com.hotent.bpm.todo.vo.TodoTaskVo;
import com.hotent.bpm.todo.vo.UpdateFlowsVo;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
@Primary
@ConditionalOnProperty(value={"todo.pushType"}, havingValue="mq", matchIfMissing=false)
public class FlowJmsMessageTransform
implements FlowMessageService {
    private static final Log logger = LogFactory.getLog(FlowJmsMessageTransform.class);
    @Resource
    private JmsTodoProducer defaultJmsTodoProducer;
    @Value(value="${eip.topic.send_todo:q_from_bpm_todo}")
    String sendTaskTopic;
    @Resource
    IUserService userService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmPushTodoLogManager bpmPushTodoLogManager;
    @Value(value="${eip.frontUrl:''}")
    private String frontUrl;
    @Value(value="${eip.mobileUrl:''}")
    private String mobileUrl;

    public void handlerFlowJmsMessage(final FlowMessage msg) {
        this.transactionSynchronizationExecute(new Runnable(){

            @Override
            public void run() {
                FlowJmsMessageTransform.this.toHandlerFlowJmsMessage(msg);
            }
        });
    }

    private void transactionSynchronizationExecute(final Runnable runnable) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    runnable.run();
                }
            });
        } else {
            runnable.run();
        }
    }

    private void toHandlerFlowJmsMessage(FlowMessage flowMessage) {
        String msgStr = "";
        String taskId = "";
        String ownerId = "";
        String ownerName = "";
        try {
            PortalInstance portalInstance = null;
            IUser user = null;
            String content = Base64.getFromBase64((String)flowMessage.getContent());
            switch (flowMessage.getType()) {
                case "inst_new": {
                    portalInstance = FlowMessageConvertUtil.buildMsgInstance((FlowMessage)flowMessage);
                    this.completeInfo(portalInstance);
                    if (ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(portalInstance.getProcessStatus())) {
                        portalInstance.setPcTaskUrl(portalInstance.getDraftUrl());
                    }
                    String status = this.getPortalInstanceStatus(portalInstance.getProcessStatus());
                    portalInstance.setProcessStatus(status);
                    PortalInstance vo = PortalInstance.clone((PortalInstance)portalInstance);
                    msgStr = this.delNullAttr(vo);
                    break;
                }
                case "inst_update": {
                    flowMessage.addTime();
                    portalInstance = FlowMessageConvertUtil.buildMsgInstance((FlowMessage)flowMessage);
                    this.completeInfo(portalInstance);
                    msgStr = this.delNullAttr(portalInstance);
                    break;
                }
                case "task_create": {
                    JsonNode jnode = JsonUtil.toJsonNode((String)content);
                    if (jnode == null || !jnode.isObject()) {
                        logger.warn((Object)("FlowMessage\u4e2d\u7684Content\u5f02\u5e38\uff0c\u4e0d\u80fd\u89e3\u6790\u4e3aObjectNode\u5bf9\u8c61\uff0c\u5176\u5185\u5bb9\u4e3a\uff1a" + content));
                        throw new BadRequestException("FlowMessage\u4e2d\u7684Content\u5f02\u5e38\uff0c\u4e0d\u80fd\u89e3\u6790\u4e3aObjectNode\u5bf9\u8c61\uff0c\u5176\u5185\u5bb9\u4e3a\uff1a" + content);
                    }
                    PortalTaskVo portalTaskVo = (PortalTaskVo)JsonUtil.toBean((String)content, PortalTaskVo.class);
                    UpdateFlowsVo updateFlowsVo = this.getInstanceVo(portalTaskVo);
                    if (updateFlowsVo != null && TaskType.NORMAL.getKey().equals(portalTaskVo.getStatus()) && ProcessInstanceStatus.STATUS_REVOKE.getKey().equals(updateFlowsVo.getFlowStatus())) {
                        updateFlowsVo.setFlowStatus(this.getPortalInstanceStatus(ProcessInstanceStatus.STATUS_RUNNING.getKey()));
                    }
                    updateFlowsVo.setOperatorType(portalTaskVo.getOperatorType());
                    if (!BeanUtils.isNotEmpty((Object)updateFlowsVo)) break;
                    try {
                        portalInstance = this.buildMsgInstance(updateFlowsVo);
                        this.completeInfo(portalInstance);
                        if (ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(portalInstance.getProcessStatus())) {
                            portalInstance.setProcessStatus("approving");
                        }
                        ArrayList<TodoTaskVo> taskList = new ArrayList<TodoTaskVo>();
                        portalTaskVo.setCommuId("0");
                        portalTaskVo.setStatus(StringUtil.isEmpty((String)portalTaskVo.getStatus()) ? "" : portalTaskVo.getStatus());
                        portalTaskVo.setOperatorType(Integer.valueOf(0));
                        if (BeanUtils.isEmpty((Object)portalTaskVo.getTaskArriveDate())) {
                            portalTaskVo.setTaskArriveDate(LocalDateTime.now());
                        }
                        String todoTypeDesc = FlowJmsMessageTransform.getTodoTypeDesc(portalTaskVo.getTodoType(), portalTaskVo.getStatus());
                        portalTaskVo.setTodoType(todoTypeDesc);
                        List identityList = portalTaskVo.getIdentityList();
                        if (BeanUtils.isNotEmpty((Object)identityList)) {
                            identityList.forEach(t -> {
                                portalTaskVo.setTaskApproveId(t.getId());
                                TodoTaskVo todoTaskVo = this.transTodoTaskVo(portalTaskVo, updateFlowsVo);
                                taskList.add(todoTaskVo);
                            });
                            if (taskList.size() == 1) {
                                taskId = ((TodoTaskVo)taskList.get(0)).getTaskId();
                                ownerId = ((TodoTaskVo)taskList.get(0)).getTaskApproveAccount();
                                ownerName = ((TodoTaskVo)taskList.get(0)).getTaskApproveName();
                            }
                        } else {
                            TodoTaskVo todoTaskVo = this.transTodoTaskVo(portalTaskVo, updateFlowsVo);
                            taskId = todoTaskVo.getTaskId();
                            ownerId = todoTaskVo.getTaskApproveAccount();
                            ownerName = todoTaskVo.getTaskApproveName();
                            taskList.add(todoTaskVo);
                        }
                        portalInstance.setTaskList(taskList);
                        msgStr = this.delNullAttr(portalInstance);
                        break;
                    }
                    catch (Exception e) {
                        logger.error((Object)"\u63a8\u9001\u5f85\u529e\u51fa\u9519\uff1a", (Throwable)e);
                        throw new WorkFlowException("\u63a8\u9001\u5f85\u529e\u51fa\u9519\uff1a" + e.getMessage());
                    }
                }
                case "task_remove": {
                    flowMessage.addTime();
                    PortalDelTodo portalDelTodo = (PortalDelTodo)JsonUtil.toBean((String)content, PortalDelTodo.class);
                    msgStr = JsonUtil.toJson((Object)portalDelTodo);
                    break;
                }
                case "task_2_done": {
                    flowMessage.addTime();
                    String taskToDoneContent = Base64.getFromBase64((String)flowMessage.getContent());
                    InsertDoneTaskVo insertDoneTaskVo = (InsertDoneTaskVo)JsonUtil.toBean((String)taskToDoneContent, InsertDoneTaskVo.class);
                    if (BeanUtils.isEmpty((Object)insertDoneTaskVo.getTaskArriveDate())) {
                        insertDoneTaskVo.setTaskArriveDate(LocalDateTime.now());
                    }
                    if (BeanUtils.isEmpty((Object)insertDoneTaskVo.getTaskDoneDate())) {
                        insertDoneTaskVo.setTaskDoneDate(LocalDateTime.now());
                    }
                    String todoTypeDesc = FlowJmsMessageTransform.getTodoTypeDesc(insertDoneTaskVo.getTodoType(), "");
                    insertDoneTaskVo.setTodoType(todoTypeDesc);
                    TodoTaskVo todoTaskDoneVo = this.transTodoTaskDoneVo(insertDoneTaskVo);
                    taskId = todoTaskDoneVo.getTaskId();
                    ownerId = todoTaskDoneVo.getTaskApproveAccount();
                    ownerName = todoTaskDoneVo.getTaskApproveName();
                    msgStr = this.delNullAttr(todoTaskDoneVo);
                    break;
                }
                case "copy_new": {
                    flowMessage.addTime();
                    InsertCallyTaskVo insertCallyTaskVo = (InsertCallyTaskVo)JsonUtil.toBean((String)content, InsertCallyTaskVo.class);
                    if (BeanUtils.isEmpty((Object)insertCallyTaskVo.getTaskArriveDate())) {
                        insertCallyTaskVo.setTaskArriveDate(LocalDateTime.now());
                    }
                    if (BeanUtils.isEmpty((Object)insertCallyTaskVo.getTaskDisposeDate())) {
                        insertCallyTaskVo.setTaskDisposeDate(LocalDateTime.now());
                    }
                    InsertCallyTaskVo insertCallyTask = InsertCallyTaskVo.clone((InsertCallyTaskVo)insertCallyTaskVo);
                    insertCallyTask.setTodoType("\u4f20\u9605");
                    insertCallyTask.setOperatorType("5");
                    DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)insertCallyTaskVo.getInstanceId()));
                    if (BeanUtils.isNotEmpty((Object)instance)) {
                        insertCallyTask.setBusinessType(instance.getProcDefName());
                        insertCallyTask.setBusinessTypeId(instance.getProcDefKey());
                        insertCallyTask.setProcessId(instance.getId());
                    }
                    taskId = insertCallyTask.getCallyId();
                    ownerId = insertCallyTask.getCallyReceiveAccount();
                    ownerName = insertCallyTask.getCallyReceiveName();
                    msgStr = this.delNullAttr(insertCallyTask);
                    break;
                }
                case "copy_handle": {
                    flowMessage.addTime();
                    OperatorCallyTasksVo operatorCallyTasksVo = (OperatorCallyTasksVo)JsonUtil.toBean((String)content, OperatorCallyTasksVo.class);
                    user = this.userService.getUserById(operatorCallyTasksVo.getCallyReceiveId());
                    String url = operatorCallyTasksVo.getMobileTaskUrl();
                    String chaccount = operatorCallyTasksVo.getCallyReceiveId();
                    String chfullname = "";
                    if (BeanUtils.isNotEmpty((Object)user)) {
                        chaccount = user.getUserId();
                        chfullname = user.getFullname();
                    }
                    if (BeanUtils.isEmpty((Object)operatorCallyTasksVo.getTaskArriveDate())) {
                        operatorCallyTasksVo.setTaskArriveDate(LocalDateTime.now());
                    }
                    operatorCallyTasksVo.setCallyReceiveId(chaccount);
                    operatorCallyTasksVo.setCallyReceiveName(chfullname);
                    operatorCallyTasksVo.setMobileTaskUrl(url);
                    DefaultBpmProcessInstance proInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)operatorCallyTasksVo.getInstanceId()));
                    operatorCallyTasksVo.setProcessId(proInstance.getId());
                    taskId = operatorCallyTasksVo.getCallyId();
                    ownerId = operatorCallyTasksVo.getCallyReceiveId();
                    ownerName = operatorCallyTasksVo.getCallyReceiveName();
                    msgStr = JsonUtil.toJson((Object)operatorCallyTasksVo);
                }
            }
        }
        catch (Exception e) {
            throw new WorkFlowException("\u6784\u9020\u63a8\u9001\u7edf\u4e00\u5f85\u529e\u6d88\u606f\u5f02\u5e38\uff1a" + e.getMessage());
        }
        logger.debug((Object)String.format("\u53d1\u9001\u5f85\u529e\u6d88\u606f\uff0c\u3010topic\u3011 %s , \u3010\u6d88\u606f\u5185\u5bb9\u3011 %s", this.sendTaskTopic, msgStr));
        this.defaultJmsTodoProducer.sendToTodoTopic((Object)msgStr, this.sendTaskTopic);
        this.buildLog(flowMessage.getSubject(), flowMessage.getType(), msgStr, "", 1, flowMessage.getInstId(), taskId, ownerId, ownerName);
    }

    private void completeInfo(PortalInstance instance) {
        DefaultBpmProcessInstance defaultBpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instance.getInstanceId()));
        if (defaultBpmProcessInstance != null) {
            ObjectNode orgNode = this.getOrgName(defaultBpmProcessInstance);
            if (BeanUtils.isNotEmpty((Object)orgNode) && orgNode.has("name")) {
                instance.setOrgName(orgNode.asText("name"));
            }
            instance.setDraftUrl(String.format("%s/matter/startProcess?defId=%s&instId=%s&instStatus=draft", this.frontUrl, defaultBpmProcessInstance.getProcDefId(), defaultBpmProcessInstance.getId()));
            instance.setPcTaskUrl(String.format("%s/matter/approvalForm?instId=%s&isReadonly=true&type=done", this.frontUrl, instance.getInstanceId()));
            if (instance.getSupportMobile() == 1) {
                instance.setMobileTaskUrl(String.format("%s/inst/%s", this.mobileUrl, instance.getInstanceId()));
            }
        }
    }

    private String delNullAttr(Object obj) throws IOException {
        ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((Object)obj);
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            if (!((JsonNode)entry.getValue()).isNull() && !BeanUtils.isEmpty(entry.getValue()) || "taskList".equals(entry.getKey())) continue;
            node.put((String)entry.getKey(), "");
        }
        return JsonUtil.toJson((Object)node);
    }

    private String getPortalInstanceStatus(String statu) {
        String status = statu;
        switch (statu) {
            case "add_sign_trans": 
            case "running": {
                status = "approving";
                break;
            }
            case "draft": {
                status = "draft";
                break;
            }
            case "end": {
                status = "complete";
                break;
            }
            case "revokeToStart": {
                status = "revoke";
                break;
            }
            case "manualend": {
                status = "cancel";
            }
        }
        return status;
    }

    private IUser getUserByUserId(String userId) {
        if (StringUtil.isNotEmpty((String)userId)) {
            return this.userService.getUserById(userId);
        }
        return null;
    }

    private UpdateFlowsVo getInstanceVo(PortalTaskVo portalTaskVo) {
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)portalTaskVo.getInstId()));
        if (BeanUtils.isNotEmpty((Object)instance)) {
            String status = this.getPortalInstanceStatus(instance.getStatus());
            UpdateFlowsVo vo = new UpdateFlowsVo(instance.getId(), instance.getCreateBy(), instance.getSubject(), status, instance.getProcDefKey(), instance.getProcDefName(), instance.getCreateTime(), instance.getId(), instance.getProcDefName(), instance.getCreateOrgId(), instance.getCreateOrgId(), instance.getSupportMobile());
            ObjectNode orgNode = this.getOrgName(instance);
            if (BeanUtils.isNotEmpty((Object)orgNode) && orgNode.has("name")) {
                vo.setStarterOrgName(orgNode.asText("name"));
            }
            vo.setOperatorType(portalTaskVo.getOperatorType());
            vo.setOwerAccount(instance.getCreateAccount());
            vo.setOwerName(instance.getCreator());
            if (ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(vo.getFlowStatus())) {
                vo.setTitle(String.format("\u3010%s\u3011%s", "\u8349\u7a3f", vo.getTitle()));
            }
            vo.setFlowType(portalTaskVo.getFlowType());
            vo.setFlowTypeName(portalTaskVo.getFlowTypeName());
            return vo;
        }
        return null;
    }

    private PortalInstance buildMsgInstance(UpdateFlowsVo vo) throws Exception {
        PortalInstance portalInstance = new PortalInstance();
        portalInstance.setInstanceId(vo.getInstanceId());
        portalInstance.setMobileTaskUrl(vo.getMobileTaskUrl());
        portalInstance.setDraftUrl(vo.getDraftUrl());
        portalInstance.setOwerAccount(vo.getOwerAccount());
        portalInstance.setOwerName(vo.getOwerName());
        portalInstance.setPcTaskUrl(vo.getPcTaskUrl());
        portalInstance.setFlowStartDate(vo.getFlowStartDate());
        portalInstance.setFlowStatus(vo.getFlowStatus());
        portalInstance.setSystemCode(vo.getSystemCode());
        portalInstance.setOperatorType((long)vo.getOperatorType().intValue());
        portalInstance.setTitle(vo.getTitle());
        portalInstance.setProcessName(vo.getProcessName());
        portalInstance.setOrgName(vo.getStarterOrgName());
        portalInstance.setOrgNumber(vo.getStarterOrgId());
        portalInstance.setFlowTypeName(vo.getFlowTypeName());
        portalInstance.setFlowType(vo.getProcessKey());
        portalInstance.setProcessName(vo.getProcessName());
        if (StringUtil.isEmpty((String)portalInstance.getFlowType())) {
            portalInstance.setFlowType(vo.getFlowType());
        }
        if (StringUtil.isEmpty((String)portalInstance.getFlowTypeName())) {
            portalInstance.setFlowTypeName(vo.getFlowTypeName());
        }
        return portalInstance;
    }

    public static String getTodoTypeDesc(String type, String status) {
        if (StringUtil.isNotEmpty((String)status)) {
            status = status.toLowerCase();
        }
        String desc = "";
        switch (type) {
            case "task": {
                switch (status) {
                    case "back": {
                        desc = "\u9a73\u56de";
                        break;
                    }
                    case "backtostart": {
                        desc = "\u9a73\u56de";
                        break;
                    }
                    case "deliverto": {
                        desc = "\u4ea4\u529e";
                        break;
                    }
                    case "transforming": {
                        desc = "\u5f81\u8be2";
                        break;
                    }
                    case "transformed": {
                        desc = "\u5f81\u8be2";
                        break;
                    }
                    case "addSign": {
                        desc = "\u52a0\u7b7e";
                    }
                }
                break;
            }
            case "commu": {
                desc = "\u6c9f\u901a";
                break;
            }
            case "forward": {
                desc = "\u8f6c\u53d1";
                break;
            }
            case "copyto": {
                desc = "\u6284\u9001";
                break;
            }
            case "follow": {
                desc = "\u8ddf\u8e2a";
            }
        }
        return desc;
    }

    private TodoTaskVo transTodoTaskVo(PortalTaskVo portalTaskVo, UpdateFlowsVo updateFlowsVo) {
        TodoTaskVo todoTaskVo = new TodoTaskVo();
        todoTaskVo.setTaskId(portalTaskVo.getTaskId());
        todoTaskVo.setInstanceId(portalTaskVo.getInstId());
        DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getByTaskId(portalTaskVo.getTaskId());
        if (checkOpinion != null) {
            todoTaskVo.setTaskArriveDate(checkOpinion.getCreateTime());
            if (checkOpinion.getCompleteTime() != null) {
                todoTaskVo.setTaskDoneDate(checkOpinion.getCompleteTime());
            } else {
                todoTaskVo.setTaskDoneDate(LocalDateTime.now());
            }
        } else {
            todoTaskVo.setTaskArriveDate(portalTaskVo.getTaskArriveDate());
            todoTaskVo.setTaskDoneDate(LocalDateTime.now());
        }
        IUser approveUser = this.getUserByUserId(portalTaskVo.getTaskApproveId());
        if (approveUser != null) {
            todoTaskVo.setTaskApproveAccount(approveUser.getAccount());
            todoTaskVo.setTaskApproveName(approveUser.getFullname());
        }
        todoTaskVo.setTodoType(portalTaskVo.getTodoType());
        todoTaskVo.setPcTaskUrl(String.format("%s/matter/approvalForm?taskId=%s&instId=%s&isGetApprovalBtn=true&key=onlyOneTask&type=fromTodoList", this.frontUrl, todoTaskVo.getTaskId(), todoTaskVo.getInstanceId()));
        if (updateFlowsVo.getSupportMobile() == 1) {
            todoTaskVo.setMobileTaskUrl(String.format("%s/task/%s/0", this.mobileUrl, todoTaskVo.getTaskId()));
        }
        return todoTaskVo;
    }

    private TodoTaskVo transTodoTaskDoneVo(InsertDoneTaskVo insertDoneTaskVo) {
        IUser approveUser;
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)insertDoneTaskVo.getInstanceId()));
        TodoTaskVo todoTaskVo = new TodoTaskVo();
        todoTaskVo.setTaskId(insertDoneTaskVo.getTaskId());
        todoTaskVo.setInstanceId(instance.getId());
        DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getByTaskId(insertDoneTaskVo.getTaskId());
        if (checkOpinion != null) {
            todoTaskVo.setTaskArriveDate(insertDoneTaskVo.getTaskArriveDate());
            if (checkOpinion.getCompleteTime() != null) {
                todoTaskVo.setTaskDoneDate(checkOpinion.getCompleteTime());
            } else {
                todoTaskVo.setTaskDoneDate(insertDoneTaskVo.getTaskDoneDate());
            }
        } else {
            todoTaskVo.setTaskArriveDate(insertDoneTaskVo.getTaskArriveDate());
            todoTaskVo.setTaskDoneDate(insertDoneTaskVo.getTaskDoneDate());
        }
        String todoSkipTaskId = ThreadMsgUtil.getMapMsg((String)"todoSkipTaskId", (boolean)true);
        if (BeanUtils.isNotEmpty((Object)checkOpinion) && StringUtil.isNotEmpty((String)checkOpinion.getQualfiedsAccount()) && StringUtil.isEmpty((String)todoSkipTaskId)) {
            todoTaskVo.setTaskApproveAccount(checkOpinion.getAuditorAccount());
            todoTaskVo.setTaskApproveName(checkOpinion.getAuditorName());
        } else if (StringUtil.isNotEmpty((String)insertDoneTaskVo.getTaskApproveId()) && (approveUser = this.getUserByUserId(insertDoneTaskVo.getTaskApproveId())) != null) {
            todoTaskVo.setTaskApproveAccount(approveUser.getAccount());
            todoTaskVo.setTaskApproveName(approveUser.getFullname());
        }
        if (instance.getSupportMobile() == 1) {
            todoTaskVo.setMobileTaskUrl(String.format("%s/inst/%s/done", this.mobileUrl, todoTaskVo.getInstanceId()));
        }
        todoTaskVo.setPcTaskUrl(String.format("%s/matter/approvalForm?instId=%s&isReadonly=true&type=done", this.frontUrl, instance.getId()));
        todoTaskVo.setFlowType(insertDoneTaskVo.getFlowType());
        todoTaskVo.setFlowTypeName(insertDoneTaskVo.getFlowTypeName());
        return todoTaskVo;
    }

    private ObjectNode getOrgName(DefaultBpmProcessInstance instance) {
        if (BeanUtils.isNotEmpty((Object)instance) && StringUtil.isNotEmpty((String)instance.getCreateOrgId())) {
            try {
                ObjectNode orgNode = this.ucFeignService.getOrgByIdOrCode(instance.getCreateOrgId());
                return orgNode;
            }
            catch (Exception e) {
                logger.error((Object)String.format("\u83b7\u53d6\u7ec4\u7ec7\u3010%s\u3011\u4fe1\u606f\u5931\u8d25\uff1a%s", instance.getCreateOrgId(), e.getMessage()));
            }
        }
        return null;
    }

    private void buildLog(String subject, String type, String content, String exception, int status, String proInstId, String taskId, String ownerId, String ownerName) {
        BpmPushTodoLog log = new BpmPushTodoLog();
        log.setId(UniqueIdUtil.getSuid());
        log.setType(type);
        log.setLogTime(LocalDateTime.now());
        log.setContent(content);
        log.setTitle(subject);
        log.setTryTime(Integer.valueOf(1));
        if (StringUtil.isNotEmpty((String)exception)) {
            if (exception.length() > 4000) {
                exception = exception.substring(0, 4000);
            }
            log.setException(exception);
        }
        log.setStatus(Integer.valueOf(status));
        log.setProcInstId(proInstId);
        log.setTaskId(taskId);
        log.setOwnerId(ownerId);
        log.setOwnerName(ownerName);
        log.setYearsPartition(Integer.valueOf(LocalDateTime.now().getYear()));
        log.setPushType("mq");
        log.setTodoTopic(this.sendTaskTopic);
        this.bpmPushTodoLogManager.create((Model)log);
    }
}

