/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.manager.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.InterfaceEventPostAsync;
import com.hotent.base.context.BaseContext;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.jms.JmsActor;
import com.hotent.base.jms.Notice;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FeignServiceUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.base.vo.AccountOrIdVo;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.BaseActionCmd;
import com.hotent.bpm.api.cmd.ProcessInstCmd;
import com.hotent.bpm.api.constant.EventType;
import com.hotent.bpm.api.constant.InterPoseType;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.constant.ProcessInstanceStatus;
import com.hotent.bpm.api.event.NodeNotifyEvent;
import com.hotent.bpm.api.event.NodeNotifyModel;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.model.form.FormType;
import com.hotent.bpm.api.model.process.def.BpmDefExtProperties;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmVariableDef;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmFormService;
import com.hotent.bpm.api.service.BpmInstService;
import com.hotent.bpm.api.service.BpmTaskService;
import com.hotent.bpm.engine.form.BpmFormFactory;
import com.hotent.bpm.engine.inst.DefaultProcessInstCmd;
import com.hotent.bpm.listener.BusDataUtil;
import com.hotent.bpm.model.form.FormModel;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.persistence.manager.BpmBusLinkManager;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmDefActManager;
import com.hotent.bpm.persistence.manager.BpmDefAuthorizeManager;
import com.hotent.bpm.persistence.manager.BpmDefUserManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmExeStackManager;
import com.hotent.bpm.persistence.manager.BpmInstDeleteLogManager;
import com.hotent.bpm.persistence.manager.BpmInterposeRecoredManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmReadRecordManager;
import com.hotent.bpm.persistence.manager.BpmSecretaryManageManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.manager.BpmTaskNoticeManager;
import com.hotent.bpm.persistence.manager.BpmTaskTurnManager;
import com.hotent.bpm.persistence.manager.BpmTaskUrgentManager;
import com.hotent.bpm.persistence.manager.CopyToManager;
import com.hotent.bpm.persistence.model.BpmBusLink;
import com.hotent.bpm.persistence.model.BpmDefAct;
import com.hotent.bpm.persistence.model.BpmDefUser;
import com.hotent.bpm.persistence.model.BpmInstDeleteLog;
import com.hotent.bpm.persistence.model.BpmInterposeRecored;
import com.hotent.bpm.persistence.model.BpmReadRecord;
import com.hotent.bpm.persistence.model.BpmTaskNotice;
import com.hotent.bpm.persistence.model.BpmTaskUrgent;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.persistence.util.BpmStackRelationUtil;
import com.hotent.bpm.persistence.util.BpmUtil;
import com.hotent.bpm.persistence.util.ServiceUtil;
import com.hotent.bpm.plugin.task.tasknotify.helper.NotifyHelper;
import com.hotent.bpm.util.BoDataUtil;
import com.hotent.bpm.util.MessageUtil;
import com.hotent.i18n.util.I18nUtil;
import com.hotent.runtime.manager.IFlowManager;
import com.hotent.runtime.manager.IProcessManager;
import com.hotent.runtime.manager.InstanceService;
import com.hotent.runtime.model.RelatedInformation;
import com.hotent.runtime.params.CopyToParam;
import com.hotent.runtime.params.DoEndParamObject;
import com.hotent.runtime.params.InfoboxVo;
import com.hotent.runtime.params.StartFlowParamObject;
import com.hotent.runtime.params.ToCopyToVo;
import com.hotent.runtime.vo.BpmInstDeleteVo;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import io.jsonwebtoken.lang.Assert;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.TaskService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InstanceServiceImpl
implements InstanceService {
    @Resource
    CopyToManager copyToManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    IFlowManager iFlowService;
    @Resource
    BpmTaskTurnManager bpmTaskTurnManager;
    @Resource
    BaseContext baseContext;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmBusLinkManager bpmBusLinkManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmDefActManager bpmDefActManager;
    @Resource
    BpmDefUserManager bpmDefUserManager;
    @Resource
    BpmTaskUrgentManager bpmTaskUrgentManager;
    @Resource
    NotifyHelper notifyHelper;
    @Resource
    BpmInstService processInstanceService;
    @Resource
    FormFeignService formRestfulService;
    @Resource
    BpmTaskService bpmTaskService;
    @Resource
    IUserService ius;
    @Resource
    BpmReadRecordManager bpmReadRecordManager;
    @Resource
    IProcessManager iProcessService;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmInstDeleteLogManager bpmInstDeleteLogManager;
    @Resource
    BpmDefAuthorizeManager bpmDefAuthorizeManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    @InterfaceEventPostAsync
    public CommonResult<String> transToMore(CopyToParam copyToParam) throws Exception {
        if (StringUtil.isEmpty((String)copyToParam.getUserId())) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u8981\u4f20\u9605\u7684\u4eba\u5458\uff01", (Object)"");
        }
        String taskName = "\u4f20\u9605\u4efb\u52a1";
        String[] userIds = copyToParam.getUserId().split("\\,");
        String curUserId = ContextUtil.getCurrentUserId();
        ArrayList<String> userList = new ArrayList<String>();
        for (String id : userIds) {
            if (curUserId.equals(id)) {
                return new CommonResult(false, "\u4f20\u9605\u4eba\u4e0d\u80fd\u4e3a\u81ea\u5df1\uff01", (Object)"");
            }
            userList.add(id);
        }
        if (StringUtil.isNotEmpty((String)copyToParam.getInstanceId()) && StringUtil.isEmpty((String)copyToParam.getTaskId())) {
            String[] instIds;
            for (String instId : instIds = copyToParam.getInstanceId().split("\\,")) {
                if (StringUtil.isEmpty((String)copyToParam.getSelectNodeId())) {
                    DefaultBpmCheckOpinion latestOrHistory = this.bpmCheckOpinionManager.getLatestOrHistoryBpmCheckOpinionByInstId(copyToParam.getInstanceId());
                    if (latestOrHistory != null) {
                        copyToParam.setSelectNodeId(latestOrHistory.getTaskKey());
                        taskName = latestOrHistory.getTaskName();
                    }
                } else {
                    List currentCheckOpinionList = this.bpmCheckOpinionManager.getByInstNodeId(copyToParam.getInstanceId(), copyToParam.getSelectNodeId());
                    if (!CollectionUtils.isEmpty((Collection)currentCheckOpinionList)) {
                        taskName = ((DefaultBpmCheckOpinion)currentCheckOpinionList.get(0)).getTaskName();
                    }
                }
                this.noticePublishEvent(instId, copyToParam.getSelectNodeId());
                this.copyToManager.transToMore(instId, userList, copyToParam.getOpinion(), copyToParam.getCopyToType(), copyToParam.getTaskId(), copyToParam.getFiles(), copyToParam.getSelectNodeId(), copyToParam.getFormData(), copyToParam.getParentId(), taskName);
            }
        } else if (StringUtil.isNotEmpty((String)copyToParam.getTaskId()) && StringUtil.isEmpty((String)copyToParam.getInstanceId())) {
            String[] taskIds;
            for (String taskId : taskIds = copyToParam.getTaskId().split("\\,")) {
                DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
                if (BeanUtils.isEmpty((Object)task)) {
                    throw new RuntimeException("\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5904\u7406\uff01");
                }
                this.noticePublishEvent(task.getProcInstId(), task.getNodeId());
                this.copyToManager.transToMore(task.getProcInstId(), userList, copyToParam.getOpinion(), copyToParam.getCopyToType(), taskId, copyToParam.getFiles(), copyToParam.getSelectNodeId(), copyToParam.getFormData(), copyToParam.getParentId(), task.getName());
            }
        } else if ((StringUtil.isNotEmpty((String)copyToParam.getTaskId()) || StringUtil.isNotEmpty((String)copyToParam.getSelectNodeId())) && StringUtil.isNotEmpty((String)copyToParam.getInstanceId())) {
            if (StringUtil.isNotEmpty((String)copyToParam.getTaskId())) {
                DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)copyToParam.getTaskId()));
                taskName = task.getName();
            } else {
                List queryInstIdAndNodeList = this.bpmTaskManager.getByInstIdAndNodeId(copyToParam.getInstanceId(), copyToParam.getSelectNodeId());
                if (!CollectionUtils.isEmpty((Collection)queryInstIdAndNodeList)) {
                    taskName = ((DefaultBpmTask)queryInstIdAndNodeList.get(0)).getName();
                }
            }
            this.noticePublishEvent(copyToParam.getInstanceId(), copyToParam.getSelectNodeId());
            this.copyToManager.transToMore(copyToParam.getInstanceId(), userList, copyToParam.getOpinion(), copyToParam.getCopyToType(), copyToParam.getTaskId(), copyToParam.getFiles(), copyToParam.getSelectNodeId(), copyToParam.getFormData(), copyToParam.getParentId(), taskName);
        }
        BpmUtil.executeRestfulPlugin((String)copyToParam.getTaskId(), (String)copyToParam.getInstanceId(), (EventType)EventType.COPY_TO_MANUAL);
        return new CommonResult(true, "\u4f20\u9605\u6210\u529f", null);
    }

    private void noticePublishEvent(String instId, String selectNodeId) {
        DefaultBpmProcessInstance instance;
        if (StringUtil.isNotEmpty((String)instId) && (instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId))) != null && StringUtil.isNotEmpty((String)selectNodeId)) {
            BaseActionCmd cmd = new BaseActionCmd();
            cmd.addTransitVars("processInstance", (Object)instance);
            NodeNotifyModel model = new NodeNotifyModel(selectNodeId, EventType.TASK_CIRCULATE, instance.getId(), (ActionCmd)cmd);
            NodeNotifyEvent ev = new NodeNotifyEvent(model);
            AppUtil.publishEvent((ApplicationEvent)ev);
        }
    }

    @Override
    public List<ObjectNode> opinionHistory(Optional<String> instId, Optional<String> taskId, Optional<Boolean> isCommu, Optional<Boolean> isRelFlow, Optional<Boolean> isRequest) throws Exception {
        Locale locale;
        BpmNodeDef bpmNodeDef;
        if (!StringUtil.isNotEmpty((String)instId.orElse(null)) || !isRelFlow.orElse(false).booleanValue()) {
            // empty if block
        }
        boolean referOpinion = true;
        if (taskId.isPresent() && StringUtil.isNotEmpty((String)taskId.orElse(null)) && (bpmNodeDef = this.iFlowService.getCurNodeProperties(taskId.get(), "", instId.orElse(""))) instanceof SignNodeDef && bpmNodeDef.getLocalProperties() != null) {
            referOpinion = bpmNodeDef.getLocalProperties().isReferOpinion();
        }
        ArrayList<String> listMyTaskKey = new ArrayList<String>();
        ArrayList<String> listMyOpinionId = new ArrayList<String>();
        IUser userCurrent = ContextUtil.getCurrentUser();
        List<ObjectNode> listObj = this.iFlowService.opinionHistory(instId.orElse(null), taskId.orElse(null), isCommu.orElse(true));
        listObj = this.iFlowService.filterByAuth(listObj, instId.orElse(null), isRequest.orElse(false));
        List<ObjectNode> listOpinion = listObj.parallelStream().filter(object -> !(!object.get("auditor").isNull() && "-1".equals(object.get("auditor").asText()) || "skip".equals(object.get("status").asText()) && "first".equals(object.get("skipType").asText()))).collect(Collectors.toList());
        for (ObjectNode objectNode : listOpinion) {
            if (!OpinionStatus.AWAITING_CHECK.getKey().equals(objectNode.get("status").asText())) continue;
            long currentTime = System.currentTimeMillis();
            Date date = new Date(currentTime += 60000L);
            Date date1 = new Date();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateNowStr = sdf.format(date);
            objectNode.put("completeTime", dateNowStr);
            JsonNode qualfieds = objectNode.get("qualfieds");
            if (BeanUtils.isEmpty((Object)qualfieds)) continue;
            ArrayNode qualfiedsObj = null;
            try {
                qualfiedsObj = (ArrayNode)JsonUtil.toJsonNode((String)qualfieds.asText());
            }
            catch (Exception e) {
                continue;
            }
            BpmIdentityExtractService bpmIdentityExtractService = (BpmIdentityExtractService)AppUtil.getBean(BpmIdentityExtractService.class);
            for (JsonNode jsonNode : qualfiedsObj) {
                ObjectNode identityObj = (ObjectNode)jsonNode;
                DefaultBpmIdentity identity = (DefaultBpmIdentity)JsonUtil.toBean((JsonNode)identityObj, DefaultBpmIdentity.class);
                if (!referOpinion && userCurrent != null && Objects.equals(identity.getId(), userCurrent.getUserId()) && objectNode.get("taskKey") != null) {
                    String taskKey = objectNode.get("taskKey").asText();
                    if (!listMyTaskKey.contains(taskKey)) {
                        listMyTaskKey.add(taskKey);
                    }
                    if (objectNode.get("id") != null && !listMyOpinionId.contains(objectNode.get("id").asText())) {
                        listMyOpinionId.add(objectNode.get("id").asText());
                    }
                }
                if ("user".equals(identity.getType())) continue;
                ArrayList<DefaultBpmIdentity> tempList = new ArrayList<DefaultBpmIdentity>();
                tempList.add(identity);
                List extractUser = bpmIdentityExtractService.extractUser(tempList);
                if (!BeanUtils.isNotEmpty((Object)extractUser)) continue;
                HashSet<String> userNames = new HashSet<String>();
                for (IUser iUser : extractUser) {
                    userNames.add(iUser.getFullname());
                }
                identityObj.put("users", StringUtil.join(userNames));
            }
            objectNode.set("qualfieds", (JsonNode)qualfiedsObj);
        }
        Collections.sort(listOpinion, new Comparator<ObjectNode>(){

            @Override
            public int compare(ObjectNode opinion1, ObjectNode opinion2) {
                String status;
                int res;
                if (BeanUtils.isEmpty((Object)opinion1.get("completeTime"))) {
                    opinion1.put("completeTime", TimeUtil.getCurrentTime());
                }
                if ((res = opinion2.get("completeTime").asText().compareTo(opinion1.get("completeTime").asText())) == 0 && "copyto".equals(status = JsonUtil.getString((JsonNode)opinion1, (String)"status"))) {
                    return -1;
                }
                return res;
            }
        });
        Collections.reverse(listOpinion);
        listOpinion = this.dealOpinions(listOpinion, instId.orElse(null));
        if (!referOpinion && !CollectionUtils.isEmpty(listMyTaskKey)) {
            ArrayList<ObjectNode> newlist = new ArrayList<ObjectNode>();
            for (ObjectNode defaultBpmCheckOpinion : listOpinion) {
                if (defaultBpmCheckOpinion.get("taskKey") != null && listMyTaskKey.contains(defaultBpmCheckOpinion.get("taskKey").asText()) && defaultBpmCheckOpinion.get("id") != null && !listMyOpinionId.contains(defaultBpmCheckOpinion.get("id").asText())) continue;
                newlist.add(defaultBpmCheckOpinion);
            }
            listOpinion = newlist;
        }
        if (!Locale.SIMPLIFIED_CHINESE.equals(locale = LocaleContextHolder.getLocale())) {
            DefaultBpmProcessInstance defaultBpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId.orElse("")));
            if (BeanUtils.isEmpty((Object)defaultBpmProcessInstance)) {
                return listOpinion;
            }
            String defKey = defaultBpmProcessInstance.getProcDefKey();
            for (ObjectNode objectNode : listOpinion) {
                JsonNode opinionJson;
                String mes;
                String key;
                String taskKey = JsonUtil.getString((JsonNode)objectNode, (String)"taskKey");
                if (StringUtil.isNotEmpty((String)taskKey) && !(key = "flow." + defKey + "." + taskKey).equals(mes = I18nUtil.getMessage((String)key, (Locale)locale)) && StringUtil.isNotEmpty((String)mes)) {
                    objectNode.put("taskName", mes);
                }
                if (BeanUtils.isNotEmpty((Object)(opinionJson = objectNode.get("opinion")))) {
                    String opinion = opinionJson.asText();
                    objectNode.put("opinion", StringUtil.isEmpty((String)opinion) ? "" : I18nUtil.handleI18nMessage((String)opinion, (String)opinion, (Locale)locale));
                }
                String completeTime = BeanUtils.isEmpty((Object)objectNode.get("completeTime")) ? TimeUtil.getCurrentTime() : objectNode.get("completeTime").asText();
                String createTime = BeanUtils.isEmpty((Object)objectNode.get("createTime")) ? TimeUtil.getCurrentTime() : objectNode.get("createTime").asText();
                objectNode.put("duration", InstanceServiceImpl.handleDuration(createTime, completeTime));
            }
        }
        return listOpinion;
    }

    public static String handleDuration(String createTime, String completeTime) {
        if (StringUtil.isEmpty((String)completeTime) || StringUtil.isEmpty((String)createTime)) {
            return I18nUtil.handleI18nMessage((String)"Common.LessThen1Minute", (String)"\u5c0f\u4e8e1\u5206\u949f");
        }
        long completeTimeMills = TimeUtil.getMillsByDateTimeString((String)completeTime);
        long createTimeMills = TimeUtil.getMillsByDateTimeString((String)createTime);
        double diff = completeTimeMills - createTimeMills;
        double days = Math.floor(diff / 8.64E7);
        double leave1 = diff % 8.64E7;
        double hours = Math.floor(leave1 / 3600000.0);
        double leave2 = leave1 % 3600000.0;
        double minutes = Math.floor(leave2 / 60000.0);
        double leave3 = leave2 % 60000.0;
        double seconds = Math.round(leave3 / 1000.0);
        StringBuilder timeBuilder = new StringBuilder();
        if (days > 0.0) {
            timeBuilder.append(days).append(I18nUtil.handleI18nMessage((String)(days > 1.0 ? "Common.Days" : "Common.Day"), (String)"\u5929"));
        }
        if (hours > 0.0) {
            timeBuilder.append(hours).append(I18nUtil.handleI18nMessage((String)(hours > 1.0 ? "Common.Hours" : "Common.Hour"), (String)"\u5c0f\u65f6"));
        }
        if (days > 0.0) {
            return timeBuilder.toString();
        }
        if (minutes > 0.0) {
            timeBuilder.append(minutes).append(I18nUtil.handleI18nMessage((String)(minutes > 1.0 ? "Common.Minutes" : "Common.Minute"), (String)"\u5206\u949f"));
        }
        if (hours > 0.0) {
            return timeBuilder.toString();
        }
        if (seconds > 0.0) {
            timeBuilder.append(seconds).append(I18nUtil.handleI18nMessage((String)(seconds > 1.0 ? "Common.Seconds" : "Common.Second"), (String)"\u79d2"));
        }
        if (minutes == 0.0 && seconds >= 0.0) {
            return I18nUtil.handleI18nMessage((String)"Common.LessThen1Minute", (String)"\u5c0f\u4e8e1\u5206\u949f");
        }
        return timeBuilder.toString();
    }

    @Override
    @Transactional
    @InterfaceEventPostAsync
    public Object remove(String ids, boolean authorize) throws Exception {
        String[] idArr = null;
        if (!StringUtil.isEmpty((String)ids)) {
            idArr = ids.split(",");
        }
        if (idArr == null || idArr.length <= 0) {
            return new CommonResult(false, "\u6d41\u7a0b\u5b9e\u4f8bID\u683c\u5f0f\u4e0d\u6b63\u786e", (Object)"");
        }
        HashSet<String> hasDelRightInstIds = null;
        if (!ContextUtil.getCurrentUser().isAdmin() && authorize) {
            hasDelRightInstIds = new HashSet<String>();
            BpmDefAuthorizeManager authorizeManager = (BpmDefAuthorizeManager)AppUtil.getBean(BpmDefAuthorizeManager.class);
            Map actRightMap = authorizeManager.getActRightByUserId(ContextUtil.getCurrentUserId(), "instance", true, true);
            if (BeanUtils.isEmpty((Object)actRightMap) || BeanUtils.isEmpty(actRightMap.get("authorizeRightMap"))) {
                new CommonResult(false, "\u60a8\u6ca1\u6709\u5220\u9664\u8fd9\u4e9b\u6d41\u7a0b\u5b9e\u4f8b\u7684\u6743\u9650", (Object)"");
            }
            HashSet hasDelRightDefs = new HashSet();
            Map authorizeRightMap = (Map)actRightMap.get("authorizeRightMap");
            for (Map.Entry next : authorizeRightMap.entrySet()) {
                ObjectNode value = (ObjectNode)next.getValue();
                if (!value.hasNonNull("i_del") || !value.get("i_del").asBoolean()) continue;
                hasDelRightDefs.add(next.getKey());
            }
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.addFilter("proc_def_key_", (Object)StringUtil.join(hasDelRightDefs, (String)","), QueryOP.IN);
            queryFilter.withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            PageList query = this.bpmProcessInstanceManager.query(queryFilter);
            if (BeanUtils.isEmpty((Object)query) || BeanUtils.isEmpty((Object)query.getRows())) {
                new CommonResult(false, "\u60a8\u6ca1\u6709\u5220\u9664\u8fd9\u4e9b\u6d41\u7a0b\u5b9e\u4f8b\u7684\u6743\u9650", (Object)"");
            }
            for (DefaultBpmProcessInstance inst : query.getRows()) {
                hasDelRightInstIds.add(inst.getId());
            }
        }
        int delFailCounts = 0;
        for (String str : idArr) {
            if (hasDelRightInstIds != null && !hasDelRightInstIds.contains(str)) {
                ++delFailCounts;
                continue;
            }
            this.bpmProcessInstanceManager.removeBpm(str);
            List tasks = this.bpmTaskService.getTasksInstId(str);
            this.iFlowService.doPostAsync(str, tasks, EventType.TASK_REMOVE);
        }
        String mString = "\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b\u6210\u529f";
        if (delFailCounts > 0) {
            mString = "\u6210\u529f\u5220\u9664:" + (idArr.length - delFailCounts) + "\u6761\uff0c\u65e0\u6743\u9650\u5220\u9664:" + delFailCounts + "\u6761";
            if (idArr.length == delFailCounts) {
                return new CommonResult(false, mString, (Object)"");
            }
        }
        return new CommonResult(true, mString, (Object)"");
    }

    @Override
    public List<InfoboxVo> getDefaultInfobox() {
        ArrayList<InfoboxVo> list = new ArrayList<InfoboxVo>();
        try {
            InfoboxVo myTaksBox = this.getMyTaksBox();
            InfoboxVo myMessBox = this.getMyMessBox();
            InfoboxVo myProCopytoBox = this.getMyProCopytoBox();
            InfoboxVo myAlreadyBox = this.getMyAlreadyBox();
            InfoboxVo myCompletedBox = this.getMyCompletedBox();
            InfoboxVo myAccordingMattersBox = this.getMyAccordingMattersBox();
            InfoboxVo myRequestBox = this.getMyRequestBox();
            InfoboxVo myDraftBox = this.getMyDraftBox();
            list.add(myTaksBox);
            list.add(myMessBox);
            list.add(myProCopytoBox);
            list.add(myAlreadyBox);
            list.add(myCompletedBox);
            list.add(myAccordingMattersBox);
            list.add(myRequestBox);
            list.add(myDraftBox);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public Map<String, Object> getDefaultInfoMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            InfoboxVo myTaksBox = this.getMyTaksBox();
            InfoboxVo myAlreadyBox = this.getMyAlreadyBox();
            InfoboxVo myRequestBox = this.getMyRequestBox();
            InfoboxVo myAccordingMattersBox = this.getMyAccordingMattersBox();
            InfoboxVo myNoticeReadBox = this.getMyNoticeTodoRead();
            map.put("myTaks", myTaksBox);
            map.put("myAlready", myAlreadyBox);
            map.put("myAccordingMatters", myAccordingMattersBox);
            map.put("myRequest", myRequestBox);
            map.put("myNoticeRead", myNoticeReadBox);
            AccountOrIdVo AccountOrIdVo2 = new AccountOrIdVo(ContextUtil.getCurrentUserId());
            JsonNode jsonNode = JsonUtil.toJsonNode((Object)AccountOrIdVo2);
            Map userInfoMap = this.ucFeignService.getDetailByAccountOrId((ObjectNode)jsonNode);
            if (BeanUtils.isNotEmpty((Object)userInfoMap)) {
                map.putAll(userInfoMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    @Override
    public ObjectNode printBoAndFormKey(String defId, String nodeId, String procInstId) throws Exception {
        BpmFormService bpmFormService = BpmFormFactory.getFormService((FormType)FormType.PC);
        BpmProcessInstance processInstance = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)procInstId));
        String currDefId = StringUtil.isNotEmpty((String)defId) ? defId : processInstance.getProcDefId();
        FormModel formModel = bpmFormService.getByDefId(currDefId, nodeId, processInstance, false);
        List boDatas = this.boDataService.getDataByInst(processInstance);
        ObjectNode jsondata = (ObjectNode)BoDataUtil.hanlerData((List)boDatas);
        List<ObjectNode> flowOpinionsList = this.getInstanceFlowOpinions(procInstId);
        ArrayNode arrayNode = JsonUtil.getMapper().createArrayNode();
        flowOpinionsList.forEach(item -> arrayNode.add((JsonNode)item));
        ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
        objectNode.put("formName", formModel.getName());
        objectNode.put("formKey", formModel.getFormKey());
        objectNode.set("boData", (JsonNode)jsondata);
        objectNode.put("subject", processInstance.getSubject());
        objectNode.set("flowOpinions", (JsonNode)arrayNode);
        return objectNode;
    }

    @Override
    public ArrayNode getNewsAndBulletin(Optional<QueryFilter> queryFilter) throws Exception {
        ArrayNode messageNews = JsonUtil.getMapper().createArrayNode();
        List<String> dataIds = this.getMessageNewsIds();
        if (BeanUtils.isNotEmpty(dataIds)) {
            PortalFeignService portalFeignService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
            QueryFilter newsFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(15)));
            ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((Object)newsFilter);
            ArrayNode array = JsonUtil.getMapper().createArrayNode();
            QueryField queryField = new QueryField("id", dataIds, QueryOP.IN, FieldRelation.AND);
            array.add(JsonUtil.toJsonNode((Object)queryField));
            node.set("querys", (JsonNode)array);
            ObjectNode dataPageList = portalFeignService.getMessageNews((JsonNode)node);
            if (BeanUtils.isNotEmpty((Object)dataPageList) && BeanUtils.isNotEmpty((Object)dataPageList.get("rows"))) {
                messageNews = (ArrayNode)JsonUtil.toJsonNode((Object)dataPageList.get("rows"));
            }
        }
        return messageNews;
    }

    @Override
    public List<String> getBusLink(ObjectNode params) throws Exception {
        List list;
        ArrayList<String> res = new ArrayList<String>();
        String taskType = params.get("taskType").asText();
        String defKey = params.get("defKey").asText();
        IUser user = ServiceUtil.getUserByAccount((String)this.baseContext.getCurrentUserAccout());
        QueryFilter queryFilter = QueryFilter.build();
        PageBean pageBean = new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE, Boolean.valueOf(true));
        queryFilter.setPageBean(pageBean);
        ArrayList ids = new ArrayList();
        if ("todo".equals(taskType)) {
            queryFilter.addFilter("inst.proc_def_key_", (Object)defKey, QueryOP.EQUAL);
            list = this.bpmTaskManager.getAllByUserId(user.getUserId(), queryFilter);
            list.forEach(item -> ids.add(item.getProcInstId()));
        } else if ("done".equals(taskType)) {
            queryFilter.addFilter("proc_def_key_", (Object)defKey, QueryOP.EQUAL);
            list = this.bpmProcessInstanceManager.getDoneInstList(user.getUserId(), queryFilter).getRows();
            list.forEach(item -> ids.add(item.get("id") + ""));
            System.out.println(list);
        } else if ("request".equals(taskType)) {
            queryFilter.addFilter("proc_def_key_", (Object)defKey, QueryOP.EQUAL);
            list = this.iFlowService.myRequest(this.baseContext.getCurrentUserAccout(), queryFilter).getRows();
            list.forEach(item -> ids.add(item.getId()));
        } else if ("todoRead".equals(taskType)) {
            queryFilter.addFilter("bpm_pro_inst.proc_def_key_", (Object)defKey, QueryOP.EQUAL);
            list = this.iFlowService.getNoticeTodoReadList(this.baseContext.getCurrentUserAccout(), queryFilter).getRows();
            list.forEach(item -> ids.add(item.getProcInstId()));
        } else if ("doneRead".equals(taskType)) {
            DefaultBpmDefinition po = this.bpmDefinitionManager.getMainByDefKey(defKey);
            queryFilter.addFilter("bpm_task_notice_done.PROC_DEF_ID_", (Object)po.getDefId(), QueryOP.EQUAL);
            List list2 = this.iFlowService.getNoticeDoneReadList(this.baseContext.getCurrentUserAccout(), queryFilter).getRows();
            list2.forEach(item -> ids.add(item.getProcInstId()));
        } else if ("myRead".equals(taskType)) {
            queryFilter.addFilter("bpm_pro_inst.proc_def_key_", (Object)defKey, QueryOP.EQUAL);
            list = this.iFlowService.getMyNoticeReadList(this.baseContext.getCurrentUserAccout(), queryFilter).getRows();
            list.forEach(item -> ids.add(item.getProcInstId()));
        } else if ("myDelegate".equals(taskType)) {
            queryFilter.addFilter("hi.proc_def_key_", (Object)defKey, QueryOP.EQUAL);
            list = this.iFlowService.getDelegate(this.baseContext.getCurrentUserAccout(), queryFilter).getRows();
            list.forEach(item -> ids.add(item.getProcInstId()));
        }
        if (ids.size() > 0) {
            QueryFilter busQueryFilter = QueryFilter.build().withQuery(new QueryField("proc_inst_id_", ids, QueryOP.IN));
            busQueryFilter.setPageBean(pageBean);
            List links = this.bpmBusLinkManager.query(busQueryFilter).getRows();
            links.forEach(item -> res.add(item.getBusinesskeyStr()));
        }
        return res;
    }

    @Override
    public List<ObjectNode> getInstRunDataList(String instanceId) throws Exception {
        ArrayList<ObjectNode> runDataList = new ArrayList<ObjectNode>();
        if (StringUtil.isNotEmpty((String)instanceId)) {
            BpmTaskManager bpmTaskManager = (BpmTaskManager)AppUtil.getBean(BpmTaskManager.class);
            TaskService taskService = (TaskService)AppUtil.getBean(TaskService.class);
            BpmInstService bpmInstService = (BpmInstService)AppUtil.getBean(BpmInstService.class);
            BpmProcessInstance bpmProcessInstance = bpmInstService.getProcessInstance(instanceId);
            List tasks = bpmTaskManager.getByInstId(instanceId);
            String defId = bpmProcessInstance.getProcDefId();
            Map params = new HashMap();
            if (tasks.size() > 0) {
                String taskId = ((DefaultBpmTask)tasks.get(0)).getTaskId();
                params = taskService.getVariables(taskId);
            }
            List<BpmVariableDef> bpmVariableList = this.getAllBpmVariableDef(defId);
            for (BpmVariableDef bpmVariableDef : bpmVariableList) {
                ObjectNode object = (ObjectNode)JsonUtil.toJsonNode((Object)bpmVariableDef);
                if (BeanUtils.isNotEmpty(params.get(bpmVariableDef.getVarKey()))) {
                    String dataType = bpmVariableDef.getDataType();
                    String dataValue = params.get(bpmVariableDef.getVarKey()).toString();
                    if ("int".equals(dataType)) {
                        object.put("runVal", Integer.valueOf(dataValue));
                    } else if ("float".equals(dataType)) {
                        object.put("runVal", Float.valueOf(dataValue));
                    } else if ("double".equals(dataType)) {
                        object.put("runVal", Double.valueOf(dataValue));
                    } else {
                        object.put("runVal", dataValue);
                    }
                }
                runDataList.add(object);
            }
        }
        return runDataList;
    }

    @Override
    public PageList<DefaultBpmProcessInstance> getInstDetailList(QueryFilter queryFilter, Optional<String> defId) throws Exception {
        Map actRightMap;
        List querys;
        String dbType;
        if (StringUtil.isNotEmpty((String)defId.orElse(""))) {
            queryFilter.addFilter("proc_def_id_", (Object)defId.orElse(""), QueryOP.EQUAL);
        }
        if ((dbType = SQLUtil.getDbType()).equals("postgresql")) {
            querys = queryFilter.getQuerys();
            ArrayList<Timestamp> objects = new ArrayList<Timestamp>();
            for (QueryField query : querys) {
                if (query.getProperty().indexOf("create") == -1 || !List.class.isInstance(query.getValue())) continue;
                for (String v : (List)query.getValue()) {
                    objects.add(Timestamp.valueOf(v));
                }
                query.setValue(objects);
            }
        }
        querys = queryFilter.getQuerys();
        Iterator iterator = querys.iterator();
        while (iterator.hasNext()) {
            QueryField queryField = (QueryField)iterator.next();
            if (BeanUtils.isEmpty((Object)queryField.getValue())) {
                iterator.remove();
                continue;
            }
            if ("id".equals(queryField.getProperty())) {
                ArrayList<String> instIds = new ArrayList<String>();
                instIds.add("1");
                QueryFilter taskFilter = QueryFilter.build();
                taskFilter.addFilter("task.STATUS_", (Object)"TRANSFORMING", QueryOP.NOT_EQUAL);
                taskFilter.addFilter("task.STATUS_", (Object)"FOLLOW", QueryOP.NOT_EQUAL);
                taskFilter.addFilter("task.ASSIGNEE_ID_", (Object)((String)queryField.getValue()), QueryOP.EQUAL);
                PageList taskquery = this.bpmTaskManager.query(taskFilter);
                for (DefaultBpmTask task : taskquery.getRows()) {
                    instIds.add(task.getProcInstId());
                }
                queryField.setValue(instIds);
                continue;
            }
            if ("createOrgId".equals(queryField.getProperty())) {
                ArrayList<String> orgIds = new ArrayList<String>();
                orgIds.add("1");
                List childOrg = new ArrayList();
                orgIds.add((String)queryField.getValue());
                try {
                    childOrg = this.ucFeignService.getChildOrg((String)queryField.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (BeanUtils.isNotEmpty(childOrg)) {
                    for (ObjectNode objectNode : childOrg) {
                        orgIds.add(objectNode.get("id").asText());
                    }
                }
                queryField.setValue(orgIds);
                continue;
            }
            if (!"authFilterId".equals(queryField.getProperty())) continue;
            queryField.setProperty("id");
        }
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() && !this.setNoAuthFilter(queryFilter).booleanValue()) {
            return new PageList((IPage)new Page());
        }
        queryFilter.addParams("isAdmin", (Object)(user.isAdmin() ? 1 : 0));
        PageList<DefaultBpmProcessInstance> instanceList = this.iFlowService.getInstanceList(this.baseContext.getCurrentUserAccout(), queryFilter);
        if (!user.isAdmin() && (actRightMap = this.bpmDefAuthorizeManager.getActRightByUserId(user.getUserId(), "management", true, true)).containsKey("authorizeRightMap")) {
            Map authorizeRightMap = (Map)actRightMap.get("authorizeRightMap");
            for (DefaultBpmProcessInstance row : instanceList.getRows()) {
                ObjectNode authorRight;
                if (authorizeRightMap.containsKey(row.getProcDefKey()) && BeanUtils.isNotEmpty((Object)(authorRight = (ObjectNode)authorizeRightMap.get(row.getProcDefKey()))) && JsonUtil.getBoolean((ObjectNode)authorRight, (String)"m_edit")) continue;
                row.setCanJumpInstance(Boolean.valueOf(false));
            }
        }
        return instanceList;
    }

    @Override
    public CommonResult<Boolean> getSponsorRevokeByInstId(String instId) throws Exception {
        List tasks;
        DefaultBpmProcessInstance parentInstance;
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        if (BeanUtils.isEmpty((Object)instance)) {
            throw new BaseException(String.format("\u6839\u636e\u5b9e\u4f8bid\u3010%s\u3011\u672a\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b", instId));
        }
        String startFlowUserId = instance.getCreateBy();
        String parentDefKey = "";
        if (StringUtil.isNotZeroEmpty((String)instance.getParentInstId()) && BeanUtils.isNotEmpty((Object)(parentInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instance.getParentInstId()))))) {
            parentDefKey = parentInstance.getProcDefKey();
            startFlowUserId = parentInstance.getCreateBy();
        }
        if (BeanUtils.isEmpty((Object)(tasks = this.bpmTaskManager.getByInstId(instId))) && !ProcessInstanceStatus.STATUS_END.getKey().equals(instance.getStatus())) {
            return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)false);
        }
        HashMap<String, DefaultBpmTask> nodeMaps = new HashMap<String, DefaultBpmTask>();
        for (DefaultBpmTask task : tasks) {
            nodeMaps.put(task.getNodeId(), task);
        }
        boolean isSponsorRevoke = false;
        boolean previousRevoke = false;
        boolean isReadRevoke = false;
        boolean isRead = false;
        String currentUserId = ContextUtil.getCurrentUserId();
        List allNodeDef = this.bpmDefinitionAccessor.getAllNodeDef(instance.getProcDefId());
        String startNodeId = ((BpmNodeDef)this.bpmDefinitionAccessor.getStartNodes(instance.getProcDefId()).get(0)).getNodeId();
        if (BeanUtils.isNotEmpty((Object)tasks)) {
            for (BpmNodeDef bpmNodeDef : allNodeDef) {
                List preNodeAuditors;
                if (!nodeMaps.containsKey(bpmNodeDef.getNodeId())) continue;
                NodeProperties nodeProperties = bpmNodeDef.getPropertiesByParentDefKey(parentDefKey);
                if (BeanUtils.isEmpty((Object)nodeProperties)) {
                    nodeProperties = bpmNodeDef.getLocalProperties();
                }
                isSponsorRevoke = nodeProperties.isSponsorRevoke();
                DefaultBpmTask bpmTask = (DefaultBpmTask)nodeMaps.get(bpmNodeDef.getNodeId());
                String fromNodeId = this.bpmExeStackManager.getCurrentTaskFromUserNodeId(allNodeDef, bpmTask.getId());
                if (StringUtil.isEmpty((String)fromNodeId)) {
                    fromNodeId = this.bpmExeStackManager.getCurrentTaskFromNodeId(bpmTask.getId());
                }
                if (BeanUtils.isNotEmpty((Object)(preNodeAuditors = this.bpmCheckOpinionManager.getAuditorByInstNodeId(bpmTask.getProcInstId(), fromNodeId))) && preNodeAuditors.contains(currentUserId)) {
                    previousRevoke = nodeProperties.isPreviousRevoke();
                }
                if (startNodeId.equals(fromNodeId) || previousRevoke) {
                    DefaultBpmDefinition def = this.bpmDefinitionManager.getById(instance.getProcDefId());
                    DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getByTaskId(bpmTask.getId());
                    if (Objects.isNull(checkOpinion)) {
                        checkOpinion = this.bpmCheckOpinionManager.getByTaskIdStatus(bpmTask.getId(), OpinionStatus.INQU.toString());
                    }
                    isReadRevoke = Boolean.valueOf(def.getIsReadRevoke());
                    boolean bl = checkOpinion != null ? checkOpinion.getIsRead() == 1 : (isRead = isRead);
                }
                if (!BeanUtils.isNotEmpty((Object)bpmNodeDef.getParentBpmNodeDef())) continue;
                return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)false);
            }
        } else if (ProcessInstanceStatus.STATUS_END.getKey().equals(instance.getStatus())) {
            BpmProcessDef bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(instance.getProcDefId());
            BpmDefExtProperties prop = bpmProcessDef.getProcessDefExt().getExtProperties();
            if (!prop.isEndRevoke()) {
                return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)false);
            }
            List endOpinions = this.bpmCheckOpinionManager.getBeforeEnd(instId, currentUserId);
            HashMap<String, Boolean> preRvkMap = new HashMap<String, Boolean>();
            for (BpmNodeDef bpmNodeDef : allNodeDef) {
                NodeProperties localProperties = bpmNodeDef.getLocalProperties();
                boolean isPreviousRevoke = localProperties.isPreviousRevoke();
                preRvkMap.put(bpmNodeDef.getNodeId(), isPreviousRevoke);
            }
            for (DefaultBpmCheckOpinion endOpinion : endOpinions) {
                Boolean preRevoke = (Boolean)preRvkMap.get(endOpinion.getTaskKey());
                if (!preRevoke.booleanValue()) continue;
                return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)true);
            }
            return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)false);
        }
        boolean result = false;
        if (currentUserId.equals(startFlowUserId) && isSponsorRevoke) {
            result = true;
        }
        if (previousRevoke && (isReadRevoke || !isRead)) {
            result = true;
        }
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)result);
    }

    @Override
    public CommonResult<String> saveFormData(StartFlowParamObject startFlowParamObject) {
        startFlowParamObject.setAccount(this.baseContext.getCurrentUserAccout());
        try {
            DefaultBpmProcessInstance defaultBpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)startFlowParamObject.getProInstId()));
            String busData = "";
            if (StringUtil.isNotEmpty((String)startFlowParamObject.getData())) {
                busData = Base64.getFromBase64((String)startFlowParamObject.getData());
            }
            DefaultProcessInstCmd processCmd = new DefaultProcessInstCmd();
            processCmd.setBusData(busData);
            BusDataUtil.handSaveBoData((BpmProcessInstance)defaultBpmProcessInstance, (ActionCmd)processCmd);
            BpmInterposeRecored bpmInterposeRecored = new BpmInterposeRecored(startFlowParamObject.getProInstId(), startFlowParamObject.getExpression(), InterPoseType.MODIFY_DATA, startFlowParamObject.getExpression());
            BpmInterposeRecoredManager manager = (BpmInterposeRecoredManager)AppUtil.getBean(BpmInterposeRecoredManager.class);
            manager.create((Model)bpmInterposeRecored);
            return new CommonResult("\u4fee\u6539\u8868\u5355\u6570\u636e\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, e.getMessage());
        }
    }

    @Override
    public List<ObjectNode> getHasAuthFlowList(QueryFilter queryFilter) throws Exception {
        queryFilter.withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(-1)));
        PageList<DefaultBpmDefinition> query = this.iFlowService.newProcess(this.baseContext.getCurrentUserAccout(), queryFilter);
        HashMap<String, ArrayNode> flowMap = new HashMap<String, ArrayNode>();
        ArrayList<ObjectNode> parentTypeList = new ArrayList<ObjectNode>();
        if (BeanUtils.isEmpty((Object)query.getRows())) {
            return parentTypeList;
        }
        for (DefaultBpmDefinition def : query.getRows()) {
            ArrayNode list = null;
            list = flowMap.containsKey(def.getTypeId()) ? (ArrayNode)flowMap.get(def.getTypeId()) : JsonUtil.getMapper().createArrayNode();
            list.add(JsonUtil.toJsonNode((Object)def));
            flowMap.put(def.getTypeId(), list);
        }
        PortalFeignService portalFeignService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
        QueryFilter typefilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        typefilter.addFilter("ID_", (Object)StringUtil.join(new ArrayList(flowMap.keySet()), (String)","), QueryOP.IN);
        FieldSort fieldSort = new FieldSort("sn_");
        typefilter.withSorter(fieldSort);
        ObjectNode allSysType = portalFeignService.getAllSysType(typefilter);
        ArrayNode typeList = (ArrayNode)allSysType.get("rows");
        for (JsonNode jsonNode : typeList) {
            ObjectNode typeNode = (ObjectNode)jsonNode;
            if ("6".equals(typeNode.get("parentId").asText())) {
                parentTypeList.add(typeNode);
            }
            typeNode.set("flowList", (JsonNode)flowMap.get(jsonNode.get("id").asText()));
        }
        block2: for (JsonNode jsonNode : typeList) {
            for (ObjectNode parentType : parentTypeList) {
                if (jsonNode.get("path").asText().indexOf(parentType.get("path").asText()) != 0 || jsonNode.get("path").asText().equals(parentType.get("path").asText())) continue;
                ArrayNode flowlit = (ArrayNode)parentType.get("flowList");
                flowlit.addAll((ArrayNode)jsonNode.get("flowList"));
                parentType.set("flowList", (JsonNode)flowlit);
                continue block2;
            }
        }
        return parentTypeList;
    }

    @Override
    public PageList<DefaultBpmProcessInstance> relatedProcess(QueryFilter queryFilter) {
        String auditor = ContextUtil.getCurrentUserId();
        ArrayList<String> strauditor = new ArrayList<String>();
        IPage list = this.bpmProcessInstanceManager.getById(auditor, queryFilter);
        if (list.getRecords().size() > 0) {
            for (DefaultBpmProcessInstance instance : list.getRecords()) {
                if (!StringUtil.isNotEmpty((String)instance.getCreateBy())) continue;
                strauditor.add(instance.getCreateBy());
            }
        }
        List pathNames = FeignServiceUtil.getPathNames(strauditor);
        for (DefaultBpmProcessInstance instance : list.getRecords()) {
            for (Map jobNamesMap : pathNames) {
                if (!((String)jobNamesMap.get("userId")).equals(instance.getCreateBy())) continue;
                if (StringUtil.isNotEmpty((String)((String)jobNamesMap.get("pathName")))) {
                    String pathName = ((String)jobNamesMap.get("pathName")).replace("\u65ed\u8f89/\u65ed\u8f89\u96c6\u56e2/", "");
                    instance.setCreateOrgPath(pathName);
                }
                if (!StringUtil.isEmpty((String)instance.getCreator())) continue;
                instance.setCreator((String)jobNamesMap.get("fullName"));
            }
        }
        return new PageList(list);
    }

    @Override
    public CommonResult<String> sendUrgentByInstId(BpmTaskUrgent bpmTaskUrgent) {
        try {
            for (String key : bpmTaskUrgent.getAppointeeObj().keySet()) {
                bpmTaskUrgent.setNodeId(key);
                StringBuilder appointeeId = new StringBuilder();
                StringBuilder appointeeName = new StringBuilder();
                List list = (List)bpmTaskUrgent.getAppointeeObj().get(key);
                for (int i = 0; i < list.size(); ++i) {
                    Map map = (Map)list.get(i);
                    appointeeId = appointeeId.append(map.get("userId").toString()).append(",");
                    appointeeName = appointeeName.append(map.get("fullname").toString()).append(",");
                    bpmTaskUrgent.setNodeName(map.get("nodeName").toString());
                }
                bpmTaskUrgent.setAppointee(appointeeName.substring(0, appointeeName.length() - 1));
                bpmTaskUrgent.setAppointeeId(appointeeId.substring(0, appointeeId.length() - 1));
                this.sendUrgent(bpmTaskUrgent);
            }
            return new CommonResult(true, "\u50ac\u529e\u6210\u529f", (Object)"");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u50ac\u529e\u5931\u8d25", (Object)e.getMessage());
        }
    }

    @Override
    @InterfaceEventPostAsync
    public CommonResult<String> sendBpmTaskUrgent(BpmTaskUrgent bpmTaskUrgent) {
        try {
            return this.sendUrgent(bpmTaskUrgent);
        }
        catch (Exception e) {
            return new CommonResult(false, I18nUtil.handleI18nMessage((String)"taskUrgeFailed", (String)"\u50ac\u529e\u5931\u8d25"), (Object)e.getMessage());
        }
    }

    private CommonResult<String> sendUrgent(BpmTaskUrgent bpmTaskUrgent) throws Exception {
        QueryFilter taskFilter = QueryFilter.build();
        taskFilter.addFilter("PROC_INST_ID_", (Object)bpmTaskUrgent.getInstId(), QueryOP.IN);
        taskFilter.addFilter("task.STATUS_", (Object)"TRANSFORMING", QueryOP.NOT_EQUAL);
        taskFilter.addFilter("task.NODE_ID_", (Object)bpmTaskUrgent.getNodeId(), QueryOP.EQUAL);
        taskFilter.addFilter("task.STATUS_", (Object)"FOLLOW", QueryOP.NOT_EQUAL);
        taskFilter.addFilter("task.STATUS_", (Object)"COPYTO", QueryOP.NOT_EQUAL);
        PageList taskList = this.bpmTaskManager.query(taskFilter);
        if (BeanUtils.isEmpty((Object)taskList) && taskList.getRows().size() == 0) {
            return new CommonResult(false, I18nUtil.handleI18nMessage((String)"taskUrgeFailedNoTaskNode", (String)"\u50ac\u529e\u5931\u8d25\uff0c\u6240\u9009\u8282\u70b9\u5df2\u65e0\u4efb\u52a1\u5b58\u5728"), (Object)"");
        }
        HashSet<String> appointeeIdSet = new HashSet<String>(Arrays.asList(bpmTaskUrgent.getAppointeeId().split(",")));
        String defKey = ((DefaultBpmTask)taskList.getRows().get(0)).getProcDefKey();
        String subject = ((DefaultBpmTask)taskList.getRows().get(0)).getSubject();
        HashMap<String, Set<String>> secretarys = new HashMap();
        if (bpmTaskUrgent.isAppointeeSecretary()) {
            BpmSecretaryManageManager manageManager = (BpmSecretaryManageManager)AppUtil.getBean(BpmSecretaryManageManager.class);
            secretarys = manageManager.getSecretaryByleaderIds(appointeeIdSet, defKey);
        }
        if (taskList.getRows().size() == 1) {
            DefaultBpmTask task = (DefaultBpmTask)taskList.getRows().get(0);
            bpmTaskUrgent.setTaskId(task.getTaskId());
            this.sendPromoterNotice(subject, defKey, bpmTaskUrgent, secretarys, true);
        } else {
            boolean needSaveTaskUrgent = true;
            for (DefaultBpmTask task : taskList.getRows()) {
                String assigneeId = task.getAssigneeId();
                bpmTaskUrgent.setTaskId(task.getTaskId());
                if (!appointeeIdSet.contains(assigneeId)) continue;
                HashMap<String, Set<String>> curTasksecretarys = new HashMap<String, Set<String>>();
                if (secretarys.containsKey(assigneeId)) {
                    curTasksecretarys.put(assigneeId, (Set<String>)secretarys.get(assigneeId));
                }
                bpmTaskUrgent.setAppointeeId(assigneeId);
                this.sendPromoterNotice(subject, defKey, bpmTaskUrgent, curTasksecretarys, needSaveTaskUrgent);
                needSaveTaskUrgent = false;
            }
        }
        BpmUtil.executeRestfulPlugin((String)bpmTaskUrgent.getTaskId(), (String)bpmTaskUrgent.getInstId(), (EventType)EventType.URGE_MANUAL);
        return new CommonResult(true, I18nUtil.handleI18nMessage((String)"taskUrgeSucceeded", (String)"\u50ac\u529e\u6210\u529f"), (Object)"");
    }

    @Override
    public CommonResult<String> getFlowKey(Optional<String> defId, Optional<String> procInstId, Optional<String> taskId) throws Exception {
        String defIdStr = defId.orElse("");
        String procInstIdStr = procInstId.orElse("");
        String taskIdStr = taskId.orElse("");
        String flowKey = "";
        if (StringUtil.isEmpty((String)defIdStr) && StringUtil.isEmpty((String)procInstIdStr) && StringUtil.isEmpty((String)taskIdStr)) {
            return new CommonResult(false, "\u8bf7\u4f20\u5165\u6d41\u7a0b\u5b9a\u4e49id\u6216\u6d41\u7a0b\u5b9e\u4f8bid\u6216\u4efb\u52a1id\u83b7\u53d6\u5176\u6d41\u7a0bkey\u3002");
        }
        if (StringUtil.isNotEmpty((String)defIdStr)) {
            DefaultBpmDefinition def = (DefaultBpmDefinition)this.bpmDefinitionManager.get((Serializable)((Object)defIdStr));
            if (BeanUtils.isNotEmpty((Object)def)) {
                flowKey = def.getDefKey();
            }
        } else if (StringUtil.isNotEmpty((String)procInstIdStr)) {
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)procInstIdStr));
            if (BeanUtils.isNotEmpty((Object)instance)) {
                flowKey = instance.getProcDefKey();
            }
        } else {
            DefaultBpmTask task = this.bpmTaskManager.getByTaskId(taskIdStr);
            if (BeanUtils.isNotEmpty((Object)task)) {
                flowKey = task.getProcDefKey();
            } else {
                DefaultBpmDefinition def;
                BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
                BpmTaskNotice notice = (BpmTaskNotice)noticeManager.get((Serializable)((Object)taskIdStr));
                if (BeanUtils.isNotEmpty((Object)notice) && BeanUtils.isNotEmpty((Object)(def = (DefaultBpmDefinition)this.bpmDefinitionManager.get((Serializable)((Object)notice.getProcDefId()))))) {
                    flowKey = def.getDefKey();
                }
            }
        }
        if (StringUtil.isNotEmpty((String)flowKey)) {
            return new CommonResult(true, "\u83b7\u53d6\u6d41\u7a0bkey\u6210\u529f\u3002", (Object)flowKey);
        }
        return new CommonResult(false, "\u83b7\u53d6\u6d41\u7a0bkey\u5931\u8d25\u3002");
    }

    @Override
    public Map<String, Object> getDefaultInfoTodo(Map<Object, String> map) {
        HashMap<String, Object> mapObj = new HashMap<String, Object>();
        try {
            if (BeanUtils.isNotEmpty(map) && map.size() > 0) {
                for (Object key : map.keySet()) {
                    String orgId = map.get(key);
                    ObjectNode objectNode = this.iFlowService.getOrgByIdOrCode(orgId);
                    HashMap<String, Object> obj = new HashMap<String, Object>();
                    obj.put("orgId", orgId);
                    obj.put("orgName", objectNode.get("name").asText());
                    obj.put("todoNum", this.getTodoByOrgId(orgId));
                    mapObj.put(key.toString(), obj);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapObj;
    }

    @Override
    public CommonResult<String> startForm(String defKey, String businessKey, String boAlias) {
        try {
            boolean isAllowed;
            if (StringUtil.isEmpty((String)defKey)) {
                return new CommonResult(false, ResponseErrorEnums.REQUIRED_ERROR.getMessage() + ":\u6d41\u7a0bkey\u5fc5\u987b\u586b\u5199\u4e00\u4e2a!", (Object)"");
            }
            if (ContextUtil.getCurrentUser() != null && !ContextUtil.getCurrentUser().isAdmin() && !(isAllowed = this.bpmDefAuthorizeManager.getStartRightByUserIdAndFlowKey(ContextUtil.getCurrentUser().getUserId(), defKey, null, null, null).booleanValue())) {
                return new CommonResult(false, "\u60a8\u6ca1\u6709\u542f\u52a8\u8be5\u6d41\u7a0b\u7684\u6743\u9650\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u6388\u6743\uff01", (Object)"");
            }
            DefaultProcessInstCmd cmd = new DefaultProcessInstCmd();
            cmd.setFlowKey(defKey);
            cmd.setDataMode("bo");
            cmd.setActionName("startFlow");
            ObjectNode formRestParams = JsonUtil.getMapper().createObjectNode();
            formRestParams.put("saveType", "database");
            formRestParams.put("boid", businessKey);
            formRestParams.put("code", boAlias);
            ObjectNode boData = this.formRestfulService.getBodataById(formRestParams);
            cmd.setBusData(JsonUtil.toJson((Object)BoDataUtil.hanlerData(Arrays.asList(boData))));
            DefaultBpmDefinition def = this.bpmDefinitionManager.getMainByDefKey(defKey);
            cmd.setSupportMobile(def.getSupportMobile());
            this.processInstanceService.startProcessInst((ProcessInstCmd)cmd);
            return new CommonResult(true, "\u6d41\u7a0b\u542f\u52a8\u6210\u529f", (Object)"");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6d41\u7a0b\u542f\u52a8\u5931\u8d25\uff1a" + e.getMessage(), (Object)"");
        }
    }

    @Override
    public List<BpmNodeDef> nodeUsers(String defId, String nodeId) throws Exception {
        List listNodeDefs = new ArrayList();
        if (StringUtil.isEmpty((String)nodeId)) {
            BpmProcessDef procDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
            BpmDefExtProperties prop = procDef.getProcessDefExt().getExtProperties();
            listNodeDefs = this.bpmDefinitionAccessor.getStartNodes(defId);
            boolean isSkip = prop.isSkipFirstNode();
            if (isSkip) {
                listNodeDefs = BpmStackRelationUtil.getAfterListNode((String)defId, (String)((BpmNodeDef)listNodeDefs.get(0)).getNodeId());
            }
        } else {
            listNodeDefs = BpmStackRelationUtil.getAfterListNode((String)defId, (String)nodeId);
        }
        return listNodeDefs;
    }

    @Override
    public ToCopyToVo toCopyTo(String proInstId, String taskId, String copyToType) {
        String nodeId = "";
        if (StringUtil.isNotEmpty((String)taskId)) {
            BpmTask task = this.bpmTaskService.getByTaskId(taskId);
            proInstId = task.getProcInstId();
            nodeId = task.getNodeId();
        }
        Map handlerTypes = MessageUtil.getHandlerTypes();
        ToCopyToVo toCopyToVo = new ToCopyToVo();
        toCopyToVo.setCopyToType(copyToType);
        toCopyToVo.setProInstId(proInstId);
        toCopyToVo.setNodeId(nodeId);
        toCopyToVo.setHandlerTypes(handlerTypes);
        return toCopyToVo;
    }

    @Override
    public Map<String, DefaultBpmDefinition> getFlowsMap() {
        HashMap<String, DefaultBpmDefinition> map = new HashMap<String, DefaultBpmDefinition>();
        try {
            String[] flowKeys = new String[]{"xwggsp", "hylc"};
            QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(20)));
            queryFilter.addFilter("defKey", (Object)flowKeys, QueryOP.IN);
            PageList flows = this.bpmDefinitionManager.query(queryFilter);
            if (BeanUtils.isNotEmpty((Object)flows) && flows.getTotal() > 0L) {
                for (DefaultBpmDefinition flow : flows.getRows()) {
                    map.put(flow.getDefKey(), flow);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    @Override
    public void publishMsgNews(String params) throws IOException {
        List links;
        ObjectNode node = (ObjectNode)JsonUtil.toJsonNode((String)params);
        String instId = node.get("instId").asText();
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        if (BeanUtils.isNotEmpty((Object)instance) && (StringUtil.isEmpty((String)instance.getResultType()) || "agree".equals(instance.getResultType())) && BeanUtils.isNotEmpty((Object)(links = this.bpmBusLinkManager.getByInstId(instId)))) {
            PortalFeignService portalFeignService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
            ArrayList<String> array = new ArrayList<String>();
            for (BpmBusLink bpmBusLink : links) {
                array.add(bpmBusLink.getBusinesskeyStr());
            }
            portalFeignService.publicMsgNews(StringUtils.join(array, (String)","));
        }
    }

    @Override
    public RelatedInformation getRelatedInformationById(String id) {
        String mes;
        String key;
        RelatedInformation relatedInformation = new RelatedInformation();
        DefaultBpmProcessInstance defaultBpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)id));
        Assert.notNull((Object)defaultBpmProcessInstance, (String)String.format("\u6ca1\u627e\u5230ID\uff1a%s\u7684\u6d41\u7a0b\u5b9e\u4f8b", id));
        Locale locale = LocaleContextHolder.getLocale();
        if (StringUtil.isNotEmpty((String)defaultBpmProcessInstance.getCreator())) {
            relatedInformation.setName(defaultBpmProcessInstance.getCreator());
        } else {
            String creatorId = defaultBpmProcessInstance.getCreateBy();
            IUser user = this.ius.getUserById(creatorId);
            relatedInformation.setName(user.getFullname());
        }
        relatedInformation.setSubject(defaultBpmProcessInstance.getSubject());
        ObjectNode deptobj = this.ucFeignService.getMainGroup(defaultBpmProcessInstance.getCreateBy());
        if (BeanUtils.isNotEmpty((Object)deptobj)) {
            String recursionOrgPath = this.recursionOrgPath(deptobj.get("parentId").asLong(), new StringJoiner("/"), deptobj);
            Object[] split = recursionOrgPath.split("/");
            split = (String[])ArrayUtil.reverse((Object[])split);
            relatedInformation.setDeptName("/" + String.join((CharSequence)"/", (CharSequence[])split));
        }
        String procDefName = defaultBpmProcessInstance.getProcDefName();
        if (!Locale.SIMPLIFIED_CHINESE.equals(locale) && !(key = "flow." + defaultBpmProcessInstance.getProcDefKey()).equals(mes = I18nUtil.getMessage((String)key, (Locale)locale))) {
            procDefName = mes;
        }
        relatedInformation.setTemplate(procDefName);
        return relatedInformation;
    }

    private String recursionOrgPath(long parentId, StringJoiner joiner, ObjectNode dept) {
        String orgPath = I18nUtil.handleI18nMessage((String)String.format("org.%s", dept.get("code").asText()), (String)dept.get("name").asText());
        joiner.add(orgPath);
        dept = parentId == 0L ? dept : this.ucFeignService.getOrgByIdOrCode(String.valueOf(parentId));
        return parentId > 0L ? this.recursionOrgPath(dept.get("parentId").asLong(), joiner, dept) : joiner.toString();
    }

    @Override
    public PageList<BpmReadRecord> getByRecordInstId(QueryFilter<BpmReadRecord> queryFilter) {
        HashMap<String, String> params = new HashMap<String, String>();
        String dbType = SQLUtil.getDbType();
        if ("mysql".equals(dbType) || "oracle".equals(dbType) || "postgresql".equals(dbType)) {
            params.put("dbType", dbType);
        } else if ("dm".equals(dbType) || "kingbasees".equals(dbType)) {
            params.put("dbType", "oracle");
        }
        if (queryFilter.getParams().get("distinct") != null) {
            params.put("distinct", queryFilter.getParams().get("distinct").toString());
        }
        queryFilter.setParams(params);
        PageList query = this.bpmReadRecordManager.selectPageByGroup(queryFilter);
        Locale locale = LocaleContextHolder.getLocale();
        if (!Locale.SIMPLIFIED_CHINESE.equals(locale)) {
            String procInstId = null;
            List querys = queryFilter.getQuerys();
            for (QueryField queryField : querys) {
                String property = queryField.getProperty();
                if (!"procInstId".equals(property)) continue;
                procInstId = queryField.getValue().toString();
                break;
            }
            DefaultBpmProcessInstance defaultBpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get(procInstId);
            String procDefKey = defaultBpmProcessInstance.getProcDefKey();
            List rows = query.getRows();
            for (BpmReadRecord bpmReadRecord : rows) {
                String mes;
                String taskKey = bpmReadRecord.getTaskKey();
                String key = "flow." + procDefKey + "." + taskKey;
                if (key.equals(mes = I18nUtil.getMessage((String)key, (Locale)locale))) continue;
                bpmReadRecord.setTaskName(mes);
            }
        }
        return query;
    }

    @Override
    public CommonResult<String> doEndProcessById(String id, Optional<String> reason) {
        try {
            List list = this.bpmProcessInstanceManager.getBpmTaskIdByInstId(id);
            if (BeanUtils.isEmpty((Object)list)) {
                throw new WorkFlowException("\u6d41\u7a0b\u5b9e\u4f8b\u6ca1\u6709\u5f85\u529e\u4efb\u52a1\u5b58\u5728\uff0c\u65e0\u9700\u7ec8\u6b62");
            }
            list = list.stream().filter(taskId -> StringUtil.isNotEmpty((String)taskId)).collect(Collectors.toList());
            DoEndParamObject doEndParamObject = new DoEndParamObject();
            doEndParamObject.setTaskId((String)list.get(0));
            doEndParamObject.setMessageType("inner");
            doEndParamObject.setFiles("");
            doEndParamObject.setEndReason(StringUtil.isEmpty((String)reason.orElse("")) ? "\u6d41\u7a0b\u53d1\u8d77\u4eba\u4eba\u5de5\u7ec8\u6b62" : reason.get());
            this.iProcessService.doEndProcess(doEndParamObject);
            this.bpmProcessInstanceManager.deleteNotice(id);
            return new CommonResult(true, I18nUtil.handleI18nMessage((String)"taskNotExistOrHasProcessed", (String)"\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u88ab\u5904\u7406\uff01"), (Object)"");
        }
        catch (Exception e) {
            return new CommonResult(true, I18nUtil.handleI18nMessage((String)"taskToEndProcess.terminatedProcess", (String)"\u5df2\u7ec8\u6b62\u6d41\u7a0b"), (Object)"");
        }
    }

    @Override
    @InterfaceEventPostAsync
    @Transactional
    public Object completelyRemove(List<BpmInstDeleteVo> bpmInstDeleteVos, String content, Boolean isRemoveBo) throws Exception {
        if (BeanUtils.isEmpty((Object)isRemoveBo)) {
            isRemoveBo = true;
        }
        if (BeanUtils.isNotEmpty(bpmInstDeleteVos)) {
            for (BpmInstDeleteVo bpmInstDeleteVo : bpmInstDeleteVos) {
                String id = bpmInstDeleteVo.getId();
                String subject = bpmInstDeleteVo.getSubject();
                List tasks = this.bpmTaskService.getTasksInstId(id);
                this.iFlowService.doPostAsync(id, tasks, EventType.TASK_REMOVE);
                if (isRemoveBo.booleanValue()) {
                    this.bpmBusLinkManager.removeDataByInstId(id);
                }
                this.bpmProcessInstanceManager.completelyRemove(id);
                BpmInstDeleteLog bpmInstDeleteLog = new BpmInstDeleteLog();
                bpmInstDeleteLog.setAccount(ContextUtil.getCurrentUser().getAccount());
                bpmInstDeleteLog.setFullname(ContextUtil.getCurrentUser().getFullname());
                bpmInstDeleteLog.setContent(content);
                bpmInstDeleteLog.setInstSubject(subject);
                bpmInstDeleteLog.setDeleteTime(LocalDateTime.now());
                this.bpmInstDeleteLogManager.create((Model)bpmInstDeleteLog);
            }
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f", (Object)"");
    }

    @Override
    public PageList<BpmInstDeleteLog> getInstDeleteLog(QueryFilter queryFilter) {
        return this.bpmInstDeleteLogManager.query(queryFilter);
    }

    private List<ObjectNode> dealOpinions(List<ObjectNode> listOpinion, String instId) throws IOException {
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        ArrayList<String> auditor = new ArrayList<String>();
        ArrayList<String> strauditor = new ArrayList<String>();
        for (ObjectNode defaultBpmCheckOpinion : listOpinion) {
            if (BeanUtils.isNotEmpty((Object)defaultBpmCheckOpinion.get("status")) && OpinionStatus.AWAITING_CHECK.getKey().equals(defaultBpmCheckOpinion.get("status").asText()) && defaultBpmCheckOpinion.get("interpose").asInt() == 0) {
                defaultBpmCheckOpinion.put("completeTime", "");
            }
            if (BeanUtils.isNotEmpty((Object)defaultBpmCheckOpinion.get("opinion")) && defaultBpmCheckOpinion.get("opinion").asText().equals("\u6284\u9001\u6d88\u606f")) {
                defaultBpmCheckOpinion.put("opinion", "");
            }
            try {
                if (BeanUtils.isEmpty((Object)defaultBpmCheckOpinion.get("auditor"))) {
                    ArrayNode array = (ArrayNode)JsonUtil.toJsonNode((String)defaultBpmCheckOpinion.get("qualfieds").asText());
                    for (JsonNode str : array) {
                        strauditor.add(str.get("id").asText());
                    }
                    LocalDateTime oldDateTime = TimeUtil.convertString((String)defaultBpmCheckOpinion.get("createTime").asText());
                    Long oldDate = oldDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
                    Long newDate = LocalDateTime.now().toInstant(ZoneOffset.of("+8")).toEpochMilli();
                    defaultBpmCheckOpinion.put("durMs", newDate - oldDate);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!BeanUtils.isNotEmpty((Object)defaultBpmCheckOpinion.get("auditor"))) continue;
            auditor.add(defaultBpmCheckOpinion.get("auditor").asText());
        }
        for (int i = 0; i < listOpinion.size(); ++i) {
            if (!BeanUtils.isNotEmpty((Object)listOpinion.get(i).get("status")) || !OpinionStatus.END.getKey().equals(listOpinion.get(i).get("status").asText())) continue;
            listOpinion.remove(i);
            --i;
        }
        if (auditor.size() > 0) {
            List jobNames = FeignServiceUtil.getPathNames(auditor);
            for (Map jobNamesMap : jobNames) {
                if (!StringUtil.isNotEmpty((String)((String)jobNamesMap.get("userId")))) continue;
                for (ObjectNode checkOpinion : listOpinion) {
                    if (BeanUtils.isNotEmpty((Object)checkOpinion.get("adminInterPose"))) {
                        checkOpinion.put("postName", "(\u7ba1\u7406\u5458)");
                        continue;
                    }
                    if (!((String)jobNamesMap.get("userId")).equals(checkOpinion.get("auditor").asText()) || !StringUtil.isNotEmpty((String)((String)jobNamesMap.get("dutyName")))) continue;
                    checkOpinion.put("postName", "(" + (String)jobNamesMap.get("dutyName") + ")");
                }
            }
        }
        if (strauditor.size() > 0) {
            List pathNames = FeignServiceUtil.getPathNames(strauditor);
            for (Map pathNamesMap : pathNames) {
                if (!StringUtil.isNotEmpty((String)((String)pathNamesMap.get("userId")))) continue;
                for (ObjectNode checkOpinion : listOpinion) {
                    if (!BeanUtils.isEmpty((Object)checkOpinion.get("auditor"))) continue;
                    ArrayNode array = (ArrayNode)JsonUtil.toJsonNode((String)checkOpinion.get("qualfieds").asText());
                    for (JsonNode str : array) {
                        if (!((String)pathNamesMap.get("userId")).equals(str.get("id").asText())) continue;
                        String pathName = (String)pathNamesMap.get("pathName");
                        checkOpinion.put("orgPath", pathName);
                        if (StringUtil.isNotEmpty((String)((String)pathNamesMap.get("dutyName")))) {
                            checkOpinion.put("postName", "(" + (String)pathNamesMap.get("dutyName") + ")");
                        }
                        checkOpinion.put("auditorName", (String)pathNamesMap.get("fullName"));
                    }
                }
            }
        }
        try {
            if (BeanUtils.isNotEmpty(listOpinion)) {
                ArrayList<ObjectNode> newlist = new ArrayList<ObjectNode>();
                for (ObjectNode objectNode : listOpinion) {
                    if (BeanUtils.isNotEmpty((Object)objectNode.get("status")) && OpinionStatus.SIGN_PASS_CANCEL.getKey().equals(objectNode.get("status").asText())) continue;
                    newlist.add(objectNode);
                }
                listOpinion = newlist;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (BeanUtils.isNotEmpty(listOpinion)) {
                ArrayList<ObjectNode> newlist = new ArrayList<ObjectNode>();
                for (ObjectNode objectNode : listOpinion) {
                    if (BeanUtils.isNotEmpty((Object)objectNode.get("status")) && ProcessInstanceStatus.STATUS_MANUAL_END.getKey().equals(instance.getStatus()) && OpinionStatus.MANUAL_END.getKey().equals(objectNode.get("status").asText())) continue;
                    newlist.add(objectNode);
                }
                listOpinion = newlist;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listOpinion;
    }

    private InfoboxVo getMyTaksBox() {
        String userId = ContextUtil.getCurrentUserId();
        Long count = this.bpmTaskManager.getTodoCountByUserId(userId, "");
        InfoboxVo infobox = new InfoboxVo();
        infobox.setIcon("fa-pencil-square-o");
        infobox.setColor("wood");
        infobox.setDataText(String.valueOf(count));
        infobox.setDataContent("\u6211\u7684\u5f85\u529e");
        infobox.setUrl("/v-flow/v-todo");
        return infobox;
    }

    private InfoboxVo getMyMessBox() {
        Integer messCount = 0;
        Integer noReadMessCount = 0;
        PortalFeignService PortalFeignService2 = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
        try {
            ObjectNode info = PortalFeignService2.getMessBoxInfo(this.baseContext.getCurrentUserAccout());
            if (BeanUtils.isNotEmpty((Object)info)) {
                messCount = info.get("messCount").asInt();
                noReadMessCount = info.get("noReadMessCount").asInt();
            }
        }
        catch (Exception info) {
            // empty catch block
        }
        InfoboxVo infobox = new InfoboxVo();
        infobox.setIcon("fa-comments");
        infobox.setColor("blue2");
        infobox.setDataText("(" + noReadMessCount + "/" + messCount + ")");
        infobox.setDataContent("\u5185\u90e8\u6d88\u606f");
        infobox.setUrl("#/messageReceiver/insideMessageList");
        return infobox;
    }

    private InfoboxVo getMyProCopytoBox() {
        String userId = ContextUtil.getCurrentUserId();
        QueryFilter querFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(1)));
        PageList list = new PageList(this.copyToManager.getMyCopyTo(userId, querFilter));
        InfoboxVo infobox = new InfoboxVo();
        infobox.setIcon("fa-comments");
        infobox.setColor("blue3");
        infobox.setDataText("(" + list.getTotal() + "/" + list.getTotal() + ")");
        infobox.setDataContent("\u6284\u9001\u8f6c\u53d1");
        infobox.setUrl("#/initiatedProcess/myCopyTo");
        return infobox;
    }

    private InfoboxVo getMyAlreadyBox() throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        Long count = this.bpmProcessInstanceManager.getDoneInstCount(userId);
        InfoboxVo infobox = new InfoboxVo();
        infobox.setIcon("fa-flag");
        infobox.setColor("red");
        infobox.setDataText(String.valueOf(count));
        infobox.setDataContent("\u5df2\u529e\u4e8b\u5b9c");
        infobox.setUrl("/v-flow/v-done");
        return infobox;
    }

    private InfoboxVo getMyCompletedBox() {
        String userId = ContextUtil.getCurrentUserId();
        QueryFilter querFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(1)));
        PageList list = new PageList(this.bpmProcessInstanceManager.getMyCompletedByUserId(userId, querFilter));
        InfoboxVo infobox = new InfoboxVo();
        infobox.setIcon("fa-check-square-o");
        infobox.setColor("brown");
        infobox.setDataText(list.getTotal() + "");
        infobox.setDataContent("\u6211\u7684\u529e\u7ed3");
        infobox.setUrl("/v-flow/v-done");
        return infobox;
    }

    private InfoboxVo getMyAccordingMattersBox() {
        String userId = ContextUtil.getCurrentUserId();
        Long count = this.bpmTaskTurnManager.getMyDelegateCountByUserId(userId);
        InfoboxVo infobox = new InfoboxVo();
        infobox.setIcon("fa-share");
        infobox.setColor("pink");
        infobox.setDataText(String.valueOf(count));
        infobox.setDataContent("\u8f6c\u529e\u4ee3\u7406");
        infobox.setUrl("/v-flow/v-todo");
        return infobox;
    }

    private InfoboxVo getMyNoticeTodoRead() throws Exception {
        InfoboxVo infobox = new InfoboxVo();
        QueryFilter queryFilter = QueryFilter.build();
        PageList<BpmTaskNotice> pageList = this.iFlowService.getNoticeTodoReadList(this.baseContext.getCurrentUserAccout(), queryFilter);
        infobox.setIcon("fa-comments");
        infobox.setColor("blue3");
        infobox.setDataText(String.valueOf(pageList.getTotal()));
        infobox.setDataContent("\u6211\u7684\u5f85\u9605");
        infobox.setUrl("/v-flow/v-todoRead");
        return infobox;
    }

    private InfoboxVo getMyRequestBox() {
        String userId = ContextUtil.getCurrentUserId();
        Long count = this.bpmProcessInstanceManager.getMyRequestCountByUserId(userId);
        InfoboxVo infobox = new InfoboxVo();
        infobox.setIcon("fa-hand-o-up");
        infobox.setColor("blue2");
        infobox.setDataText(String.valueOf(count));
        infobox.setDataContent("\u6211\u7684\u8bf7\u6c42");
        infobox.setUrl("/v-flow/v-request");
        return infobox;
    }

    private InfoboxVo getMyDraftBox() {
        String userId = ContextUtil.getCurrentUserId();
        QueryFilter querFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(1)));
        PageList list = new PageList(this.bpmProcessInstanceManager.getDraftsByUserId(userId, querFilter));
        InfoboxVo infobox = new InfoboxVo();
        infobox.setIcon("fa-pencil-square-o");
        infobox.setColor("wood");
        infobox.setDataText(list.getTotal() + "");
        infobox.setDataContent("\u6211\u7684\u8349\u7a3f");
        infobox.setUrl("#/initiatedProcess/myDraft");
        return infobox;
    }

    private InfoboxVo getMyNoticeReadBox() throws Exception {
        InfoboxVo infobox = new InfoboxVo();
        QueryFilter queryFilter = QueryFilter.build();
        PageList<BpmTaskNotice> pageList = this.iFlowService.getMyNoticeReadList(this.baseContext.getCurrentUserAccout(), queryFilter);
        infobox.setIcon("fa-comments");
        infobox.setColor("blue3");
        infobox.setDataText(String.valueOf(pageList.getTotal()));
        infobox.setDataContent("\u6211\u4f20\u9605\u7684");
        infobox.setUrl("/v-flow/v-myRead");
        return infobox;
    }

    public List<ObjectNode> getInstanceFlowOpinions(String instId) throws Exception {
        List<ObjectNode> listobj = this.iFlowService.opinionHistory(instId, null);
        List<ObjectNode> listOpinion = new ArrayList<ObjectNode>();
        for (ObjectNode object : listobj) {
            if (!object.get("auditor").isNull() && "-1".equals(object.get("auditor").asText())) continue;
            listOpinion.add(object);
        }
        for (ObjectNode defaultBpmCheckOpinion : listOpinion) {
            if (!OpinionStatus.AWAITING_CHECK.getKey().equals(defaultBpmCheckOpinion.get("status").asText())) continue;
            defaultBpmCheckOpinion.put("completeTime", TimeUtil.getCurrentTime());
        }
        Collections.sort(listOpinion, new Comparator<ObjectNode>(){

            @Override
            public int compare(ObjectNode opinion1, ObjectNode opinion2) {
                if (BeanUtils.isEmpty((Object)opinion1.get("completeTime"))) {
                    opinion1.put("completeTime", TimeUtil.getCurrentTime());
                }
                return opinion2.get("completeTime").asText().compareTo(opinion1.get("completeTime").asText());
            }
        });
        listOpinion = this.dealOpinions(listOpinion, instId);
        return listOpinion;
    }

    private List<String> getMessageNewsIds() {
        ArrayList<String> ids = new ArrayList<String>();
        QueryFilter filter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        filter.addFilter("procDefKey", (Object)"xwggsp", QueryOP.EQUAL);
        filter.addFilter("status", (Object)"end", QueryOP.EQUAL);
        filter.addFilter("resultType", (Object)"agree", QueryOP.EQUAL);
        PageList pageList = this.bpmProcessInstanceManager.query(filter);
        if (BeanUtils.isNotEmpty((Object)pageList) && pageList.getTotal() > 0L) {
            List list = pageList.getRows();
            ArrayList<String> instIds = new ArrayList<String>();
            for (DefaultBpmProcessInstance instance : list) {
                instIds.add(instance.getId());
            }
            QueryFilter linkFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            linkFilter.addFilter("procInstId", instIds, QueryOP.IN);
            PageList linkPage = this.bpmBusLinkManager.query(linkFilter);
            if (BeanUtils.isNotEmpty((Object)linkPage) && linkPage.getTotal() > 0L) {
                List links = linkPage.getRows();
                for (BpmBusLink bpmBusLink : links) {
                    ids.add(bpmBusLink.getBusinesskeyStr());
                }
            }
        }
        return ids;
    }

    private List<BpmVariableDef> getAllBpmVariableDef(String defId) throws Exception {
        ArrayList<BpmVariableDef> bpmVariableList = new ArrayList<BpmVariableDef>();
        BpmProcessDef bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        if (defExt.getVariableList() != null) {
            bpmVariableList.addAll(defExt.getVariableList());
        }
        List bpmNodeDefList = this.bpmDefinitionAccessor.getNodesByType(defId, NodeType.USERTASK);
        bpmNodeDefList.addAll(this.bpmDefinitionAccessor.getNodesByType(defId, NodeType.SIGNTASK));
        for (BpmNodeDef bpmNodeDef : bpmNodeDefList) {
            UserTaskNodeDef taskNodeDef = (UserTaskNodeDef)bpmNodeDef;
            List nodeVarList = taskNodeDef.getVariableList();
            if (nodeVarList == null) continue;
            bpmVariableList.addAll(nodeVarList);
        }
        return bpmVariableList;
    }

    private Boolean setNoAuthFilter(QueryFilter queryFilter) {
        List list = this.bpmDefUserManager.getByUserMap("bpmDef", null);
        IGroup ugroup = ContextUtil.getCurrentGroup();
        HashMap<String, String> userRightMap = new HashMap<String, String>();
        if (BeanUtils.isNotEmpty((Object)list)) {
            for (BpmDefUser bpmDefUser : list) {
                String type;
                List bpmDefAct;
                if (StringUtil.isNotEmpty((String)bpmDefUser.getAuthOrg())) {
                    bpmDefAct = this.bpmDefActManager.getByAuthorizeId(bpmDefUser.getAuthorizeId());
                    if (!BeanUtils.isNotEmpty((Object)bpmDefAct)) continue;
                    for (BpmDefAct bpm : bpmDefAct) {
                        type = bpm.getType();
                        if ("1".equals(type)) {
                            userRightMap.put(bpm.getDefKey(), bpmDefUser.getAuthOrg());
                        }
                        if (!"2".equals(type)) continue;
                        List defKeys = this.bpmDefinitionManager.queryByTypeId(Arrays.asList(bpm.getDefKey()));
                        for (String defKey : defKeys) {
                            userRightMap.put(defKey, bpmDefUser.getAuthOrg());
                        }
                    }
                    continue;
                }
                bpmDefAct = this.bpmDefActManager.getByAuthorizeId(bpmDefUser.getAuthorizeId());
                if (!BeanUtils.isNotEmpty((Object)bpmDefAct)) continue;
                for (BpmDefAct bpm : bpmDefAct) {
                    type = bpm.getType();
                    String orgId = null;
                    if (StringUtil.isNotEmpty((String)bpm.getRightContent())) {
                        try {
                            ObjectNode rightJson = (ObjectNode)JsonUtil.toJsonNode((String)bpm.getRightContent());
                            if (JsonUtil.getBoolean((ObjectNode)rightJson, (String)"i_org", (boolean)false)) {
                                orgId = BeanUtils.isNotEmpty((Object)ugroup) ? ugroup.getGroupId() : "-1";
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    bpm.getRightContent();
                    if ("1".equals(type)) {
                        userRightMap.put(bpm.getDefKey(), StringUtil.isNotEmpty(orgId) ? orgId : null);
                    }
                    if (!"2".equals(type)) continue;
                    List defKeys = this.bpmDefinitionManager.queryByTypeId(Arrays.asList(bpm.getDefKey()));
                    for (String defKey : defKeys) {
                        userRightMap.put(defKey, StringUtil.isNotEmpty((String)orgId) ? orgId : null);
                    }
                }
            }
            if (BeanUtils.isNotEmpty(userRightMap)) {
                Map maps = this.ucFeignService.getChildrenIds(userRightMap);
                Map rightMap = StringUtil.getMapStringByMapList((Map)maps);
                userRightMap.putAll(rightMap);
                queryFilter.addParams("userRightMap", userRightMap);
            }
        }
        return CollUtil.isNotEmpty(userRightMap);
    }

    private void sendPromoterNotice(String subject, String defKey, BpmTaskUrgent bpmTaskUrgent, Map<String, Set<String>> secretarys, boolean needSaveTaskUrgent) throws Exception {
        ArrayNode users;
        bpmTaskUrgent.setUrgrntDate(LocalDateTime.now());
        String instId = bpmTaskUrgent.getInstId();
        HashSet<String> sendMsgUserIds = new HashSet<String>(Arrays.asList(bpmTaskUrgent.getAppointeeId().split(",")));
        if (secretarys != null && !secretarys.isEmpty()) {
            for (Set<String> set : secretarys.values()) {
                sendMsgUserIds.addAll(set);
            }
            bpmTaskUrgent.setAppointeeSecretaryConf(JsonUtil.toJson(secretarys));
        }
        if (BeanUtils.isEmpty((Object)(users = this.ucFeignService.getUserByIdsOrAccounts(StringUtil.join(new ArrayList<String>(sendMsgUserIds), (String)","))))) {
            return;
        }
        String[] accountArray = new String[users.size()];
        ArrayList<JmsActor> receiver = new ArrayList<JmsActor>();
        for (int i = 0; i < users.size(); ++i) {
            ObjectNode jsonNode = (ObjectNode)users.get(i);
            if (!BeanUtils.isNotEmpty((Object)jsonNode) || !jsonNode.hasNonNull("account")) continue;
            JmsActor jmsActor = this.notifyHelper.convertUserObject2JmsActor((JsonNode)jsonNode);
            receiver.add(jmsActor);
            accountArray[i] = jsonNode.get("account").asText();
        }
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        String creator = instance.getCreator();
        Map<String, Object> vars = this.getFormData(bpmTaskUrgent.getInstId());
        vars.put("title", subject);
        vars.put("startorName", creator);
        vars.put("startDate", DateUtil.getCurrentTime((String)"yyyy-MM-dd"));
        vars.put("flowKey_", defKey);
        vars.put("instanceId_", instId);
        vars.put("startUser", creator);
        vars.put("promoter", bpmTaskUrgent.getPromoter());
        vars.put("appointee", bpmTaskUrgent.getAppointee());
        vars.put("instId", instId);
        vars.put("subject", subject);
        vars.put("sponsor", creator);
        vars.put("nodeName", bpmTaskUrgent.getNodeName());
        vars.put("taskId", bpmTaskUrgent.getTaskId());
        BpmUtil.setBaseUrl(vars);
        String html = StringUtil.getStrByRule((String)bpmTaskUrgent.getContent(), vars);
        vars.put("taskSubject", html);
        bpmTaskUrgent.setContent(html);
        String notifyType = bpmTaskUrgent.getType();
        if (StringUtil.isEmpty((String)notifyType)) {
            throw new BaseException("\u8bf7\u9009\u62e9\u50ac\u529e\u65b9\u5f0f");
        }
        Notice notice = new Notice();
        notice.setSubject(bpmTaskUrgent.getSubject());
        notice.setContent(bpmTaskUrgent.getContent());
        notice.setUseTemplate(true);
        notice.setTemplateType("promoter");
        notice.setMessageTypes(MessageUtil.parseNotifyType((String)("smsApproval".equals(notifyType) ? "sms" : notifyType)));
        IUser currentUser = ContextUtil.getCurrentUser();
        notice.setSender(currentUser == null ? "" : currentUser.getAccount());
        notice.setVars(vars);
        notice.setReceiver(receiver);
        notice.setReceivers(accountArray);
        PortalFeignService portalFeignService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
        portalFeignService.sendNoticeToQueue(notice);
        bpmTaskUrgent.setPromoterId(this.baseContext.getCurrentUserId());
        bpmTaskUrgent.setId(UniqueIdUtil.getSuid());
        if (needSaveTaskUrgent) {
            this.bpmTaskUrgentManager.create((Model)bpmTaskUrgent);
        }
    }

    private Map<String, Object> getFormData(String instId) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        DefaultBpmProcessInstance bpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.getById((Serializable)((Object)instId));
        List data = this.boDataService.getDataByInst((BpmProcessInstance)bpmProcessInstance);
        for (ObjectNode objectNode : data) {
            String boDefAlias = JsonUtil.getString((JsonNode)objectNode, (String)"boDefAlias");
            if (!StringUtil.isNotEmpty((String)boDefAlias) || !BeanUtils.isNotEmpty((Object)objectNode.get("data"))) continue;
            result.put(boDefAlias, JsonUtil.toBean((JsonNode)objectNode.get("data"), Map.class));
        }
        return result;
    }

    private Integer getTodoByOrgId(String orgId) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("inst.CREATE_ORG_PATH_", (Object)orgId, QueryOP.LIKE, FieldRelation.AND, "orgId");
        queryFilter.withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        if (BeanUtils.isNotEmpty((Object)queryFilter.getQuerys()) && queryFilter.getQuerys().size() > 0) {
            ArrayList<QueryField> fields = new ArrayList<QueryField>();
            for (QueryField field : queryFilter.getQuerys()) {
                if ("urgentStateValue".equals(field.getProperty())) {
                    field.setGroup("groupUrgent");
                    field.setRelation(FieldRelation.AND);
                    QueryFilter defFilter = QueryFilter.build();
                    defFilter.addFilter("IS_MAIN_", (Object)"Y", QueryOP.EQUAL);
                    defFilter.addFilter("SHOW_URGENT_STATE_", (Object)"1", QueryOP.EQUAL);
                    PageList query = this.bpmDefinitionManager.query(defFilter);
                    ArrayList<String> defKeys = new ArrayList<String>();
                    defKeys.add("-1");
                    if (BeanUtils.isNotEmpty((Object)query.getRows())) {
                        for (DefaultBpmDefinition def : query.getRows()) {
                            defKeys.add(def.getDefKey());
                        }
                    }
                    fields.add(new QueryField("PROC_DEF_KEY_", defKeys, QueryOP.IN, FieldRelation.AND, "groupUrgent"));
                    continue;
                }
                fields.add(field);
            }
            queryFilter.setQuerys(fields);
        }
        queryFilter.setGroupRelation(FieldRelation.AND);
        PageList<DefaultBpmTask> pageList = this.iFlowService.getTodoList(this.baseContext.getCurrentUserAccout(), (QueryFilter<DefaultBpmTask>)queryFilter).get();
        return pageList.getRows().size();
    }
}

