/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.manager.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.task.BpmTaskOpinion;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmOpinionService;
import com.hotent.bpm.persistence.manager.BpmDefUserManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.util.BoDataUtil;
import com.hotent.runtime.dao.MeetingRoomAppointmentDao;
import com.hotent.runtime.manager.MeetingRoomAppointmentManager;
import com.hotent.runtime.manager.MeetingRoomManager;
import com.hotent.runtime.model.MeetingRoom;
import com.hotent.runtime.model.MeetingRoomAppointment;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="meetingRoomAppointmentManager")
public class MeetingRoomAppointmentManagerImpl
extends BaseManagerImpl<MeetingRoomAppointmentDao, MeetingRoomAppointment>
implements MeetingRoomAppointmentManager {
    @Resource
    BpmDefUserManager bpmDefUserManager;
    @Resource
    MeetingRoomManager meetingRoomManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmOpinionService bpmOpinionService;
    @Resource
    BoDataService boDataService;

    @Override
    public PageList<ObjectNode> getAppointList(QueryFilter queryFilter) throws IOException {
        List defs = this.bpmDefinitionManager.queryByDefKey("hylc");
        String defId = "";
        if (defs.size() > 0 && BeanUtils.isNotEmpty(defs.get(defs.size() - 1))) {
            defId = ((DefaultBpmDefinition)defs.get(defs.size() - 1)).getDefId();
        }
        List querys = queryFilter.getQuerys();
        String weekStr = "";
        ArrayList<QueryField> newQuerys = new ArrayList<QueryField>();
        for (QueryField queryField : querys) {
            if ("weekStr".equals(queryField.getProperty())) {
                weekStr = queryField.getValue().toString();
                continue;
            }
            newQuerys.add(queryField);
        }
        queryFilter.setQuerys(newQuerys);
        QueryFilter qfForMeetingAppoint = QueryFilter.build();
        PageList meetingroomList = this.meetingRoomManager.query(queryFilter);
        String[] arr = weekStr.split(",");
        LocalDateTime begTime = TimeUtil.convertString((String)(arr[0].split("\\|")[0] + " 00:00:00"));
        LocalDateTime endTime = TimeUtil.convertString((String)(arr[6].split("\\|")[0] + " 00:00:00"));
        qfForMeetingAppoint.addFilter("APPOINTMENT_BEG_TIME_", (Object)begTime, QueryOP.GREAT_EQUAL);
        qfForMeetingAppoint.addFilter("APPOINTMENT_END_TIME_", (Object)endTime, QueryOP.LESS_EQUAL);
        qfForMeetingAppoint.addFilter("APPOINTMENT_STATUS_", (Object)"1", QueryOP.EQUAL);
        PageList meetingAppointList = this.query(qfForMeetingAppoint);
        PageList resultList = new PageList();
        ArrayList<ObjectNode> objList = new ArrayList<ObjectNode>();
        for (int i = 0; i < meetingroomList.getRows().size(); ++i) {
            ObjectNode data = JsonUtil.getMapper().createObjectNode();
            MeetingRoom meetingroom = (MeetingRoom)((Object)meetingroomList.getRows().get(i));
            data.put("mtRoomId", meetingroom.getId());
            data.put("defId", defId);
            data.put("mtName", meetingroom.getName());
            for (int z = 0; z < arr.length; ++z) {
                int curDate = Integer.valueOf(arr[z].split("\\|")[0].replace("-", ""));
                String elNmae = arr[z].split("\\|")[1];
                ArrayList<ObjectNode> appList = new ArrayList<ObjectNode>();
                for (int j = 0; j < meetingAppointList.getRows().size(); ++j) {
                    MeetingRoomAppointment meetingAppoint = (MeetingRoomAppointment)((Object)meetingAppointList.getRows().get(j));
                    int endDate = Integer.valueOf(TimeUtil.getDateString((LocalDateTime)meetingAppoint.getAppointmentEndTime(), (String)"yyyyMMdd"));
                    int begDate = Integer.valueOf(TimeUtil.getDateString((LocalDateTime)meetingAppoint.getAppointmentBegTime(), (String)"yyyyMMdd"));
                    if (!meetingAppoint.getMeetingroomId().equals(meetingroom.getId()) || curDate > endDate || curDate < begDate) continue;
                    ObjectNode obj = JsonUtil.getMapper().createObjectNode();
                    obj.put("meetingId", meetingAppoint.getMeetingId());
                    obj.put("meetingName", meetingAppoint.getMeetingName());
                    obj.put("hostName", meetingAppoint.getHostessName());
                    obj.put("dateStr", TimeUtil.getDateString((LocalDateTime)meetingAppoint.getAppointmentBegTime(), (String)"HH:mm:ss") + "-" + TimeUtil.getDateString((LocalDateTime)meetingAppoint.getAppointmentEndTime(), (String)"HH:mm:ss"));
                    appList.add(obj);
                }
                if (appList.size() > 0) {
                    data.put(elNmae, JsonUtil.toJson(appList));
                    continue;
                }
                data.put(elNmae, "");
            }
            objList.add(data);
        }
        resultList.setRows(objList);
        resultList.setPage(meetingroomList.getPage());
        resultList.setTotal(meetingroomList.getTotal());
        resultList.setPageSize(meetingroomList.getPageSize());
        return resultList;
    }

    @Override
    public PageList<ObjectNode> myRequestJson(QueryFilter queryFilter) throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        queryFilter.addFilter("create_by_", (Object)userId, QueryOP.EQUAL);
        queryFilter.addFilter("PROC_DEF_KEY_", (Object)"hylc", QueryOP.EQUAL);
        queryFilter.addFilter("STATUS_", (Object)"draft", QueryOP.NOT_EQUAL);
        PageList query = this.bpmProcessInstanceManager.query(queryFilter);
        PageList pList = new PageList();
        ArrayList<ObjectNode> insList = new ArrayList<ObjectNode>();
        for (int i = 0; i < query.getRows().size(); ++i) {
            DefaultBpmProcessInstance processInstance = (DefaultBpmProcessInstance)query.getRows().get(i);
            List bpmTaskOpinions = this.bpmOpinionService.getTaskOpinions(processInstance.getId());
            BpmTaskOpinion bto = (BpmTaskOpinion)bpmTaskOpinions.get(bpmTaskOpinions.size() - 1);
            List boDatas = this.boDataService.getDataByInst((BpmProcessInstance)processInstance);
            ObjectNode data = (ObjectNode)BoDataUtil.hanlerData((BpmProcessInstance)processInstance, (String)bto.getTaskKey(), (List)boDatas).get("hyywdx");
            data.put("taskId", bto.getTaskKey());
            insList.add(data);
        }
        pList.setPage(query.getPage());
        pList.setRows(insList);
        pList.setPageSize(query.getPageSize());
        pList.setTotal(query.getTotal());
        return pList;
    }

    @Override
    public PageList<ObjectNode> myCompletedJson(QueryFilter queryFilter) throws Exception {
        String userId = ContextUtil.getCurrentUserId();
        queryFilter.addFilter("wfInst.PROC_DEF_KEY_", (Object)"hylc", QueryOP.EQUAL);
        queryFilter.addFilter("opinion.task_key_", (Object)"UserTask4", QueryOP.EQUAL);
        queryFilter.addFilter("opinion.auditor_", (Object)userId, QueryOP.EQUAL);
        PageList query = this.bpmProcessInstanceManager.getMyHandledMeeting(queryFilter);
        PageList pList = new PageList();
        ArrayList<ObjectNode> insList = new ArrayList<ObjectNode>();
        for (int i = 0; i < query.getRows().size(); ++i) {
            DefaultBpmProcessInstance processInstance = (DefaultBpmProcessInstance)query.getRows().get(i);
            List bpmTaskOpinions = this.bpmOpinionService.getTaskOpinions(processInstance.getId());
            Collections.sort(bpmTaskOpinions, new Comparator<BpmTaskOpinion>(){

                @Override
                public int compare(BpmTaskOpinion arg0, BpmTaskOpinion arg1) {
                    int hits0 = Integer.valueOf(arg0.getId());
                    int hits1 = Integer.valueOf(arg1.getId());
                    if (hits1 > hits0) {
                        return 1;
                    }
                    if (hits1 == hits0) {
                        return 0;
                    }
                    return -1;
                }
            });
            BpmTaskOpinion bto = (BpmTaskOpinion)bpmTaskOpinions.get(bpmTaskOpinions.size() - 1);
            List boDatas = this.boDataService.getDataByInst((BpmProcessInstance)processInstance);
            ObjectNode data = (ObjectNode)BoDataUtil.hanlerData((BpmProcessInstance)processInstance, (String)bto.getTaskKey(), (List)boDatas).get("hyywdx");
            data.put("taskId", bto.getTaskKey());
            insList.add(data);
        }
        pList.setRows(insList);
        pList.setPage((long)queryFilter.getPageBean().getPage().intValue());
        pList.setPageSize((long)queryFilter.getPageBean().getPageSize().intValue());
        pList.setTotal(query.getTotal());
        return pList;
    }
}

