/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.aop;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.context.BaseContext;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.DataDesensiUtil;
import com.hotent.runtime.annotation.DesensitizeHandle;
import com.hotent.runtime.params.FormAndBoVo;
import com.hotent.runtime.params.InstFormAndBoVo;
import com.hotent.runtime.params.TaskDetailVo;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DesensitizeHandleAspect {
    @Resource
    BaseContext baseContext;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Around(value="execution(* *..*Controller.*(..)) && @annotation(com.hotent.runtime.annotation.DesensitizeHandle)")
    public Object desensitizeHandle(ProceedingJoinPoint joinPoint) throws Throwable {
        DesensitizeHandle desensitizeHandle;
        Class<?> targetClass = joinPoint.getTarget().getClass();
        String methodName = joinPoint.getSignature().getName();
        Method[] methods = targetClass.getMethods();
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            method = methods[i];
            break;
        }
        if (BeanUtils.isEmpty((Object)(desensitizeHandle = method.getAnnotation(DesensitizeHandle.class)))) {
            return joinPoint.proceed();
        }
        boolean isMobile = desensitizeHandle.isMobile();
        Object result = joinPoint.proceed();
        if (result instanceof CommonResult) {
            CommonResult commonResult = (CommonResult)result;
            ObjectNode jsondata = null;
            String permission = "";
            if (commonResult.getValue() instanceof InstFormAndBoVo) {
                InstFormAndBoVo vo = (InstFormAndBoVo)commonResult.getValue();
                jsondata = vo.getData();
                permission = vo.getPermission();
            } else if (commonResult.getValue() instanceof TaskDetailVo) {
                TaskDetailVo vo = (TaskDetailVo)commonResult.getValue();
                jsondata = vo.getData();
                permission = vo.getPermission();
            }
            DataDesensiUtil.hanlerDataDesensitize((ObjectNode)jsondata, (String)permission, (boolean)isMobile);
        } else if (result instanceof FormAndBoVo) {
            FormAndBoVo vo = (FormAndBoVo)result;
            DataDesensiUtil.hanlerDataDesensitize((ObjectNode)vo.getData(), (String)vo.getPermission(), (boolean)isMobile);
        } else if (result instanceof InstFormAndBoVo) {
            InstFormAndBoVo vo = (InstFormAndBoVo)result;
            DataDesensiUtil.hanlerDataDesensitize((ObjectNode)vo.getData(), (String)vo.getPermission(), (boolean)isMobile);
        }
        return result;
    }
}

