/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.DefaultButton;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.persistence.manager.BpmDefaultButtonManager;
import com.hotent.bpm.persistence.manager.DefaultBpmDefinitionAccessor;
import com.hotent.runtime.constant.ButtonTypeEnum;
import com.hotent.runtime.vo.ButtonCommonStyleVO;
import com.hotent.runtime.vo.ButtonOrderVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/runtime/BpmDefaultButton/v1"})
@Api(tags={"\u6d41\u7a0b\u6309\u94ae\u63a7\u5236\u5668"})
@ApiGroup(group={"group_bpm"})
public class BpmDefaultButtonController
extends BaseController<BpmDefaultButtonManager, DefaultButton> {
    @Resource
    BpmDefaultButtonManager bpmDefaultButtonManager;

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u5b9e\u4f53")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody DefaultButton t) {
        boolean result = ((BpmDefaultButtonManager)this.baseService).updateById((Object)t);
        if (!result) {
            throw new BaseException(ResponseErrorEnums.FAIL_UPDATE);
        }
        BpmDefinitionAccessor bpmDefinitionAccessor = (BpmDefinitionAccessor)AppUtil.getBean(DefaultBpmDefinitionAccessor.class);
        bpmDefinitionAccessor.clearAll();
        return new CommonResult();
    }

    @PostMapping(value={"/top/order"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u5e76\u81ea\u52a8\u66f4\u65b0\u6392\u5e8f")
    public CommonResult<String> createAndOrder(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @RequestBody DefaultButton t) {
        if (t == null || !ButtonTypeEnum.isTopButton(t.getType())) {
            throw new BaseException("\u53ea\u80fd\u4f20\u5165\u9876\u90e8\u6309\u94ae\u7c7b\u578b\uff01");
        }
        boolean result = ((BpmDefaultButtonManager)this.baseService).createAndOrder(t);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"/top/style"})
    @ApiOperation(value="\u8bbe\u7f6e\u9876\u90e8\u6309\u94ae\u901a\u7528\u98ce\u683c\uff0c\u5c06\u9876\u90e8\u6309\u94ae\u5168\u90e8\u8bbe\u7f6e\u4e3a\u901a\u7528\u98ce\u683c")
    public CommonResult<String> setCommonStyle(@ApiParam(name="model", value="\u901a\u7528\u98ce\u683c\u5b9e\u4f53\u4fe1\u606f") @RequestBody ButtonCommonStyleVO styleVO) {
        DefaultButton styleDto = new DefaultButton();
        BeanUtil.copyProperties((Object)styleVO, (Object)styleDto, (String[])new String[0]);
        ((BpmDefaultButtonManager)this.baseService).setCommonStyle(styleDto);
        return CommonResult.ok().value((Object)"\u8bbe\u7f6e\u6210\u529f");
    }

    @RequestMapping(value={"order"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6392\u5e8f\u53d8\u66f4\uff0c\u66f4\u65b0\u4e24\u4e2a\u6216\u66f4\u591a\u6309\u94ae\u6392\u5e8f", httpMethod="POST", notes="\u6392\u5e8f\u53d8\u66f4\uff0c\u66f4\u65b0\u4e24\u4e2a\u6216\u66f4\u591a\u6309\u94ae\u6392\u5e8f")
    public CommonResult<String> switchOrder(@ApiParam(name="buttonList", value="\u6309\u94ae\u5217\u8868\uff0c\u5305\u542bID\u548c\u6392\u5e8f") @RequestBody List<ButtonOrderVo> buttonList) {
        if (CollUtil.isEmpty(buttonList)) {
            return CommonResult.error((String)"\u6309\u94ae\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List defaultButtonList = buttonList.stream().map(item -> {
            DefaultButton button = new DefaultButton();
            button.setId(item.getId());
            button.setOrder(item.getOrder());
            return button;
        }).collect(Collectors.toList());
        this.bpmDefaultButtonManager.switchOrder(defaultButtonList);
        return CommonResult.ok().value((Object)"\u6392\u5e8f\u53d8\u66f4\u6210\u529f");
    }

    @RequestMapping(value={"disabled"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u542f\u7528\u6216\u8005\u7981\u7528", httpMethod="POST", notes="\u542f\u7528\u6216\u8005\u7981\u7528")
    public CommonResult<String> updateDisabled(@ApiParam(name="id", value="\u6309\u94ae\u4e3b\u952e") @RequestParam(value="id") String id, @ApiParam(name="status", value="\u6309\u94ae\u72b6\u6001 1-\u7981\u7528\uff1b0-\u542f\u7528") @RequestParam(value="status") Integer status) {
        if (StringUtil.isEmpty((String)id)) {
            return CommonResult.error((String)"\u6309\u94ae\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.bpmDefaultButtonManager.updateDisabled(id, status);
        return CommonResult.ok().value((Object)"\u8bbe\u7f6e\u72b6\u6001\u6210\u529f");
    }

    @RequestMapping(value={"getButtonsByType"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7c7b\u578b\u83b7\u53d6\u6309\u94ae", httpMethod="POST", notes="\u6839\u636e\u7c7b\u578b\u83b7\u53d6\u6309\u94ae")
    public CommonResult<PageList<DefaultButton>> getButtonsByType(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<DefaultButton> queryFilter, @ApiParam(name="type", value="\u6309\u94ae\u7c7b\u578b top-\u6d41\u7a0b\u9876\u90e8\u6309\u94ae\uff0cfixed\u51b3\u5b9a\u662f\u5426\u56fa\u5b9a") @RequestParam(value="type") String type) {
        List sorter;
        queryFilter.withQuery(new QueryField("TYPE_", (Object)type, QueryOP.EQUAL, FieldRelation.AND));
        if (!ButtonTypeEnum.isTopButton(type)) {
            queryFilter.withQuery(new QueryField("ALIAS_", (Object)"instanceTrans,backToStart,commu", QueryOP.NOT_IN, FieldRelation.AND));
        }
        if (CollUtil.isEmpty((Collection)(sorter = queryFilter.getSorter()))) {
            sorter.add(new FieldSort("ORDER_", Direction.ASC));
        }
        PageList defaultButtonPageList = this.bpmDefaultButtonManager.query(queryFilter);
        if (ButtonTypeEnum.isTopButton(type) && CollUtil.isEmpty((Collection)defaultButtonPageList.getRows())) {
            defaultButtonPageList.setRows(this.bpmDefaultButtonManager.addFixedTopButtons());
        }
        return CommonResult.ok().value((Object)defaultButtonPageList);
    }

    @RequestMapping(value={"saveButtonById"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eID\u4fdd\u5b58\u6309\u94ae\u914d\u7f6e", httpMethod="POST", notes="\u6839\u636eID\u4fdd\u5b58\u6309\u94ae\u914d\u7f6e")
    public CommonResult<String> saveButtonById(@ApiParam(name="defaultButton", value="\u6d41\u7a0b\u6309\u94ae\u914d\u7f6e") @RequestBody DefaultButton defaultButton) {
        return this.bpmDefaultButtonManager.saveButtonById(defaultButton);
    }
}

