/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.controller;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.runtime.manager.BpmTestCaseManager;
import com.hotent.runtime.model.BpmTestCase;
import com.hotent.runtime.params.TestCaseBaseInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/runtime/bpmTestCase/v1/"})
@Api(tags={"\u6d41\u7a0b\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6e"})
@ApiGroup(group={"group_bpm"})
public class BpmTestCaseController
extends BaseController<BpmTestCaseManager, BpmTestCase> {
    @Resource
    BpmTestCaseManager bpmTestCaseManager;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6e\u5217\u8868\uff08\u5e26\u5206\u9875\u4fe1\u606f\uff09", httpMethod="POST", notes="\u83b7\u53d6\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6e\u5217\u8868")
    public PageList<BpmTestCase> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.bpmTestCaseManager.query(queryFilter);
    }

    @RequestMapping(value={"get"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6e\u660e\u7ec6", httpMethod="GET", notes="\u83b7\u53d6\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6e\u660e\u7ec6")
    public BpmTestCase get(@ApiParam(name="id", value="bo\u5b9a\u4e49\u522b\u540d", required=true) @RequestParam String id) throws Exception {
        return (BpmTestCase)this.bpmTestCaseManager.get((Serializable)((Object)id));
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u7684\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6e\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u6d41\u7a0b\u7684\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6e\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="bpmTestCase", value="\u6d41\u7a0b\u7684\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6e", required=true) @RequestBody BpmTestCase bpmTestCase) throws Exception {
        String id = bpmTestCase.getId();
        String resultMsg = null;
        if (StringUtil.isEmpty((String)id)) {
            bpmTestCase.setId(UniqueIdUtil.getSuid());
            this.bpmTestCaseManager.create((Model)bpmTestCase);
            resultMsg = "\u6dfb\u52a0\u6d41\u7a0b\u7684\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6e\u6210\u529f";
        } else {
            this.bpmTestCaseManager.update((Model)bpmTestCase);
            resultMsg = "\u66f4\u65b0\u6d41\u7a0b\u7684\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6e\u6210\u529f";
        }
        return new CommonResult(true, resultMsg, (Object)"");
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b\u7684\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6e", httpMethod="DELETE", notes="\u5220\u9664\u6d41\u7a0b\u7684\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6e")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u6d41\u7a0b\u7684\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6eid\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694", required=true) @RequestParam String ids) throws Exception {
        String message = "\u5220\u9664\u6d41\u7a0b\u7684\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6e\u6210\u529f";
        boolean isTrue = true;
        try {
            String[] idArr = null;
            if (!StringUtil.isEmpty((String)ids)) {
                idArr = ids.split(",");
            }
            this.bpmTestCaseManager.removeByIds(idArr);
        }
        catch (Exception e) {
            message = "\u5220\u9664\u6d41\u7a0b\u7684\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6e\u5931\u8d25\uff1a" + e.getMessage();
            isTrue = false;
        }
        return new CommonResult(isTrue, message, (Object)"");
    }

    @RequestMapping(value={"startTest"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u542f\u52a8\u6d4b\u8bd5", httpMethod="POST", notes="\u542f\u52a8\u6d4b\u8bd5")
    public CommonResult<String> startTest(@ApiParam(name="ids", value="\u6d41\u7a0b\u7684\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6eid\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694", required=true) @RequestBody String ids) throws Exception {
        this.bpmTestCaseManager.startTest(ids);
        return new CommonResult(true, "\u542f\u52a8\u6d4b\u8bd5\u7528\u4f8b\u6210\u529f", (Object)"");
    }

    @RequestMapping(value={"doNext"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7ee7\u7eed\u542f\u52a8\u6d4b\u8bd5\u7528\u4f8b\u8bd5", httpMethod="POST", notes="\u7ee7\u7eed\u542f\u52a8\u6d4b\u8bd5\u7528\u4f8b")
    public CommonResult<String> doNext(@ApiParam(name="id", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) @RequestParam String id) throws Exception {
        if (StringUtil.isEmpty((String)id)) {
            return new CommonResult(false, "\u6ca1\u6709\u4f20\u9012\u6d41\u7a0b\u5b9e\u4f8bid", (Object)"");
        }
        this.bpmTestCaseManager.doNext(id);
        return new CommonResult(true, "\u6d4b\u8bd5\u7528\u4f8b\u91cd\u65b0\u542f\u52a8\u6210\u529f", (Object)"");
    }

    @RequestMapping(value={"getBaseInfo"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f")
    public TestCaseBaseInfoVo getBaseInfo(@ApiParam(name="defKey", value="\u6d41\u7a0b\u5b9a\u4e49Key", required=true) @RequestParam String defKey) throws Exception {
        return this.bpmTestCaseManager.getBaseInfo(defKey);
    }

    @RequestMapping(value={"getReportData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d4b\u8bd5\u7528\u4f8b\u56fe\u8868\u4fe1\u606f", httpMethod="POST", notes="\u83b7\u53d6\u6d4b\u8bd5\u7528\u4f8b\u56fe\u8868\u4fe1\u606f")
    public CommonResult<ObjectNode> getReportData(@ApiParam(name="aryIds", value="\u6d41\u7a0b\u7684\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6eid\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694", required=true) @RequestBody String aryIds) throws Exception {
        if (StringUtil.isEmpty((String)aryIds)) {
            return new CommonResult(false, "\u6d4b\u8bd5\u7528\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a", null);
        }
        ObjectNode jo = this.bpmTestCaseManager.getReportData(aryIds);
        return new CommonResult(true, "\u83b7\u53d6\u6d4b\u8bd5\u7528\u4f8b\u56fe\u8868\u4fe1\u606f\u6210\u529f", (Object)jo);
    }
}

