/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.controller;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.id.IdGenerator;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.runtime.manager.ScriptManager;
import com.hotent.runtime.model.Script;
import com.hotent.runtime.model.TreeEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/runtime/script/v1/"})
@Api(tags={"\u811a\u672c\u7ba1\u7406"})
@ApiGroup(group={"group_bpm"})
public class ScriptController
extends BaseController<ScriptManager, Script> {
    @Resource
    private ScriptManager scriptManager;
    @Resource
    private IdGenerator idGenerator;
    @Resource
    GroovyScriptEngine groovyScriptEngine;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7cfb\u7edf\u811a\u672c\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u7cfb\u7edf\u811a\u672c\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<Script> listJson(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.scriptManager.query(queryFilter);
    }

    @RequestMapping(value={"getCategoryList"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u811a\u672c\u7684\u5206\u7c7b", httpMethod="GET", notes="\u83b7\u53d6\u6240\u6709\u811a\u672c\u7684\u5206\u7c7b")
    public List<String> getCategoryList() throws Exception {
        return this.scriptManager.getDistinctCategory();
    }

    @GetMapping(value={"/getAllScript"})
    @ApiOperation(value="\u83b7\u53d6\u5230\u6240\u6709\u7684\u5e38\u7528\u811a\u672c", httpMethod="GET", notes="\u83b7\u53d6\u5230\u6240\u6709\u7684\u5e38\u7528\u811a\u672c")
    public List<Script> getAllScript() {
        return this.scriptManager.getAll();
    }

    @RequestMapping(value={"get"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u811a\u672c\u660e\u7ec6", httpMethod="GET", notes="\u83b7\u53d6\u811a\u672c\u660e\u7ec6")
    public Script get(@ApiParam(required=true, name="id", value="\u811a\u672cid") @RequestParam String id) throws Exception {
        Script script = null;
        if (StringUtil.isNotEmpty((String)id)) {
            script = (Script)this.scriptManager.get((Serializable)((Object)id));
        }
        return script;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5e38\u7528\u811a\u672c", httpMethod="POST", notes="\u4fdd\u5b58\u5e38\u7528\u811a\u672c")
    public CommonResult<String> save(@ApiParam(required=true, name="script", value="\u811a\u672c\u4fe1\u606f") @RequestBody Script script) throws Exception {
        String resultMsg = null;
        String id = script.getId();
        try {
            if (StringUtil.isEmpty((String)id)) {
                script.setId(this.idGenerator.getSuid());
                script.setUpdateTime(LocalDateTime.now());
                this.scriptManager.create((Model)script);
                resultMsg = "\u6dfb\u52a0\u7cfb\u7edf\u811a\u672c\u6210\u529f";
            } else {
                this.scriptManager.update((Model)script);
                resultMsg = "\u66f4\u65b0\u7cfb\u7edf\u811a\u672c\u6210\u529f";
            }
            return new CommonResult(true, resultMsg);
        }
        catch (Exception e) {
            return new CommonResult(false, resultMsg + "," + e.getMessage());
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u811a\u672c", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u811a\u672c")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u6d41\u7a0b\u7684\u6d4b\u8bd5\u7528\u4f8b\u8bbe\u7f6eid\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = null;
            if (!StringUtil.isEmpty((String)ids)) {
                aryIds = ids.split(",");
            }
            this.scriptManager.removeByIds(aryIds);
            return new CommonResult(true, "\u5220\u9664\u7cfb\u7edf\u811a\u672c\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u7cfb\u7edf\u811a\u672c\u5931\u8d25");
        }
    }

    @RequestMapping(value={"executeScript"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6267\u884c\u811a\u672c", httpMethod="POST", notes="\u6267\u884c\u811a\u672c")
    public CommonResult<String> executeScript(@ApiParam(name="script", value="\u811a\u672c\u5185\u5bb9", required=true) @RequestBody String script) throws Exception {
        try {
            Object obj = this.groovyScriptEngine.executeObject(script, new HashMap());
            String value = "";
            if (BeanUtils.isNotEmpty((Object)obj)) {
                value = JsonUtil.toJsonNode((Object)obj).toString();
                if (obj instanceof String) {
                    value = JsonUtil.toJsonNode((Object)obj).textValue();
                }
            }
            return new CommonResult(true, "\u6267\u884c\u6210\u529f\uff01", (Object)value);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u811a\u672c\uff01");
        }
    }

    @RequestMapping(value={"script/execute"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    public CommonResult<Object> executeScriptObject(@RequestBody String script) {
        try {
            Object obj = this.groovyScriptEngine.executeObject(script, new HashMap());
            return new CommonResult(true, "\u6267\u884c\u6210\u529f\uff01", obj);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u811a\u672c\uff01");
        }
    }

    @RequestMapping(value={"executeScriptByList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6267\u884c\u591a\u4e2a\u811a\u672c\u901a\u8fc7map\u8fd4\u56de", httpMethod="POST", notes="\u6267\u884c\u591a\u4e2a\u811a\u672c\u901a\u8fc7map\u8fd4\u56de")
    public CommonResult<List<Map<String, String>>> executeScriptByList(@ApiParam(name="list", value="\u811a\u672c\u5185\u5bb9", required=true) @RequestBody List<String> list) throws Exception {
        return this.scriptManager.executeScriptByList(list);
    }

    @RequestMapping(value={"getScriptTreeData"})
    @ResponseBody
    public List<TreeEntity> getScriptTreeData(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.scriptManager.getScriptTreeData();
    }

    @RequestMapping(value={"getByScript"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u811a\u672c\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f", httpMethod="POST", notes="\u6267\u884c\u811a\u672c")
    public Script getByScript(@ApiParam(name="script", value="\u811a\u672c\u5185\u5bb9", required=true) @RequestBody String script) throws Exception {
        return ((ScriptManager)this.baseService).getByScript(script);
    }
}

