/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.controller;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.context.BaseContext;
import com.hotent.base.controller.BaseController;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.NotFoundException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.bpm.api.constant.ProcessInstanceStatus;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.model.form.FormType;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.BpmDefLayout;
import com.hotent.bpm.api.model.process.def.BpmNodeLayout;
import com.hotent.bpm.api.model.process.def.BpmVariableDef;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.service.BpmAgentService;
import com.hotent.bpm.api.service.BpmIdentityService;
import com.hotent.bpm.api.service.BpmInstService;
import com.hotent.bpm.api.service.BpmTaskService;
import com.hotent.bpm.natapi.task.NatTaskService;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmCommuReceiverManager;
import com.hotent.bpm.persistence.manager.BpmDefAuthorizeManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmSaveOpinionManager;
import com.hotent.bpm.persistence.manager.BpmTaskCommuManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.manager.BpmTaskNoticeDoneManager;
import com.hotent.bpm.persistence.manager.BpmTaskNoticeManager;
import com.hotent.bpm.persistence.model.BpmLeaderTask;
import com.hotent.bpm.persistence.model.BpmSaveOpinion;
import com.hotent.bpm.persistence.model.BpmTaskCommu;
import com.hotent.bpm.persistence.model.BpmTaskNotice;
import com.hotent.bpm.persistence.model.BpmTaskNoticeDone;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.persistence.model.DefaultBpmTaskTurn;
import com.hotent.bpm.persistence.util.ServiceUtil;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.bpm.util.MessageUtil;
import com.hotent.i18n.util.I18nUtil;
import com.hotent.runtime.annotation.PermissionCheck;
import com.hotent.runtime.annotation.TaskTransDesensitizeHandle;
import com.hotent.runtime.manager.BpmTaskTransManager;
import com.hotent.runtime.manager.BpmTaskTransRecordManager;
import com.hotent.runtime.manager.IFlowManager;
import com.hotent.runtime.manager.IProcessManager;
import com.hotent.runtime.manager.TaskTransService;
import com.hotent.runtime.model.BpmTaskTransRecord;
import com.hotent.runtime.params.AssignParamObject;
import com.hotent.runtime.params.BpmNodeDefVo;
import com.hotent.runtime.params.BpmTaskResult;
import com.hotent.runtime.params.CommunicateParamObject;
import com.hotent.runtime.params.DoNextParamObject;
import com.hotent.runtime.params.IsAllowAddSignObject;
import com.hotent.runtime.params.ModifyExecutorsParamObject;
import com.hotent.runtime.params.TaskApproveLineParam;
import com.hotent.runtime.params.TaskCommuVo;
import com.hotent.runtime.params.TaskDetailVo;
import com.hotent.runtime.params.TaskDoNextVo;
import com.hotent.runtime.params.TaskGetVo;
import com.hotent.runtime.params.TaskToAgreeVo;
import com.hotent.runtime.params.TaskToRejectVo;
import com.hotent.runtime.params.TaskTransParamObject;
import com.hotent.runtime.params.TaskjImageVo;
import com.hotent.runtime.params.WithDrawParam;
import com.hotent.runtime.service.TaskService;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/runtime/task/v1/"})
@Api(tags={"\u6d41\u7a0b\u4efb\u52a1"})
@ApiGroup(group={"group_bpm"})
public class TaskController
extends BaseController<BpmTaskManager, DefaultBpmTask> {
    @Resource
    IFlowManager iFlowService;
    @Resource
    NatTaskService natTaskService;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    IUserService userService;
    @Resource
    IProcessManager iProcessService;
    @Resource
    BpmTaskTransRecordManager taskTransRecordManager;
    @Resource
    BpmTaskCommuManager bpmTaskCommuManager;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    BpmDefAuthorizeManager bpmDefAuthorizeManager;
    @Resource
    BpmCommuReceiverManager bpmCommuReceiverManager;
    @Resource
    BpmAgentService bpmAgentService;
    @Resource
    TaskTransService taskTransService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmTaskTransManager bpmTaskTransManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BaseContext baseContext;
    @Resource
    BpmSaveOpinionManager bpmSaveOpinionManager;
    @Resource
    BpmIdentityService bpmIdentityService;
    @Resource
    BpmIdentityExtractService bpmIdentityExtractService;
    @Autowired
    TaskService taskService;
    @Resource
    BpmTaskService bpmTaskService;

    @RequestMapping(value={"getBpmTaskNoticeById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4e3b\u952eID\u83b7\u53d6\u5f85\u529e\u77e5\u4f1a\u4efb\u52a1\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u4e3b\u952eID\u83b7\u53d6\u5f85\u529e\u77e5\u4f1a\u4efb\u52a1\u4fe1\u606f")
    public BpmTaskNotice getBpmTaskNoticeById(@ApiParam(required=true, name="id", value="\u5f85\u529e\u77e5\u4f1a\u4efb\u52a1\u4e3b\u952eId") String id) throws NotFoundException {
        BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
        BpmTaskNotice notice = (BpmTaskNotice)noticeManager.get((Serializable)((Object)id));
        if (BeanUtils.isEmpty((Object)notice)) {
            throw new NotFoundException(String.format("\u6839\u636e\u4f20\u9605\u4efb\u52a1id\u3010%s\u3011\u672a\u627e\u5230\u4efb\u52a1\u3002", id));
        }
        if (StringUtil.isNotEmpty((String)notice.getOpinionId())) {
            DefaultBpmCheckOpinion checkOpinion = (DefaultBpmCheckOpinion)this.bpmCheckOpinionManager.get((Serializable)((Object)notice.getOpinionId()));
            notice.setFormData(checkOpinion.getFormData());
        }
        return notice;
    }

    @RequestMapping(value={"getBpmTaskNoticeDoneById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4e3b\u952eID\u83b7\u53d6\u5df2\u529e\u77e5\u4f1a\u4efb\u52a1\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u4e3b\u952eID\u83b7\u53d6\u5df2\u529e\u77e5\u4f1a\u4efb\u52a1\u4fe1\u606f")
    public BpmTaskNoticeDone getBpmTaskNoticeDoneById(@ApiParam(required=true, name="id", value="\u5df2\u529e\u77e5\u4f1a\u4efb\u52a1\u4e3b\u952eId") String id) {
        BpmTaskNoticeDoneManager noticeDoneManager = (BpmTaskNoticeDoneManager)AppUtil.getBean(BpmTaskNoticeDoneManager.class);
        BpmTaskNoticeDone noticeDone = (BpmTaskNoticeDone)noticeDoneManager.get((Serializable)((Object)id));
        return noticeDone;
    }

    @RequestMapping(value={"getTaskKeyByTaskId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1Id\u83b7\u53d6\u5ba1\u6279\u5386\u53f2\u6570\u636e\uff08\u53ea\u6709\u4e00\u6761\uff09", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1Id\u83b7\u53d6\u5ba1\u6279\u5386\u53f2\u6570\u636e\uff08\u53ea\u6709\u4e00\u6761\uff09")
    public DefaultBpmCheckOpinion getTaskKeyByTaskId(@ApiParam(required=true, name="taskId", value="\u4efb\u52a1Id") String taskId) {
        DefaultBpmCheckOpinion defaultBpmCheckOpinion = this.bpmCheckOpinionManager.getTaskKeyByTaskId(taskId);
        return defaultBpmCheckOpinion;
    }

    @RequestMapping(value={"getTaskKeyByNodeId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1\u8282\u70b9ID\u548c\u6d41\u7a0b\u5b9e\u4f8bID\u83b7\u53d6\u5ba1\u6279\u5386\u53f2\u6570\u636e\uff08\u53ea\u6709\u4e00\u6761\uff09", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1\u8282\u70b9ID\u548c\u6d41\u7a0b\u5b9e\u4f8bID\u83b7\u53d6\u5ba1\u6279\u5386\u53f2\u6570\u636e\uff08\u53ea\u6709\u4e00\u6761\uff09")
    public DefaultBpmCheckOpinion getTaskKeyByNodeId(@ApiParam(required=true, name="nodeId", value="\u4efb\u52a1\u8282\u70b9Id") String nodeId, @ApiParam(required=true, name="instId", value="\u6d41\u7a0b\u5b9e\u4f8bId") String instId) {
        DefaultBpmCheckOpinion defaultBpmCheckOpinion = this.bpmCheckOpinionManager.getTaskKeyByNodeId(nodeId, instId);
        return defaultBpmCheckOpinion;
    }

    @RequestMapping(value={"retrieveBpmTask"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u56de\u59d4\u6258/\u8f6c\u529e\u6d41\u7a0b", httpMethod="GET", notes="\u53d6\u56de\u59d4\u6258/\u8f6c\u529e\u6d41\u7a0b\u6d41\u7a0b")
    public CommonResult<String> retrieveBpmTask(@ApiParam(required=true, name="taskId", value="\u4efb\u52a1taskId") String taskId) {
        IUser user = ContextUtil.getCurrentUser();
        return this.bpmTaskManager.retrieveBpmTask(user, taskId);
    }

    @RequestMapping(value={"divertBpmTask"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8f6c\u79fb\u4efb\u52a1\u7ed9\u7528\u6237", httpMethod="POST", notes="\u8f6c\u79fb\u4efb\u52a1\u7528\u6237")
    public CommonResult<String> divertBpmTask(@ApiParam(name="map", value="\u53c2\u6570", required=true) @RequestBody Map<String, Object> map) throws Exception {
        return this.bpmTaskManager.divertBpmTask(map);
    }

    @PostMapping(value={"getTodoCountByTeam"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u529e\u6570\u76ee(\u6839\u636e\u7528\u6237\u3001\u7ec4\u7ec7\u3001\u5c97\u4f4d\u3001\u89d2\u8272)", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u529e\u6570\u76ee(\u6839\u636e\u7528\u6237\u3001\u7ec4\u7ec7\u3001\u5c97\u4f4d\u3001\u89d2\u8272)")
    public List<Map<String, Object>> getTodoCountByTeam(@ApiParam(name="team", value="\u7528\u6237\u3001\u7ec4\u7ec7\u3001\u5c97\u4f4d\u3001\u89d2\u8272(\u53c2\u6570\u5982\uff1a{key:'user',val:'1'})", required=true) @RequestParam String team) throws Exception {
        return this.bpmTaskManager.getTodoCountByTeam(team);
    }

    @RequestMapping(value={"getTodoListByTeam"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u529e\u4e8b\u5b9c(\u6839\u636e\u7528\u6237\u3001\u7ec4\u7ec7\u3001\u5c97\u4f4d\u3001\u89d2\u8272)", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u529e\u4e8b\u5b9c(\u6839\u636e\u7528\u6237\u3001\u7ec4\u7ec7\u3001\u5c97\u4f4d\u3001\u89d2\u8272")
    public PageList<DefaultBpmTask> getTodoListByTeam(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter<DefaultBpmTask> queryFilter, @ApiParam(name="team", value="\u7528\u6237\u3001\u7ec4\u7ec7\u3001\u5c97\u4f4d\u3001\u89d2\u8272(\u53c2\u6570\u5982\uff1a{key:'user',val:'1'})", required=true) @RequestParam String team) throws Exception {
        PageList<DefaultBpmTask> pageList = this.iFlowService.getTodoListByTeam(team, queryFilter);
        return pageList;
    }

    @RequestMapping(value={"exportTodoListByTeam"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u5f85\u529e\u4fe1\u606f", httpMethod="POST", notes="\u5bfc\u51fa\u5f85\u529e\u4fe1\u606f")
    public void exportTodoListByTeam(@ApiParam(name="filter", value="\u67e5\u8be2\u5bf9\u8c61", required=true) @RequestBody QueryFilter filter, @ApiParam(name="team", value="\u7528\u6237\u3001\u7ec4\u7ec7\u3001\u5c97\u4f4d\u3001\u89d2\u8272(\u53c2\u6570\u5982\uff1a{key:'user',val:'1'})", required=true) @RequestParam String team, HttpServletResponse httpServletResponse) throws Exception {
        this.iFlowService.exportTodoListByTeam(team, filter, httpServletResponse);
    }

    @RequestMapping(value={"getLeaderTodoList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u9886\u5bfc\u7684\u5f85\u529e\u4e8b\u5b9c", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u9886\u5bfc\u7684\u5f85\u529e\u4e8b\u5b9c")
    public PageList<DefaultBpmTask> getLeaderTodoList(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        PageList<DefaultBpmTask> res = this.taskService.getLeaderTodoList(queryFilter);
        return res;
    }

    @RequestMapping(value={"getLeaderTodoCard"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u9886\u5bfc\u7684\u5f85\u529e\u4e8b\u5b9c", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u9886\u5bfc\u7684\u5f85\u529e\u4e8b\u5b9c")
    public CommonResult<Map<String, BpmLeaderTask>> getLeaderTodoCard(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter, @ApiParam(required=true, name="size", defaultValue="6") @RequestParam Integer size) throws Exception {
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", this.taskService.getLeaderTodoCard(queryFilter, size));
    }

    @RequestMapping(value={"getTodoList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7684\u5f85\u529e\u4e8b\u5b9c", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u7684\u5f85\u529e\u4e8b\u5b9c")
    public PageList<DefaultBpmTask> getTodoList(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter<DefaultBpmTask> queryFilter) throws Exception {
        PageList<DefaultBpmTask> res = this.taskService.getTodoList(queryFilter);
        return res;
    }

    @RequestMapping(value={"deleteAgendaDay"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u5f85\u529e\u7c7b\u578b\u65e5\u7a0b", httpMethod="POST", notes="\u6839\u636eid\u5220\u9664\u5f85\u529e\u7c7b\u578b\u65e5\u7a0b")
    public CommonResult<String> deleteAgendaDay(@ApiParam(name="id", value="\u5f85\u529eid\uff0cbpm_task\u8868\u4e3b\u952e") @RequestParam(value="id") String id) throws Exception {
        this.bpmTaskManager.deleteAgendaDay(id);
        return CommonResult.ok();
    }

    @RequestMapping(value={"getTodoCard"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5f85\u529e\uff0c\u901a\u8fc7defKey\u5206\u7c7b\uff0c\u5e76\u83b7\u53d6\u524dn\u4e2a", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u5f85\u529e\uff0c\u901a\u8fc7defKey\u5206\u7c7b\uff0c\u5e76\u83b7\u53d6\u524dn\u4e2a")
    public CommonResult<Map<String, List<DefaultBpmTask>>> getTodoCard(@ApiParam(required=true, name="queryFilter") @RequestBody QueryFilter<DefaultBpmTask> queryFilter, @ApiParam(required=true, name="size", defaultValue="6") @RequestParam Integer size) throws Exception {
        Map result = ((BpmTaskManager)this.baseService).getTodoCard(queryFilter, size);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)result);
    }

    @RequestMapping(value={"getTodoCardCount"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u529e\u6570\u91cf\uff0c\u901a\u8fc7defKey\u5206\u7c7b", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u529e\u6570\u91cf\uff0c\u901a\u8fc7defKey\u5206\u7c7b")
    public CommonResult<Map<String, String>> getTodoCardCount() {
        Map map = ((BpmTaskManager)this.baseService).getTodoCardCount();
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)map);
    }

    @PostMapping(value={"getTodoCount"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u529e\u6570\u76ee", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u529e\u6570\u76ee")
    public List<Map<String, Object>> getTodoCount(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.bpmTaskManager.getCountByUserId(this.baseContext.getCurrentUserId());
    }

    @RequestMapping(value={"getMobileTodoList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u624b\u673a\u7684\u5f85\u529e\u4e8b\u5b9c", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u624b\u673a\u7684\u5f85\u529e\u4e8b\u5b9c")
    public PageList<DefaultBpmTask> getMobileTodoList(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        queryFilter.addFilter("bt.SUPPORT_MOBILE_", (Object)1, QueryOP.EQUAL, FieldRelation.AND, "m");
        CompletableFuture<PageList<DefaultBpmTask>> result = this.iFlowService.getTodoList(this.baseContext.getCurrentUserAccout(), (QueryFilter<DefaultBpmTask>)queryFilter);
        return result.get();
    }

    @RequestMapping(value={"getDelegate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u8f6c\u529e\u4ee3\u7406\u4e8b\u5b9c", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u8f6c\u529e\u4ee3\u7406\u4e8b\u5b9c")
    public PageList<DefaultBpmTaskTurn> getMyDelegate(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.iFlowService.getDelegate(this.baseContext.getCurrentUserAccout(), queryFilter);
    }

    @RequestMapping(value={"getDelegateCard"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u8f6c\u529e\u4ee3\u7406\u4e8b\u5b9c", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u8f6c\u529e\u4ee3\u7406\u4e8b\u5b9c")
    public CommonResult<Map<String, List<DefaultBpmTaskTurn>>> getDelegateCard(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter, @ApiParam(name="size", value="\u5206\u9875\u6570\u91cf") @RequestParam(required=false) Optional<Integer> size) throws Exception {
        Map<String, List<DefaultBpmTaskTurn>> result = this.iFlowService.getDelegateCard(this.baseContext.getCurrentUserAccout(), queryFilter, size.orElse(10));
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", result);
    }

    @PostMapping(value={"getDelegateCount"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u8f6c\u529e\u4ee3\u7406\u4e8b\u5b9c\u6570\u91cf", httpMethod="POST", notes="\u83b7\u53d6\u7528\u6237\u8f6c\u529e\u4ee3\u7406\u4e8b\u5b9c")
    public List<Map<String, Object>> getMyDelegateCount(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.iFlowService.getDelegateCount(this.baseContext.getCurrentUserAccout(), queryFilter);
    }

    @RequestMapping(value={"getMobileDelegate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u624b\u673a\u7528\u6237\u8f6c\u529e\u4ee3\u7406\u4e8b\u5b9c", httpMethod="POST", notes="\u83b7\u53d6\u624b\u673a\u7528\u6237\u8f6c\u529e\u4ee3\u7406\u4e8b\u5b9c")
    public PageList<DefaultBpmTaskTurn> getMobileDelegate(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.iFlowService.getDelegate(this.baseContext.getCurrentUserAccout(), queryFilter);
    }

    @RequestMapping(value={"getMyTrans"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6211\u7684\u6d41\u8f6c\u4efb\u52a1", httpMethod="POST", notes="\u6211\u7684\u6d41\u8f6c\u4efb\u52a1")
    public PageList<BpmTaskTransRecord> getMyTrans(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter, HttpServletResponse response) throws Exception {
        return this.iFlowService.getMyTrans(this.baseContext.getCurrentUserAccout(), queryFilter);
    }

    @RequestMapping(value={"delegate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4efb\u52a1\u8f6c\u529e", httpMethod="POST", notes="\u4efb\u52a1\u8f6c\u529e")
    @TaskTransDesensitizeHandle
    public CommonResult<String> delegate(@ApiParam(required=true, name="assignParamObject", value="\u4efb\u52a1\u8f6c\u529e\u53c2\u6570") @RequestBody AssignParamObject assignParamObject, HttpServletResponse response, @ApiParam(name="leaderId", value="\u9886\u5bfcid", required=false) @RequestParam(required=false) Optional<String> leaderId, @ApiParam(name="assignee", value="\u4efb\u52a1\u5904\u7406\u4eba\u8d26\u53f7", required=false) @RequestParam(required=false) Optional<String> assignee) throws Exception {
        return this.taskService.delegate(assignParamObject, response, leaderId, assignee);
    }

    @RequestMapping(value={"doCancelTurn"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u53d6\u6d88\u4ee3\u7406\u6216\u8f6c\u529e", httpMethod="POST", notes="\u53d6\u6d88\u4ee3\u7406\u6216\u8f6c\u529e")
    @TaskTransDesensitizeHandle
    public CommonResult<String> doCancelTurn(@ApiParam(required=true, name="assignParamObject", value="\u53d6\u6d88\u4ee3\u7406\u6216\u8f6c\u529e") @RequestBody AssignParamObject assignParamObject, HttpServletResponse response) throws Exception {
        try {
            this.bpmAgentService.retrieveTask(assignParamObject.getTaskId(), assignParamObject.getMessageType(), assignParamObject.getOpinion());
        }
        catch (Exception e) {
            return new CommonResult(false, "\u53d6\u6d88\u4efb\u52a1\u5931\u8d25\uff01" + e.getMessage());
        }
        return new CommonResult(true, "\u53d6\u6d88\u6d41\u8f6c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"doRevokeTrans"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5904\u7406\u64a4\u9500\u6d41\u8f6c\u4efb\u52a1", httpMethod="POST", notes="\u5904\u7406\u64a4\u9500\u6d41\u8f6c\u4efb\u52a1")
    public CommonResult<String> doRevokeTrans(@ApiParam(required=true, name="withDrawParam", value="\u64a4\u9500\u6d41\u8f6c\u4efb\u52a1\u53c2\u6570") @RequestBody WithDrawParam withDrawParam, HttpServletResponse response) throws Exception {
        try {
            return this.iFlowService.withDraw(withDrawParam);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6d41\u8f6c\u4efb\u52a1\u53d6\u56de\u5931\u8d25\uff01" + e.getMessage());
        }
    }

    @RequestMapping(value={"communicate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4efb\u52a1\u6c9f\u901a", httpMethod="POST", notes="\u4efb\u52a1\u6c9f\u901a")
    public CommonResult<String> communicate(@ApiParam(required=true, name="communicateParamObject", value="\u4efb\u52a1\u6c9f\u901a\u53c2\u6570") @RequestBody CommunicateParamObject communicateParamObject) throws Exception {
        return this.iFlowService.communicate(communicateParamObject);
    }

    @RequestMapping(value={"taskSignUsers"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u52a0\u7b7e", httpMethod="POST", notes="\u52a0\u7b7e")
    @TaskTransDesensitizeHandle
    public CommonResult<String> taskSignUsers(@ApiParam(required=true, name="signParamObject", value="\u4efb\u52a1\u52a0\u7b7e\u53c2\u6570") @RequestBody AssignParamObject signParamObject, HttpServletResponse response) throws Exception {
        return this.iFlowService.taskSignUsers(signParamObject);
    }

    @RequestMapping(value={"taskCustomSignUsers"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6dfb\u52a0\u7b7e\u7f72\u4eba\u5458", httpMethod="POST", notes="\u6dfb\u52a0\u7b7e\u7f72\u4eba\u5458")
    public CommonResult<String> taskCustomSignUsers(@ApiParam(required=true, name="signParamObject", value="\u4efb\u52a1\u52a0\u7b7e\u53c2\u6570") @RequestBody AssignParamObject signParamObject, HttpServletResponse response) throws Exception {
        return this.iFlowService.taskCustomSignUsers(signParamObject);
    }

    @GetMapping(value={"getTaskVar"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1taskId, \u83b7\u53d6\u6d41\u7a0b\u53d8\u91cf(\u5168\u5c40\u548c\u8282\u70b9)", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1id, \u83b7\u53d6\u6d41\u7a0b\u53d8\u91cf(\u5168\u5c40\u548c\u8282\u70b9)")
    public Map<String, Object> getTaskVar(@ApiParam(name="taskId", required=true) @RequestParam String taskId) {
        return this.natTaskService.getVariables(taskId);
    }

    @GetMapping(value={"getTaskVarLocal"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1taskId,\u83b7\u53d6\u6d41\u7a0b\u4efb\u52a1\u8282\u70b9\u7684\u53d8\u91cf", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1id,\u83b7\u53d6\u6d41\u7a0b\u4efb\u52a1\u8282\u70b9\u7684\u53d8\u91cf")
    public Map<String, Object> getTaskVarLocal(@ApiParam(name="taskId", required=true) @RequestParam String taskId) {
        return this.natTaskService.getVariablesLocal(taskId);
    }

    @GetMapping(value={"getWorkflowVar"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49ID\u6216\u6d41\u7a0b\u5b9a\u4e49KEY\u83b7\u53d6\u6d41\u7a0b\u53d8\u91cf", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49ID\u6216\u6d41\u7a0b\u5b9a\u4e49KEY\u83b7\u53d6\u6d41\u7a0b\u53d8\u91cf")
    public List<BpmVariableDef> getWorkflowVar(@ApiParam(name="json", required=true) @RequestParam String json) throws Exception {
        return this.iFlowService.getWorkflowVar(json);
    }

    @PostMapping(value={"setTaskVar"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1taskId,\u8bbe\u7f6e\u6d41\u7a0b\u53d8\u91cf", httpMethod="POST", notes="\u6839\u636e\u4efb\u52a1taskId,\u8bbe\u7f6e\u6d41\u7a0b\u53d8\u91cf")
    public CommonResult<String> setTaskVar(@ApiParam(name="taskId", required=true) @RequestParam String taskId, @ApiParam(name="variables", required=true) @RequestBody Map<String, Object> variables) throws Exception {
        return this.iProcessService.setTaskVar(taskId, variables);
    }

    @PostMapping(value={"setTaskVarLocal"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1taskId,\u8bbe\u7f6e\u4efb\u52a1\u8282\u70b9\u672c\u5730\u53d8\u91cf", httpMethod="POST", notes="\u6839\u636e\u4efb\u52a1taskId,\u8bbe\u7f6e\u6d41\u7a0b\u53d8\u91cf")
    public CommonResult<String> setTaskVarLocal(@ApiParam(name="taskId", required=true) @RequestParam String taskId, @ApiParam(name="variables", required=true) @RequestBody Map<String, Object> variables) throws Exception {
        return this.iProcessService.setTaskVarLocal(taskId, variables);
    }

    @PostMapping(value={"isAllowAddSign"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u6dfb\u52a0\u4f1a\u7b7e\u6743\u9650", httpMethod="POST", notes="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u6dfb\u52a0\u4f1a\u7b7e\u6743\u9650")
    public Boolean isAllowAddSign(@RequestBody @ApiParam(name="isAllowAddSignObject", required=true) IsAllowAddSignObject isAllowAddSignObject) throws Exception {
        return this.iFlowService.isAllowAddSign(isAllowAddSignObject);
    }

    @RequestMapping(value={"setTaskExecutors"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u4efb\u52a1\u6267\u884c\u4eba", httpMethod="POST", notes="\u4fee\u6539\u4efb\u52a1\u6267\u884c\u4eba")
    public CommonResult<String> setTaskExecutors(@ApiParam(required=true, name="modifyExecutorsParamObject", value="\u4fee\u6539\u6267\u884c\u4eba\u5bf9\u8c61") @RequestBody ModifyExecutorsParamObject modifyExecutorsParamObject) throws Exception {
        return this.iFlowService.setTaskExecutors(modifyExecutorsParamObject);
    }

    @RequestMapping(value={"taskToTrans"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6d41\u8f6c\u4fe1\u606f\uff08\u589e\u52a0\u6d41\u8f6c\uff09", httpMethod="POST", notes="\u4fdd\u5b58\u6d41\u8f6c\u4fe1\u606f\uff08\u589e\u52a0\u6d41\u8f6c\uff09")
    @TaskTransDesensitizeHandle
    public CommonResult<String> taskToTrans(@ApiParam(name="taskTransParamObject", value="\u6d41\u8f6c\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody TaskTransParamObject taskTransParamObject, @ApiParam(name="leaderId", value="\u9886\u5bfcid", required=false) @RequestParam(required=false) Optional<String> leaderId) throws Exception {
        BpmUtil.checkDefForbidStatus((String)"", (String)"", (String)taskTransParamObject.getTaskId());
        if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
            ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
        }
        return this.iFlowService.taskToTrans(taskTransParamObject);
    }

    @RequestMapping(value={"userTaskToSign"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u666e\u901a\u4efb\u52a1\u52a0\u7b7e\uff08\u6d41\u8f6c\u505a\u7684\uff09", httpMethod="POST", notes="\u666e\u901a\u4efb\u52a1\u52a0\u7b7e")
    @TaskTransDesensitizeHandle
    public CommonResult<String> userTaskToSign(@ApiParam(name="taskTransParamObject", value="\u52a0\u7b7e\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody TaskTransParamObject taskTransParamObject, @ApiParam(name="leaderId", value="\u9886\u5bfcid", required=false) @RequestParam(required=false) Optional<String> leaderId) throws Exception {
        BpmUtil.checkDefForbidStatus((String)"", (String)"", (String)taskTransParamObject.getTaskId());
        if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
            ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
        }
        return this.iFlowService.userTaskToSign(taskTransParamObject);
    }

    @RequestMapping(value={"taskToSignSequence"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u987a\u5e8f\u7b7e\u7f72\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u987a\u5e8f\u7b7e\u7f72\u4fe1\u606f")
    @TaskTransDesensitizeHandle
    public CommonResult<String> taskToSignSequence(@ApiParam(name="taskTransParamObject", value="\u6d41\u8f6c\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody TaskTransParamObject taskTransParamObject, @ApiParam(name="leaderId", value="\u9886\u5bfcid", required=false) @RequestParam Optional<String> leaderId) throws Exception {
        BpmUtil.checkDefForbidStatus((String)"", (String)"", (String)taskTransParamObject.getTaskId());
        if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
            ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
        }
        return this.iFlowService.taskToSignSequence(taskTransParamObject);
    }

    @RequestMapping(value={"taskToSignLine"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5e76\u884c\u7b7e\u7f72\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u5e76\u884c\u7b7e\u7f72\u4fe1\u606f")
    @TaskTransDesensitizeHandle
    public CommonResult<String> taskToSignLine(@ApiParam(name="taskTransParamObject", value="\u6d41\u8f6c\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody TaskTransParamObject taskTransParamObject, @ApiParam(name="leaderId", value="\u9886\u5bfcid", required=false) @RequestParam Optional<String> leaderId) throws Exception {
        if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
            ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
        }
        return this.iFlowService.taskToSignLine(taskTransParamObject);
    }

    @RequestMapping(value={"taskToApproveLine"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5e76\u884c\u5ba1\u6279\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u5e76\u884c\u5ba1\u6279\u4fe1\u606f")
    @TaskTransDesensitizeHandle
    public CommonResult<String> taskToApproveLine(@ApiParam(name="taskTransParamObject", value="\u5e76\u884c\u5ba1\u6279\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody TaskApproveLineParam taskApproveLineParam, @ApiParam(name="leaderId", value="\u9886\u5bfcid", required=false) @RequestParam Optional<String> leaderId) throws Exception {
        if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
            ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
        }
        return this.iFlowService.taskToApproveLine(taskApproveLineParam);
    }

    @RequestMapping(value={"getTaskByTaskId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u4efb\u52a1id\u83b7\u53d6\u4efb\u52a1\u5bf9\u8c61", httpMethod="GET", notes="\u901a\u8fc7\u4efb\u52a1id\u83b7\u53d6\u4efb\u52a1\u5bf9\u8c61")
    public BpmTaskResult getTaskByTaskId(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.iProcessService.getTaskByTaskId(taskId);
    }

    @RequestMapping(value={"getTaskNameByTaskId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u4efb\u52a1id\u83b7\u53d6\u4efb\u52a1\u540d\u79f0", httpMethod="GET", notes="\u901a\u8fc7\u4efb\u52a1id\u83b7\u53d6\u4efb\u52a1\u540d\u79f0")
    public String getTaskNameByTaskId(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.iProcessService.getTaskNameByTaskId(taskId);
    }

    @RequestMapping(value={"getTasksByInstId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u5b9e\u4f8bid\u83b7\u53d6\u4efb\u52a1\u5217\u8868", httpMethod="GET", notes="\u901a\u8fc7\u5b9e\u4f8bid\u83b7\u53d6\u4efb\u52a1\u5217\u8868")
    public PageList<DefaultBpmTask> getTasksByInstId(@ApiParam(name="instId", value="\u5b9e\u4f8bid", required=true) @RequestParam String instId) throws Exception {
        return this.iProcessService.getTasksByInstId(instId);
    }

    @RequestMapping(value={"instanceDetail"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u5b9e\u4f8bID\u96c6\u5408\u83b7\u53d6\u6d41\u7a0b\u5f53\u524d\u72b6\u6001\u4fe1\u606f", httpMethod="POST", notes="\u901a\u8fc7\u5b9e\u4f8bID\u96c6\u5408\u83b7\u53d6\u6d41\u7a0b\u5f53\u524d\u72b6\u6001\u4fe1\u606f")
    public CommonResult<Map<String, List<DefaultBpmTask>>> getTasksByInstIds(@ApiParam(name="ids", value="\u5b9e\u4f8bid\u96c6\u5408", required=true) @RequestBody List<String> ids) throws Exception {
        Map<String, List<DefaultBpmTask>> result = this.iProcessService.instanceDetails(ids);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", result);
    }

    @RequestMapping(value={"getMyRequestTask"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6211\u7684\u8bf7\u6c42\u5bf9\u5e94\u5b9e\u4f8b\u7684\u5f53\u524d\u4efb\u52a1", httpMethod="POST", notes="\u83b7\u53d6\u6211\u7684\u8bf7\u6c42\u5bf9\u5e94\u5b9e\u4f8b\u7684\u5f53\u524d\u4efb\u52a1")
    public CommonResult<DefaultBpmTask> getMyRequestTask(@ApiParam(name="id", value="\u5b9e\u4f8bid", required=true) @RequestBody String id) throws Exception {
        DefaultBpmTask result = this.iProcessService.getMyRequestTask(id);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)result);
    }

    @RequestMapping(value={"getNextTaskUsers"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u4e0b\u4e00\u73af\u8282\u5904\u7406\u4eba", notes="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u4e0b\u4e00\u73af\u8282\u5904\u7406\u4eba", httpMethod="GET")
    public Map<String, List<BpmIdentity>> getNextTaskUsers(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.iFlowService.getNextTaskUsers(taskId);
    }

    @RequestMapping(value={"getApprovalItems"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u9884\u5148\u8bbe\u7f6e\u7684\u5ba1\u6279\u7528\u8bed\u5217\u8868", notes="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u9884\u5148\u8bbe\u7f6e\u7684\u5ba1\u6279\u7528\u8bed\u5217\u8868", httpMethod="GET")
    public List<String> getApprovalItems(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.iProcessService.getApprovalItems(taskId);
    }

    @RequestMapping(value={"getTaskOutNodes"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u4efb\u52a1id\u83b7\u53d6\u4efb\u52a1\u7684\u540e\u7eed\u8282\u70b9", httpMethod="GET", notes="\u901a\u8fc7\u4efb\u52a1id\u83b7\u53d6\u4efb\u52a1\u7684\u540e\u7eed\u8282\u70b9")
    public List<BpmNodeDefVo> getTaskOutNodes(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.iProcessService.getTaskOutNodes(taskId);
    }

    @GetMapping(value={"getUrlFormByTaskId"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u7684\u5728\u7ebf\u8868\u5355\u5730\u5740", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u7684\u5728\u7ebf\u8868\u5355\u5730\u5740")
    public String getUrlFormByTaskId(@ApiParam(name="taskId", required=true) @RequestParam String taskId, @ApiParam(name="formType", required=true, defaultValue="pc") @RequestParam String formType) throws Exception {
        return this.iFlowService.getUrlFormByTaskId(taskId, formType);
    }

    @GetMapping(value={"getInstUrlForm"}, produces={"application/json;charset=UTF-8"})
    @ApiOperation(value="\u83b7\u53d6\u5b9e\u4f8b\u5728\u7ebf\u8868\u5355", httpMethod="GET", notes="\u83b7\u53d6\u5b9e\u4f8b\u5728\u7ebf\u8868\u5355")
    public String getInstUrlForm(@ApiParam(name="proInstId", required=true) @RequestParam String proInstId, @ApiParam(name="nodeId", required=false) @RequestParam(required=false) String nodeId, @ApiParam(name="formType", required=true, defaultValue="pc") @RequestParam String formType) throws Exception {
        return this.iFlowService.getInstUrlForm(proInstId, nodeId, formType);
    }

    @RequestMapping(value={"taskDoNext"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7ba1\u7406\u5458\u5904\u7406\u4efb\u52a1\u9875\u9762", httpMethod="GET", notes="\u7ba1\u7406\u5458\u5904\u7406\u4efb\u52a1\u9875\u9762")
    public TaskDoNextVo taskDoNext(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.iFlowService.taskDoNext(taskId).get();
    }

    @RequestMapping(value={"taskApprove"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5ba1\u6279\u754c\u9762\u53c2\u6570", httpMethod="GET", notes="\u83b7\u53d6\u7528\u6237\u5ba1\u6279\u754c\u9762\u53c2\u6570")
    public TaskDoNextVo taskApprove(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.iFlowService.taskApprove(taskId);
    }

    @RequestMapping(value={"taskImage"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u67e5\u770b\u4efb\u52a1\u6d41\u7a0b\u56fe\u53c2\u6570", httpMethod="GET", notes="\u83b7\u53d6\u67e5\u770b\u4efb\u52a1\u6d41\u7a0b\u56fe\u754c\u9762\u53c2\u6570")
    public TaskjImageVo taskImage(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam(required=true) Optional<String> taskId, @ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=false) @RequestParam(required=false) Optional<String> defId) throws Exception {
        return this.iFlowService.taskImage(taskId.orElse(""), defId.orElse(""));
    }

    @RequestMapping(value={"nodeOpinion"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u4e2d\u6307\u5b9a\u8282\u70b9\u7684\u5ba1\u6279\u610f\u89c1", httpMethod="GET", notes="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u4e2d\u6307\u5b9a\u8282\u70b9\u7684\u5ba1\u6279\u610f\u89c1")
    public Object nodeOpinion(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam Optional<String> defId, @ApiParam(name="instId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) @RequestParam Optional<String> instId, @ApiParam(name="nodeId", value="\u4efb\u52a1\u8282\u70b9id\uff0c\u591a\u4e2a\u4ee5\u9017\u53f7\u62fc\u63a5", required=true) @RequestParam String nodeId) throws Exception {
        return this.taskService.nodeOpinion(defId, instId, nodeId, true);
    }

    @RequestMapping(value={"nodeOpinionFromPreview"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u4e2d\u6307\u5b9a\u8282\u70b9\u7684\u5ba1\u6279\u610f\u89c1 \u4f1a\u7b7e\u8282\u70b9\u8bb0\u5f55\u4f1a\u8fdb\u884c\u5206\u7ec4", httpMethod="GET", notes="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u4e2d\u6307\u5b9a\u8282\u70b9\u7684\u5ba1\u6279\u610f\u89c1 \u4f1a\u7b7e\u8282\u70b9\u8bb0\u5f55\u4f1a\u8fdb\u884c\u5206\u7ec4")
    public Object nodeOpinionFromPreview(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam Optional<String> defId, @ApiParam(name="instId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) @RequestParam Optional<String> instId, @ApiParam(name="nodeId", value="\u4efb\u52a1\u8282\u70b9id\uff0c\u591a\u4e2a\u4ee5\u9017\u53f7\u62fc\u63a5", required=true) @RequestParam String nodeId, @ApiParam(name="isDerive", value="\u662f\u5426\u63a8\u6f14\u672a\u5230\u8fbe\u8282\u70b9\u5ba1\u6279\u4eba", required=true) @RequestParam Optional<String> isDerive) throws Exception {
        boolean derive = true;
        if (isDerive.orElse("true").equals("false")) {
            derive = false;
        }
        return this.taskService.nodeOpinionFromPreview(defId, instId, nodeId, derive);
    }

    @RequestMapping(value={"taskBackOpinion"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u5b9e\u4f8b\u6700\u8fd1\u4e00\u6b21\u7684\u9a73\u56de\u8bb0\u5f55", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u5b9e\u4f8b\u6700\u8fd1\u4e00\u6b21\u7684\u9a73\u56de\u8bb0\u5f55")
    public Object taskBackOpinion(@ApiParam(name="instId", value="\u6d41\u7a0b\u5b9a\u4e49id", required=true) @RequestParam String instId) throws Exception {
        return this.taskService.taskBackOpinion(instId);
    }

    @RequestMapping(value={"getButtonsBytaskId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1ID\u83b7\u53d6\u5ba1\u6279\u6309\u94ae", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1ID\u83b7\u53d6\u5ba1\u6279\u6309\u94ae")
    public TaskDetailVo getButtonsBytaskId(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="leaderId", value="\u4ee3\u4e3a\u5904\u7406\u7684\u9886\u5bfcid", required=true) @RequestParam Optional<String> leaderId) throws Exception {
        return this.taskService.getButtonsBytaskId(taskId, leaderId);
    }

    @RequestMapping(value={"taskDetail"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u7684\u8be6\u60c5", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u7684\u8be6\u60c5")
    public TaskDetailVo taskDetail(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="reqParams", value="\u8bf7\u6c42\u53c2\u6570", required=false) @RequestParam(required=false) String reqParams, @ApiParam(name="leaderId", value="\u4ee3\u4e3a\u5904\u7406\u7684\u9886\u5bfcid", required=false) @RequestParam(required=false) Optional<String> leaderId) throws Exception {
        return this.iFlowService.taskDetail(taskId, reqParams, FormType.PC, leaderId.orElse("")).get();
    }

    @RequestMapping(value={"taskDetailBo"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u7684\u8be6\u60c5", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u7684\u8be6\u60c5")
    @PermissionCheck(taskId="#taskId", isDefAuthorize="#isDefAuthorize")
    public CommonResult<TaskDetailVo> taskDetailBo(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="reqParams", value="\u8bf7\u6c42\u53c2\u6570", required=true) @RequestParam String reqParams, @ApiParam(name="leaderId", value="\u4ee3\u4e3a\u5904\u7406\u7684\u9886\u5bfcid", required=false) @RequestParam(required=false) Optional<String> leaderId, @ApiParam(name="isDefAuthorize", value="\u662f\u5426\u662f\u5206\u7ba1\u6388\u6743\u83b7\u53d6\u7684\u6253\u5f00\u6743\u9650") @RequestParam(required=false) String isDefAuthorize) throws Exception {
        TaskDetailVo taskDetailVo = this.iFlowService.taskDetail(taskId, reqParams, FormType.PC, leaderId.orElse("").equals("0") ? "" : leaderId.orElse("")).get();
        return CommonResult.ok().value((Object)taskDetailVo);
    }

    @RequestMapping(value={"taskMobileDetail"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u624b\u673a\u4efb\u52a1\u7684\u8be6\u60c5", httpMethod="GET", notes="\u83b7\u53d6\u624b\u673a\u4efb\u52a1\u7684\u8be6\u60c5")
    @PermissionCheck(taskId="#taskId", isDefAuthorize="#isDefAuthorize")
    public TaskDetailVo taskMobileDetail(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="reqParams", value="\u8bf7\u6c42\u53c2\u6570", required=false) @RequestParam(required=false) String reqParams, @ApiParam(name="isDefAuthorize", value="\u662f\u5426\u662f\u5206\u7ba1\u6388\u6743\u83b7\u53d6\u7684\u6253\u5f00\u6743\u9650") @RequestParam(required=false) String isDefAuthorize) throws Exception {
        return this.iFlowService.taskDetailMobile(taskId, reqParams, FormType.MOBILE).get();
    }

    @RequestMapping(value={"getMyTasks"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6211\u7684\u5f85\u529e\uff0c\u5e76\u4e14\u8fdb\u884c\u6761\u4ef6\u8fc7\u6ee4", httpMethod="GET", notes="\u83b7\u53d6\u6211\u7684\u5f85\u529e\uff0c\u5e76\u4e14\u8fdb\u884c\u6761\u4ef6\u8fc7\u6ee4")
    public PageList<DefaultBpmTask> getMyTasks(@ApiParam(name="account", value="\u7528\u6237\u8d26\u53f7", required=true) @RequestParam String account, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        IUser user = ServiceUtil.getUserByAccount((String)account);
        return this.bpmTaskManager.getByUserId(user.getUserId(), queryFilter);
    }

    @RequestMapping(value={"getTaskEnt"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u5f85\u529e", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u5f85\u529e")
    public BpmTask getTaskEnt(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return (BpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
    }

    @RequestMapping(value={"getTaskVars"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u4e0a\u4e0b\u6587\u6d41\u7a0b\u53d8\u91cf", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u4e0a\u4e0b\u6587\u6d41\u7a0b\u53d8\u91cf")
    public Map<String, Object> getTaskVars(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.iFlowService.getTaskVars(taskId, null);
    }

    @RequestMapping(value={"complete"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5904\u7406\u4efb\u52a1", httpMethod="POST", notes="\u5904\u7406\u4efb\u52a1")
    public CommonResult<String> complete(@ApiParam(name="doNextParamObject", value="\u6d41\u8f6c\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody DoNextParamObject doNextParamObject) throws Exception {
        if (!this.iFlowService.isAuth(doNextParamObject.getTaskId(), doNextParamObject.getAgentLeaderId()).booleanValue()) {
            return new CommonResult(false, "\u60a8\u6ca1\u6709\u5904\u7406\u8be5\u4efb\u52a1\u7684\u6743\u9650\uff01");
        }
        try {
            return this.iFlowService.complete(doNextParamObject).get();
        }
        catch (SQLException e) {
            if (StringUtil.hasEmoji((String)doNextParamObject.getOpinion())) {
                return new CommonResult(false, "\u5ba1\u6279\u610f\u89c1\u4e0d\u80fd\u8f93\u5165\u8868\u60c5\uff01");
            }
            throw e;
        }
    }

    @RequestMapping(value={"saveDraft"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u8349\u7a3f", httpMethod="POST", notes="\u4fdd\u5b58\u8349\u7a3f")
    public CommonResult<String> saveDraft(@ApiParam(name="doNextParamObject", value="\u6d41\u8f6c\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody DoNextParamObject doNextParamObject) throws Exception {
        return this.iFlowService.saveDraft(doNextParamObject);
    }

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4efb\u52a1\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u4efb\u52a1\u5217\u8868")
    public PageList<DefaultBpmTask> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        PageList<DefaultBpmTask> res = this.taskService.listJson(queryFilter);
        return res;
    }

    @RequestMapping(value={"get"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u660e\u7ec6", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u660e\u7ec6")
    public TaskGetVo get(@ApiParam(name="id", value="\u4efb\u52a1id", required=true) @RequestParam String id) throws Exception {
        return this.iFlowService.getTaskById(id, true).get();
    }

    @RequestMapping(value={"getNotice"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u660e\u7ec6", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u660e\u7ec6")
    public TaskGetVo getNotice(@ApiParam(name="id", value="\u4efb\u52a1id", required=true) @RequestParam String id) throws Exception {
        return this.iFlowService.getTaskById(id, false).get();
    }

    @RequestMapping(value={"taskToAgree"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4efb\u52a1\u529e\u7406(\u540c\u610f\u3001\u53cd\u5bf9\u3001\u5f03\u6743)", httpMethod="GET", notes="\u4efb\u52a1\u529e\u7406(\u540c\u610f\u3001\u53cd\u5bf9\u3001\u5f03\u6743)")
    public TaskToAgreeVo taskToAgree(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="actionName", value="\u5ba1\u6279\u52a8\u4f5c", required=true) @RequestParam String actionName) throws Exception {
        return this.iFlowService.toAgree(taskId, actionName);
    }

    @RequestMapping(value={"taskToReject"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a73\u56de\u4efb\u52a1\u9875\u9762\u53c2\u6570", httpMethod="GET", notes="\u9a73\u56de\u4efb\u52a1\u9875\u9762\u53c2\u6570")
    public TaskToRejectVo taskToReject(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="backModel", value="\u9a73\u56de\u6a21\u5f0f\uff1areject\u3001backToStart") @RequestParam String backModel) throws Exception {
        return this.iFlowService.toReject(taskId, backModel);
    }

    @RequestMapping(value={"handlerTypes"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u652f\u6301\u7684\u6d88\u606f\u5904\u7406\u7c7b\u578b", httpMethod="GET", notes="\u83b7\u53d6\u652f\u6301\u7684\u6d88\u606f\u5904\u7406\u7c7b\u578b")
    public Map<String, String> getHandlerTypes() throws Exception {
        return MessageUtil.getHandlerTypes();
    }

    @RequestMapping(value={"getTaskTransById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u8f6c\u4efb\u52a1id\u660e\u7ec6", httpMethod="GET", notes="\u6839\u636e\u6d41\u8f6c\u4efb\u52a1id\u660e\u7ec6")
    public BpmTaskTransRecord getTaskTransById(@ApiParam(name="id", value="\u6d41\u8f6c\u4efb\u52a1id", required=true) @RequestParam String id) throws Exception {
        return (BpmTaskTransRecord)this.taskTransRecordManager.get((Serializable)((Object)id));
    }

    @RequestMapping(value={"getTransRecordList"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u7684\u6d41\u8f6c\u8bb0\u5f55\u660e\u7ec6", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u7684\u6d41\u8f6c\u8bb0\u5f55\u660e\u7ec6")
    public List<BpmTaskTransRecord> getTransRecordList(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE)).withParam("taskId", (Object)taskId);
        return this.taskTransRecordManager.getTransRecordList(queryFilter);
    }

    @RequestMapping(value={"withDraw"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u64a4\u9500\u6211\u6d41\u8f6c\u51fa\u53bb\u7684\u4efb\u52a1", httpMethod="POST", notes="\u64a4\u9500\u6211\u6d41\u8f6c\u51fa\u53bb\u7684\u4efb\u52a1")
    public CommonResult<String> withDraw(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestBody WithDrawParam withDrawParam) throws Exception {
        return this.iFlowService.withDraw(withDrawParam);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1\u8bb0\u5f55", httpMethod="DELETE", notes="\u5220\u9664\u4efb\u52a1\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u4efb\u52a1\u8bb0\u5f55ID\uff0c\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = null;
        if (!StringUtil.isEmpty((String)ids)) {
            aryIds = ids.split(",");
        }
        this.bpmTaskManager.removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u4efb\u52a1\u6210\u529f", (Object)"");
    }

    @RequestMapping(value={"getTaskCommu"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6c9f\u901a\u53cd\u9988\u4efb\u52a1", httpMethod="GET", notes="\u901a\u8fc7\u6c9f\u901a\u4efb\u52a1id\u83b7\u53d6\u6c9f\u901a\u53cd\u9988\u4efb\u52a1")
    public TaskCommuVo getTaskCommu(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        BpmTask bpmTask = (BpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        BpmTaskCommu taskCommu = this.bpmTaskCommuManager.getByTaskId(bpmTask.getParentId());
        List commuReceivers = null;
        if (taskCommu != null) {
            commuReceivers = this.bpmCommuReceiverManager.getByCommuStatus(taskCommu.getId(), null);
        }
        return new TaskCommuVo(taskCommu, commuReceivers);
    }

    @RequestMapping(value={"canLock"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u662f\u5426\u80fd\u9501\u5b9a", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u662f\u5426\u80fd\u9501\u5b9a\uff0c\u8fd4\u56de\u5f53\u524d\u4efb\u52a1\u7684\u53ef\u64cd\u4f5c\u72b6\u6001\uff1a0:\u4efb\u52a1\u5df2\u7ecf\u5904\u7406,1:\u53ef\u4ee5\u9501\u5b9a,2:\u4e0d\u9700\u8981\u89e3\u9501 ,3:\u53ef\u4ee5\u89e3\u9501\uff0c4,\u88ab\u5176\u4ed6\u4eba\u9501\u5b9a,5:\u8fd9\u79cd\u60c5\u51b5\u4e00\u822c\u662f\u7ba1\u7406\u5458\u64cd\u4f5c\uff0c\u6240\u4ee5\u4e0d\u7528\u51fa\u9501\u5b9a\u6309\u94ae")
    public int canLock(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="leaderId", value="\u9886\u5bfcid", required=true) @RequestParam Optional<String> leaderId) throws Exception {
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (task == null) {
            return 0;
        }
        boolean isForbindden = this.bpmInstService.isSuspendByInstId(task.getProcInstId());
        if (isForbindden) {
            return 6;
        }
        int rtn = this.bpmTaskManager.canLockTask(taskId, leaderId.orElse(""));
        return rtn;
    }

    @RequestMapping(value={"isForbindden"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u4efb\u52a1\u662f\u5426\u5df2\u88ab\u7981\u7528", httpMethod="GET", notes="\u83b7\u53d6\u6d41\u7a0b\u4efb\u52a1\u662f\u5426\u5df2\u88ab\u7981\u7528\uff1a1\u3001\u6d41\u7a0b\u5df2\u7ecf\u88ab\u7981\u6b62\uff0c2\u3001\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c3\u3001\u6ca1\u6709\u5904\u7406\u6b64\u4efb\u52a1\u7684\u6743\u9650\u3002")
    public int isForbindden(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        ObjectNode jsonObj;
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (task == null) {
            return 2;
        }
        boolean isForbindden = this.bpmInstService.isSuspendByInstId(task.getProcInstId());
        IUser user = ContextUtil.getCurrentUser();
        if (!user.isAdmin() && (jsonObj = this.bpmDefAuthorizeManager.getRight(task.getProcDefKey(), "task")) == null && !ContextUtil.getCurrentUserId().equals(task.getAssigneeId())) {
            return 3;
        }
        if (isForbindden) {
            return 1;
        }
        return 0;
    }

    @RequestMapping(value={"lockUnlock"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u9501\u5b9a\u72b6\u6001", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u9501\u5b9a\u72b6\u6001\uff1a0:\u4efb\u52a1\u5df2\u7ecf\u5904\u7406,1:\u53ef\u4ee5\u9501\u5b9a,2:\u4e0d\u9700\u8981\u89e3\u9501 ,3:\u53ef\u4ee5\u89e3\u9501\uff0c4,\u88ab\u5176\u4ed6\u4eba\u9501\u5b9a\u3002")
    public int lockUnlock(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="leaderId", value="\u9886\u5bfcid", required=false) @RequestParam Optional<String> leaderId) throws Exception {
        int rtn;
        String curUserId = ContextUtil.getCurrentUserId();
        if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
            ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
            curUserId = leaderId.get();
        }
        if ((rtn = this.bpmTaskManager.canLockTask(taskId)) == 0 || rtn == 4 || rtn == 2 || rtn == 5) {
            return rtn;
        }
        if (rtn == 1) {
            this.bpmTaskManager.lockTask(taskId, curUserId);
        } else {
            this.bpmTaskManager.unLockTask(taskId, curUserId);
        }
        return rtn;
    }

    @RequestMapping(value={"getCandidatesListByInstId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8b\u83b7\u53d6\u5176\u4e0b\u7684\u5019\u9009\u4eba\u5217\u8868", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8b\u83b7\u53d6\u5176\u4e0b\u7684\u5019\u9009\u4eba\u5217\u8868")
    public List<BpmIdentity> getCandidatesListByInstId(@ApiParam(name="instId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) @RequestParam String instId) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("PROC_INST_ID_", (Object)instId, QueryOP.EQUAL);
        queryFilter.addFilter("task.STATUS_", (Object)"TRANSFORMING", QueryOP.NOT_EQUAL);
        PageList query = this.bpmTaskManager.query(queryFilter);
        if (query.getRows().size() != 1) {
            return null;
        }
        DefaultBpmTask defaultBpmTask = (DefaultBpmTask)query.getRows().get(0);
        BpmTaskService bpmTaskService = (BpmTaskService)AppUtil.getBean(BpmTaskService.class);
        List bpmIdentities = bpmTaskService.getTaskCandidates(defaultBpmTask.getTaskId());
        return bpmIdentities;
    }

    @RequestMapping(value={"taskNode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u53ef\u8ddf\u8e2a\u7684\u4efb\u52a1\u8282\u70b9", httpMethod="GET", notes="\u83b7\u53d6\u53ef\u8ddf\u8e2a\u7684\u4efb\u52a1\u8282\u70b9")
    public TaskjImageVo taskNode(@ApiParam(name="taskId", value="\u4efb\u52a1id") @RequestParam Optional<String> taskId, @ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49id") @RequestParam Optional<String> defId) throws Exception {
        TaskjImageVo taskNode = this.iFlowService.taskImage(taskId.orElse(""), defId.orElse(""));
        Locale locale = LocaleContextHolder.getLocale();
        if (!Locale.SIMPLIFIED_CHINESE.equals(locale)) {
            DefaultBpmDefinition defaultBpmDefinition = (DefaultBpmDefinition)this.bpmDefinitionManager.get((Serializable)((Object)defId.orElse("")));
            String procDefKey = defaultBpmDefinition.getDefKey();
            BpmDefLayout bpmDefLayout = taskNode.getBpmDefLayout();
            List listLayout = bpmDefLayout.getListLayout();
            for (BpmNodeLayout bpmNodeLayout : listLayout) {
                String mes;
                String key = "flow." + procDefKey + "." + bpmNodeLayout.getNodeId();
                if (key.equals(mes = I18nUtil.getMessage((String)key, (Locale)locale))) continue;
                bpmNodeLayout.setName(mes);
            }
        }
        return taskNode;
    }

    @RequestMapping(value={"addSign"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u52a0\u7b7e", httpMethod="POST", notes="\u52a0\u7b7e")
    @TaskTransDesensitizeHandle
    public CommonResult<String> addSign(@ApiParam(name="taskTransParamObject", value="\u6d41\u8f6c\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody TaskTransParamObject taskTransParamObject) throws Exception {
        return this.taskTransService.addSign(taskTransParamObject);
    }

    @RequestMapping(value={"isEnd"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u662f\u5426\u7ed3\u675f", httpMethod="POST", notes="\u6d41\u7a0b\u662f\u5426\u7ed3\u675f")
    public CommonResult<String> isEnd(@ApiParam(name="procInstId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) @RequestParam String procInstId) throws Exception {
        String errorMsg;
        DefaultBpmProcessInstance defaultBpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)procInstId));
        List<String> endStatus = Arrays.asList(ProcessInstanceStatus.STATUS_END.getKey(), ProcessInstanceStatus.STATUS_MANUAL_END.getKey());
        String string = errorMsg = BeanUtils.isEmpty((Object)defaultBpmProcessInstance) ? "\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728" : "\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u7ed3\u675f!";
        if (BeanUtils.isEmpty((Object)defaultBpmProcessInstance) || endStatus.contains(defaultBpmProcessInstance.getStatus())) {
            return new CommonResult(false, errorMsg);
        }
        return new CommonResult(true, "");
    }

    @RequestMapping(value={"taskToInqu"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5f81\u8be2\u8bbe\u7f6e", httpMethod="POST", notes="\u5f81\u8be2\u8bbe\u7f6e")
    @TaskTransDesensitizeHandle
    public CommonResult<String> taskToInqu(@ApiParam(name="taskTransParamObject", value="\u5f81\u8be2\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody TaskTransParamObject taskTransParamObject, @ApiParam(name="leaderId", value="\u4ee3\u4e3a\u5904\u7406\u7684\u9886\u5bfcid", required=true) @RequestParam Optional<String> leaderId) throws Exception {
        BpmUtil.checkDefForbidStatus((String)"", (String)"", (String)taskTransParamObject.getTaskId());
        if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
            ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
        }
        return this.iFlowService.taskToInqu(taskTransParamObject);
    }

    @RequestMapping(value={"taskToInquReply"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5f81\u8be2\u56de\u590d", httpMethod="POST", notes="\u5f81\u8be2\u56de\u590d")
    @TaskTransDesensitizeHandle
    public CommonResult<String> taskToInquReply(@ApiParam(name="dbo", value="\u56de\u590d\u4fe1\u606f", required=true) @RequestBody DefaultBpmCheckOpinion dbo, @ApiParam(name="leaderId", value="\u4ee3\u4e3a\u5904\u7406\u7684\u9886\u5bfcid", required=true) @RequestParam Optional<String> leaderId) throws Exception {
        if (!this.iFlowService.isAuth(dbo.getTaskId(), leaderId.orElse(null)).booleanValue()) {
            throw new RuntimeException("\u60a8\u6ca1\u6709\u5904\u7406\u8be5\u4efb\u52a1\u7684\u6743\u9650\uff01");
        }
        try {
            BpmUtil.checkDefForbidStatus((String)"", (String)"", (String)dbo.getTaskId());
            if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
                ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
            }
            this.bpmTaskTransManager.taskToInquReply(dbo);
            return new CommonResult(true, "\u5f81\u8be2\u56de\u590d\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5f81\u8be2\u56de\u590d\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"userAddSignFeedback"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u666e\u901a\u7528\u6237\u8282\u70b9\u7528\u6237\u52a0\u7b7e\u53cd\u9988", httpMethod="POST", notes="\u666e\u901a\u7528\u6237\u8282\u70b9\u7528\u6237\u52a0\u7b7e\u53cd\u9988")
    public CommonResult<String> userAddSignFeedback(@ApiParam(name="dbo", value="\u56de\u590d\u4fe1\u606f", required=true) @RequestBody DefaultBpmCheckOpinion dbo, @ApiParam(name="leaderId", value="\u4ee3\u4e3a\u5904\u7406\u7684\u9886\u5bfcid", required=true) @RequestParam Optional<String> leaderId) throws Exception {
        try {
            BpmUtil.checkDefForbidStatus((String)"", (String)"", (String)dbo.getTaskId());
            if (StringUtil.isNotZeroEmpty((String)leaderId.orElse(""))) {
                ThreadMsgUtil.addMapMsg((String)"leaderId", (String)leaderId.get());
            }
            this.bpmTaskTransManager.userAddSignFeedback(dbo);
            return new CommonResult(true, "\u52a0\u7b7e\u53cd\u9988\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u52a0\u7b7e\u53cd\u9988\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"addReadRecord"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6240\u4f20\u4efb\u52a1id\u65b0\u589e\u8be5\u4efb\u52a1\u7684\u9605\u8bfb\u8bb0\u5f55", httpMethod="POST", notes="\u6839\u636e\u6240\u4f20\u4efb\u52a1id\u65b0\u589e\u8be5\u4efb\u52a1\u7684\u9605\u8bfb\u8bb0\u5f55")
    public void addReadRecord(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        DefaultBpmTask bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)bpmTask)) {
            bpmTask = new DefaultBpmTask();
            BpmTaskNoticeManager noticeManager = (BpmTaskNoticeManager)AppUtil.getBean(BpmTaskNoticeManager.class);
            BpmTaskNotice bpmTaskNotice = (BpmTaskNotice)noticeManager.get((Serializable)((Object)taskId));
            if (BeanUtils.isEmpty((Object)bpmTaskNotice)) {
                throw new BaseException("\u6839\u636e\u6240\u4f20\u4efb\u52a1id:" + taskId + "\u672a\u627e\u5230\u4efb\u52a1\uff01");
            }
            bpmTask = bpmTaskNotice.convertToBpmTask();
        }
        this.iFlowService.addReadRecord(bpmTask);
        List userList = this.bpmTaskService.getUsersByTaskId(bpmTask.getId());
        if (!CollectionUtils.isEmpty((Collection)userList)) {
            String currUserId = ContextUtil.getCurrentUserId();
            if (userList.stream().anyMatch(u -> Objects.equals(u.getUserId(), currUserId))) {
                this.bpmCheckOpinionManager.checkOpinionIsRead(bpmTask.getId());
            }
        }
    }

    @RequestMapping(value={"noticeTurnDode"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u77e5\u4f1a\u4efb\u52a1\u5f85\u529e\u8f6c\u5df2\u529e", httpMethod="POST", notes="\u77e5\u4f1a\u4efb\u52a1\u5f85\u529e\u8f6c\u5df2\u529e")
    public void noticeTurnDode(@ApiParam(name="taskId", value="\u77e5\u4f1a\u4efb\u52a1\u4e3b\u952eid\u96c6\u5408", required=true) @RequestParam String taskId) throws Exception {
        String[] val;
        for (String id : val = taskId.split(",")) {
            this.iFlowService.noticeTurnDode(id);
        }
    }

    @RequestMapping(value={"getCurNodeProperties"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u8282\u70b9\u5c5e\u6027,\u542f\u52a8\u7684\u65f6\u5019\u53d6\u53d1\u8d77\u8282\u70b9", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u8282\u70b9\u5c5e\u6027,\u542f\u52a8\u7684\u65f6\u5019\u53d6\u53d1\u8d77\u8282\u70b9")
    public BpmNodeDef getCurNodeProperties(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=false) @RequestParam Optional<String> taskId, @ApiParam(name="defId", value="\u5b9a\u4e49id", required=false) @RequestParam Optional<String> defId, @ApiParam(name="instId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=false) @RequestParam Optional<String> instId) throws Exception {
        return this.iFlowService.getCurNodeProperties(taskId.orElse(""), defId.orElse(""), instId.orElse(""));
    }

    @RequestMapping(value={"getNodePropertiesByNodeId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u5c5e\u6027", httpMethod="GET", notes="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u5c5e\u6027")
    public CommonResult<BpmNodeDef> getNodePropertiesByNodeId(@ApiParam(name="defId", value="\u5b9a\u4e49id", required=false) @RequestParam Optional<String> defId, @ApiParam(name="instId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=false) @RequestParam Optional<String> instId, @ApiParam(name="nodeId", value="\u8282\u70b9id", required=true) @RequestParam String nodeId) throws Exception {
        try {
            return CommonResult.success((Object)this.iFlowService.getNodePropertiesByNodeId(defId.orElse(""), instId.orElse(""), nodeId));
        }
        catch (Exception e) {
            return CommonResult.error((String)e.getMessage());
        }
    }

    @RequestMapping(value={"getAfterJumpNodes"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8282\u70b9\u914d\u7f6e\u83b7\u53d6\u540e\u7eed\u53ef\u8df3\u8f6c\u8282\u70b9", httpMethod="POST", notes="\u6839\u636e\u8282\u70b9\u914d\u7f6e\u83b7\u53d6\u540e\u7eed\u53ef\u8df3\u8f6c\u8282\u70b9")
    public ObjectNode getAfterJumpNodes(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestBody ObjectNode obj) throws Exception {
        return this.iFlowService.getAfterJumpNode(obj);
    }

    @RequestMapping(value={"getNoticeTodoReadById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09", httpMethod="GET", notes="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09")
    public BpmTaskNotice getNoticeTodoReadById(@ApiParam(required=true, name="noticeId", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestParam(value="noticeId") String noticeId) {
        return this.iFlowService.getNoticeTodoReadById(noticeId);
    }

    @RequestMapping(value={"getNoticeTodoReadList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09")
    public PageList<BpmTaskNotice> getNoticeTodoReadList(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        PageList<BpmTaskNotice> pageList = this.iFlowService.getNoticeTodoReadList(this.baseContext.getCurrentUserAccout(), queryFilter);
        return pageList;
    }

    @RequestMapping(value={"getNoticeTodoReadCard"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09")
    public CommonResult<Map<String, List<BpmTaskNotice>>> getNoticeTodoReadCard(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter, @ApiParam(name="size", value="\u5355\u4e2a\u5206\u7c7b\u83b7\u53d6\u6d41\u7a0b\u6570\u91cf") @RequestParam Optional<Integer> size) throws Exception {
        Map<String, List<BpmTaskNotice>> result = this.iFlowService.getNoticeTodoReadCard(this.baseContext.getCurrentUserAccout(), queryFilter, size.orElse(10));
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", result);
    }

    @PostMapping(value={"getNoticeTodoReadCount"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09\u6570\u91cf", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09\u6570\u91cf")
    public List<Map<String, Object>> getNoticeTodoReadCount(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.iFlowService.getNoticeTodoReadCount(this.baseContext.getCurrentUserAccout(), queryFilter);
    }

    @RequestMapping(value={"getNoticeDoneReadList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5df2\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09", httpMethod="POST", notes="\u83b7\u53d6\u5df2\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09")
    public PageList<BpmTaskNoticeDone> getNoticeDoneReadList(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        List boys = queryFilter.getQuerys();
        Optional<QueryField> queryFieldOptional = boys.stream().filter(s -> s.getProperty().equals("inst.PROC_DEF_KEY_")).findFirst();
        if (queryFieldOptional.isPresent()) {
            QueryField queryField = queryFieldOptional.get();
            DefaultBpmDefinition po = this.bpmDefinitionManager.getMainByDefKey(queryFieldOptional.get().getValue().toString());
            queryFilter.addFilter("bpm_task_notice_done.PROC_DEF_ID_", (Object)po.getDefId(), QueryOP.EQUAL);
            queryFilter.getQuerys().remove(queryFieldOptional.get());
        }
        PageList<BpmTaskNoticeDone> pageList = this.iFlowService.getNoticeDoneReadList(this.baseContext.getCurrentUserAccout(), queryFilter);
        return pageList;
    }

    @PostMapping(value={"getNoticeDoneReadCount"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09\u6570\u91cf", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09\u6570\u91cf")
    public List<Map<String, Object>> getNoticeDoneReadCount(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.iFlowService.getNoticeDoneReadCount(this.baseContext.getCurrentUserAccout(), queryFilter);
    }

    @RequestMapping(value={"getMyNoticeReadList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6211\u4f20\u9605\u7684\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09", httpMethod="POST", notes="\u83b7\u53d6\u6211\u4f20\u9605\u7684\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09")
    public PageList<BpmTaskNotice> getMyNoticeReadList(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        PageList<BpmTaskNotice> pageList = this.iFlowService.getMyNoticeReadList(this.baseContext.getCurrentUserAccout(), queryFilter);
        return pageList;
    }

    @RequestMapping(value={"getMyNoticeReadCard"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6211\u4f20\u9605\u7684\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09", httpMethod="POST", notes="\u83b7\u53d6\u6211\u4f20\u9605\u7684\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09")
    public CommonResult<Map<String, List<BpmTaskNotice>>> getMyNoticeReadCard(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter, @ApiParam(name="size", value="\u5355\u4e2a\u5206\u7c7b\u83b7\u53d6\u6d41\u7a0b\u6570\u91cf") @RequestParam Optional<Integer> size) throws Exception {
        Map<String, List<BpmTaskNotice>> result = this.iFlowService.getMyNoticeReadCard(this.baseContext.getCurrentUserAccout(), queryFilter, size.orElse(10));
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", result);
    }

    @PostMapping(value={"getMyNoticeReadCount"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09\u6570\u91cf", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u9605\u4efb\u52a1\uff08\u77e5\u4f1a\u4efb\u52a1\uff09\u6570\u91cf")
    public List<Map<String, Object>> getMyNoticeReadCount(@ApiParam(required=true, name="queryFilter", value="\u67e5\u8be2\u53c2\u6570\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        return this.iFlowService.getMyNoticeReadCount(this.baseContext.getCurrentUserAccout(), queryFilter);
    }

    @RequestMapping(value={"delBpmTaskNoticeById"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eID\u4e3b\u952eID\u5220\u9664\u4f20\u9605\u4efb\u52a1", httpMethod="POST", notes="\u6839\u636eID\u4e3b\u952eID\u5220\u9664\u4f20\u9605\u4efb\u52a1")
    public CommonResult<String> delBpmTaskNoticeById(@ApiParam(name="id", value="\u4e3b\u952eID", required=true) @RequestParam String id) throws Exception {
        try {
            this.iFlowService.delBpmTaskNoticeById(id);
            return new CommonResult(true, "\u64a4\u56de\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u64a4\u56de\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @RequestMapping(value={"nextExecutor"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u987a\u5e8f\u7b7e\u7f72\u4e0b\u4e00\u6b65\u6267\u884c\u4eba", httpMethod="GET", notes="\u83b7\u53d6\u987a\u5e8f\u7b7e\u7f72\u4e0b\u4e00\u6b65\u6267\u884c\u4eba")
    public CommonResult<BpmIdentity> nextExecutor(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.iFlowService.nextExecutor(taskId);
    }

    @RequestMapping(value={"testRevoke"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u987a\u7b7e\u64a4\u56de", httpMethod="GET", notes="\u987a\u7b7e\u64a4\u56de")
    public CommonResult<BpmIdentity> testRevoke(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId, @ApiParam(name="customSignTaskId", value="\u4efb\u52a1id", required=true) @RequestParam String customSignTaskId, @ApiParam(name="instId", value="instId", required=true) @RequestParam String instId) throws Exception {
        return new CommonResult(true, "\u6210\u529f");
    }

    @RequestMapping(value={"getBpmTaskByInstId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bId\u83b7\u53d6\u4ee3\u529e\u4efb\u52a1", httpMethod="GET", notes="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bId\u83b7\u53d6\u4ee3\u529e\u4efb\u52a1")
    public List<DefaultBpmTask> getBpmTaskByInstId(@ApiParam(name="instId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true) @RequestParam String instId) throws Exception {
        IUser iUser = this.userService.getUserByAccount(this.baseContext.getCurrentUserAccout());
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter.addFilter("bt.proc_inst_id_", (Object)instId, QueryOP.EQUAL);
        return this.bpmTaskManager.getByUserId(iUser.getUserId(), queryFilter).getRows();
    }

    @RequestMapping(value={"getCandidatesListByTaskId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u5176\u4e0b\u7684\u5019\u9009\u4eba\u5217\u8868\u5e76\u62bd\u53d6\u6267\u884c\u4eba", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u5176\u4e0b\u7684\u5019\u9009\u4eba\u5217\u8868\u5e76\u62bd\u53d6\u6267\u884c\u4eba")
    public ArrayNode getCandidatesListByTaskId(@ApiParam(name="taskId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true) @RequestParam String taskId) throws Exception {
        ArrayNode res = this.taskService.getCandidatesListByTaskId(taskId);
        return res;
    }

    @RequestMapping(value={"getAssignersByTaskId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u5176\u4e0b\u7684\u5019\u9009\u4eba\u5217\u8868\u5e76\u62bd\u53d6\u6267\u884c\u4eba", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u5176\u4e0b\u7684\u5019\u9009\u4eba\u5217\u8868\u5e76\u62bd\u53d6\u6267\u884c\u4eba")
    public List<IUser> getAssignersByTaskId(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        return this.taskService.getAssignersByTaskId(taskId);
    }

    @RequestMapping(value={"getTaskListByTenantId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u79df\u6237id\u83b7\u53d6\u4efb\u52a1\u5217\u8868", httpMethod="GET", notes="\u6839\u636e\u79df\u6237id\u83b7\u53d6\u4efb\u52a1\u5217\u8868")
    public List<ObjectNode> getTaskListByTenantId(@ApiParam(name="tenantId", value="\u79df\u6237id", required=true) @RequestParam String tenantId) throws Exception {
        return this.bpmTaskManager.getTaskListByTenantId(tenantId);
    }

    @RequestMapping(value={"getLeaderTodoCount"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u9886\u5bfc\u5f85\u529e\u6570\u76ee", httpMethod="GET", notes="\u83b7\u53d6\u9886\u5bfc\u5f85\u529e\u6570\u76ee")
    public List<Map<String, Object>> getLeaderTodoCount() throws Exception {
        return this.bpmTaskManager.getLeaderCountByUserId(this.baseContext.getCurrentUserId());
    }

    @RequestMapping(value={"createBpmSaveOpinion"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539\u6682\u5b58\u7684\u5ba1\u6279\u610f\u89c1", httpMethod="POST", notes="\u65b0\u589e\u6216\u4fee\u6539\u6682\u5b58\u7684\u5ba1\u6279\u610f\u89c1")
    public CommonResult<String> createBpmSaveOpinion(@ApiParam(name="bpmSaveOpinion", value="\u5ba1\u6279\u610f\u89c1\u6682\u5b58\u4fe1\u606f") @RequestBody BpmSaveOpinion bpmSaveOpinion) {
        boolean result = this.bpmSaveOpinionManager.createBpmSaveOpinion(bpmSaveOpinion);
        if (!result) {
            return new CommonResult(false, "\u6682\u5b58\u5931\u8d25");
        }
        return new CommonResult(true, "\u6682\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"getBpmSaveOpinionByTeam"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u6d41\u7a0b\u5b9e\u4f8bID\u548c\u4efb\u52a1ID\u83b7\u53d6\u5ba1\u6279\u610f\u89c1", httpMethod="GET", notes="\u901a\u8fc7\u6d41\u7a0b\u5b9e\u4f8bID\u548c\u4efb\u52a1ID\u83b7\u53d6\u5ba1\u6279\u610f\u89c1")
    public CommonResult<String> getBpmSaveOpinionByTeam(@ApiParam(name="instId", value="\u6d41\u7a0b\u5b9e\u4f8bID", required=true) @RequestParam String instId, @ApiParam(name="taskId", value="\u6d41\u7a0b\u4efb\u52a1ID", required=true) @RequestParam String taskId) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instId", instId);
        params.put("taskId", taskId);
        BpmSaveOpinion bpmSaveOpinion = this.bpmSaveOpinionManager.getBpmSaveOpinionByTeam(params);
        if (BeanUtils.isNotEmpty((Object)bpmSaveOpinion)) {
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)bpmSaveOpinion.getOpinion());
        }
        return new CommonResult(true, "\u83b7\u53d6\u5931\u8d25", (Object)"");
    }

    @RequestMapping(value={"checkTaskAuth"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u8be5\u4efb\u52a1\u5904\u7406\u6743\u9650", httpMethod="GET", notes="\u9a8c\u8bc1\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u8be5\u4efb\u52a1\u5904\u7406\u6743\u9650")
    public CommonResult<Boolean> checkTaskAuth(@ApiParam(name="taskId", value="\u6d41\u7a0b\u4efb\u52a1ID", required=true) @RequestParam String taskId) throws Exception {
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)this.iFlowService.checkTaskByAssignee(taskId));
    }

    @RequestMapping(value={"batchHandle"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5904\u7406\u4efb\u52a1", httpMethod="POST", notes="\u6279\u91cf\u5904\u7406\u4efb\u52a1")
    public CommonResult<HashMap<String, Object>> batchHandle(@ApiParam(name="requestMap", value="\u8bf7\u6c42\u4f53") @RequestBody Map<String, Object> requestMap) throws Exception {
        CommonResult<HashMap<String, Object>> res = this.taskService.batchHandle(requestMap);
        return res;
    }

    @RequestMapping(value={"nextTask"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u4e00\u4e2a\u4ee3\u529e\u4efb\u52a1", httpMethod="GET", notes="\u83b7\u53d6\u4e0b\u4e00\u4e2a\u4ee3\u529e\u4efb\u52a1")
    public CommonResult<DefaultBpmTask> nextTask(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9a\u4e49ID") @RequestParam String defId, @RequestParam String defKey, @RequestParam(required=false) Boolean mobile) throws Exception {
        return this.taskService.nextTask(defId, defKey, mobile);
    }

    @RequestMapping(value={"/filterUnBatchable"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8fc7\u6ee4\u975e\u6279\u91cf\u5904\u7406\u7c7b\u578b\u4efb\u52a1", httpMethod="GET", notes="\u8fc7\u6ee4\u975e\u6279\u91cf\u5904\u7406\u7c7b\u578b\u4efb\u52a1")
    public CommonResult<List<String>> filterUnBatchable(@ApiParam(name="taskIds", value="\u591a\u4e2aID\u7528\u9017\u53f7\u9694\u5f00") @RequestParam String taskIds) {
        return this.taskService.filterUnBatchable(taskIds);
    }

    @RequestMapping(value={"/getCheckOpinionByTaskId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u4efb\u52a1ID\u83b7\u53d6\u5ba1\u6279\u610f\u89c1", httpMethod="GET", notes="\u901a\u8fc7\u4efb\u52a1ID\u83b7\u53d6\u5ba1\u6279\u610f\u89c1")
    public CommonResult<DefaultBpmCheckOpinion> getChcekOpinionByTaskId(@ApiParam(name="taskId", value="\u4efb\u52a1ID") @RequestParam(value="taskId") String taskId) {
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)this.bpmCheckOpinionManager.getByTaskId(taskId));
    }

    @RequestMapping(value={"taskIsFirstNode"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4efb\u52a1\u662f\u5426\u5728\u7b2c\u4e00\u4e2a\u8282\u70b9", httpMethod="GET", notes="\u83b7\u53d6\u4efb\u52a1\u662f\u5426\u5728\u7b2c\u4e00\u4e2a\u8282\u70b9")
    public CommonResult<Boolean> taskIsFirstNode(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        Boolean taskFirstNode = this.iFlowService.isTaskFirstNode(taskId);
        return CommonResult.ok().value((Object)taskFirstNode);
    }

    @RequestMapping(value={"taskDelayById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4efb\u52a1\u5ef6\u540e\u5904\u7406", httpMethod="GET", notes="\u4efb\u52a1\u5ef6\u540e\u5904\u7406")
    public CommonResult<Object> deferredTreatment(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws Exception {
        if (!this.bpmTaskManager.taskDelayById(taskId).booleanValue()) {
            return new CommonResult(false, "\u5ef6\u8fdf\u5904\u7406\u5931\u8d25", new ArrayList());
        }
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.getSorter().add(new FieldSort("PRIORITY_", Direction.ASC));
        queryFilter.getSorter().add(new FieldSort("inst.create_time_", Direction.DESC));
        queryFilter.setPageBean(new PageBean(Integer.valueOf(0), Integer.valueOf(20)));
        List rows = this.taskService.getTodoList((QueryFilter<DefaultBpmTask>)queryFilter).getRows();
        return new CommonResult(true, "\u5ef6\u8fdf\u5904\u7406\u6210\u529f", (Object)rows);
    }

    @RequestMapping(value={"taskCanJump"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7ba1\u7406\u7aef\u4efb\u52a1\u7ba1\u7406\u4efb\u52a1\u662f\u5426\u80fd\u8df3\u8f6c", httpMethod="GET", notes="\u7ba1\u7406\u7aef\u4efb\u52a1\u7ba1\u7406\u4efb\u52a1\u662f\u5426\u80fd\u8df3\u8f6c")
    public CommonResult<Boolean> taskCanJump(@ApiParam(name="procInstId", value="\u6d41\u7a0b\u5b9e\u4f8bID", required=true) @RequestParam String procInstId, @ApiParam(name="nodeId", value="\u8282\u70b9ID", required=true) @RequestParam String nodeId) throws Exception {
        return ((BpmTaskManager)this.baseService).taskCanJump(procInstId, nodeId);
    }

    @RequestMapping(value={"getTransReceiverByTaskId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u6d41\u8f6c\u63a5\u6536\u4eba", httpMethod="GET", notes="\u6839\u636e\u4efb\u52a1id\u83b7\u53d6\u6d41\u8f6c\u63a5\u6536\u4eba")
    public CommonResult<String> getTransReceiverByTaskId(@ApiParam(required=true, name="taskId", value="\u4efb\u52a1id") @RequestParam String taskId) throws Exception {
        return this.iFlowService.getTransReceiverByTaskId(taskId);
    }

    @RequestMapping(value={"addTransReceiver"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u8f6c\u6dfb\u52a0", httpMethod="POST", notes="\u6d41\u8f6c\u6dfb\u52a0")
    public CommonResult<String> addTransReceiver(@ApiParam(name="taskTransParamObject", value="\u6d41\u8f6c\u53c2\u6570\u5bf9\u8c61", required=true) @RequestBody TaskTransParamObject taskTransParamObject) throws Exception {
        return this.iFlowService.addTransReceiver(taskTransParamObject);
    }
}

