/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.job;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.runtime.controller.InstanceController;
import com.hotent.runtime.params.StartFlowParamObject;
import com.hotent.runtime.params.StartResult;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class FlowStartXxlJob {
    @Resource
    InstanceController instanceController;

    @XxlJob(value="flowStartXxlJob")
    public ReturnT<String> flowStartXxlJob(String param) throws Exception {
        XxlJobLogger.log((String)"XXL-JOB, \u5f00\u59cb\u6267\u884c\u5b9a\u65f6\u542f\u52a8\u6d41\u7a0b.", (Object[])new Object[0]);
        String defaultAccount = "admin";
        JsonNode jsonNode = JsonUtil.toJsonNode((String)param);
        String flowkey = jsonNode.get("flowkey").asText();
        String startAccount = jsonNode.get("startAccount").asText();
        if (StringUtil.isNotEmpty((String)startAccount)) {
            defaultAccount = startAccount;
        }
        ContextUtil.setCurrentUserByAccount((String)defaultAccount);
        if (BeanUtils.isEmpty((Object)flowkey)) {
            throw new BaseException("\u5b9a\u65f6\u542f\u52a8\u6d41\u7a0b\u7684\u81ea\u52a8\u4efb\u52a1\u4e2d\u5fc5\u987b\u914d\u7f6eflowkey\u6765\u6307\u5b9a\u8981\u542f\u52a8\u7684\u6d41\u7a0b.");
        }
        this.startFlow(flowkey, defaultAccount);
        return ReturnT.SUCCESS;
    }

    private void startFlow(String flowKey, String account) throws Exception {
        ObjectNode startFlowParam = JsonUtil.getMapper().createObjectNode();
        startFlowParam.put("flowKey", flowKey);
        startFlowParam.put("account", account);
        StartFlowParamObject startFlowParamObject = new StartFlowParamObject();
        startFlowParamObject.setFlowKey(flowKey);
        startFlowParamObject.setAccount(account);
        StartResult startFlowResult = this.instanceController.start(startFlowParamObject);
        if (BeanUtils.isNotEmpty((Object)((Object)startFlowResult)) && !startFlowResult.getState().booleanValue()) {
            String message = "\u6d41\u7a0b\u542f\u52a8\u5931\u8d25";
            if (BeanUtils.isNotEmpty((Object)((Object)startFlowResult)) && BeanUtils.isNotEmpty((Object)startFlowResult.getMessage())) {
                message = message + ":" + startFlowResult.getMessage();
            }
            throw new BaseException(message);
        }
    }
}

