/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.manager.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.runtime.dao.BpmPrintRecordDao;
import com.hotent.runtime.manager.BpmPrintRecordManager;
import com.hotent.runtime.model.BpmPrintRecord;
import com.hotent.runtime.params.BpmPrintRecordObject;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmPrintRecordManager")
public class BpmPrintRecordManagerImpl
extends BaseManagerImpl<BpmPrintRecordDao, BpmPrintRecord>
implements BpmPrintRecordManager {
    @Resource
    BpmPrintRecordManager bpmPrintRecordManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    UCFeignService ucFeignService;
    ThreadLocal<Map<String, ObjectNode>> userMap = new ThreadLocal();

    @Override
    public BpmPrintRecord getLastVersion(String procInstId, String nodeId, String templateId) {
        return ((BpmPrintRecordDao)this.baseMapper).getLastVersion(procInstId, nodeId, templateId);
    }

    @Override
    public void cleanLastVersion(String procInstId, String nodeId, String templateId) {
        ((BpmPrintRecordDao)this.baseMapper).cleanLastVersion(procInstId, nodeId, templateId);
    }

    @Override
    @Transactional
    public CommonResult<String> addPrintLog(BpmPrintRecordObject printRecordObject) {
        try {
            BpmPrintRecord newRecord = (BpmPrintRecord)((Object)JsonUtil.toBean((String)JsonUtil.toJson((Object)printRecordObject), BpmPrintRecord.class));
            newRecord.setId(UniqueIdUtil.getSuid());
            newRecord.setPrinterName(AuthenticationUtil.getCurrentUserFullname());
            ((BpmPrintRecordDao)this.baseMapper).cleanLastVersion(newRecord.getProcInstId(), newRecord.getNodeId(), newRecord.getTemplateId());
            newRecord.setLastVersion(1);
            super.save((Object)newRecord);
        }
        catch (IOException e) {
            return new CommonResult(false, "\u65b0\u589e\u6253\u5370\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
        }
        return new CommonResult(false, "\u65b0\u589e\u6253\u5370\u8bb0\u5f55\u6210\u529f\u3002");
    }

    @Override
    public List<BpmPrintRecord> getByProInstId(String procInstId, Optional<String> nodeId) {
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), Integer.valueOf(1000)));
        queryFilter.addFilter("LAST_VERSION_", (Object)1, QueryOP.EQUAL, FieldRelation.AND, "isMain");
        queryFilter.addFilter("PROC_INST_ID_", (Object)procInstId, QueryOP.EQUAL, FieldRelation.AND, "isMain");
        if (StringUtil.isNotEmpty((String)nodeId.orElse(null))) {
            queryFilter.addFilter("NODE_ID_", (Object)nodeId.get(), QueryOP.EQUAL, FieldRelation.AND, "isMain");
        }
        queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        PageList pageList = this.bpmPrintRecordManager.query(queryFilter);
        if (BeanUtils.isNotEmpty((Object)pageList)) {
            return pageList.getRows();
        }
        return new ArrayList<BpmPrintRecord>();
    }

    @Override
    public CommonResult<String> printLog(BpmPrintRecordObject printRecordObject) {
        if (StringUtil.isEmpty((String)printRecordObject.getProcInstId())) {
            return new CommonResult(false, "\u65b0\u589e\u6253\u5370\u8bb0\u5f55\u5931\u8d25\uff0c\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtil.isEmpty((String)printRecordObject.getProcDefId())) {
            return new CommonResult(false, "\u65b0\u589e\u6253\u5370\u8bb0\u5f55\u5931\u8d25\uff0c\u6d41\u7a0b\u5b9a\u4e49id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DefaultBpmDefinition def = (DefaultBpmDefinition)this.bpmDefinitionManager.get((Serializable)((Object)printRecordObject.getProcDefId()));
        if (BeanUtils.isEmpty((Object)def)) {
            return new CommonResult(false, "\u65b0\u589e\u6253\u5370\u8bb0\u5f55\u5931\u8d25\uff0c\u6d41\u7a0b\u5b9a\u4e49id\u4e0d\u5b58\u5728\uff01");
        }
        printRecordObject.setProcDefKey(def.getDefKey());
        printRecordObject.setProcDefName(def.getName());
        return this.bpmPrintRecordManager.addPrintLog(printRecordObject);
    }
}

