/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.runtime.dao.BpmProPublicityReadDao;
import com.hotent.runtime.manager.BpmProPublicityReadManager;
import com.hotent.runtime.model.BpmProPublicityRead;
import com.hotent.runtime.vo.BpmProPublicityReadVo;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class BpmProPublicityReadManagerImpl
extends BaseManagerImpl<BpmProPublicityReadDao, BpmProPublicityRead>
implements BpmProPublicityReadManager {
    @Override
    public void readed(BpmProPublicityRead bpmProPublicityRead) {
        bpmProPublicityRead.setUserId(ContextUtil.getCurrentUserId());
        Integer count = ((BpmProPublicityReadDao)this.baseMapper).selectCount((Wrapper)new QueryWrapper((Object)bpmProPublicityRead));
        if (count == 0) {
            bpmProPublicityRead.setId(UniqueIdUtil.getSuid());
            ((BpmProPublicityReadDao)this.baseMapper).insert((Object)bpmProPublicityRead);
        }
    }

    @Override
    public List<BpmProPublicityReadVo> getIsReadByProcInstIds(List<String> procInstIds) {
        ArrayList result = Lists.newArrayList();
        if (BeanUtils.isEmpty(procInstIds)) {
            return result;
        }
        String currentUserId = ContextUtil.getCurrentUserId();
        LambdaQueryWrapper query = Wrappers.lambdaQuery();
        query.in(BpmProPublicityRead::getProcInstId, procInstIds);
        query.eq(BpmProPublicityRead::getUserId, (Object)currentUserId);
        List bpmProPublicityReads = ((BpmProPublicityReadDao)this.baseMapper).selectList((Wrapper)query);
        Set collect = bpmProPublicityReads.stream().map(BpmProPublicityRead::getProcInstId).collect(Collectors.toSet());
        for (String procId : procInstIds) {
            BpmProPublicityReadVo readVo = new BpmProPublicityReadVo();
            readVo.setProcInstId(procId);
            if (collect.contains(procId)) {
                readVo.setReaded(true);
            }
            result.add(readVo);
        }
        return result;
    }
}

