/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.constant.DecideType;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.constant.TaskType;
import com.hotent.bpm.api.constant.VoteType;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.helper.identity.UserQueryPluginHelper;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmInstService;
import com.hotent.bpm.api.service.BpmOpinionService;
import com.hotent.bpm.api.service.BpmTaskActionService;
import com.hotent.bpm.engine.inst.DefaultProcessInstCmd;
import com.hotent.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.hotent.bpm.exception.ApproveTaskException;
import com.hotent.bpm.listener.BusDataUtil;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.natapi.inst.NatProInstanceService;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskCandidateManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.persistence.model.DefaultBpmTaskCandidate;
import com.hotent.bpm.persistence.util.BpmUtil;
import com.hotent.bpm.todo.util.TodoPushUtil;
import com.hotent.bpm.todo.vo.PortalTaskVo;
import com.hotent.bpm.util.BoDataUtil;
import com.hotent.bpm.util.BpmCheckOpinionUtil;
import com.hotent.bpm.util.MessageUtil;
import com.hotent.runtime.constant.SignLineStatus;
import com.hotent.runtime.constant.SignSequenceStatus;
import com.hotent.runtime.manager.BpmTaskSignLineManager;
import com.hotent.runtime.manager.BpmTaskSignSequenceManager;
import com.hotent.runtime.manager.BpmTaskTransManager;
import com.hotent.runtime.manager.BpmTaskTransRecordManager;
import com.hotent.runtime.manager.BpmTransReceiverManager;
import com.hotent.runtime.manager.TaskTransService;
import com.hotent.runtime.model.BpmTaskSignLine;
import com.hotent.runtime.model.BpmTaskSignSequence;
import com.hotent.runtime.model.BpmTaskTrans;
import com.hotent.runtime.model.BpmTaskTransRecord;
import com.hotent.runtime.model.BpmTransReceiver;
import com.hotent.runtime.model.TaskTrans;
import com.hotent.runtime.params.RevokeSignLineParamObject;
import com.hotent.runtime.params.RevokeTransParamObject;
import com.hotent.runtime.params.TaskTransParamObject;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultTaskTransService
implements TaskTransService {
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmTaskTransManager bpmTaskTransManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    NatProInstanceService natProInstanceService;
    @Resource
    BpmTaskActionService bpmTaskActionService;
    @Resource
    BpmOpinionService bpmOpinionService;
    @Resource
    BpmTaskTransRecordManager bpmTaskTransRecordManager;
    @Resource
    BpmTransReceiverManager transReceiverManager;
    @Resource
    BpmTaskSignSequenceManager signSequenceManager;
    @Resource
    BpmTaskSignLineManager signLineManager;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    FormFeignService formRestfulService;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmTaskCandidateManager bpmTaskCandidateManager;
    @Resource
    BpmIdentityExtractService bpmIdentityExtractService;
    @Resource
    BpmInstService bpmInstService;
    @Resource
    BoDataService boDataService;

    private void updOpinionVue(String taskId, OpinionStatus opinionStatus, String trunsAction, String transUser, String opinion, String files, String zFiles) {
        DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getByTaskId(taskId);
        if ("back".equals(trunsAction)) {
            checkOpinion.setStatus(OpinionStatus.AWAITING_CHECK.getKey());
        } else {
            if (!opinionStatus.getKey().equals(OpinionStatus.SIGN_PASS_CANCEL.getKey()) && !opinionStatus.getKey().equals(OpinionStatus.SIGN_NOPASS_CANCEL.getKey())) {
                IUser user = BpmUtil.getUser((String)transUser);
                checkOpinion.setAuditor(user.getUserId());
                checkOpinion.setAuditorName(user.getFullname());
                checkOpinion.setOpinion(opinion);
                checkOpinion.setZfiles(zFiles);
                checkOpinion.setFiles(files);
            }
            checkOpinion.setStatus(opinionStatus.getKey());
            checkOpinion.setCompleteTime(LocalDateTime.now());
            long durMs = TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)checkOpinion.getCreateTime());
            checkOpinion.setDurMs(Long.valueOf(durMs));
        }
        this.bpmCheckOpinionManager.update((Model)checkOpinion);
    }

    private SignResult calcVote(TaskTrans bpmTaskTrans) {
        boolean isFinished;
        SignResult result = new SignResult();
        BpmTaskTransRecord transRecord = this.bpmTaskTransRecordManager.getByTaskId(bpmTaskTrans.getTaskId());
        Short totalAmount = transRecord.getTotalAmount();
        short agreeAmount = transRecord.getAgreeAmount();
        boolean bl = isFinished = totalAmount == agreeAmount;
        if (isFinished) {
            result.setComplete(true);
            result.setDecideType(DecideType.AGREE);
        } else {
            result.setComplete(false);
            result.setDecideType(DecideType.AGREE);
        }
        this.updTransRecord((BpmTaskTrans)bpmTaskTrans);
        return result;
    }

    @Override
    @Transactional
    public void taskToInquReply(String formData, String taskId, String actionName, String notifyType, String opinion, boolean isIntervene, String files, String zFiles) throws Exception {
        List<DefaultBpmTask> list = this.getList(taskId);
        DefaultBpmTask tranTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)tranTask)) {
            throw new ApproveTaskException("\u5f53\u524d\u4efb\u52a1\u5df2\u529e\u7406\uff0c\u4e0d\u53ef\u91cd\u590d\u529e\u7406\uff0c");
        }
        this.commentsBackFill(opinion, tranTask);
        OpinionStatus opinionStatus = DecideType.AGREE.getKey().equals(actionName) ? OpinionStatus.INQU_REPLY : OpinionStatus.TRANS_OPPOSE;
        this.updOpinionVue(taskId, opinionStatus, actionName, ContextUtil.getCurrentUser().getUserId(), opinion, files, zFiles);
        TodoPushUtil.taskToHandled((BpmTask)tranTask, (String)"task");
        BpmTaskTransRecord transRecord = this.bpmTaskTransRecordManager.getByTaskId(tranTask.getParentId());
        this.dealWithTransRecord(opinionStatus, transRecord, tranTask, opinion);
        BpmTaskTrans parenTaskTrans = this.bpmTaskTransManager.getByTaskId(tranTask.getParentId());
        String inquType = parenTaskTrans.getInquType();
        if (StringUtil.isNotEmpty((String)inquType) && "step".equals(inquType)) {
            list = this.getParentList(taskId);
        }
        this.bpmTaskManager.remove((Serializable)((Object)taskId));
        for (int i = 0; i < list.size(); ++i) {
            DefaultBpmTask bpmTask = list.get(i);
            String id = bpmTask.getId();
            BpmTaskTrans taskTrans = this.bpmTaskTransManager.getByTaskId(id);
            this.updTaskTrans(actionName, taskTrans);
            this.bpmTaskTransManager.update((Model)taskTrans);
            SignResult result = this.calcVote(taskTrans);
            if (result.isComplete()) {
                OpinionStatus resultOpinionStatus = DecideType.AGREE.equals((Object)result.getDecideType()) ? OpinionStatus.SIGN_PASS_CANCEL : OpinionStatus.SIGN_NOPASS_CANCEL;
                List tasks = this.bpmTaskManager.getChildsByTaskId(bpmTask.getId());
                for (DefaultBpmTask task : tasks) {
                    this.updOpinionVue(BeanUtils.isEmpty((Object)task.getTaskId()) ? task.getId() : task.getTaskId(), resultOpinionStatus, actionName, null, DecideType.AGREE.getKey().equals(actionName) ? "\u6d41\u8f6c\u81ea\u52a8\u540c\u610f[\u7cfb\u7edf]" : "\u6d41\u8f6c\u81ea\u52a8\u53cd\u5bf9[\u7cfb\u7edf]", files, zFiles);
                }
                boolean isStop = this.handComplete(taskTrans, bpmTask, list, result, i, opinion, notifyType, tranTask.getAssigneeId(), null, null);
                if (!isStop || !"back".equals(taskTrans.getAction())) continue;
                this.addCheckOpinion(bpmTask, OpinionStatus.AWAITING_CHECK, "", "", false);
                continue;
            }
            this.handNotComplete(bpmTask, taskTrans, notifyType, opinion);
            break;
        }
        if (BeanUtils.isNotEmpty((Object)formData)) {
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)tranTask.getProcInstId()));
            BusDataUtil.updateBoData((DefaultBpmProcessInstance)instance, (String)tranTask.getNodeId(), (String)formData);
        }
    }

    @Override
    @Transactional
    public void completeTask(String taskId, String actionName, String notifyType, String opinion, String addSignAction, String busData, Map<String, Object> vars) throws Exception {
        List<DefaultBpmTask> list = this.getList(taskId);
        DefaultBpmTask tranTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        OpinionStatus opinionStatus = null;
        if (StringUtil.isNotEmpty((String)addSignAction)) {
            opinionStatus = DecideType.AGREE.getKey().equals(actionName) ? OpinionStatus.ADDSIGN_AGREE : OpinionStatus.ADDSIGN_OPPOSE;
        } else {
            OpinionStatus opinionStatus2 = opinionStatus = DecideType.AGREE.getKey().equals(actionName) ? OpinionStatus.TRANS_AGREE : OpinionStatus.TRANS_OPPOSE;
        }
        if (TaskType.APPROVELINEED.getKey().equals(tranTask.getStatus())) {
            OpinionStatus opinionStatus3 = opinionStatus = DecideType.AGREE.getKey().equals(actionName) ? OpinionStatus.APPROVE_LINEING_AGREE : OpinionStatus.APPROVE_LINEING_OPPOSE;
        }
        if (TaskType.SIGNSEQUENCEED.getKey().equals(tranTask.getStatus())) {
            OpinionStatus opinionStatus4 = opinionStatus = DecideType.AGREE.getKey().equals(actionName) ? OpinionStatus.SIGNSEQUENCE_AGREE : OpinionStatus.SIGNSEQUENCE_OPPOSE;
        }
        if (TaskType.SIGNLINEED.getKey().equals(tranTask.getStatus())) {
            opinionStatus = DecideType.AGREE.getKey().equals(actionName) ? OpinionStatus.SIGNLINE_AGREE : OpinionStatus.SIGNLINE_OPPOSE;
        }
        this.updOpinionComplete(taskId, opinionStatus, actionName, ContextUtil.getCurrentUser().getUserId(), opinion, true);
        TodoPushUtil.taskToHandled((BpmTask)tranTask);
        this.bpmTaskManager.remove((Serializable)((Object)taskId));
        if (TaskType.SIGNSEQUENCEED.getKey().equals(tranTask.getStatus())) {
            this.handleSignSequence(tranTask, taskId, actionName, notifyType, opinion);
            return;
        }
        if (TaskType.SIGNLINEED.getKey().equals(tranTask.getStatus())) {
            this.handleSignLine(tranTask, taskId, actionName, notifyType, opinion);
            return;
        }
        BpmTaskTransRecord transRecord = this.bpmTaskTransRecordManager.getByTaskId(tranTask.getParentId());
        if (BeanUtils.isNotEmpty((Object)((Object)transRecord))) {
            this.dealWithTransRecord(opinionStatus, transRecord, tranTask, opinion);
            for (int i = 0; i < list.size(); ++i) {
                DefaultBpmTask bpmTask = list.get(i);
                String id = bpmTask.getId();
                BpmTaskTrans taskTrans = this.bpmTaskTransManager.getByTaskId(id);
                this.updTaskTrans(actionName, taskTrans);
                this.bpmTaskTransManager.update((Model)taskTrans);
                SignResult result = this.calcResult(taskTrans);
                if (result.isComplete()) {
                    OpinionStatus resultOpinionStatus = DecideType.AGREE.equals((Object)result.getDecideType()) ? OpinionStatus.SIGN_PASS_CANCEL : OpinionStatus.SIGN_NOPASS_CANCEL;
                    List tasks = this.bpmTaskManager.getChildsByTaskId(bpmTask.getId());
                    for (DefaultBpmTask task : tasks) {
                        this.updOpinionComplete(BeanUtils.isEmpty((Object)task.getTaskId()) ? task.getId() : task.getTaskId(), resultOpinionStatus, actionName, null, DecideType.AGREE.getKey().equals(actionName) ? "\u6d41\u8f6c\u81ea\u52a8\u540c\u610f[\u7cfb\u7edf]" : "\u6d41\u8f6c\u81ea\u52a8\u53cd\u5bf9[\u7cfb\u7edf]", false);
                    }
                    boolean isStop = this.handComplete(taskTrans, bpmTask, list, result, i, opinion, notifyType, tranTask.getAssigneeId(), busData, vars);
                    if (!isStop) continue;
                    if ("back".equals(taskTrans.getAction())) {
                        this.addCheckOpinion(bpmTask, OpinionStatus.AWAITING_CHECK, "", "", false);
                    }
                } else {
                    this.handNotComplete(bpmTask, taskTrans, notifyType, opinion);
                }
                break;
            }
        } else {
            Map variables = new HashMap();
            TaskService taskService = (TaskService)AppUtil.getBean(TaskService.class);
            variables = taskService.getVariables(tranTask.getParentId());
            BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(tranTask.getProcDefId(), tranTask.getNodeId());
            UserQueryPluginHelper userQueryPluginHelper = (UserQueryPluginHelper)AppUtil.getBean(UserQueryPluginHelper.class);
            List bpmPluginContexts = bpmNodeDef.getBpmPluginContexts();
            List identityList = userQueryPluginHelper.query(bpmPluginContexts, variables, "user");
            List userList = new ArrayList();
            if (BeanUtils.isNotEmpty((Object)identityList)) {
                userList = this.bpmIdentityExtractService.extractUser(identityList);
            }
            if (BeanUtils.isEmpty(userList)) {
                DefaultTaskFinishCmd taskFinishCmd = new DefaultTaskFinishCmd();
                taskFinishCmd.setTaskId(list.get(0).getId());
                taskFinishCmd.setActionName("agree");
                taskFinishCmd.setApprovalOpinion("\u6267\u884c\u4eba\u4e3a\u7a7a\u81ea\u52a8\u5b8c\u6210");
                if (BeanUtils.isNotEmpty(vars)) {
                    taskFinishCmd.setVariables(vars);
                }
                this.bpmTaskActionService.finishTask((TaskFinishCmd)taskFinishCmd);
                DefaultBpmCheckOpinion checkOpinion = new DefaultBpmCheckOpinion();
                checkOpinion.setId(UniqueIdUtil.getSuid());
                checkOpinion.setProcDefId(list.get(0).getBpmnDefId());
                checkOpinion.setProcInstId(list.get(0).getProcInstId());
                checkOpinion.setTaskId(list.get(0).getTaskId());
                checkOpinion.setTaskKey(list.get(0).getNodeId());
                checkOpinion.setTaskName(list.get(0).getName());
                checkOpinion.setStatus(OpinionStatus.AGREE.getKey());
                checkOpinion.setCreateTime(LocalDateTime.now());
                checkOpinion.setQualfieds("[{\"id\":\"" + tranTask.getAssigneeId() + "\",\"type\":\"user\",\"groupType\":null,\"name\":\"" + tranTask.getAssigneeName() + "\"}]");
                checkOpinion.setQualfiedNames(tranTask.getAssigneeName());
                checkOpinion.setAuditor(tranTask.getAssigneeId());
                checkOpinion.setAuditorName(tranTask.getAssigneeName());
                checkOpinion.setCompleteTime(LocalDateTime.now().plusSeconds(5L));
                checkOpinion.setDurMs(Long.valueOf(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)list.get(0).getCreateTime())));
                checkOpinion.setOpinion("\u6267\u884c\u4eba\u4e3a\u7a7a\u81ea\u52a8\u5b8c\u6210");
                this.bpmCheckOpinionManager.create((Model)checkOpinion);
            } else {
                List candidateList = this.bpmTaskCandidateManager.queryByTaskId(list.get(0).getId());
                if (candidateList.size() != 0) {
                    this.bpmTaskCandidateManager.removeByTaskId(((DefaultBpmTaskCandidate)candidateList.get(0)).getTaskId());
                }
                if (identityList.size() == 1) {
                    BpmIdentity identity = (BpmIdentity)identityList.get(0);
                    if ("user".equals(identity.getType())) {
                        list.get(0).setOwnerId(identity.getId());
                        list.get(0).setOwnerName(identity.getName());
                        list.get(0).setAssigneeId(identity.getId());
                        list.get(0).setAssigneeName(identity.getName());
                    } else {
                        this.bpmTaskCandidateManager.addCandidate((BpmTask)list.get(0), identityList);
                    }
                } else {
                    this.bpmTaskCandidateManager.addCandidate((BpmTask)list.get(0), identityList);
                }
                list.get(0).setStatus(TaskType.NORMAL.getKey());
                this.bpmTaskManager.update((Model)list.get(0));
                DefaultBpmCheckOpinion checkOpinion = new DefaultBpmCheckOpinion();
                checkOpinion.setId(UniqueIdUtil.getSuid());
                checkOpinion.setProcDefId(list.get(0).getBpmnDefId());
                checkOpinion.setProcInstId(list.get(0).getProcInstId());
                checkOpinion.setTaskId(list.get(0).getTaskId());
                checkOpinion.setTaskKey(list.get(0).getNodeId());
                checkOpinion.setTaskName(list.get(0).getName());
                checkOpinion.setStatus(OpinionStatus.AWAITING_CHECK.getKey());
                checkOpinion.setCreateTime(LocalDateTime.now());
                checkOpinion.setQualfieds(BpmCheckOpinionUtil.getIdentityIds((List)identityList));
                checkOpinion.setQualfiedNames(BpmCheckOpinionUtil.getIdentityNames((List)identityList));
                this.bpmCheckOpinionManager.create((Model)checkOpinion);
            }
        }
    }

    private void handleSignLine(DefaultBpmTask tranTask, String taskId, String actionName, String notifyType, String opinion) throws Exception {
        BpmTaskSignLine signLine = this.signLineManager.getByTaskId(taskId);
        signLine.setStatus(SignLineStatus.COMPLETE.getKey());
        this.signLineManager.update((Model)signLine);
        this.handSignLineA(signLine, actionName, opinion, notifyType);
    }

    private void handSignLineA(BpmTaskSignLine signLine, String actionName, String opinion, String notifyType) throws Exception {
        String instanceId = signLine.getInstanceId();
        String rootTaskId = signLine.getPath().split("\\.")[0];
        String status = SignSequenceStatus.INAPPROVAL.getKey();
        String nodeId = signLine.getNodeId();
        List<BpmTaskSignLine> signLines = this.signLineManager.getByInstNodeIdAndStatus(instanceId, rootTaskId, nodeId, status);
        if (BeanUtils.isEmpty(signLines)) {
            if ("submit".equals(signLine.getAction())) {
                actionName = "agree";
                DefaultTaskFinishCmd cmd = new DefaultTaskFinishCmd();
                cmd.setTaskId(rootTaskId);
                cmd.setActionName(actionName);
                cmd.setApprovalOpinion(opinion);
                DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)rootTaskId));
                IUser user = BpmUtil.getUser((String)defaultBpmTask.getAssigneeId());
                UsernamePasswordAuthenticationToken usernamePwdAuth = new UsernamePasswordAuthenticationToken((Object)user, null);
                SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePwdAuth);
                this.bpmTaskActionService.finishTask((TaskFinishCmd)cmd);
            } else {
                DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)rootTaskId));
                defaultBpmTask.setStatus(TaskType.NORMAL.getKey());
                this.bpmTaskManager.update((Model)defaultBpmTask);
                this.addTranCheckOpinion(defaultBpmTask, OpinionStatus.AWAITING_CHECK, defaultBpmTask.getAssigneeId(), "", "");
                MessageUtil.notify((DefaultBpmTask)defaultBpmTask, (String)opinion, (IUser)BpmUtil.getUser((String)defaultBpmTask.getAssigneeId()), (String)notifyType, (String)"bpmnTaskSignLine");
            }
            this.signLineManager.removeByInstIdNodeId(instanceId, rootTaskId, nodeId);
        }
    }

    private void handleSignSequence(DefaultBpmTask tranTask, String taskId, String actionName, String notifyType, String opinion) throws Exception {
        Map<String, String> map = this.signSequenceManager.getNextExecutor(taskId);
        if (BeanUtils.isEmpty(map)) {
            DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)tranTask.getParentId()));
            actionName = "agree";
            DefaultTaskFinishCmd cmd = new DefaultTaskFinishCmd();
            cmd.setTaskId(tranTask.getParentId());
            cmd.setActionName(actionName);
            cmd.setApprovalOpinion(opinion);
            IUser user = BpmUtil.getUser((String)defaultBpmTask.getAssigneeId());
            UsernamePasswordAuthenticationToken usernamePwdAuth = new UsernamePasswordAuthenticationToken((Object)user, null);
            SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePwdAuth);
            this.bpmTaskActionService.finishTask((TaskFinishCmd)cmd);
            this.signSequenceManager.removeByInstNodeId(defaultBpmTask.getProcInstId(), tranTask.getParentId(), defaultBpmTask.getNodeId());
        } else {
            IUser user = BpmUtil.getUser((String)map.get("id"));
            DefaultBpmTask task = BpmUtil.convertTask((DefaultBpmTask)tranTask, (String)tranTask.getParentId(), (TaskType)TaskType.SIGNSEQUENCEED, (IUser)user);
            task.setId(map.get("taskId"));
            this.bpmTaskManager.create((Model)task);
            this.addTranCheckOpinion(task, OpinionStatus.AWAITING_CHECK, user.getUserId(), "", tranTask.getParentId());
            MessageUtil.notify((DefaultBpmTask)task, (String)opinion, (IUser)user, (String)notifyType, (String)"bpmnTaskSignSequence");
        }
    }

    private List<DefaultBpmTask> getList(String taskId) {
        ArrayList<DefaultBpmTask> list = new ArrayList<DefaultBpmTask>();
        DefaultBpmTask bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        while (BeanUtils.isNotEmpty((Object)bpmTask) && StringUtil.isNotZeroEmpty((String)bpmTask.getParentId())) {
            String parentId = bpmTask.getParentId();
            bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)parentId));
            list.add(bpmTask);
        }
        return list;
    }

    private List<DefaultBpmTask> getParentList(String taskId) {
        ArrayList<DefaultBpmTask> list = new ArrayList<DefaultBpmTask>();
        DefaultBpmTask bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isNotEmpty((Object)bpmTask) && StringUtil.isNotZeroEmpty((String)bpmTask.getParentId())) {
            String parentId = bpmTask.getParentId();
            bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)parentId));
            list.add(bpmTask);
        }
        return list;
    }

    @Override
    public void handNotComplete(DefaultBpmTask parentTask, BpmTaskTrans bpmTaskTrans, String notifyType, String opinion) throws Exception {
        if ("parallel".equals(bpmTaskTrans.getSignType())) {
            return;
        }
        IUser user = bpmTaskTrans.getUserByIndex(bpmTaskTrans.getSeq().shortValue());
        DefaultBpmTask task = BpmUtil.convertTask((DefaultBpmTask)parentTask, (String)parentTask.getId(), (TaskType)TaskType.TRANSFORMED, (IUser)user);
        this.bpmTaskManager.create((Model)task);
        TodoPushUtil.addTodoToPortal((BpmTask)task);
        this.addTranCheckOpinion(task, OpinionStatus.AWAITING_CHECK, user.getUserId(), "", parentTask.getId());
        MessageUtil.notify((DefaultBpmTask)task, (String)opinion, (IUser)user, (String)notifyType, (String)"bpmnTaskTrans");
    }

    private boolean handComplete(TaskTrans taskTrans, DefaultBpmTask bpmTask, List<DefaultBpmTask> list, SignResult result, int index, String opinion, String notifyType, String transUser, String busData, Map<String, Object> vars) throws Exception {
        boolean isStop = false;
        String taskId = bpmTask.getId();
        this.bpmTaskTransManager.remove((Serializable)((Object)taskTrans.getId()));
        this.bpmTaskManager.delByParentId(taskId);
        if ("back".equals(taskTrans.getAction())) {
            BpmTaskTransRecord transRecord = this.bpmTaskTransRecordManager.getByTaskId(taskTrans.getTaskId());
            transRecord.setStatus((short)1);
            this.bpmTaskTransRecordManager.update((Model)transRecord);
            boolean isBpmnTask = bpmTask.isBpmnTask();
            if (isBpmnTask) {
                bpmTask.setStatus(TaskType.NORMAL.name());
                bpmTask.setCreateTime(LocalDateTime.now());
                IUser user = BpmUtil.getUser((String)bpmTask.getAssigneeId());
                if (StringUtil.isEmpty((String)bpmTask.getAssigneeName())) {
                    bpmTask.setAssigneeName(user.getFullname());
                }
                this.bpmTaskManager.update((Model)bpmTask);
                TodoPushUtil.addTodoToPortal((BpmTask)bpmTask);
                MessageUtil.notify((DefaultBpmTask)bpmTask, (String)opinion, (IUser)user, (String)"", (String)"bpmnTaskTrans");
            } else {
                String inquType = taskTrans.getInquType();
                if (StringUtil.isNotEmpty((String)inquType) && "step".equals(inquType)) {
                    bpmTask.setStatus(TaskType.TRANSFORMEDINQU.name());
                    bpmTask.setCreateTime(LocalDateTime.now());
                    this.bpmTaskManager.update((Model)bpmTask);
                    TodoPushUtil.addTodoToPortal((BpmTask)bpmTask);
                    IUser user = BpmUtil.getUser((String)bpmTask.getAssigneeId());
                    MessageUtil.notify((DefaultBpmTask)bpmTask, (String)opinion, (IUser)user, (String)"", (String)"bpmnTaskTrans");
                } else {
                    this.bpmTaskManager.remove((Serializable)bpmTask);
                    TodoPushUtil.taskToHandled((BpmTask)bpmTask);
                    return isStop;
                }
            }
            isStop = true;
        } else {
            if (bpmTask.isBpmnTask()) {
                String actionName = result.getDecideType().equals((Object)DecideType.AGREE) ? "agree" : "oppose";
                DefaultTaskFinishCmd cmd = new DefaultTaskFinishCmd();
                cmd.setTaskId(bpmTask.getId());
                cmd.setActionName(actionName);
                cmd.setApprovalOpinion(opinion);
                cmd.setBusData(busData);
                if (BeanUtils.isNotEmpty(vars)) {
                    cmd.setVariables(vars);
                }
                this.bpmTaskActionService.finishTask((TaskFinishCmd)cmd);
            } else {
                this.bpmTaskManager.remove((Serializable)((Object)taskId));
                DefaultBpmTask nextBpmTask = list.get(index + 1);
                BpmTaskTrans nextTaskTrans = this.bpmTaskTransManager.getByTaskId(nextBpmTask.getId());
                this.changeVoteAmount(result, nextTaskTrans);
                this.bpmTaskTransManager.update((Model)nextTaskTrans);
                IUser user = BpmUtil.getUser((String)nextBpmTask.getAssigneeId());
                MessageUtil.notify((DefaultBpmTask)nextBpmTask, (String)opinion, (IUser)user, (String)notifyType, (String)"bpmTransFeedBack");
                OpinionStatus opinionStatus = result.getDecideType().equals((Object)DecideType.AGREE) ? OpinionStatus.TRANS_AGREE : OpinionStatus.TRANS_OPPOSE;
                this.addCheckOpinion(bpmTask, opinionStatus, transUser, opinion, true);
            }
            BpmTaskTransRecord transRecord = this.bpmTaskTransRecordManager.getByTaskId(taskTrans.getTaskId());
            transRecord.setStatus((short)1);
            this.bpmTaskTransRecordManager.update((Model)transRecord);
        }
        return isStop;
    }

    private void updOpinionComplete(String taskId, OpinionStatus opinionStatus, String trunsAction, String transUser, String opinion, Boolean recordFile) {
        DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getByTaskId(taskId);
        TaskFinishCmd cmd = (TaskFinishCmd)ContextThreadUtil.getActionCmd();
        if ("back".equals(trunsAction)) {
            checkOpinion.setStatus(OpinionStatus.AWAITING_CHECK.getKey());
        } else {
            if (!opinionStatus.getKey().equals(OpinionStatus.SIGN_PASS_CANCEL.getKey()) && !opinionStatus.getKey().equals(OpinionStatus.SIGN_NOPASS_CANCEL.getKey())) {
                IUser user = BpmUtil.getUser((String)transUser);
                checkOpinion.setAuditor(user.getUserId());
                checkOpinion.setAuditorName(user.getFullname());
                checkOpinion.setOpinion(opinion);
                checkOpinion.setFormName(cmd.getOpinionIdentity());
            }
            checkOpinion.setStatus(opinionStatus.getKey());
            checkOpinion.setCompleteTime(LocalDateTime.now());
            long durMs = TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)checkOpinion.getCreateTime());
            checkOpinion.setDurMs(Long.valueOf(durMs));
        }
        if (BeanUtils.isNotEmpty((Object)cmd.getBusData())) {
            try {
                checkOpinion.setFormData(Base64.getBase64((String)cmd.getBusData()));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (recordFile.booleanValue()) {
            checkOpinion.setFiles(cmd.getFiles());
        }
        this.bpmCheckOpinionManager.update((Model)checkOpinion);
    }

    private void updTaskTrans(String actionName, BpmTaskTrans bpmTaskTrans) {
        short agreeAmount = bpmTaskTrans.getAgreeAmount();
        short oppseAmount = bpmTaskTrans.getOpposeAmount();
        if (OpinionStatus.AGREE.getKey().equals(actionName)) {
            agreeAmount = (short)(agreeAmount + 1);
        } else {
            oppseAmount = (short)(oppseAmount + 1);
        }
        bpmTaskTrans.setAgreeAmount(agreeAmount);
        bpmTaskTrans.setOpposeAmount(oppseAmount);
        if ("seq".equals(bpmTaskTrans.getSignType())) {
            short seq = (short)(bpmTaskTrans.getSeq() + 1);
            bpmTaskTrans.setSeq(seq);
        }
        this.updTransRecord(bpmTaskTrans);
    }

    private void changeVoteAmount(SignResult result, BpmTaskTrans bpmTaskTrans) {
        short agreeAmount = bpmTaskTrans.getAgreeAmount();
        short oppseAmount = bpmTaskTrans.getOpposeAmount();
        if (OpinionStatus.AGREE.getKey().equals(result.getDecideType().getKey())) {
            agreeAmount = (short)(agreeAmount + 1);
        } else {
            oppseAmount = (short)(oppseAmount + 1);
        }
        bpmTaskTrans.setAgreeAmount(agreeAmount);
        bpmTaskTrans.setOpposeAmount(oppseAmount);
    }

    private SignResult calcResult(TaskTrans bpmTaskTrans) {
        short oppseAmount;
        boolean isFinished;
        SignResult result = new SignResult();
        short totalAmount = bpmTaskTrans.getTotalAmount();
        short voteAmount = bpmTaskTrans.getVoteAmount();
        String decideType = bpmTaskTrans.getDecideType();
        String voteType = bpmTaskTrans.getVoteType();
        short agreeAmount = bpmTaskTrans.getAgreeAmount();
        boolean bl = isFinished = totalAmount == agreeAmount + (oppseAmount = bpmTaskTrans.getOpposeAmount().shortValue());
        if (DecideType.AGREE.getKey().equals(decideType)) {
            if (VoteType.PERCENT.getKey().equals(voteType)) {
                agreeAmount = (short)((float)agreeAmount / (float)totalAmount * 100.0f);
            }
            if (agreeAmount >= voteAmount) {
                result.setComplete(true);
                result.setDecideType(DecideType.AGREE);
            } else if (isFinished) {
                result.setComplete(true);
                result.setDecideType(DecideType.REFUSE);
            }
        } else {
            if (VoteType.PERCENT.getKey().equals(voteType)) {
                oppseAmount = (short)((float)oppseAmount / (float)totalAmount * 100.0f);
            }
            if (oppseAmount >= voteAmount) {
                result.setComplete(true);
                result.setDecideType(DecideType.REFUSE);
            } else if (isFinished) {
                result.setComplete(true);
                result.setDecideType(DecideType.AGREE);
            }
        }
        this.updTransRecord((BpmTaskTrans)bpmTaskTrans);
        return result;
    }

    @Override
    @Transactional
    public void addTransTask(TaskTrans taskTrans, List<IUser> listUsers, String notifyType, String opinion, String formData, String files, Boolean addSignUser) throws Exception {
        DefaultBpmTask bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskTrans.getTaskId()));
        TodoPushUtil.taskToHandled((BpmTask)bpmTask, (String)"task");
        BpmTaskTrans trans = (BpmTaskTrans)taskTrans;
        if (addSignUser.booleanValue()) {
            String parentTaskId = "";
            if ("0".equals(bpmTask.getParentId())) {
                this.addTaskTrans(trans, bpmTask, listUsers);
                bpmTask.setStatus(TaskType.TRANSFORMING.name());
                this.bpmTaskManager.update((Model)bpmTask);
                parentTaskId = trans.getTaskId();
            } else {
                DefaultBpmTask parentBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)bpmTask.getParentId()));
                this.addTaskTrans(trans, parentBpmTask, listUsers);
                this.bpmTaskManager.remove((Serializable)bpmTask);
                parentTaskId = bpmTask.getParentId();
            }
            this.addTaskByUsers(parentTaskId, bpmTask, listUsers, trans.getSignType(), opinion, notifyType, "addSignTask", addSignUser);
        } else {
            this.addTaskTrans(trans, bpmTask, listUsers);
            bpmTask.setStatus(TaskType.TRANSFORMING.name());
            this.bpmTaskManager.update((Model)bpmTask);
            this.addTaskByUsers(trans.getTaskId(), bpmTask, listUsers, trans.getSignType(), opinion, notifyType, "bpmnTaskTrans", addSignUser);
        }
        DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getByTaskId(bpmTask.getId());
        if (checkOpinion == null) {
            checkOpinion = new DefaultBpmCheckOpinion();
            checkOpinion.setCreateTime(LocalDateTime.now());
            checkOpinion.setProcDefId(bpmTask.getProcDefId());
            checkOpinion.setProcInstId(bpmTask.getProcInstId());
            checkOpinion.setTaskId(bpmTask.getId());
            checkOpinion.setTaskKey(bpmTask.getNodeId());
            checkOpinion.setParentTaskId(bpmTask.getParentId());
            checkOpinion.setTaskName("\u6d41\u8f6c\u4efb\u52a1");
            checkOpinion.setQualfiedNames(bpmTask.getAssigneeName());
        }
        if (addSignUser.booleanValue()) {
            checkOpinion.setStatus(OpinionStatus.ADDSIGN.getKey());
        } else {
            checkOpinion.setStatus(OpinionStatus.TRANS_FORMING.getKey());
        }
        checkOpinion.setOpinion(opinion);
        checkOpinion.setCompleteTime(LocalDateTime.now());
        checkOpinion.setDurMs(Long.valueOf(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)checkOpinion.getCreateTime())));
        checkOpinion.setAuditor(ContextUtil.getCurrentUser().getUserId());
        checkOpinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
        checkOpinion.setFiles(files);
        if (StringUtil.isNotEmpty((String)formData)) {
            checkOpinion.setFormData(formData);
        }
        this.bpmCheckOpinionManager.saveOrUpdate((Object)checkOpinion);
    }

    private void addTranCheckOpinion(DefaultBpmTask bpmTask, OpinionStatus opinionStatus, String transUser, String opinion, String parentTaskId) {
        String bpmnInstId = bpmTask.getBpmnInstId();
        String superInstId = (String)this.natProInstanceService.getSuperVariable(bpmnInstId, "instanceId_");
        IUser user = BpmUtil.getUser((String)bpmTask.getAssigneeId(), (String)bpmTask.getAssigneeName());
        if (StringUtil.isNotEmpty((String)transUser)) {
            user = BpmUtil.getUser((String)transUser);
        }
        ArrayList<DefaultBpmIdentity> identityList = new ArrayList<DefaultBpmIdentity>();
        DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
        bpmIdentity.setType("user");
        bpmIdentity.setId(user.getUserId());
        bpmIdentity.setName(user.getFullname());
        identityList.add(bpmIdentity);
        DefaultBpmCheckOpinion checkOpinion = new DefaultBpmCheckOpinion();
        checkOpinion.setId(UniqueIdUtil.getSuid());
        checkOpinion.setProcDefId(bpmTask.getBpmnDefId());
        checkOpinion.setSupInstId(superInstId);
        checkOpinion.setProcInstId(bpmTask.getProcInstId());
        checkOpinion.setTaskId(BeanUtils.isEmpty((Object)bpmTask.getTaskId()) ? bpmTask.getId() : bpmTask.getTaskId());
        checkOpinion.setTaskKey(bpmTask.getNodeId());
        checkOpinion.setTaskName(bpmTask.getName());
        checkOpinion.setStatus(opinionStatus.getKey());
        checkOpinion.setCreateTime(bpmTask.getCreateTime());
        checkOpinion.setQualfieds(BpmCheckOpinionUtil.getIdentityIds(identityList));
        checkOpinion.setQualfiedNames(user.getFullname());
        if (StringUtil.isNotEmpty((String)parentTaskId)) {
            checkOpinion.setParentTaskId(parentTaskId);
        }
        this.bpmCheckOpinionManager.create((Model)checkOpinion);
    }

    @Override
    @Transactional
    public void addCheckOpinion(DefaultBpmTask bpmTask, OpinionStatus opinionStatus, String transUser, String opinion, boolean isCompleted) {
        String bpmnInstId = bpmTask.getBpmnInstId();
        String superInstId = (String)this.natProInstanceService.getSuperVariable(bpmnInstId, "instanceId_");
        IUser user = BpmUtil.getUser((String)bpmTask.getAssigneeId(), (String)bpmTask.getAssigneeName());
        if (StringUtil.isNotEmpty((String)transUser)) {
            user = BpmUtil.getUser((String)transUser);
        }
        ArrayList<DefaultBpmIdentity> identityList = new ArrayList<DefaultBpmIdentity>();
        DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
        bpmIdentity.setType("user");
        bpmIdentity.setId(user.getUserId());
        bpmIdentity.setName(user.getFullname());
        identityList.add(bpmIdentity);
        DefaultBpmCheckOpinion checkOpinion = new DefaultBpmCheckOpinion();
        checkOpinion.setId(UniqueIdUtil.getSuid());
        checkOpinion.setProcDefId(bpmTask.getBpmnDefId());
        checkOpinion.setSupInstId(superInstId);
        checkOpinion.setProcInstId(bpmTask.getProcInstId());
        checkOpinion.setTaskId(bpmTask.getTaskId());
        checkOpinion.setTaskKey(bpmTask.getNodeId());
        checkOpinion.setTaskName(bpmTask.getName());
        checkOpinion.setStatus(opinionStatus.getKey());
        checkOpinion.setCreateTime(LocalDateTime.now());
        checkOpinion.setQualfieds(BpmCheckOpinionUtil.getIdentityIds(identityList));
        checkOpinion.setQualfiedNames(user.getFullname());
        if (isCompleted) {
            checkOpinion.setAuditor(user.getUserId());
            checkOpinion.setAuditorName(user.getFullname());
            if (OpinionStatus.TRANSFORM_CANCEL.equals((Object)opinionStatus)) {
                checkOpinion.setCompleteTime(LocalDateTime.now().plusSeconds(1L));
            } else {
                checkOpinion.setCompleteTime(LocalDateTime.now());
            }
            checkOpinion.setDurMs(Long.valueOf(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)bpmTask.getCreateTime())));
            checkOpinion.setOpinion(opinion);
        }
        this.bpmCheckOpinionManager.create((Model)checkOpinion);
    }

    @Override
    public void addTaskByUsers(String parentTaskId, DefaultBpmTask bpmTask, List<IUser> listUsers, String signType, String opinion, String notifyType, String typeKey, Boolean addSignUser) throws Exception {
        if ("parallel".equals(signType)) {
            for (IUser user : listUsers) {
                DefaultBpmTask task = null;
                task = addSignUser != false ? BpmUtil.convertTask((DefaultBpmTask)bpmTask, (String)parentTaskId, (TaskType)TaskType.NORMAL, (IUser)user) : BpmUtil.convertTask((DefaultBpmTask)bpmTask, (String)parentTaskId, (TaskType)TaskType.TRANSFORMED, (IUser)user);
                this.bpmTaskManager.create((Model)task);
                TodoPushUtil.addTodoToPortal((BpmTask)bpmTask);
                this.addTranCheckOpinion(task, OpinionStatus.AWAITING_CHECK, user.getUserId(), "", parentTaskId);
                MessageUtil.notify((DefaultBpmTask)task, (String)opinion, (IUser)user, (String)notifyType, (String)typeKey);
            }
        } else {
            IUser user = listUsers.get(0);
            DefaultBpmTask task = BpmUtil.convertTask((DefaultBpmTask)bpmTask, (String)parentTaskId, (TaskType)TaskType.TRANSFORMED, (IUser)user);
            this.bpmTaskManager.create((Model)task);
            this.addTranCheckOpinion(task, OpinionStatus.AWAITING_CHECK, user.getUserId(), "", parentTaskId);
            MessageUtil.notify((DefaultBpmTask)bpmTask, (String)opinion, (IUser)user, (String)notifyType, (String)typeKey);
        }
    }

    private void addTaskTrans(BpmTaskTrans trans, DefaultBpmTask bpmTask, List<IUser> users) throws IOException {
        IUser user = ContextUtil.getCurrentUser();
        BpmTaskTrans oleTrans = this.bpmTaskTransManager.getByTaskId(bpmTask.getId());
        if (oleTrans != null) {
            this.bpmTaskTransManager.remove((Serializable)((Object)oleTrans.getId()));
        }
        trans.setId(UniqueIdUtil.getSuid());
        trans.setInstanceId(bpmTask.getProcInstId());
        trans.setTaskId(bpmTask.getId());
        if (StringUtil.isZeroEmpty((String)bpmTask.getAssigneeId())) {
            bpmTask.setAssigneeId(user.getUserId());
        }
        trans.setCreator(user.getFullname());
        trans.setCreateTime(LocalDateTime.now());
        trans.setTotalAmount((short)users.size());
        trans.setAgreeAmount((short)0);
        trans.setOpposeAmount((short)0);
        trans.setSeq((short)0);
        short allowFormEdit = trans.getAllowFormEdit();
        trans.setAllowFormEdit(allowFormEdit);
        String signType = trans.getSignType();
        ArrayNode jArray = (ArrayNode)JsonUtil.toJsonNode(users);
        if ("seq".equals(signType)) {
            trans.setUserJson(jArray.toString());
        }
        this.bpmTaskTransManager.create((Model)trans);
        this.createTransRecord(trans, bpmTask, users);
    }

    public PageList<DefaultBpmTask> getMyTransTask(String userId, QueryFilter queryFilter) {
        return this.bpmTaskManager.getMyTransTask(userId, queryFilter);
    }

    @Override
    @Transactional
    public void withDraw(String taskId, String notifyType, String opinion) throws Exception {
        this.toWithDraw(taskId, notifyType, opinion, "bpmTransCancel");
    }

    @Override
    @Transactional
    public void withDraw(String taskId, String notifyType, String opinion, String msgTemplate) throws Exception {
        this.toWithDraw(taskId, notifyType, opinion, msgTemplate);
    }

    private void toWithDraw(String taskId, String notifyType, String opinion, String msgTemplate) throws Exception {
        DefaultBpmTask bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        List opinions = this.bpmCheckOpinionManager.getByInstNodeId(bpmTask.getProcInstId(), bpmTask.getNodeId());
        for (DefaultBpmCheckOpinion checkOpinion : opinions) {
            if (!checkOpinion.getStatus().equals(OpinionStatus.AWAITING_CHECK.getKey())) continue;
            checkOpinion.setStatus(OpinionStatus.TRANSFORM_CANCEL.getKey());
            checkOpinion.setCompleteTime(LocalDateTime.now());
            long durMs = TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)checkOpinion.getCreateTime());
            checkOpinion.setDurMs(Long.valueOf(durMs));
            checkOpinion.setOpinion(opinion);
            checkOpinion.setAuditor(ContextUtil.getCurrentUser().getUserId());
            checkOpinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
            this.bpmCheckOpinionManager.update((Model)checkOpinion);
        }
        this.addCheckOpinion(bpmTask, OpinionStatus.TRANSFORM_CANCEL, "", opinion, true);
        bpmTask.setStatus(bpmTask.isBpmnTask() ? TaskType.NORMAL.name() : TaskType.TRANSFORMED.name());
        this.bpmTaskManager.update((Model)bpmTask);
        TodoPushUtil.addTodoToPortal((BpmTask)bpmTask);
        BpmTaskTransRecord transRecord = this.bpmTaskTransRecordManager.getByTaskId(bpmTask.getTaskId());
        transRecord.setStatus((short)2);
        this.bpmTaskTransRecordManager.update((Model)transRecord);
        IUserService userService = (IUserService)AppUtil.getBean(IUserService.class);
        List childTasks = this.bpmTaskManager.getChildsByTaskId(taskId);
        if (BeanUtils.isNotEmpty((Object)childTasks)) {
            ArrayList<String> taskIds = new ArrayList<String>();
            ArrayList<String> userIds = new ArrayList<String>();
            for (DefaultBpmTask task : childTasks) {
                IUser receiver = userService.getUserById(task.getAssigneeId());
                MessageUtil.notify((DefaultBpmTask)task, (String)opinion, (IUser)receiver, (String)notifyType, (String)msgTemplate);
                this.bpmTaskManager.remove((Serializable)((Object)task.getId()));
                taskIds.add(task.getId());
                userIds.add(receiver.getUserId());
            }
            PortalTaskVo portalTaskVo = new PortalTaskVo();
            portalTaskVo.setInstId(bpmTask.getProcInstId());
            portalTaskVo.setFlowType(bpmTask.getProcDefKey());
            portalTaskVo.setFlowTypeName(bpmTask.getProcDefName());
            TodoPushUtil.delTodo((String)bpmTask.getProcInstId(), taskIds, (int)3, userIds, (String)"", (PortalTaskVo)portalTaskVo);
        }
    }

    @Override
    public BpmTaskTrans getTransTaskByTaskId(String taskId) {
        return this.bpmTaskTransManager.getByTaskId(taskId);
    }

    @Transactional
    public void createTransRecord(BpmTaskTrans taskTrans, DefaultBpmTask bpmTask, List<IUser> users) {
        BpmTaskTransRecord bpmTaskTransRecord = this.bpmTaskTransRecordManager.getByTaskId(bpmTask.getId());
        if (bpmTaskTransRecord != null) {
            this.bpmTaskTransRecordManager.remove((Serializable)((Object)bpmTaskTransRecord.getId()));
        }
        IUser user = ContextUtil.getCurrentUser();
        BpmTaskTransRecord transRecord = new BpmTaskTransRecord();
        transRecord.setId(UniqueIdUtil.getSuid());
        transRecord.setCreator(user.getFullname());
        transRecord.setTaskName(bpmTask.getName());
        transRecord.setTaskSubject(bpmTask.getSubject());
        transRecord.setStatus((short)0);
        transRecord.setTransOwner(bpmTask.getAssigneeId());
        transRecord.setTransTime(LocalDateTime.now());
        transRecord.setDefName(bpmTask.getProcDefName());
        transRecord.setProcInstId(bpmTask.getProcInstId());
        transRecord.setAction(taskTrans.getAction());
        transRecord.setAgreeAmount(taskTrans.getAgreeAmount());
        transRecord.setDecideType(taskTrans.getDecideType());
        transRecord.setVoteAmount(taskTrans.getVoteAmount());
        transRecord.setVoteType(taskTrans.getVoteType());
        transRecord.setSignType(taskTrans.getSignType());
        transRecord.setTotalAmount(taskTrans.getTotalAmount());
        transRecord.setAgreeAmount(taskTrans.getAgreeAmount());
        transRecord.setOpposeAmount(taskTrans.getOpposeAmount());
        transRecord.setTaskId(taskTrans.getTaskId());
        String transUsers = "";
        String transUserIds = "";
        for (IUser u : users) {
            transUsers = transUsers + "\u3010" + u.getFullname() + "\u3011 ";
            transUserIds = transUserIds + u.getUserId() + ",";
            BpmTransReceiver transReceiver = new BpmTransReceiver();
            transReceiver.setId(UniqueIdUtil.getSuid());
            transReceiver.setTransRecordid(transRecord.getId());
            transReceiver.setReceiver(u.getFullname());
            transReceiver.setReceiverId(u.getUserId());
            transReceiver.setStatus((short)0);
            transReceiver.setCheckType((short)0);
            transReceiver.setReceiverTime(LocalDateTime.now());
            this.transReceiverManager.create((Model)transReceiver);
        }
        transUserIds.substring(0, transUserIds.length() - 1);
        transRecord.setTransUsers(transUsers);
        transRecord.setTransUserIds(transUserIds);
        this.bpmTaskTransRecordManager.create((Model)transRecord);
    }

    @Transactional
    public void updTransRecord(BpmTaskTrans taskTrans) {
        BpmTaskTransRecord transRecord = this.bpmTaskTransRecordManager.getByTaskId(taskTrans.getTaskId());
        transRecord.setAgreeAmount(taskTrans.getAgreeAmount());
        transRecord.setDecideType(taskTrans.getDecideType());
        transRecord.setVoteAmount(taskTrans.getVoteAmount());
        transRecord.setVoteType(taskTrans.getVoteType());
        transRecord.setSignType(taskTrans.getSignType());
        transRecord.setTotalAmount(taskTrans.getTotalAmount());
        transRecord.setAgreeAmount(taskTrans.getAgreeAmount());
        transRecord.setOpposeAmount(taskTrans.getOpposeAmount());
        this.bpmTaskTransRecordManager.update((Model)transRecord);
    }

    @Transactional
    public void dealWithTransRecord(OpinionStatus opinionStatus, BpmTaskTransRecord transRecord, DefaultBpmTask tranTask, String opinion) {
        String transOpinion = transRecord.getTransOpinion();
        String userFullname = tranTask.getAssigneeName();
        if (BeanUtils.isEmpty((Object)transOpinion)) {
            transOpinion = "";
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", tranTask.getOwnerId());
        params.put("transRecordid", transRecord.getId());
        BpmTransReceiver transReceiver = this.transReceiverManager.getByTransRecordAndUserId(params);
        transReceiver.setCheckTime(LocalDateTime.now());
        transReceiver.setOpinion(opinion);
        transReceiver.setStatus((short)1);
        if (OpinionStatus.TRANS_AGREE.equals((Object)opinionStatus)) {
            transOpinion = transOpinion + "\u3010" + userFullname + "\u3011\uff1a\u540c\u610f\uff1b";
            transReceiver.setCheckType((short)1);
        } else if (OpinionStatus.TRANS_OPPOSE.equals((Object)opinionStatus)) {
            transOpinion = transOpinion + "\u3010" + userFullname + "\u3011\uff1a\u53cd\u5bf9\uff1b";
            transReceiver.setCheckType((short)2);
        } else if (OpinionStatus.ADDSIGN_AGREE.equals((Object)opinionStatus)) {
            transOpinion = transOpinion + "\u3010" + userFullname + "\u3011\uff1a\u540c\u610f\uff1b";
            transReceiver.setCheckType((short)1);
        } else if (OpinionStatus.ADDSIGN_OPPOSE.equals((Object)opinionStatus)) {
            transOpinion = transOpinion + "\u3010" + userFullname + "\u3011\uff1a\u53cd\u5bf9\uff1b";
            transReceiver.setCheckType((short)2);
        } else if (OpinionStatus.TRANS_ADD.equals((Object)opinionStatus)) {
            transOpinion = transOpinion + "\u3010" + userFullname + "\u3011\uff1a\u6d41\u8f6c\u6dfb\u52a0\uff1b";
            transReceiver.setCheckType((short)3);
        }
        transRecord.setTransOpinion(transOpinion);
        this.bpmTaskTransRecordManager.update((Model)transRecord);
        this.transReceiverManager.update((Model)transReceiver);
    }

    @Override
    public CommonResult<String> addSign(TaskTransParamObject taskTransParamObject) throws Exception {
        return null;
    }

    @Override
    @Transactional
    public void addTaskToInqu(TaskTrans taskTrans, List<IUser> listUsers, String notifyType, String opinion, String files) throws Exception {
        BpmTaskTrans parentTaskTrans;
        DefaultBpmTask bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskTrans.getTaskId()));
        BpmTaskTrans trans = (BpmTaskTrans)taskTrans;
        String inquType = taskTrans.getInquType();
        if (StringUtil.isEmpty((String)inquType) && BeanUtils.isNotEmpty((Object)(parentTaskTrans = this.bpmTaskTransManager.getByTaskId(bpmTask.getParentId())))) {
            trans.setInquType(parentTaskTrans.getInquType());
        }
        this.addTaskTrans(trans, bpmTask, listUsers);
        bpmTask.setStatus(TaskType.TRANSFORMING.name());
        this.bpmTaskManager.update((Model)bpmTask);
        TodoPushUtil.taskToHandled((BpmTask)bpmTask, (String)"task");
        this.addTaskInquByUsers(trans.getTaskId(), bpmTask, listUsers, opinion, null, null);
        DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getByTaskId(taskTrans.getTaskId());
        if (BeanUtils.isEmpty((Object)checkOpinion)) {
            DefaultBpmCheckOpinion defaultBpmCheckOpinion = new DefaultBpmCheckOpinion();
            defaultBpmCheckOpinion.setId(UniqueIdUtil.getSuid());
            defaultBpmCheckOpinion.setProcDefId(bpmTask.getBpmnDefId());
            defaultBpmCheckOpinion.setProcInstId(bpmTask.getProcInstId());
            defaultBpmCheckOpinion.setTaskId(BeanUtils.isEmpty((Object)bpmTask.getTaskId()) ? bpmTask.getId() : bpmTask.getTaskId());
            defaultBpmCheckOpinion.setTaskKey(bpmTask.getNodeId());
            defaultBpmCheckOpinion.setTaskName(bpmTask.getName());
            defaultBpmCheckOpinion.setStatus(OpinionStatus.INQU.getKey());
            defaultBpmCheckOpinion.setCreateTime(bpmTask.getCreateTime());
            defaultBpmCheckOpinion.setOpinion(opinion);
            defaultBpmCheckOpinion.setCompleteTime(LocalDateTime.now());
            defaultBpmCheckOpinion.setDurMs(Long.valueOf(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)defaultBpmCheckOpinion.getCreateTime())));
            defaultBpmCheckOpinion.setAuditor(ContextUtil.getCurrentUser().getUserId());
            defaultBpmCheckOpinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
            defaultBpmCheckOpinion.setFiles(files);
            this.bpmCheckOpinionManager.create((Model)defaultBpmCheckOpinion);
        } else {
            checkOpinion.setStatus(OpinionStatus.INQU.getKey());
            checkOpinion.setOpinion(opinion);
            checkOpinion.setCompleteTime(LocalDateTime.now());
            checkOpinion.setDurMs(Long.valueOf(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)checkOpinion.getCreateTime())));
            checkOpinion.setAuditor(ContextUtil.getCurrentUser().getUserId());
            checkOpinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
            checkOpinion.setFiles(files);
            this.bpmCheckOpinionManager.update((Model)checkOpinion);
        }
    }

    private void addTaskInquByUsers(String parentTaskId, DefaultBpmTask bpmTask, List<IUser> listUsers, String opinion, TaskType taskType, String type) throws Exception {
        if (BeanUtils.isEmpty((Object)type)) {
            type = "inqu";
        }
        if (BeanUtils.isEmpty((Object)taskType)) {
            taskType = TaskType.TRANSFORMEDINQU;
        }
        for (IUser user : listUsers) {
            DefaultBpmTask task = BpmUtil.convertTask((DefaultBpmTask)bpmTask, (String)parentTaskId, (TaskType)taskType, (IUser)user);
            TaskEntity delegateTask = new TaskEntity();
            delegateTask.setId(task.getId());
            delegateTask.setAssignee(task.getAssigneeId());
            delegateTask.setOwner(task.getOwnerId());
            delegateTask.setTaskDefinitionKey(task.getNodeId());
            delegateTask.setProcessDefinitionId(task.getBpmnDefId());
            delegateTask.setName(task.getName());
            delegateTask.setProcessInstanceId(task.getBpmnInstId());
            delegateTask.setSuspensionState((int)task.getSuspendState().shortValue());
            delegateTask.setPriority(task.getPriority().intValue());
            delegateTask.setCreateTime(new Date());
            task.setExecId(null);
            task.setTaskId(delegateTask.getId());
            task.setCreatorId(ContextUtil.getCurrentUserId());
            this.bpmTaskManager.create((Model)task);
            TodoPushUtil.addTodoToPortal((BpmTask)task);
            MessageUtil.notify((DefaultBpmTask)task, (String)opinion, (IUser)user, (String)"", (String)"bpmnTaskTrans");
            this.addTranCheckOpinion(task, OpinionStatus.AWAITING_CHECK, user.getUserId(), "", parentTaskId);
        }
    }

    @Override
    @Transactional
    public void addApproveLineTask(TaskTrans taskTrans, List<IUser> listUsers, String notifyType, String opinion) throws Exception {
        DefaultBpmTask bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskTrans.getTaskId()));
        BpmTaskTrans trans = (BpmTaskTrans)taskTrans;
        this.addTaskTrans(trans, bpmTask, listUsers);
        bpmTask.setStatus(TaskType.APPROVELINEING.name());
        this.bpmTaskManager.update((Model)bpmTask);
        this.addApproveLineTaskByUsers(trans.getTaskId(), bpmTask, listUsers, trans.getSignType(), opinion, notifyType, "bpmnTaskApproveLine");
        DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getByTaskId(taskTrans.getTaskId());
        checkOpinion.setStatus(OpinionStatus.APPROVE_LINEING.getKey());
        checkOpinion.setOpinion(opinion);
        checkOpinion.setCompleteTime(LocalDateTime.now());
        checkOpinion.setDurMs(Long.valueOf(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)checkOpinion.getCreateTime())));
        checkOpinion.setAuditor(ContextUtil.getCurrentUser().getUserId());
        checkOpinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
        this.bpmCheckOpinionManager.update((Model)checkOpinion);
    }

    private void addApproveLineTaskByUsers(String parentTaskId, DefaultBpmTask bpmTask, List<IUser> listUsers, String signType, String opinion, String notifyType, String typeKey) throws Exception {
        if ("parallel".equals(signType)) {
            for (IUser user : listUsers) {
                DefaultBpmTask task = BpmUtil.convertTask((DefaultBpmTask)bpmTask, (String)parentTaskId, (TaskType)TaskType.APPROVELINEED, (IUser)user);
                this.bpmTaskManager.create((Model)task);
                this.addTranCheckOpinion(task, OpinionStatus.AWAITING_CHECK, user.getUserId(), "", parentTaskId);
                MessageUtil.notify((DefaultBpmTask)task, (String)opinion, (IUser)user, (String)notifyType, (String)typeKey);
            }
        } else {
            IUser user = listUsers.get(0);
            DefaultBpmTask task = BpmUtil.convertTask((DefaultBpmTask)bpmTask, (String)parentTaskId, (TaskType)TaskType.APPROVELINEED, (IUser)user);
            this.bpmTaskManager.create((Model)task);
            this.addTranCheckOpinion(task, OpinionStatus.AWAITING_CHECK, user.getUserId(), "", parentTaskId);
            MessageUtil.notify((DefaultBpmTask)bpmTask, (String)opinion, (IUser)user, (String)notifyType, (String)typeKey);
        }
        TodoPushUtil.addTodoToPortal((BpmTask)bpmTask);
    }

    @Override
    @Transactional
    public void addSignSequenceTask(BpmTaskTrans taskTrans, List<IUser> userList, String notifyType, String opinion) throws Exception {
        DefaultBpmTask bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskTrans.getTaskId()));
        BpmTaskTrans trans = taskTrans;
        bpmTask.setStatus(TaskType.SIGNSEQUENCEING.name());
        this.bpmTaskManager.update((Model)bpmTask);
        this.addSignSequenceTaskByUsers(trans.getTaskId(), bpmTask, userList, trans.getSignType(), opinion, notifyType, "bpmnTaskSignSequence");
        DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getByTaskId(taskTrans.getTaskId());
        checkOpinion.setStatus(OpinionStatus.SIGNSEQUENCEING.getKey());
        checkOpinion.setOpinion(opinion);
        checkOpinion.setCompleteTime(LocalDateTime.now());
        checkOpinion.setDurMs(Long.valueOf(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)checkOpinion.getCreateTime())));
        checkOpinion.setAuditor(ContextUtil.getCurrentUser().getUserId());
        checkOpinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
        this.bpmCheckOpinionManager.update((Model)checkOpinion);
    }

    private void addSignSequenceTaskByUsers(String parentTaskId, DefaultBpmTask bpmTask, List<IUser> listUsers, String signType, String opinion, String notifyType, String typeKey) throws Exception {
        IUser user = listUsers.get(0);
        String parentId = bpmTask.getParentId();
        if ("0".equals(parentId)) {
            parentId = bpmTask.getId();
        }
        if (!bpmTask.isBpmnTask()) {
            this.bpmTaskManager.remove((Serializable)((Object)bpmTask.getId()));
        }
        DefaultBpmTask task = BpmUtil.convertTask((DefaultBpmTask)bpmTask, (String)parentId, (TaskType)TaskType.SIGNSEQUENCEED, (IUser)user);
        this.bpmTaskManager.create((Model)task);
        this.addTranCheckOpinion(task, OpinionStatus.AWAITING_CHECK, user.getUserId(), "", task.getParentId());
        MessageUtil.notify((DefaultBpmTask)bpmTask, (String)opinion, (IUser)user, (String)notifyType, (String)typeKey);
        String newTaskId = task.getId();
        BpmTaskSignSequence signSequence = this.signSequenceManager.getByTaskId(bpmTask.getId());
        String path = bpmTask.getId();
        if (BeanUtils.isNotEmpty((Object)((Object)signSequence))) {
            path = signSequence.getPath() + "." + path;
            signSequence.setStatus(SignSequenceStatus.HALF.getKey());
            signSequence.setNextTaskId(task.getId());
            this.signSequenceManager.update((Model)signSequence);
        }
        for (int i = 0; i < listUsers.size(); ++i) {
            BpmTaskSignSequence entity = new BpmTaskSignSequence();
            parentId = bpmTask.getId();
            entity.setParentId(parentId);
            entity.setInstanceId(bpmTask.getProcInstId());
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put("id", listUsers.get(i).getUserId());
            userMap.put("type", "user");
            userMap.put("name", listUsers.get(i).getFullname());
            entity.setExecutor(JsonUtil.toJson(userMap));
            String status = SignSequenceStatus.WAITINGFORGENERATIONSIGNATURETASK.getKey();
            if (i == 0) {
                entity.setTaskId(newTaskId);
                status = SignSequenceStatus.INAPPROVAL.getKey();
            }
            entity.setStatus(status);
            entity.setSeq((short)i);
            entity.setPath(path);
            entity.setNodeId(bpmTask.getNodeId());
            this.signSequenceManager.create((Model)entity);
        }
    }

    @Override
    @Transactional
    public void addRevokeTask(DefaultBpmTask bpmTask, IUser user, String messageType) throws Exception {
        BpmTaskTransRecord taskTransRecord = this.bpmTaskTransRecordManager.getByTaskId(bpmTask.getTaskId());
        if (BeanUtils.isEmpty((Object)((Object)taskTransRecord))) {
            throw new WorkFlowException("\u672a\u627e\u5230\u6d41\u8f6c\u8bb0\u5f55\uff01");
        }
        if (!taskTransRecord.getStatus().equals((short)0)) {
            throw new WorkFlowException("\u5f53\u524d\u8282\u70b9\u5df2\u4e0d\u652f\u6301\u64a4\u56de\uff01");
        }
        taskTransRecord.setAgreeAmount((short)(taskTransRecord.getAgreeAmount() - 1));
        this.bpmTaskTransRecordManager.update((Model)taskTransRecord);
        BpmTaskTrans trans = this.bpmTaskTransManager.getByTaskId(bpmTask.getTaskId());
        trans.setAgreeAmount((short)(trans.getAgreeAmount() - 1));
        this.bpmTaskTransManager.update((Model)trans);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("transRecordid", taskTransRecord.getId());
        params.put("userId", user.getUserId());
        BpmTransReceiver receiver = this.transReceiverManager.getByTransRecordAndUserId(params);
        receiver.setStatus(Short.valueOf("0"));
        receiver.setOpinion(null);
        receiver.setCheckTime(null);
        this.transReceiverManager.update((Model)receiver);
        DefaultBpmTask task = BpmUtil.convertTask((DefaultBpmTask)bpmTask, (String)bpmTask.getTaskId(), (TaskType)TaskType.APPROVELINEED, (IUser)user);
        this.bpmTaskManager.create((Model)task);
        TodoPushUtil.addTodoToPortal((BpmTask)bpmTask);
        this.addTranCheckOpinion(task, OpinionStatus.AWAITING_CHECK, user.getUserId(), "", bpmTask.getTaskId());
        MessageUtil.notify((DefaultBpmTask)task, (String)"", (IUser)user, (String)messageType, (String)"bpmnTaskApproveLine");
    }

    @Override
    @Transactional
    public void revokeSignSequence(RevokeTransParamObject revokeTransParamObject) throws Exception {
        BpmTaskSignSequence revokeTaskSignSeq = this.signSequenceManager.getByTaskId(revokeTransParamObject.getTaskId());
        String rootTaskId = revokeTransParamObject.getTaskId();
        if (BeanUtils.isNotEmpty((Object)((Object)revokeTaskSignSeq))) {
            rootTaskId = revokeTaskSignSeq.getPath().split("\\.")[0];
        }
        BpmTaskSignSequence inApproval = this.signSequenceManager.getInApprovalByInstNodeId(revokeTransParamObject.getInstanceId(), rootTaskId, revokeTransParamObject.getNodeId());
        String revokeTaskId = revokeTransParamObject.getTaskId();
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)revokeTransParamObject.getInstanceId()));
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(instance.getProcDefId());
        if (BeanUtils.isEmpty((Object)((Object)revokeTaskSignSeq))) {
            String firstTaskId;
            BpmTaskSignSequence firstTaskSignSeq;
            if (BeanUtils.isNotEmpty((Object)((Object)inApproval)) && revokeTaskId.equals(inApproval.getParentId()) && 0 == inApproval.getSeq() && ("true".equals(def.getIsReadRevoke()) || inApproval.isNotRead())) {
                this.revokeSignSequenceA(inApproval, revokeTransParamObject, revokeTaskId);
                return;
            }
            if (BeanUtils.isNotEmpty((Object)((Object)inApproval)) && inApproval.getPath().contains(".") && ("true".equals(def.getIsReadRevoke()) || inApproval.isNotRead()) && BeanUtils.isNotEmpty((Object)((Object)(firstTaskSignSeq = this.signSequenceManager.getByTaskId(firstTaskId = inApproval.getPath().split("\\.")[1])))) && 0 == firstTaskSignSeq.getSeq()) {
                this.revokeSignSequenceA(inApproval, revokeTransParamObject, revokeTaskId);
                return;
            }
        } else {
            String nextTaskId = revokeTaskSignSeq.getNextTaskId();
            revokeTaskSignSeq.setStatus(SignSequenceStatus.INAPPROVAL.getKey());
            revokeTaskSignSeq.setNextTaskId("");
            revokeTaskSignSeq.setTaskId(UniqueIdUtil.getSuid());
            this.signSequenceManager.update((Model)revokeTaskSignSeq);
            if (BeanUtils.isNotEmpty((Object)((Object)inApproval)) && inApproval.getPath().contains(revokeTaskSignSeq.getPath() + "." + revokeTaskId) && ("true".equals(def.getIsReadRevoke()) || inApproval.isNotRead())) {
                this.createSignSequenceTask(revokeTransParamObject, revokeTaskSignSeq, inApproval.getTaskId());
                this.updateInApprovalOpinion(inApproval.getTaskId(), revokeTransParamObject.getCause());
                this.signSequenceManager.removeByPath(revokeTaskSignSeq.getPath() + "." + revokeTaskId);
                return;
            }
            if (BeanUtils.isNotEmpty((Object)((Object)inApproval)) && inApproval.getPath().equals(revokeTaskSignSeq.getPath()) && inApproval.getTaskId().equals(nextTaskId) && ("true".equals(def.getIsReadRevoke()) || inApproval.isNotRead())) {
                inApproval.setStatus(SignSequenceStatus.WAITINGFORGENERATIONSIGNATURETASK.getKey());
                String inApprovalTaskId = inApproval.getTaskId();
                inApproval.setTaskId("");
                this.signSequenceManager.update((Model)inApproval);
                this.createSignSequenceTask(revokeTransParamObject, revokeTaskSignSeq, inApprovalTaskId);
                this.updateInApprovalOpinion(inApprovalTaskId, revokeTransParamObject.getCause());
                return;
            }
        }
        throw new WorkFlowException("\u5f53\u524d\u8282\u70b9\u5df2\u4e0d\u652f\u6301\u64a4\u56de\uff01");
    }

    private void revokeSignSequenceA(BpmTaskSignSequence inApproval, RevokeTransParamObject revokeTransParamObject, String taskId) {
        String rootTaskId = inApproval.getPath().split("\\.")[0];
        this.bpmTaskManager.remove((Serializable)((Object)inApproval.getTaskId()));
        this.updateInApprovalOpinion(inApproval.getTaskId(), revokeTransParamObject.getCause());
        this.signSequenceManager.removeByInstNodeId(inApproval.getInstanceId(), rootTaskId, inApproval.getNodeId());
        DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        defaultBpmTask.setStatus(TaskType.NORMAL.getKey());
        this.bpmTaskManager.update((Model)defaultBpmTask);
        this.addTranCheckOpinion(defaultBpmTask, OpinionStatus.AWAITING_CHECK, ContextUtil.getCurrentUserId(), "", defaultBpmTask.getId());
    }

    private void createSignSequenceTask(RevokeTransParamObject revokeTransParamObject, BpmTaskSignSequence revokeSignSeq, String inApprovalTaskId) throws Exception {
        DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)inApprovalTaskId));
        String executor = revokeSignSeq.getExecutor();
        JsonNode jsonNode = JsonUtil.toJsonNode((String)executor);
        IUser user = BpmUtil.getUser((String)jsonNode.get("id").asText());
        DefaultBpmTask convertTask = BpmUtil.convertTask((DefaultBpmTask)defaultBpmTask, (String)defaultBpmTask.getParentId(), (TaskType)TaskType.SIGNSEQUENCEED, (IUser)user);
        this.bpmTaskManager.remove((Serializable)((Object)defaultBpmTask.getId()));
        convertTask.setId(revokeSignSeq.getTaskId());
        this.bpmTaskManager.create((Model)convertTask);
        this.addTranCheckOpinion(convertTask, OpinionStatus.AWAITING_CHECK, user.getUserId(), "", convertTask.getParentId());
        MessageUtil.notify((DefaultBpmTask)convertTask, (String)revokeTransParamObject.getCause(), (IUser)user, (String)revokeTransParamObject.getMessageType(), (String)"bpmnTaskSignSequence");
    }

    private void updateInApprovalOpinion(String taskId, String opinion) {
        this.updateInApprovalOpinion(taskId, opinion, OpinionStatus.SIGN_RECOVER_CANCEL.getKey());
    }

    private void updateInApprovalOpinion(String taskId, String opinion, String status) {
        DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getByTaskId(taskId);
        if (BeanUtils.isEmpty((Object)checkOpinion)) {
            throw new BaseException("\u64a4\u56de\u7684\u4efb\u52a1\u5df2\u7ecf\u88ab\u5904\u7406\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u83b7\u53d6\u3002");
        }
        checkOpinion.setStatus(status);
        checkOpinion.setOpinion(opinion);
        checkOpinion.setCompleteTime(LocalDateTime.now());
        checkOpinion.setDurMs(Long.valueOf(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)checkOpinion.getCreateTime())));
        checkOpinion.setAuditor(ContextUtil.getCurrentUser().getUserId());
        checkOpinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
        this.bpmCheckOpinionManager.update((Model)checkOpinion);
    }

    @Override
    @Transactional
    public void addSignLineTask(BpmTaskTrans taskTrans, List<IUser> listUsers, String notifyType, String opinion) throws Exception {
        DefaultBpmTask bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskTrans.getTaskId()));
        BpmTaskTrans trans = taskTrans;
        bpmTask.setStatus(TaskType.SIGNLINEING.name());
        this.bpmTaskManager.update((Model)bpmTask);
        this.addSignLine(trans, bpmTask, listUsers, opinion, notifyType, taskTrans.getAction());
        DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getByTaskId(taskTrans.getTaskId());
        checkOpinion.setStatus(OpinionStatus.SIGNLINEING.getKey());
        checkOpinion.setOpinion(opinion);
        checkOpinion.setCompleteTime(LocalDateTime.now());
        checkOpinion.setDurMs(Long.valueOf(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)checkOpinion.getCreateTime())));
        checkOpinion.setAuditor(ContextUtil.getCurrentUser().getUserId());
        checkOpinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
        this.bpmCheckOpinionManager.update((Model)checkOpinion);
    }

    private void addSignLine(BpmTaskTrans trans, DefaultBpmTask bpmTask, List<IUser> listUsers, String opinion, String notifyType, String action) throws Exception {
        String parentTaskId;
        String rootTaskId = parentTaskId = trans.getTaskId();
        BpmTaskSignLine signLine = this.signLineManager.getByTaskId(trans.getTaskId());
        String path = parentTaskId;
        if (BeanUtils.isNotEmpty((Object)((Object)signLine))) {
            path = String.format("%s.%s", signLine.getPath(), parentTaskId);
            rootTaskId = path.split("\\.")[0];
            signLine.setStatus(SignLineStatus.COMPLETE.getKey());
            this.signLineManager.update((Model)signLine);
            action = signLine.getAction();
        }
        for (IUser user : listUsers) {
            DefaultBpmTask task = BpmUtil.convertTask((DefaultBpmTask)bpmTask, (String)rootTaskId, (TaskType)TaskType.SIGNLINEED, (IUser)user);
            this.bpmTaskManager.create((Model)task);
            String taskId = task.getId();
            this.addTranCheckOpinion(task, OpinionStatus.AWAITING_CHECK, user.getUserId(), "", parentTaskId);
            MessageUtil.notify((DefaultBpmTask)task, (String)opinion, (IUser)user, (String)notifyType, (String)"bpmnTaskSignLine");
            BpmTaskSignLine newSignLine = new BpmTaskSignLine();
            newSignLine.setTaskId(taskId);
            newSignLine.setInstanceId(task.getProcInstId());
            newSignLine.setPath(path);
            newSignLine.setStatus(SignLineStatus.INAPPROVAL.getKey());
            ObjectNode mainGroup = this.ucFeignService.getMainGroup(user.getUserId());
            String orgName = "";
            HashMap<String, String> userMap = new HashMap<String, String>();
            if (BeanUtils.isNotEmpty((Object)mainGroup) && mainGroup.has("name")) {
                orgName = mainGroup.get("name").asText();
            }
            userMap.put("orgName", orgName);
            userMap.put("id", user.getUserId());
            userMap.put("type", "user");
            userMap.put("account", user.getAccount());
            userMap.put("name", user.getFullname());
            newSignLine.setExecutor(JsonUtil.toJson(userMap));
            newSignLine.setAction(action);
            newSignLine.setNodeId(task.getNodeId());
            this.signLineManager.create((Model)newSignLine);
        }
    }

    @Override
    @Transactional
    public void revokeSignLine(RevokeSignLineParamObject revokeParamObject) throws Exception {
        BpmTaskSignLine revokeSignLine = this.signLineManager.getByTaskId(revokeParamObject.getTaskId());
        String rootTaskId = revokeParamObject.getTaskId();
        if (BeanUtils.isNotEmpty((Object)((Object)revokeSignLine))) {
            rootTaskId = revokeSignLine.getPath().split("\\.")[0];
        }
        List<BpmTaskSignLine> signLines = this.signLineManager.getByInstNodeIdAndStatus(revokeParamObject.getInstanceId(), rootTaskId, revokeParamObject.getNodeId(), SignLineStatus.INAPPROVAL.getKey());
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)revokeParamObject.getInstanceId()));
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(instance.getProcDefId());
        String isReadRevoke = def.getIsReadRevoke();
        boolean isNotRead = false;
        if ("false".equals(isReadRevoke)) {
            for (BpmTaskSignLine bpmTaskSignLine : signLines) {
                if (!bpmTaskSignLine.isNotRead()) continue;
                isNotRead = true;
                break;
            }
        } else {
            isNotRead = true;
        }
        if (BeanUtils.isEmpty((Object)((Object)revokeSignLine)) && BeanUtils.isNotEmpty(signLines) && isNotRead) {
            String[] taskIds;
            String inApprovalTaskIds = revokeParamObject.getInApprovalTaskIds();
            for (String taskId : taskIds = inApprovalTaskIds.split(",")) {
                this.updateInApprovalOpinion(taskId, revokeParamObject.getCause(), OpinionStatus.SIGN_LINE_RETRACTED.getKey());
            }
            this.bpmTaskManager.removeByIds(taskIds);
            String status = SignLineStatus.RETRACTED.getKey();
            this.signLineManager.updateStatusByTaskIds(status, taskIds);
            signLines = this.signLineManager.getByInstNodeIdAndStatus(revokeParamObject.getInstanceId(), rootTaskId, revokeParamObject.getNodeId(), SignLineStatus.INAPPROVAL.getKey());
            if (BeanUtils.isEmpty(signLines)) {
                DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)rootTaskId));
                defaultBpmTask.setStatus(TaskType.NORMAL.getKey());
                this.bpmTaskManager.update((Model)defaultBpmTask);
                this.signLineManager.removeByInstIdNodeId(revokeParamObject.getInstanceId(), rootTaskId, revokeParamObject.getNodeId());
                this.addTranCheckOpinion(defaultBpmTask, OpinionStatus.AWAITING_CHECK, ContextUtil.getCurrentUserId(), "", defaultBpmTask.getId());
            }
            return;
        }
        if (BeanUtils.isNotEmpty((Object)((Object)revokeSignLine))) {
            DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)rootTaskId));
            List<BpmTaskSignLine> pathChildSignLines = this.signLineManager.getByPathChildAndStatus(String.format("%s.%s", revokeSignLine.getPath(), revokeSignLine.getTaskId()), null);
            if (BeanUtils.isEmpty(pathChildSignLines) && BeanUtils.isNotEmpty(signLines) && SignLineStatus.COMPLETE.getKey().equals(revokeSignLine.getStatus())) {
                DefaultBpmTask task = BpmUtil.convertTask((DefaultBpmTask)defaultBpmTask, (String)rootTaskId, (TaskType)TaskType.SIGNLINEED, (IUser)ContextUtil.getCurrentUser());
                this.bpmTaskManager.create((Model)task);
                this.addCheckOpinion(task, OpinionStatus.SIGN_LINE_RETRACTED, ContextUtil.getCurrentUserId(), revokeParamObject.getCause(), true);
                this.addTranCheckOpinion(task, OpinionStatus.AWAITING_CHECK, ContextUtil.getCurrentUserId(), "", defaultBpmTask.getId());
                revokeSignLine.setStatus(SignLineStatus.WITHDRAWALOFAPPROVAL.getKey());
                this.signLineManager.update((Model)revokeSignLine);
                revokeSignLine.setTaskId(task.getId());
                revokeSignLine.setStatus(SignLineStatus.INAPPROVAL.getKey());
                revokeSignLine.setId(UniqueIdUtil.getSuid());
                this.signLineManager.create((Model)revokeSignLine);
                return;
            }
            if (BeanUtils.isEmpty(pathChildSignLines) && BeanUtils.isNotEmpty((Object)defaultBpmTask) && TaskType.NORMAL.getKey().equals(defaultBpmTask.getStatus()) && SignLineStatus.COMPLETE.getKey().equals(revokeSignLine.getStatus())) {
                DefaultBpmTask task = BpmUtil.convertTask((DefaultBpmTask)defaultBpmTask, (String)rootTaskId, (TaskType)TaskType.SIGNLINEED, (IUser)ContextUtil.getCurrentUser());
                this.bpmTaskManager.create((Model)task);
                this.addTranCheckOpinion(task, OpinionStatus.AWAITING_CHECK, ContextUtil.getCurrentUserId(), "", defaultBpmTask.getId());
                defaultBpmTask.setStatus(TaskType.SIGNLINEING.getKey());
                this.bpmTaskManager.update((Model)defaultBpmTask);
                this.updateInApprovalOpinion(defaultBpmTask.getTaskId(), revokeParamObject.getCause(), OpinionStatus.SIGN_LINE_RETRACTED.getKey());
                revokeSignLine.setStatus(SignLineStatus.WITHDRAWALOFAPPROVAL.getKey());
                this.signLineManager.update((Model)revokeSignLine);
                revokeSignLine.setTaskId(task.getId());
                revokeSignLine.setStatus(SignLineStatus.INAPPROVAL.getKey());
                revokeSignLine.setId(UniqueIdUtil.getSuid());
                this.signLineManager.create((Model)revokeSignLine);
                return;
            }
            pathChildSignLines = this.signLineManager.getByPathChildAndStatus(String.format("%s.%s", revokeSignLine.getPath(), revokeSignLine.getTaskId()), SignLineStatus.INAPPROVAL.getKey());
            if ("false".equals(isReadRevoke)) {
                for (BpmTaskSignLine bpmTaskSignLine : pathChildSignLines) {
                    if (!bpmTaskSignLine.isNotRead()) continue;
                    isNotRead = true;
                    break;
                }
            } else {
                isNotRead = true;
            }
            if (BeanUtils.isNotEmpty(pathChildSignLines) && isNotRead) {
                String[] taskIds;
                String inApprovalTaskIds = revokeParamObject.getInApprovalTaskIds();
                for (String taskId : taskIds = inApprovalTaskIds.split(",")) {
                    this.updateInApprovalOpinion(taskId, revokeParamObject.getCause(), OpinionStatus.SIGN_LINE_RETRACTED.getKey());
                }
                this.bpmTaskManager.removeByIds(taskIds);
                String status = SignLineStatus.RETRACTED.getKey();
                this.signLineManager.updateStatusByTaskIds(status, taskIds);
                List<BpmTaskSignLine> pathChildAndStatus = this.signLineManager.getByPathChildAndStatus(String.format("%s.%s", revokeSignLine.getPath(), revokeSignLine.getTaskId()), null);
                boolean isCreateAn = true;
                for (BpmTaskSignLine bpmTaskSignLine : pathChildAndStatus) {
                    if (!SignLineStatus.COMPLETE.getKey().equals(bpmTaskSignLine.getStatus()) && !SignLineStatus.INAPPROVAL.getKey().equals(bpmTaskSignLine.getStatus())) continue;
                    isCreateAn = false;
                    break;
                }
                if (isCreateAn) {
                    DefaultBpmTask task = BpmUtil.convertTask((DefaultBpmTask)defaultBpmTask, (String)rootTaskId, (TaskType)TaskType.SIGNLINEED, (IUser)ContextUtil.getCurrentUser());
                    this.bpmTaskManager.create((Model)task);
                    this.addTranCheckOpinion(task, OpinionStatus.AWAITING_CHECK, ContextUtil.getCurrentUserId(), "", defaultBpmTask.getId());
                    revokeSignLine.setTaskId(task.getId());
                    revokeSignLine.setStatus(SignLineStatus.INAPPROVAL.getKey());
                    this.signLineManager.update((Model)revokeSignLine);
                } else {
                    this.handSignLineA(revokeSignLine, "", revokeParamObject.getCause(), revokeParamObject.getMessageType());
                }
                return;
            }
        }
        throw new WorkFlowException("\u5f53\u524d\u8282\u70b9\u5df2\u4e0d\u652f\u6301\u64a4\u56de\uff01");
    }

    @Override
    public void addTransTask(BpmTaskTrans taskTrans, List<IUser> listUsers, String notifyType, String opinion, String files) throws Exception {
        DefaultBpmTask bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskTrans.getTaskId()));
        BpmTaskTrans trans = taskTrans;
        this.addTaskTrans(trans, bpmTask, listUsers);
        bpmTask.setStatus(TaskType.TRANSFORMING.name());
        TodoPushUtil.taskToHandled((BpmTask)bpmTask, (String)"task");
        this.bpmTaskManager.update((Model)bpmTask);
        this.addTaskByUsers(trans.getTaskId(), bpmTask, listUsers, opinion, null, null);
        DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getByTaskId(taskTrans.getTaskId());
        if (BeanUtils.isEmpty((Object)checkOpinion)) {
            DefaultBpmCheckOpinion defaultBpmCheckOpinion = new DefaultBpmCheckOpinion();
            defaultBpmCheckOpinion.setId(UniqueIdUtil.getSuid());
            defaultBpmCheckOpinion.setProcDefId(bpmTask.getBpmnDefId());
            defaultBpmCheckOpinion.setProcInstId(bpmTask.getProcInstId());
            defaultBpmCheckOpinion.setTaskId(BeanUtils.isEmpty((Object)bpmTask.getTaskId()) ? bpmTask.getId() : bpmTask.getTaskId());
            defaultBpmCheckOpinion.setTaskKey(bpmTask.getNodeId());
            defaultBpmCheckOpinion.setTaskName(bpmTask.getName());
            defaultBpmCheckOpinion.setStatus(OpinionStatus.ADDSIGN.getKey());
            defaultBpmCheckOpinion.setCreateTime(bpmTask.getCreateTime());
            defaultBpmCheckOpinion.setOpinion(opinion);
            defaultBpmCheckOpinion.setCompleteTime(LocalDateTime.now());
            defaultBpmCheckOpinion.setDurMs(Long.valueOf(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)defaultBpmCheckOpinion.getCreateTime())));
            defaultBpmCheckOpinion.setAuditor(ContextUtil.getCurrentUser().getUserId());
            defaultBpmCheckOpinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
            defaultBpmCheckOpinion.setFiles(files);
            this.bpmCheckOpinionManager.create((Model)defaultBpmCheckOpinion);
        } else {
            checkOpinion.setStatus(OpinionStatus.ADDSIGN.getKey());
            checkOpinion.setOpinion(opinion);
            checkOpinion.setCompleteTime(LocalDateTime.now());
            checkOpinion.setDurMs(Long.valueOf(TimeUtil.getCurrentTimeMillis() - TimeUtil.getTimeMillis((LocalDateTime)checkOpinion.getCreateTime())));
            checkOpinion.setAuditor(ContextUtil.getCurrentUser().getUserId());
            checkOpinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
            checkOpinion.setFiles(files);
            this.bpmCheckOpinionManager.update((Model)checkOpinion);
        }
    }

    private void addTaskByUsers(String parentTaskId, DefaultBpmTask bpmTask, List<IUser> listUsers, String opinion, TaskType taskType, String type) throws Exception {
        if (BeanUtils.isEmpty((Object)type)) {
            type = "inqu";
        }
        if (BeanUtils.isEmpty((Object)taskType)) {
            taskType = TaskType.USERADDSIGN;
        }
        for (IUser user : listUsers) {
            DefaultBpmTask task = BpmUtil.convertTask((DefaultBpmTask)bpmTask, (String)parentTaskId, (TaskType)taskType, (IUser)user);
            TaskEntity delegateTask = new TaskEntity();
            delegateTask.setId(task.getId());
            delegateTask.setAssignee(task.getAssigneeId());
            delegateTask.setOwner(task.getOwnerId());
            delegateTask.setTaskDefinitionKey(task.getNodeId());
            delegateTask.setProcessDefinitionId(task.getBpmnDefId());
            delegateTask.setName(task.getName());
            delegateTask.setProcessInstanceId(task.getBpmnInstId());
            delegateTask.setSuspensionState((int)task.getSuspendState().shortValue());
            delegateTask.setPriority(task.getPriority().intValue());
            delegateTask.setCreateTime(new Date());
            task.setExecId(null);
            task.setTaskId(delegateTask.getId());
            task.setCreatorId(ContextUtil.getCurrentUserId());
            this.bpmTaskManager.create((Model)task);
            TodoPushUtil.addTodoToPortal((BpmTask)bpmTask);
            MessageUtil.notify((DefaultBpmTask)task, (String)opinion, (IUser)user, (String)"", (String)"bpmnTaskTrans");
            this.addTranCheckOpinion(task, OpinionStatus.AWAITING_CHECK, user.getUserId(), "", parentTaskId);
        }
    }

    public void userAddSignFeedback(String taskId, String actionName, String notifyType, String opinion, boolean isIntervene, String files, String zFiles) throws Exception {
        List<DefaultBpmTask> list = this.getList(taskId);
        DefaultBpmTask tranTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (BeanUtils.isEmpty((Object)tranTask)) {
            throw new ApproveTaskException("\u5f53\u524d\u4efb\u52a1\u5df2\u529e\u7406\uff0c\u4e0d\u53ef\u91cd\u590d\u529e\u7406\uff0c");
        }
        this.commentsBackFill(opinion, tranTask);
        OpinionStatus opinionStatus = DecideType.AGREE.getKey().equals(actionName) ? OpinionStatus.USER_ADD_SIGN_BACK : OpinionStatus.TRANS_OPPOSE;
        this.updOpinionVue(taskId, opinionStatus, actionName, ContextUtil.getCurrentUser().getUserId(), opinion, files, zFiles);
        BpmTaskTransRecord transRecord = this.bpmTaskTransRecordManager.getByTaskId(tranTask.getParentId());
        this.dealWithTransRecord(opinionStatus, transRecord, tranTask, opinion);
        BpmTaskTrans parenTaskTrans = this.bpmTaskTransManager.getByTaskId(tranTask.getParentId());
        String inquType = parenTaskTrans.getInquType();
        if (StringUtil.isNotEmpty((String)inquType) && "step".equals(inquType)) {
            list = this.getParentList(taskId);
        }
        TodoPushUtil.taskToHandled((BpmTask)tranTask, (String)"task");
        this.bpmTaskManager.remove((Serializable)((Object)taskId));
        for (int i = 0; i < list.size(); ++i) {
            DefaultBpmTask bpmTask = list.get(i);
            String id = bpmTask.getId();
            BpmTaskTrans taskTrans = this.bpmTaskTransManager.getByTaskId(id);
            this.updTaskTrans(actionName, taskTrans);
            this.bpmTaskTransManager.update((Model)taskTrans);
            SignResult result = this.calcVote(taskTrans);
            if (result.isComplete()) {
                OpinionStatus resultOpinionStatus = DecideType.AGREE.equals((Object)result.getDecideType()) ? OpinionStatus.SIGN_PASS_CANCEL : OpinionStatus.SIGN_NOPASS_CANCEL;
                List tasks = this.bpmTaskManager.getChildsByTaskId(bpmTask.getId());
                for (DefaultBpmTask task : tasks) {
                    this.updOpinionVue(BeanUtils.isEmpty((Object)task.getTaskId()) ? task.getId() : task.getTaskId(), resultOpinionStatus, actionName, null, DecideType.AGREE.getKey().equals(actionName) ? "\u6d41\u8f6c\u81ea\u52a8\u540c\u610f[\u7cfb\u7edf]" : "\u6d41\u8f6c\u81ea\u52a8\u53cd\u5bf9[\u7cfb\u7edf]", files, zFiles);
                }
                boolean isStop = this.handComplete(taskTrans, bpmTask, list, result, i, opinion, notifyType, tranTask.getAssigneeId(), null, null);
                if (!isStop || !"back".equals(taskTrans.getAction())) continue;
                this.addCheckOpinion(bpmTask, OpinionStatus.AWAITING_CHECK, "", "", false);
                continue;
            }
            this.handNotComplete(bpmTask, taskTrans, notifyType, opinion);
            break;
        }
    }

    private void commentsBackFill(String opinion, DefaultBpmTask tranTask) throws Exception {
        BpmProcessDef procDef = BpmUtil.getProcessDefByDefId((String)tranTask.getProcDefId());
        BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(tranTask.getProcInstId());
        List boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
        ObjectNode boData = BoDataUtil.hanlerData((BpmProcessInstance)bpmProcessInstance, null, (List)boDatas);
        opinion = tranTask.getName() + ":\t\u3000\u3000\u5ba1\u6838\u610f\u89c1\uff1a" + opinion + "\u3000\u3000\u5ba1\u6838\u4eba\uff1a" + tranTask.getOwnerName() + " \u3000\u3000\u5ba1\u6838\u65e5\u671f\uff1a" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy-MM-dd HH:mm:ss") + "";
        for (int i = 0; i < procDef.getBpmnNodeDefs().size(); ++i) {
            if (!((BpmNodeDef)procDef.getBpmnNodeDefs().get(i)).getNodeId().equals(tranTask.getNodeId()) || ((BpmNodeDef)procDef.getBpmnNodeDefs().get(i)).getNodeProperties().size() < 1) continue;
            for (int k = 0; k < ((BpmNodeDef)procDef.getBpmnNodeDefs().get(i)).getNodeProperties().size(); ++k) {
                NodeProperties nodeProperties = (NodeProperties)((BpmNodeDef)procDef.getBpmnNodeDefs().get(i)).getNodeProperties().get(k);
                if (!BeanUtils.isNotEmpty((Object)nodeProperties.getOpinionField())) continue;
                String opinionField = nodeProperties.getOpinionField();
                ObjectNode boDataZhu = (ObjectNode)boData.get(opinionField.split("\\.")[0]);
                if (nodeProperties.isAppendOpinion()) {
                    boDataZhu.put(opinionField.split("\\.")[1], opinion);
                    continue;
                }
                if (BeanUtils.isNotEmpty((Object)boDataZhu.get(opinionField.split("\\.")[1]))) {
                    opinion = JsonUtil.getString((JsonNode)boDataZhu, (String)opinionField.split("\\.")[1]) + "   \n" + opinion;
                    boDataZhu.put(opinionField.split("\\.")[1], opinion);
                    continue;
                }
                boDataZhu.put(opinionField.split("\\.")[1], opinion);
            }
        }
        DefaultProcessInstCmd processCmd = new DefaultProcessInstCmd();
        processCmd.setBusData(JsonUtil.toJson((Object)boData));
        BusDataUtil.handSaveBoData((BpmProcessInstance)bpmProcessInstance, (ActionCmd)processCmd);
    }

    @Override
    public List<BpmTaskTrans> getByInstId(String instId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BpmTaskTrans::getInstanceId, (Object)instId);
        return this.bpmTaskTransManager.list((Wrapper)lambdaQueryWrapper);
    }

    class SignResult {
        boolean isComplete = false;
        DecideType decideType = DecideType.AGREE;

        public SignResult() {
        }

        public SignResult(boolean isComplete, DecideType decideType) {
            this.decideType = decideType;
            this.isComplete = isComplete;
        }

        public boolean isComplete() {
            return this.isComplete;
        }

        public void setComplete(boolean isComplete) {
            this.isComplete = isComplete;
        }

        public DecideType getDecideType() {
            return this.decideType;
        }

        public void setDecideType(DecideType decideType) {
            this.decideType = decideType;
        }
    }
}

