/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.runtime.script;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.groovy.IUserScript;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.uc.api.constant.GroupTypeConstant;
import com.hotent.uc.api.impl.model.UserFacade;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IParamService;
import com.hotent.uc.api.service.IUserGroupService;
import com.hotent.uc.api.service.IUserService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BpmUserScript
implements IUserScript {
    @Resource
    IUserService userService;
    @Resource
    IUserGroupService userGroupService;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    IParamService paramService;

    private Set<BpmIdentity> convertUserList(List<IUser> list) {
        LinkedHashSet<BpmIdentity> identitys = new LinkedHashSet<BpmIdentity>();
        for (IUser iUser : list) {
            if (!BeanUtils.isNotEmpty((Object)iUser) || !BeanUtils.isNotEmpty((Object)iUser.getStatus()) || iUser.getStatus() != 1) continue;
            DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
            bpmIdentity.setId(iUser.getUserId());
            bpmIdentity.setName(iUser.getFullname());
            bpmIdentity.setType("user");
            identitys.add((BpmIdentity)bpmIdentity);
        }
        return identitys;
    }

    public Set<BpmIdentity> getListUserByRoleId(String roleCode) {
        IGroup role = this.userGroupService.getGroupByIdOrCode(GroupTypeConstant.ROLE.key(), roleCode);
        List list = this.userService.getUserListByGroup(GroupTypeConstant.ROLE.key(), role.getGroupId(), role.getGroupCode());
        return this.convertUserList(list);
    }

    public Set<BpmIdentity> getListUserByRelCode(String relCode) {
        ArrayNode array = this.ucFeignService.getUserByPost(relCode);
        ArrayList<IUser> list = new ArrayList<IUser>();
        if (BeanUtils.isNotEmpty((Object)array)) {
            for (Object node : array) {
                try {
                    ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode(node);
                    UserFacade user = new UserFacade();
                    user.setId(obj.get("id").asText());
                    user.setUserId(obj.get("id").asText());
                    user.setAccount(obj.get("account").asText());
                    user.setFullname(obj.get("fullname").asText());
                    user.setStatus(Integer.valueOf(BeanUtils.isNotEmpty((Object)obj.get("status")) ? obj.get("status").asInt() : 0));
                    list.add((IUser)user);
                }
                catch (IOException iOException) {}
            }
        }
        return this.convertUserList(list);
    }

    public Set<BpmIdentity> getListUserByParentOrgRoleCode(String roleCode) {
        IGroup role = this.userGroupService.getGroupByIdOrCode(GroupTypeConstant.ROLE.key(), roleCode);
        List list = this.userService.getUserListByGroup(GroupTypeConstant.ROLE.key(), role.getGroupId(), role.getGroupCode());
        return this.convertUserList(list);
    }

    public Set<BpmIdentity> getUserByOrgParamsAlias(String alias) {
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        String userId = (String)taskCmd.getVariables().get("startUser");
        ObjectNode org = this.ucFeignService.getMainGroup(userId);
        if (org == null) {
            return new LinkedHashSet<BpmIdentity>();
        }
        String value = this.paramService.getParamByGroup(org.get("groupId").asText(), alias) + "";
        ArrayList<IUser> list = new ArrayList<IUser>();
        IUser iUser = this.userService.getUserById(value);
        list.add(iUser);
        Set<BpmIdentity> set = this.convertUserList(list);
        return set;
    }
}

