/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.chart.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.chart.IChart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component(value="handle_throughput")
public class HandleThroughputChart
implements IChart {
    @Override
    public String getQuerySql(String flowType, String dimension, String ids, String orgIds, String startTime, String endTime, String orgType, String dbType) {
        String[] idArray;
        String idCode;
        StringBuilder sql = new StringBuilder();
        String whereIds = "org".equals(dimension) ? ids : orgIds;
        StringBuilder whereSql = new StringBuilder();
        String string = idCode = "2".equals(orgType) ? "CREATE_BY_" : "CREATE_ORG_ID_";
        if ("oracle".equals(dbType)) {
            whereSql.append(" AND opinion.STATUS_ IS NOT NULL AND opinion.COMPLETE_TIME_ between to_date('" + startTime + "','YYYY-MM-DD HH24:MI:SS') and to_date('" + endTime + "','YYYY-MM-DD HH24:MI:SS')");
        } else {
            whereSql.append(" AND opinion.STATUS_ IS NOT NULL AND opinion.COMPLETE_TIME_>='" + startTime + "' AND opinion.COMPLETE_TIME_<='" + endTime + "' ");
        }
        if (StringUtil.isNotEmpty((String)whereIds)) {
            idArray = whereIds.split(",");
            if ("org".equals(dimension)) {
                if ("1".equals(flowType)) {
                    whereSql.append(" AND " + StringUtil.idsInSql((String[])idArray, (String)"inst.PROC_DEF_ID_"));
                } else if ("2".equals(flowType)) {
                    whereSql.append(" AND " + StringUtil.idsInSql((String[])idArray, (String)"inst.TYPE_ID_"));
                }
            } else {
                idCode = !"2".equals(orgType) ? "ORG_ID_" : "AUDITOR_";
                whereSql.append(" AND " + StringUtil.idsInSql((String[])idArray, (String)("opinion." + idCode)));
            }
        }
        if (StringUtil.isNotEmpty((String)orgIds) && "org".equals(dimension)) {
            String[] orgIdArray = orgIds.split(",");
            boolean isFirst = false;
            for (String id : orgIdArray) {
                if (!isFirst) {
                    isFirst = true;
                } else {
                    sql.append(" UNION ");
                }
                String baseSql = this.getBaseSql(id, flowType, dimension, whereSql.toString(), orgType, dbType);
                sql.append(baseSql);
            }
        } else if (StringUtil.isNotEmpty((String)ids) && "flow".equals(dimension)) {
            idArray = ids.split(",");
            boolean isFirst = false;
            for (String id : idArray) {
                if (!isFirst) {
                    isFirst = true;
                } else {
                    sql.append(" UNION ");
                }
                String baseSql = this.getBaseSql(id, flowType, dimension, whereSql.toString(), orgType, dbType);
                sql.append(baseSql);
            }
        } else {
            String baseSql = this.getBaseSql("", flowType, dimension, whereSql.toString(), orgType, dbType);
            sql.append(baseSql);
        }
        return sql.toString();
    }

    private String getBaseSql(String orgId, String flowType, String dimension, String whereSql, String orgType, String dbType) {
        String[] status;
        StringBuilder baseSql = new StringBuilder();
        String orgSql = this.getOrgSql(flowType, orgType, orgId, dimension);
        String havingSql = " having count(1) >0 ";
        if ("oracle".equals(dbType) || "postgresql".equals(dbType) || "kingbasees".equals(dbType)) {
            String idCode = "2".equals(orgType) ? "AUDITOR_" : "ORG_ID_";
            String groupBySql = " GROUP BY opinion." + idCode;
            if ("flow".equals(dimension)) {
                groupBySql = "1".equals(flowType) ? " GROUP BY inst.PROC_DEF_ID_  " : " GROUP BY inst.TYPE_ID_ ";
            }
            havingSql = groupBySql + " having count(1) >0 ";
        }
        StringBuilder agreeSql = new StringBuilder();
        agreeSql.append(this.getApprovalSelectSql(flowType, orgType, dimension, "bpm_check_opinion", "agree"));
        agreeSql.append(" and opinion.STATUS_ in('transAgree','oppose','transOppose','back','backToStart','revoker','revoker_to_start','agree') ");
        agreeSql.append(orgSql);
        agreeSql.append(whereSql);
        agreeSql.append(havingSql);
        agreeSql.append(" UNION ");
        agreeSql.append(this.getApprovalSelectSql(flowType, orgType, dimension, "bpm_check_opinion_hi", "agree"));
        agreeSql.append(" and opinion.STATUS_ in('transAgree','oppose','transOppose','back','backToStart','revoker','revoker_to_start','agree') ");
        agreeSql.append(orgSql);
        agreeSql.append(whereSql);
        agreeSql.append(havingSql);
        baseSql.append(" select SUM(a.count) as count,a.id as id,'agree' as status from ( ");
        baseSql.append(agreeSql.toString());
        baseSql.append(" ) a ");
        if ("oracle".equals(dbType) || "postgresql".equals(dbType) || "kingbasees".equals(dbType)) {
            baseSql.append(" GROUP BY a.id ");
        }
        for (String statu : status = new String[]{"start_commu", "deliverto", "inqu", "copyto"}) {
            baseSql.append(" UNION ");
            StringBuilder otherSql = new StringBuilder();
            otherSql.append(this.getApprovalSelectSql(flowType, orgType, dimension, "bpm_check_opinion_hi", statu));
            otherSql.append(" and opinion.STATUS_ ='" + statu + "' ");
            otherSql.append(orgSql);
            otherSql.append(whereSql);
            otherSql.append(havingSql);
            otherSql.append(" UNION ");
            otherSql.append(this.getApprovalSelectSql(flowType, orgType, dimension, "bpm_check_opinion", statu));
            otherSql.append(" and opinion.STATUS_ ='" + statu + "' ");
            otherSql.append(orgSql);
            otherSql.append(whereSql);
            otherSql.append(havingSql);
            baseSql.append(" select SUM(a.count) as count,a.id as id,'" + statu + "' as status from ( ");
            baseSql.append(otherSql.toString());
            baseSql.append(" ) a ");
            if (!"oracle".equals(dbType) && !"postgresql".equals(dbType) && !"kingbasees".equals(dbType)) continue;
            baseSql.append(" GROUP BY a.id ");
        }
        return baseSql.toString();
    }

    private String getOrgSql(String flowType, String orgType, String orgId, String dimension) {
        String orgSql;
        String idCode = "2".equals(orgType) ? "AUDITOR_" : "ORG_ID_";
        String string = orgSql = StringUtil.isNotEmpty((String)orgId) ? " AND opinion." + idCode + " ='" + orgId + "' " : " ";
        if ("flow".equals(dimension)) {
            orgSql = "1".equals(flowType) ? (StringUtil.isNotEmpty((String)orgId) ? " AND inst.PROC_DEF_ID_ ='" + orgId + "' " : " ") : (StringUtil.isNotEmpty((String)orgId) ? " AND inst.TYPE_ID_ ='" + orgId + "' " : " ");
        }
        return orgSql;
    }

    private String getApprovalSelectSql(String flowType, String orgType, String dimension, String table, String status) {
        String idCode = "2".equals(orgType) ? "AUDITOR_" : "ORG_ID_";
        String selectSql = "select count(1) as count,opinion." + idCode + " as id,'" + status + "' as status FROM " + table + " opinion LEFT JOIN bpm_pro_inst inst on opinion.PROC_INST_ID_=inst.ID_ where opinion." + idCode + " is not null ";
        if ("flow".equals(dimension)) {
            selectSql = "1".equals(flowType) ? "select count(1) as count,inst.PROC_DEF_ID_ as id,'" + status + "' as status FROM " + table + " opinion LEFT JOIN bpm_pro_inst inst on opinion.PROC_INST_ID_=inst.ID_ where 1=1 " : "select count(1) as count,inst.TYPE_ID_ as id,'" + status + "' as status FROM " + table + " opinion LEFT JOIN bpm_pro_inst inst on opinion.PROC_INST_ID_=inst.ID_ where 1=1 ";
        }
        return selectSql;
    }

    @Override
    public String getDesc() {
        return "\u529e\u4ef6\u541e\u5410\u91cf";
    }

    @Override
    public List<String> getLegend() {
        return Arrays.asList("\u5ba1\u6279\u6b21\u6570", "\u6c9f\u901a\u6b21\u6570", "\u5f81\u8be2\u6b21\u6570", "\u8f6c\u529e\u6b21\u6570", "\u4f20\u9605\u6b21\u6570");
    }

    @Override
    public ArrayNode getSeries(List<String> legend, List<Map<String, Object>> selectList, Map<String, String> map) throws Exception {
        ArrayNode array = JsonUtil.getMapper().createArrayNode();
        String defType = "bar";
        for (String le : legend) {
            ObjectNode node = JsonUtil.getMapper().createObjectNode();
            node.put("name", le);
            node.put("type", defType);
            List<Object> data = this.getSeriesData(le, selectList, map);
            node.set("data", JsonUtil.toJsonNode(data));
            array.add((JsonNode)node);
        }
        return array;
    }

    private List<Object> getSeriesData(String le, List<Map<String, Object>> selectList, Map<String, String> map) throws Exception {
        ArrayList<Object> data = new ArrayList<Object>();
        String status = this.getLegendCode(le);
        for (String key : map.keySet()) {
            double isValue = 0.0;
            for (Map<String, Object> obj : selectList) {
                if (!BeanUtils.isNotEmpty(obj)) continue;
                ObjectNode oNode = (ObjectNode)JsonUtil.toJsonNode(obj);
                if (BeanUtils.isNotEmpty((Object)oNode.get("id")) && key.equals(oNode.get("id").asText()) && status.equals(oNode.get("status").asText())) {
                    JsonNode countNode = Optional.ofNullable(oNode.get("count")).orElse(oNode.get("COUNT"));
                    double count = BeanUtils.isNotEmpty((Object)countNode) ? countNode.asDouble() : 0.0;
                    isValue += count;
                    continue;
                }
                if (!BeanUtils.isNotEmpty((Object)oNode.get("ID")) || !key.equals(oNode.get("ID").asText()) || !status.equals(oNode.get("STATUS").asText())) continue;
                double count = BeanUtils.isNotEmpty((Object)oNode.get("COUNT")) ? oNode.get("COUNT").asDouble() : 0.0;
                isValue += count;
            }
            data.add(isValue);
        }
        return data;
    }

    private String getLegendCode(String desc) {
        String status = "";
        switch (desc) {
            case "\u5ba1\u6279\u6b21\u6570": {
                status = "agree";
                break;
            }
            case "\u6c9f\u901a\u6b21\u6570": {
                status = "start_commu";
                break;
            }
            case "\u5f81\u8be2\u6b21\u6570": {
                status = "inqu";
                break;
            }
            case "\u8f6c\u529e\u6b21\u6570": {
                status = "deliverto";
                break;
            }
            case "\u4f20\u9605\u6b21\u6570": {
                status = "copyto";
            }
        }
        return status;
    }
}

