/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.def.impl;

import com.hotent.base.util.Dom4jUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.DesignerType;
import com.hotent.bpm.api.service.BpmDefConditionService;
import com.hotent.bpm.natapi.def.DefTransform;
import com.hotent.bpm.natapi.def.NatProDefinitionService;
import com.hotent.bpm.persistence.dao.BpmDefDataDao;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.model.BpmDefData;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.XPath;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMCDATA;
import org.dom4j.dom.DOMElement;
import org.springframework.stereotype.Service;

@Service
public class DefaultBpmDefConditionService
implements BpmDefConditionService {
    private String bpmnXmlns = "http://www.omg.org/spec/BPMN/20100524/MODEL";
    @Resource
    private BpmDefinitionManager bpmDefinitionManager;
    @Resource
    private BpmDefDataDao bpmDefDataDao;
    @Resource
    NatProDefinitionService natProDefinitionService;

    @Override
    public void saveCondition(String defId, String nodeId, Map<String, String> map) throws Exception {
        DefaultBpmDefinition bpmDef = this.bpmDefinitionManager.getById(defId);
        String designXml = bpmDef.getDefXml();
        String bpmnXml = bpmDef.getBpmnXml();
        String designer = bpmDef.getDesigner();
        DefTransform transform = this.natProDefinitionService.getDefTransform(DesignerType.valueOf(designer));
        designXml = transform.converConditionXml(nodeId, map, designXml);
        if (DesignerType.WEB.getKey().equals(designer)) {
            designXml = transform.converConditionXml(nodeId, map, bpmDef.getDefJson());
        }
        bpmnXml = DefaultBpmDefConditionService.converConditionXml(nodeId, map, bpmnXml);
        BpmDefData defData = new BpmDefData();
        defData.setId(defId);
        defData.setBpmnXml(bpmnXml);
        defData.setDefXml(designXml);
        defData.setDefJson(bpmDef.getDefJson());
        this.bpmDefinitionManager.updBpmData(defId, defData);
    }

    public static String converConditionXml(String nodeId, Map<String, String> map, String bpmnXml) {
        Document newDoc = Dom4jUtil.loadXml((String)bpmnXml);
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("bpmn2", "http://www.omg.org/spec/BPMN/20100524/MODEL");
        XPath xpath = newDoc.createXPath("//bpmn2:*[@sourceRef='" + nodeId + "']");
        xpath.setNamespaceURIs(nsMap);
        List list = xpath.selectNodes((Object)newDoc);
        for (Node node : list) {
            Element el = (Element)node;
            String targetRef = el.attributeValue("targetRef");
            String condition = map.get(targetRef);
            condition = condition.replace("<![CDATA[", "").replace("]]>", "");
            if (StringUtil.isEmpty((String)targetRef)) continue;
            DefaultBpmDefConditionService.removeChild(el);
            Namespace namespace = new Namespace("", "http://www.omg.org/spec/BPMN/20100524/MODEL");
            DOMElement conditionEl = new DOMElement("conditionExpression", namespace);
            Namespace namespaceXsi = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            QName qName = new QName("type", namespaceXsi);
            DOMAttribute attr = new DOMAttribute(qName, "tFormalExpression");
            conditionEl.add((Attribute)attr);
            DOMCDATA cdata = new DOMCDATA(condition);
            conditionEl.add((CDATA)cdata);
            el.add((Element)conditionEl);
        }
        return newDoc.asXML();
    }

    private static void removeChild(Element el) {
        List childs = el.elements();
        Iterator it = childs.iterator();
        while (it.hasNext()) {
            el.remove((Node)it.next());
        }
    }

    @Override
    public Map<String, String> getDecisionConditions(String defId, String nodeId) {
        DefaultBpmDefinition bpmDef = this.bpmDefinitionManager.getById(defId);
        String defXml = bpmDef.getBpmnXml();
        HashMap<String, String> map = new HashMap<String, String>();
        Document doc = Dom4jUtil.loadXml((String)defXml);
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("bpmn2", this.bpmnXmlns);
        XPath xpath = doc.createXPath("//bpmn2:sequenceFlow[@sourceRef='" + nodeId + "']");
        xpath.setNamespaceURIs(nsMap);
        List nodes = xpath.selectNodes((Object)doc);
        for (Node node : nodes) {
            Element el = (Element)node;
            String id = el.attributeValue("targetRef");
            String condition = "";
            Element conditionNode = el.element("conditionExpression");
            if (conditionNode != null) {
                condition = conditionNode.getText().trim();
            }
            map.put(id, condition);
        }
        return map;
    }
}

