/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.def.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.exception.ProcessDefException;
import com.hotent.bpm.api.model.process.def.BpmDefinition;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.def.BpmVariableDef;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.CallActivityNodeDef;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.natapi.def.NatProDefinitionService;
import com.hotent.bpm.persistence.dao.BpmProcessInstanceDao;
import com.hotent.bpm.persistence.manager.BpmBusLinkManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmInstFormManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.manager.BpmTaskNoticeDoneManager;
import com.hotent.bpm.persistence.manager.BpmTaskNoticeManager;
import com.hotent.bpm.persistence.manager.BpmTaskTurnManager;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.query.BpmDefFieldSorts;
import com.hotent.bpm.persistence.model.query.BpmDefQueryFields;
import com.hotent.bpm.todo.util.TodoPushUtil;
import com.hotent.bpm.util.BpmUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class DefaultBpmDefinitionService
implements BpmDefinitionService {
    @Resource(name="proDefinitionServiceImpl")
    NatProDefinitionService natProDefinitionService;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmBusLinkManager bpmBusLinkManager;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource
    BpmInstFormManager bpmInstFromManager;
    @Resource
    BpmTaskNoticeManager bpmTaskNoticeManager;
    @Resource
    BpmTaskNoticeDoneManager bpmTaskNoticeDoneManager;
    @Resource
    BpmTaskTurnManager bpmTaskTurnManager;
    @Resource
    BpmProcessInstanceDao bpmProcessInstanceDao;
    @Resource
    BpmTaskManager bpmTaskManager;

    @Override
    public boolean deploy(BpmDefinition bpmDefinition) throws Exception {
        return this.bpmDefinitionManager.deploy(bpmDefinition, null);
    }

    @Override
    public boolean saveDraft(BpmDefinition bpmDefinition) throws Exception {
        return this.bpmDefinitionManager.saveDraft(bpmDefinition);
    }

    @Override
    public BpmNodeDef getBpmNodeDef(String bpmnDefId, String nodeId) throws Exception {
        String defId = this.bpmDefinitionManager.getDefIdByBpmnDefId(bpmnDefId);
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        return bpmNodeDef;
    }

    @Override
    public BpmNodeDef getBpmNodeDefByDefIdNodeId(String procDefId, String nodeId) throws Exception {
        return this.bpmDefinitionAccessor.getBpmNodeDef(procDefId, nodeId);
    }

    @Override
    public BpmNodeDef getStartBpmNodeDef(String defId) throws Exception {
        List<BpmNodeDef> bpmNodeDefs = this.getAllBpmNodeDefs(defId);
        return bpmNodeDefs.size() > 0 ? bpmNodeDefs.get(0) : null;
    }

    @Override
    public List<BpmNodeDef> getAllBpmNodeDefs(String defId) throws Exception {
        return this.bpmDefinitionAccessor.getNodeDefs(defId);
    }

    @Override
    public List<BpmNodeDef> getEndNode(String defId) throws Exception {
        ArrayList<BpmNodeDef> endNodeDefs = new ArrayList<BpmNodeDef>();
        List<BpmNodeDef> bpmNodeDefs = this.getAllBpmNodeDefs(defId);
        for (BpmNodeDef bpmNodeDef : bpmNodeDefs) {
            if (bpmNodeDef.getOutcomeNodes().size() != 0) continue;
            endNodeDefs.add(bpmNodeDef);
        }
        return endNodeDefs;
    }

    @Override
    public boolean removeBpmDefinition(String defId) throws Exception {
        this.bpmDefinitionManager.removeCascade(defId);
        return true;
    }

    @Override
    public boolean disabledBpmDefinition(String defId) {
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        defaultBpmDefinition.setStatus("forbidden");
        this.bpmDefinitionManager.update((Model)defaultBpmDefinition);
        return true;
    }

    @Override
    public boolean enabledBpmDefinition(String defId) {
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        defaultBpmDefinition.setStatus("deploy");
        this.bpmDefinitionManager.update((Model)defaultBpmDefinition);
        this.bpmProcessInstanceManager.updForbiddenByDefKey(defaultBpmDefinition.getDefKey(), BpmProcessInstance.FORBIDDEN_NO);
        return true;
    }

    @Override
    public boolean updateBpmDefinition(BpmDefinition bpmDefinition) throws Exception {
        return this.bpmDefinitionManager.updateBpmDefinition(bpmDefinition);
    }

    @Override
    public List<BpmDefinition> getAllVersions(String defId) {
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        List<BpmDefinition> defaultBpmDefinitions = this.bpmDefinitionManager.queryByDefKey(defaultBpmDefinition.getDefKey());
        return defaultBpmDefinitions;
    }

    @Override
    public List<BpmDefinition> getAllHistoryVersions(String defId) {
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        List<DefaultBpmDefinition> defaultBpmDefinitions = this.bpmDefinitionManager.queryHistorys(defaultBpmDefinition.getDefKey());
        return this.convertBpmDefinitions(defaultBpmDefinitions);
    }

    @Override
    public List<BpmDefinition> getAll(QueryFilter queryFilter) {
        List defaultBpmDefinitions = this.bpmDefinitionManager.query(queryFilter).getRows();
        return this.convertBpmDefinitions(defaultBpmDefinitions);
    }

    @Override
    public boolean hasExternalSubprocess(String defId) throws Exception {
        List<BpmNodeDef> list = this.bpmDefinitionAccessor.getNodeDefs(defId);
        for (BpmNodeDef nodeDef : list) {
            if (!NodeType.CALLACTIVITY.equals((Object)nodeDef.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getExternalSubprocess(List<String> defIds) throws Exception {
        HashSet<String> result = new HashSet<String>();
        for (String defId : defIds) {
            this.recurrenceSubprocess(result, defId);
        }
        return new ArrayList<String>(result);
    }

    private void recurrenceSubprocess(Set<String> result, String defId) throws Exception {
        if (!result.contains(defId)) {
            result.add(defId);
            List<BpmNodeDef> list = this.bpmDefinitionAccessor.getNodeDefs(defId);
            for (BpmNodeDef nodeDef : list) {
                String subFlowKey;
                DefaultBpmDefinition mainByDefKey;
                if (!NodeType.CALLACTIVITY.equals((Object)nodeDef.getType()) || BeanUtils.isEmpty((Object)(mainByDefKey = this.bpmDefinitionManager.getMainByDefKey(subFlowKey = ((CallActivityNodeDef)nodeDef).getFlowKey(), false))) || result.contains(mainByDefKey.getDefId())) continue;
                this.recurrenceSubprocess(result, mainByDefKey.getDefId());
            }
        }
    }

    @Override
    public String getDesignFile(String defId) {
        if (StringUtils.isEmpty((String)defId)) {
            return "";
        }
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        if (defaultBpmDefinition != null) {
            return defaultBpmDefinition.getDefXml();
        }
        return "";
    }

    @Override
    public String getBpmnFile(String defId) {
        if (StringUtils.isEmpty((String)defId)) {
            return "";
        }
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        if (defaultBpmDefinition != null) {
            return defaultBpmDefinition.getDefXml();
        }
        return "";
    }

    @Override
    public List<BpmDefinition> queryList(QueryFilter query) throws IOException {
        List defaultBpmDefinitions = this.bpmDefinitionManager.queryList((QueryFilter<DefaultBpmDefinition>)query).getRows();
        return defaultBpmDefinitions;
    }

    @Override
    public boolean isDefCodeExist(String defCode) {
        List<DefaultBpmDefinition> defaultBpmDefinitions = this.bpmDefinitionManager.queryByDefKey(defCode);
        return defaultBpmDefinitions.size() > 0;
    }

    @Override
    public boolean updateTreeType(String defId, String typeId) {
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        if (defaultBpmDefinition != null) {
            defaultBpmDefinition.setTypeId(typeId);
            this.bpmDefinitionManager.update((Model)defaultBpmDefinition);
            return true;
        }
        return false;
    }

    @Override
    public List<BpmDefinition> getProcessDefinitionByUserId(String userId) {
        BpmDefQueryFields bpmDefQueryFields = new BpmDefQueryFields();
        bpmDefQueryFields.addCreateBy(userId);
        BpmDefFieldSorts bpmDefFieldSorts = new BpmDefFieldSorts();
        bpmDefFieldSorts.addDefId();
        List<DefaultBpmDefinition> defaultBpmDefinitions = this.bpmDefinitionManager.query(bpmDefQueryFields, FieldRelation.AND, bpmDefFieldSorts);
        return this.convertBpmDefinitions(defaultBpmDefinitions);
    }

    @Override
    public List<BpmDefinition> getProcessDefinitionByUserId(String userId, QueryFilter queryFilter) {
        if (StringUtils.isEmpty((String)userId) || queryFilter == null) {
            return new ArrayList<BpmDefinition>();
        }
        queryFilter.addFilter("CREATE_BY_", (Object)userId, QueryOP.EQUAL, FieldRelation.AND);
        PageList pageList = this.bpmDefinitionManager.query(queryFilter);
        return this.convertBpmDefinitions(pageList.getRows());
    }

    @Override
    public BpmDefinition getBpmDefinitionByDefId(String defId) {
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        return defaultBpmDefinition;
    }

    @Override
    public BpmDefinition getBpmDefinitionByDefKey(String defKey, boolean needData) {
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getMainByDefKey(defKey, needData);
        return defaultBpmDefinition;
    }

    private List<BpmDefinition> convertBpmDefinitions(List<DefaultBpmDefinition> defaultBpmDefinitions) {
        ArrayList<BpmDefinition> bpmDefinitions = new ArrayList<BpmDefinition>();
        for (DefaultBpmDefinition _defaultBpmDefinition : defaultBpmDefinitions) {
            bpmDefinitions.add(_defaultBpmDefinition);
        }
        return bpmDefinitions;
    }

    @Override
    public String getDefIdByBpmnDefId(String bpmnDefId) {
        return this.bpmDefinitionManager.getDefIdByBpmnDefId(bpmnDefId);
    }

    @Override
    public BpmProcessDef<BpmProcessDefExt> getBpmProcessDef(String bpmnDefId) throws Exception {
        String defId = this.bpmDefinitionManager.getDefIdByBpmnDefId(bpmnDefId);
        BpmProcessDef<BpmProcessDefExt> processDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        return processDef;
    }

    @Override
    public String getBpmnXmlByBpmnDefId(String bpmnDefId) {
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getByBpmnDefId(bpmnDefId);
        return this.natProDefinitionService.getDefXmlByDeployId(bpmDefinition.getBpmnDeployId());
    }

    @Override
    public String getBpmnXmlByDeployId(String deployId) {
        DefaultBpmDefinition bpmDefinition = this.bpmDefinitionManager.getByBpmnDeployId(deployId);
        return this.natProDefinitionService.getDefXmlByDeployId(bpmDefinition.getBpmnDeployId());
    }

    @Override
    public List<BpmVariableDef> getVariableDefs(String defId) throws Exception {
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        return ((DefaultBpmProcessDefExt)bpmProcessDef.getProcessDefExt()).getVariableList();
    }

    @Override
    public List<BpmVariableDef> getVariableDefs(String defId, String nodeId) throws Exception {
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        return ((DefaultBpmProcessDefExt)bpmProcessDef.getProcessDefExt()).getVariableList(nodeId);
    }

    @Override
    public void switchMainVersion(String defId) {
        this.bpmDefinitionManager.updMainVersion(defId, false);
    }

    @Override
    public boolean disabledBpmDefinitionInst(String defId) {
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        defaultBpmDefinition.setStatus("forbidden_instance");
        this.bpmDefinitionManager.update((Model)defaultBpmDefinition);
        String defKey = defaultBpmDefinition.getDefKey();
        this.bpmProcessInstanceManager.updForbiddenByDefKey(defKey, BpmProcessInstance.FORBIDDEN_YES);
        return false;
    }

    @Override
    public void cleanData(String defId) throws Exception {
        DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
        if (!"test".equals(defaultBpmDefinition.getTestStatus())) {
            throw new ProcessDefException("\u975e\u6d4b\u8bd5\u72b6\u6001\u7684\u6d41\u7a0b\u4e0d\u80fd\u6e05\u9664\u6570\u636e");
        }
        List<DefaultBpmProcessInstance> instances = this.bpmProcessInstanceDao.getTestListByBpmnDefKey(defaultBpmDefinition.getDefKey());
        if (BeanUtils.isNotEmpty(instances)) {
            for (DefaultBpmProcessInstance entity : instances) {
                List<DefaultBpmProcessInstance> instancesSub = this.bpmProcessInstanceDao.getByParentId(entity.getId());
                if (!BeanUtils.isNotEmpty(instancesSub)) continue;
                ArrayList<String> listStr = new ArrayList<String>();
                for (DefaultBpmProcessInstance instance : instancesSub) {
                    String instId = instance.getId();
                    TodoPushUtil.handTodoInstanceRemove(instId, instance.getSysCode());
                    this.bpmProcessInstanceManager.remove((Serializable)((Object)instId));
                    this.bpmInstFromManager.removeDataByInstId(instId);
                    this.bpmTaskNoticeManager.delBpmTaskNoticeByInstId(instId);
                    this.bpmTaskNoticeDoneManager.delBpmTaskNoticeDoneByInstId(instId);
                    listStr.add(instId);
                }
                if (!BeanUtils.isNotEmpty(listStr)) continue;
                this.bpmTaskTurnManager.delByInstList(listStr);
                this.bpmTaskManager.delByInstList(listStr);
            }
        }
        List<DefaultBpmDefinition> listDefaultBpmDefinition = this.bpmDefinitionManager.queryByDefKey(defaultBpmDefinition.getDefKey());
        for (DefaultBpmDefinition entity : listDefaultBpmDefinition) {
            List<DefaultBpmProcessInstance> list = this.bpmProcessInstanceDao.getTestListByBpmnDefKey(entity.getDefKey());
            ArrayList<String> listStr = new ArrayList<String>();
            if (BeanUtils.isNotEmpty(list)) {
                for (DefaultBpmProcessInstance defaultBpmProcessInstance : list) {
                    String instId = defaultBpmProcessInstance.getId();
                    listStr.add(instId);
                    this.bpmTaskNoticeDoneManager.delBpmTaskNoticeDoneByInstId(instId);
                    this.bpmTaskNoticeManager.delBpmTaskNoticeByInstId(instId);
                    this.bpmInstFromManager.removeDataByInstId(instId);
                    this.bpmBusLinkManager.removeDataByInstId(instId);
                }
            }
            if (BeanUtils.isNotEmpty(listStr)) {
                this.bpmTaskTurnManager.delByInstList(listStr);
                this.bpmTaskManager.delByInstList(listStr);
            }
            this.bpmProcessInstanceManager.removeTestInstByDefKey(entity.getDefKey(), true);
        }
    }

    @Override
    public BpmDefinition getByBpmnDefId(String bpmnDefId) {
        return this.bpmDefinitionManager.getByBpmnDefId(bpmnDefId);
    }

    @Override
    public CommonResult<String> goRunOrTest(String defIds, Boolean isRun) throws Exception {
        if (BeanUtils.isNotEmpty((Object)defIds)) {
            List<String> ids = Arrays.asList(defIds.split(","));
            UpdateWrapper updateWrap = new UpdateWrapper();
            ((UpdateWrapper)updateWrap.in((Object)"def_id_", ids)).set((Object)"test_status_", (Object)(isRun != false ? "run" : "test"));
            boolean update = this.bpmDefinitionManager.update(null, (Wrapper)updateWrap);
            if (update) {
                BpmUtil.clearCacheByDefIds(ids);
            }
            return update ? CommonResult.success((Object)"\u6210\u529f") : CommonResult.error((String)"\u5931\u8d25");
        }
        return CommonResult.success((Object)"\u6210\u529f");
    }
}

