/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.def.impl.handler;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.Dom4jUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.model.process.def.BpmDefSetting;
import com.hotent.bpm.api.model.process.def.BpmSubTableRight;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.FormExt;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.engine.def.AbstractBpmDefXmlHandler;
import com.hotent.bpm.engine.def.BpmDefUtil;
import com.hotent.bpm.engine.def.DefXmlHandlerUtil;
import com.hotent.bpm.model.form.Form;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.stereotype.Service;

@Service
public class BpmDefSettingBpmDefXmlHandler
extends AbstractBpmDefXmlHandler<BpmDefSetting> {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;

    @Override
    protected String getXml(String defId, String nodeId, BpmDefSetting bpmDefSetting) throws Exception {
        DefaultBpmDefinition bpmDef = this.bpmDefinitionManager.getById(defId);
        List<BpmNodeDef> list = this.getNodeList(defId);
        String defXml = bpmDef.getBpmnXml();
        Document doc = Dom4jUtil.loadXml((String)defXml);
        Element root = doc.getRootElement();
        this.handGlobalForm(bpmDefSetting, root);
        this.handInstForm(bpmDefSetting, root);
        this.handNodeProperties(bpmDefSetting, root, list);
        this.handNodeForm(bpmDefSetting, root, list);
        this.handTableSubRights(bpmDefSetting, root, list);
        return root.asXML();
    }

    void handNodeForm(BpmDefSetting bpmDefSetting, Element root, List<BpmNodeDef> list) {
        String parentDefKey = bpmDefSetting.getParentDefKey();
        Map<String, Form> map = bpmDefSetting.getFormMap(true);
        Map<String, Form> mobileMap = bpmDefSetting.getFormMap(false);
        for (BpmNodeDef nodeDef : list) {
            String nodeId = nodeDef.getNodeId();
            this.handNodeForm(map, root, parentDefKey, nodeId, true);
            this.handNodeForm(mobileMap, root, parentDefKey, nodeId, false);
        }
    }

    void handNodeForm(Map<String, Form> map, Element root, String parentDefKey, String nodeId, boolean isPc) {
        String formPre = isPc ? "form" : "mobileForm";
        boolean isContain = map.containsKey(nodeId);
        String xml = "";
        if (!isContain) {
            return;
        }
        xml = BpmDefUtil.getFormXml(map.get(nodeId));
        if ("local_".equals(parentDefKey)) {
            String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:" + formPre;
            String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']";
            DefXmlHandlerUtil.handXmlDom(root, xml, xParentPath, xPath);
        } else {
            String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:subProcessForm";
            String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']";
            Element elSubForm = (Element)root.selectSingleNode(xPath);
            Element elParent = (Element)root.selectSingleNode(xParentPath);
            if (elSubForm == null) {
                String propxml = "<ext:subProcessForm xmlns:ext=\"http://www.jee-soft.cn/bpm\" />";
                Document doc = Dom4jUtil.loadXml((String)propxml);
                elParent.add(doc.getRootElement());
            }
            String xPathItem = "//ext:*[@bpmnElement='" + nodeId + "']/ext:subProcessForm/ext:" + formPre + "[@parentFlowKey='" + parentDefKey + "']";
            DefXmlHandlerUtil.handXmlDom(root, xml, xPath, xPathItem);
        }
    }

    void handGlobalForm(BpmDefSetting bpmDefSetting, Element root) {
        String xParentPath = "//ext:extProcess";
        String xPath = "//ext:extProcess/ext:globalForm";
        Element el = (Element)root.selectSingleNode(xPath);
        Element elParent = (Element)root.selectSingleNode(xParentPath);
        if (el == null) {
            String propxml = "<ext:globalForm xmlns:ext=\"http://www.jee-soft.cn/bpm\" />";
            Document doc = Dom4jUtil.loadXml((String)propxml);
            elParent.add(doc.getRootElement());
        }
        String parentDefKey = bpmDefSetting.getParentDefKey();
        String xFormPath = "//ext:globalForm/ext:form[@parentFlowKey='" + parentDefKey + "']";
        FormExt frm = bpmDefSetting.getGlobalForm();
        String xml = BpmDefUtil.getFormXml(frm);
        DefXmlHandlerUtil.handXmlDom(root, xml, xPath, xFormPath);
        String xMobileFormPath = "//ext:globalForm/ext:mobileForm[@parentFlowKey='" + parentDefKey + "']";
        FormExt mobileFrm = bpmDefSetting.getGlobalMobileForm();
        String mobileXml = BpmDefUtil.getFormXml(mobileFrm);
        DefXmlHandlerUtil.handXmlDom(root, mobileXml, xPath, xMobileFormPath);
    }

    void handInstForm(BpmDefSetting bpmDefSetting, Element root) {
        String instmobilePath;
        Element mobileel;
        String xParentPath = "//ext:extProcess";
        String xPath = "//ext:extProcess/ext:instForm";
        Element el = (Element)root.selectSingleNode(xPath);
        Element elParent = (Element)root.selectSingleNode(xParentPath);
        if (el == null) {
            String propxml = "<ext:instForm xmlns:ext=\"http://www.jee-soft.cn/bpm\" />";
            Document doc = Dom4jUtil.loadXml((String)propxml);
            elParent.add(doc.getRootElement());
        }
        String parentDefKey = bpmDefSetting.getParentDefKey();
        String xFormPath = "//ext:instForm/ext:form[@parentFlowKey='" + parentDefKey + "']";
        FormExt frm = bpmDefSetting.getInstForm();
        String xml = BpmDefUtil.getFormXml(frm);
        if (el != null) {
            String formPath = "//ext:instForm/ext:form";
            String mobileFormPath = "//ext:instForm/ext:mobileForm";
            Element formEl = (Element)el.selectSingleNode(formPath);
            Element mobileFormEl = (Element)el.selectSingleNode(mobileFormPath);
            if (StringUtil.isEmpty((String)xml) && formEl == null && BeanUtils.isEmpty((Object)mobileFormEl)) {
                elParent.remove(el);
            }
        }
        if ((mobileel = (Element)root.selectSingleNode(instmobilePath = "//ext:extProcess/ext:instMobileForm")) != null) {
            elParent.remove(mobileel);
        }
        DefXmlHandlerUtil.handXmlDom(root, xml, xPath, xFormPath);
        String xMobileFormPath = "//ext:instForm/ext:mobileForm[@parentFlowKey='" + parentDefKey + "']";
        FormExt mobileFrm = bpmDefSetting.getInstMobileForm();
        String mobileXml = BpmDefUtil.getFormXml(mobileFrm);
        DefXmlHandlerUtil.handXmlDom(root, mobileXml, xPath, xMobileFormPath);
    }

    void handTableSubRights(BpmDefSetting bpmDefSetting, Element root, List<BpmNodeDef> list) {
        Map<String, List<BpmSubTableRight>> map = bpmDefSetting.getBpmSubTableRightMap();
        String parentDefKey = bpmDefSetting.getParentDefKey();
        for (BpmNodeDef nodeDef : list) {
            List<BpmSubTableRight> subTableRights;
            String nodeId = nodeDef.getNodeId();
            boolean isContain = map.containsKey(nodeId);
            if (!isContain || (subTableRights = map.get(nodeId)) == null) continue;
            String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:subTableRights";
            String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']";
            Node el = root.selectSingleNode(xPath);
            Element elParent = (Element)root.selectSingleNode(xParentPath);
            if (el == null) {
                String propxml = "<ext:subTableRights xmlns:ext=\"http://www.jee-soft.cn/bpm\" />";
                Document doc = Dom4jUtil.loadXml((String)propxml);
                elParent.add(doc.getRootElement());
            }
            String xml = "";
            String xPathItem = "//ext:*[@bpmnElement='" + nodeId + "']/ext:subTableRights/ext:rightsItem[@parentDefKey='" + parentDefKey + "']";
            DefXmlHandlerUtil.handXmlDom(root, xml, xPath, xPathItem);
            for (BpmSubTableRight tableRight : subTableRights) {
                String tableName = tableRight.getTableName();
                xPathItem = "//ext:*[@bpmnElement='" + nodeId + "']/ext:subTableRights/ext:rightsItem[@parentDefKey='" + parentDefKey + "' and @tableName='" + tableName + "']";
                xml = BpmDefSettingBpmDefXmlHandler.getTableRight(tableRight);
                DefXmlHandlerUtil.handXmlDom(root, xml, xPath, xPathItem);
            }
        }
    }

    void handNodeProperties(BpmDefSetting bpmDefSetting, Element root, List<BpmNodeDef> list) {
        Map<String, NodeProperties> map = bpmDefSetting.getNodePropertieMap();
        for (BpmNodeDef nodeDef : list) {
            String nodeId = nodeDef.getNodeId();
            boolean isContain = map.containsKey(nodeId);
            if (!isContain) continue;
            String xml = this.getPropXml(map.get(nodeId));
            String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:propers";
            String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']";
            Node el = root.selectSingleNode(xPath);
            Element elParent = (Element)root.selectSingleNode(xParentPath);
            if (el == null) {
                String propxml = "<ext:propers xmlns:ext=\"http://www.jee-soft.cn/bpm\" />";
                Document doc = Dom4jUtil.loadXml((String)propxml);
                elParent.add(doc.getRootElement());
            }
            String xPathItem = "//ext:*[@bpmnElement='" + nodeId + "']/ext:propers/ext:item[@parentDefKey='" + bpmDefSetting.getParentDefKey() + "']";
            DefXmlHandlerUtil.handXmlDom(root, xml, xPath, xPathItem);
        }
    }

    private String getPropXml(NodeProperties properties) {
        String xml = "<ext:item xmlns:ext=\"%s\"  allowExecutorEmpty=\"%s\" backMode=\"%s\"   backNode=\"%s\"  backUserMode=\"%s\"  jumpType=\"%s\" notifyType=\"%s\" parentDefKey=\"%s\" postHandler=\"%s\" prevHandler=\"%s\" skipExecutorEmpty=\"%s\" dateType=\"%s\" dueTime=\"%s\" popWin=\"%s\" choiceExcutor=\"%s\" allowEditUrgentState=\"%s\" help=\"%s\" helpGlobal=\"%s\"  allowSmsApproval=\"%s\" userNodeType=\"%s\" approvalArea=\"%s\" referOpinion=\"%s\" sponsorRevoke=\"%s\" previousRevoke=\"%s\"  initFillData=\"%s\" opinionField=\"%s\" appendOpinion=\"%s\" executorIsEmpty=\"%s\" executorUserAccount=\"%s\" executorUserName=\"%s\"  batchHandleRevoke=\"%s\" signatureField=\"%s\" signatureCover=\"%s\"  secretFree=\"%s\"  msgConfig=\"%s\" printTemplate=\"%s\" preSkipAfterApprovePreview=\"%s\"  />";
        xml = String.format(xml, "http://www.jee-soft.cn/bpm", properties.isAllowExecutorEmpty(), properties.getBackMode(), properties.getBackNode(), properties.getBackUserMode(), properties.getJumpType(), properties.getNotifyType(), properties.getParentDefKey(), properties.getPostHandler(), properties.getPrevHandler(), properties.isSkipExecutorEmpty(), properties.getDateType(), properties.getDueTime(), properties.isPopWin(), properties.getChoiceExcutor(), properties.isAllowEditUrgentState(), properties.getHelp(), properties.getHelpGlobal(), properties.isAllowSmsApproval(), properties.getUserNodeType(), properties.getApprovalArea(), properties.isReferOpinion(), properties.isSponsorRevoke(), properties.isPreviousRevoke(), properties.isInitFillData(), properties.getOpinionField(), properties.isAppendOpinion(), properties.getExecutorIsEmpty(), properties.getExecutorUserAccount(), properties.getExecutorUserName(), properties.isBatchHandleRevoke(), properties.getSignatureField(), properties.isSignatureCover(), properties.isSecretFree(), properties.getMsgConfig(), properties.getPrintTemplate(), properties.isPreSkipAfterApprovePreview());
        return xml;
    }

    public static String getTableRight(BpmSubTableRight tableRight) {
        String xml = " <ext:rightsItem xmlns:ext=\"%s\"  tableName=\"%s\" rightType=\"%s\" parentDefKey=\"%s\"><ext:script><![CDATA[%s]]></ext:script></ext:rightsItem>";
        xml = String.format(xml, "http://www.jee-soft.cn/bpm", tableRight.getTableName(), tableRight.getRightType(), tableRight.getParentDefKey(), tableRight.getScript());
        return xml;
    }

    public String copyNodeForm(String sourceNodeId, String targetNodeId, String bpmnXml, boolean isPc, String parentDefKey) {
        String formPre = isPc ? "form" : "mobileForm";
        Document doc = Dom4jUtil.loadXml((String)bpmnXml);
        Element root = doc.getRootElement();
        if ("local_".equals(parentDefKey)) {
            String xParentPath = "//ext:*[@bpmnElement='" + targetNodeId + "']";
            String xPath = "//ext:*[@bpmnElement='%s']/ext:" + formPre;
            Element sourceEl = (Element)root.selectSingleNode(String.format(xPath, sourceNodeId));
            DefXmlHandlerUtil.handXmlDom(root, sourceEl != null ? sourceEl.asXML() : "", xParentPath, String.format(xPath, targetNodeId));
        }
        return root.asXML();
    }

    public String copyNodeProperties(String sourceNodeId, String targetNodeId, String bpmnXml) {
        Document doc = Dom4jUtil.loadXml((String)bpmnXml);
        Element root = doc.getRootElement();
        String xParentPath = "//ext:*[@bpmnElement='%s']";
        String subElName = "propers";
        Element parentEl = (Element)root.selectSingleNode(String.format(xParentPath, sourceNodeId));
        Element element = parentEl.element(subElName);
        DefXmlHandlerUtil.handleXmlDom(root, element != null ? element.asXML() : "", String.format(xParentPath, targetNodeId), subElName);
        return root.asXML();
    }
}

