/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.def.impl.handler;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.Dom4jUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.ActionType;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.Button;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.DefaultButton;
import com.hotent.bpm.engine.def.AbstractBpmDefXmlHandler;
import com.hotent.bpm.engine.def.ButtonDTO;
import com.hotent.bpm.engine.def.DefXmlHandlerUtil;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.jamesmurty.utils.XMLBuilder;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ButtonsBpmDefXmlHandler
extends AbstractBpmDefXmlHandler<ButtonDTO> {
    private static Logger logger = LoggerFactory.getLogger(ButtonsBpmDefXmlHandler.class);

    private String getXml(List<Button> buttons) {
        String xml = "";
        if (BeanUtils.isEmpty(buttons)) {
            return "";
        }
        try {
            XMLBuilder ruleBuilder = XMLBuilder.create((String)"ext:buttons");
            ruleBuilder.a("xmlns:ext", "http://www.jee-soft.cn/bpm");
            Boolean isFalg = false;
            for (Button btn : buttons) {
                if (!"lockUnlock".equals(btn.getAlias()) || !btn.getIsLock().booleanValue()) continue;
                isFalg = true;
                break;
            }
            for (Button btn : buttons) {
                String isLock = "false";
                if (isFalg.booleanValue()) {
                    isLock = "true";
                }
                XMLBuilder build = ruleBuilder.e("ext:button").a("name", btn.getName()).a("alias", btn.getAlias()).a("isLock", isLock);
                if (BeanUtils.isNotEmpty((Object)btn.getBeforeScript())) {
                    build.e("ext:beforeScript").d(btn.getBeforeScript());
                }
                if (BeanUtils.isNotEmpty((Object)btn.getAfterScript())) {
                    build.e("ext:afterScript").d(btn.getAfterScript());
                }
                if (BeanUtils.isNotEmpty((Object)btn.getGroovyScript())) {
                    build.e("ext:groovyScript").d(btn.getGroovyScript());
                }
                if (ActionType.REJECT.getKey().equals(btn.getAlias())) {
                    if (BeanUtils.isNotEmpty((Object)btn.getRejectMode())) {
                        build.e("ext:rejectMode").d(btn.getRejectMode());
                    }
                    if (BeanUtils.isNotEmpty((Object)btn.getRejectRecallMode())) {
                        build.e("ext:rejectRecallMode").d(btn.getRejectRecallMode());
                    }
                    if (BeanUtils.isNotEmpty((Object)btn.getDefaultRejectMode())) {
                        build.e("ext:defaultRejectMode").d(btn.getDefaultRejectMode());
                    }
                    if (BeanUtils.isNotEmpty((Object)btn.getDefaultRejectRecallMode())) {
                        build.e("ext:defaultRejectRecallMode").d(btn.getDefaultRejectRecallMode());
                    }
                }
                if (BeanUtils.isNotEmpty((Object)btn.getCompleteEventGroovyScript())) {
                    build.e("ext:completeEventGroovyScript").d(btn.getCompleteEventGroovyScript());
                }
                if (BeanUtils.isNotEmpty((Object)btn.getRejectNode())) {
                    build.a("rejectNode", btn.getRejectNode());
                }
                if (BeanUtils.isNotEmpty((Object)btn.getMsgConfig())) {
                    build.a("msgConfig", btn.getMsgConfig());
                }
                if (StringUtil.isNotEmpty((String)btn.getDefaultOpinion())) {
                    build.a("defaultOpinion", btn.getDefaultOpinion());
                }
                ruleBuilder.up();
            }
            xml = ruleBuilder.asString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xml;
    }

    private String getTopButtonsXml(List<DefaultButton> topButtons) {
        String xml = "";
        if (BeanUtils.isEmpty(topButtons)) {
            return xml;
        }
        try {
            XMLBuilder ruleBuilder = XMLBuilder.create((String)"ext:topButtons");
            ruleBuilder.a("xmlns:ext", "http://www.jee-soft.cn/bpm");
            for (DefaultButton btn : topButtons) {
                XMLBuilder build = ruleBuilder.e("ext:button").a("name", btn.getName()).a("alias", btn.getAlias());
                this.setXMLField(build, "ext:jsScript", btn.getJsScript(), "");
                this.setXMLField(build, "ext:icon", btn.getIcon(), "");
                this.setXMLField(build, "ext:labelColor", btn.getLabelColor(), "");
                this.setXMLField(build, "ext:textColor", btn.getTextColor(), "#409eff");
                this.setXMLField(build, "ext:order", btn.getOrder(), "");
                this.setXMLField(build, "ext:fixed", btn.getFixed(), "0");
                this.setXMLField(build, "ext:disabled", btn.getDisabled(), "0");
                ruleBuilder.up();
            }
            xml = ruleBuilder.asString();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u9876\u90e8\u6309\u94aexml\u5f02\u5e38", (Throwable)e);
        }
        return xml;
    }

    private void setXMLField(XMLBuilder build, String fieldName, Object value, String defaultValue) {
        if (BeanUtils.isNotEmpty((Object)value)) {
            build.e(fieldName).d(value.toString());
        } else {
            build.e(fieldName).d(defaultValue);
        }
    }

    public static void main(String[] args) {
    }

    @Override
    protected String getXml(String defId, String nodeId, ButtonDTO buttonDTO) {
        List<Button> buttons = buttonDTO.getButtons();
        String xml = this.getXml(buttons);
        String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:buttons";
        String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']";
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        String defXml = def.getBpmnXml();
        String rtnXml = DefXmlHandlerUtil.getXml(defXml, xml, xParentPath, xPath);
        rtnXml = this.getTopPathXml(rtnXml, nodeId, buttonDTO.getTopButtons());
        return rtnXml;
    }

    private String getTopPathXml(String rtnXml, String nodeId, List<DefaultButton> topButtons) {
        String xml = this.getTopButtonsXml(topButtons);
        String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:topButtons";
        String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']";
        return DefXmlHandlerUtil.getXml(rtnXml, xml, xParentPath, xPath);
    }

    public void saveNodeXml(String defId, Map<String, String> btnsMap, String parentFlowKey) throws Exception {
        if (BeanUtils.isEmpty(btnsMap)) {
            return;
        }
        Set<Map.Entry<String, String>> entrySet = btnsMap.entrySet();
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        String rtnXml = def.getBpmnXml();
        for (Map.Entry<String, String> entry : entrySet) {
            String nodeId = entry.getKey();
            String nodeJson = entry.getValue();
            if (StringUtil.isEmpty((String)nodeJson)) continue;
            List buttons = (List)JsonUtil.toBean((String)nodeJson, List.class);
            String xml = this.getXml(buttons);
            String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:buttons";
            String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']";
            rtnXml = DefXmlHandlerUtil.getXml(rtnXml, xml, xParentPath, xPath);
        }
        this.updateXml(defId, rtnXml);
    }

    public String copyNodeButtons(String sourceNodeId, String targetNodeId, String bpmnXml) {
        Document doc = Dom4jUtil.loadXml((String)bpmnXml);
        Element root = doc.getRootElement();
        String xParentPath = "//ext:*[@bpmnElement='%s']";
        String subElName = "buttons";
        String topElName = "topButtons";
        Element parentEl = (Element)root.selectSingleNode(String.format(xParentPath, sourceNodeId));
        Element element = parentEl.element(subElName);
        Element elementTop = parentEl.element(topElName);
        DefXmlHandlerUtil.handleXmlDom(root, element != null ? element.asXML() : "", String.format(xParentPath, targetNodeId), subElName);
        DefXmlHandlerUtil.handleXmlDom(root, elementTop != null ? elementTop.asXML() : "", String.format(xParentPath, targetNodeId), topElName);
        return root.asXML();
    }
}

