/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.def.impl.handler;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.Dom4jUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.plugin.core.context.BpmPluginContext;
import com.hotent.bpm.api.plugin.core.context.PluginParse;
import com.hotent.bpm.engine.def.AbstractBpmDefXmlHandler;
import com.hotent.bpm.engine.def.DefXmlHandlerUtil;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

@Service
public class PluginsBpmDefXmlHandler
extends AbstractBpmDefXmlHandler<List<BpmPluginContext>> {
    @Override
    protected String getXml(String defId, String nodeId, List<BpmPluginContext> list) {
        String xml = this.getByPluginList(list);
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        String defXml = def.getBpmnXml();
        String xParentPath = "//ext:extProcess";
        String xPath = "//ext:extProcess/ext:extPlugins";
        if (StringUtil.isNotEmpty((String)nodeId)) {
            xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']";
            xPath = xParentPath + "/ext:extPlugins";
        }
        String rtnXml = DefXmlHandlerUtil.getXml(defXml, xml, xParentPath, xPath);
        return rtnXml;
    }

    private String getByPluginList(List<BpmPluginContext> list) {
        if (BeanUtils.isEmpty(list)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<ext:extPlugins xmlns:ext=\"http://www.jee-soft.cn/bpm\">\n");
        for (BpmPluginContext ctx : list) {
            if (!(ctx instanceof PluginParse)) continue;
            PluginParse parse = (PluginParse)((Object)ctx);
            sb.append(parse.getPluginXml());
        }
        sb.append("</ext:extPlugins>");
        return sb.toString();
    }

    public void saveNodeXml(String defId, Map<String, List<BpmPluginContext>> nodeRestMap) throws Exception {
        String xml = this.getXml(defId, nodeRestMap);
        this.updateXml(defId, xml);
    }

    private String getXml(String defId, Map<String, List<BpmPluginContext>> nodeRestMap) {
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        String defXml = def.getBpmnXml();
        Element root = this.updateRoot(defXml);
        String rtnXml = "";
        Set<Map.Entry<String, List<BpmPluginContext>>> entrySet = nodeRestMap.entrySet();
        for (Map.Entry<String, List<BpmPluginContext>> entry : entrySet) {
            String nodeId = entry.getKey();
            List<BpmPluginContext> pluginContexts = entry.getValue();
            String xml = this.getByPluginList(pluginContexts);
            String xParentPath = "//ext:extProcess";
            String xPath = "//ext:extProcess/ext:extPlugins";
            if (StringUtil.isNotEmpty((String)nodeId)) {
                xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']";
                xPath = xParentPath + "/ext:extPlugins";
            }
            rtnXml = DefXmlHandlerUtil.getXml(root, xml, xParentPath, xPath);
            root = this.updateRoot(rtnXml);
        }
        return rtnXml;
    }

    private Element updateRoot(String rtnXml) {
        Document doc = Dom4jUtil.loadXml((String)rtnXml);
        Element root = doc.getRootElement();
        root.addNamespace("restFuls", "http://www.jee-soft.cn/bpm/plugins/execution/restFuls");
        return root;
    }

    public String copyNodeRestFul(String sourceNodeId, String targetNodeId, String bpmnXml) {
        Document doc = Dom4jUtil.loadXml((String)bpmnXml);
        Element root = doc.getRootElement();
        String xParentPath = "//ext:*[@bpmnElement='%s']/ext:extPlugins";
        String subElName = "restFuls";
        Element parentEl = (Element)root.selectSingleNode(String.format(xParentPath, sourceNodeId));
        Element element = parentEl.element(subElName);
        DefXmlHandlerUtil.handleXmlDom(root, element != null ? element.asXML() : "", String.format(xParentPath, targetNodeId), subElName);
        return root.asXML();
    }

    public String copyNodeReminder(String sourceNodeId, String targetNodeId, String bpmnXml) {
        Document doc = Dom4jUtil.loadXml((String)bpmnXml);
        Element root = doc.getRootElement();
        String subElName = "reminders";
        String xParentPath = "//ext:*[@bpmnElement='%s']/ext:extPlugins";
        Element parentEl = (Element)root.selectSingleNode(String.format(xParentPath, sourceNodeId));
        Element element = parentEl.element(subElName);
        DefXmlHandlerUtil.handleXmlDom(root, element != null ? element.asXML() : "", String.format(xParentPath, targetNodeId), subElName);
        return root.asXML();
    }

    public String copyNodeStartNewFlow(String sourceNodeId, String targetNodeId, String bpmnXml) {
        Document doc = Dom4jUtil.loadXml((String)bpmnXml);
        Element root = doc.getRootElement();
        String subElName = "startNewFlow";
        String xParentPath = "//ext:*[@bpmnElement='%s']/ext:extPlugins";
        Element parentEl = (Element)root.selectSingleNode(String.format(xParentPath, sourceNodeId));
        Element element = parentEl.element(subElName);
        DefXmlHandlerUtil.handleXmlDom(root, element != null ? element.asXML() : "", String.format(xParentPath, targetNodeId), subElName);
        return root.asXML();
    }
}

