/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.def.impl.handler;

import com.hotent.base.util.Dom4jUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.engine.def.AbstractBpmDefXmlHandler;
import com.hotent.bpm.engine.def.DefXmlHandlerUtil;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

@Service
public class ScriptNodeBpmDefXmlHandler
extends AbstractBpmDefXmlHandler<String> {
    @Override
    protected String getXml(String defId, String nodeId, String script) {
        String xml = this.getXml(script);
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        String defXml = def.getBpmnXml();
        Document doc = Dom4jUtil.loadXml((String)defXml);
        Element root = doc.getRootElement();
        root.addNamespace("sc", "http://www.jee-soft.cn/bpm/plugins/execution/script");
        String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:extPlugins/sc:scriptNode";
        String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:extPlugins";
        DefXmlHandlerUtil.handXmlDom(root, xml, xParentPath, xPath);
        return root.asXML();
    }

    private String getXml(String script) {
        if (StringUtil.isEmpty((String)script)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<scriptNode xmlns=\"http://www.jee-soft.cn/bpm/plugins/execution/script\">");
        sb.append("<![CDATA[");
        sb.append(script);
        sb.append("]]>");
        sb.append("</scriptNode>");
        return sb.toString();
    }
}

