/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.def.impl.handler;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.model.process.def.BpmWordPrintDef;
import com.hotent.bpm.engine.def.AbstractBpmDefXmlHandler;
import com.hotent.bpm.engine.def.DefXmlHandlerUtil;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.jamesmurty.utils.XMLBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class WordPrintDefBpmDefXmlHandler
extends AbstractBpmDefXmlHandler<List<BpmWordPrintDef>> {
    @Override
    protected String getXml(String defId, String nodeId, List<BpmWordPrintDef> list) throws Exception {
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        String defXml = def.getBpmnXml();
        String xParentPath = "//ext:extProcess";
        String xPath = "//ext:extProcess/ext:wordPrints";
        Map<String, List<BpmWordPrintDef>> map = this.getByWordPrint(list);
        Map<String, String> xmlMap = this.getXml(map);
        String globalXml = xmlMap.get("global");
        if (globalXml == null) {
            globalXml = "";
        }
        String rtnXml = DefXmlHandlerUtil.getXml(defXml, globalXml, xParentPath, xPath);
        map.remove("global");
        xmlMap.remove("global");
        return rtnXml;
    }

    private Map<String, String> getXml(Map<String, List<BpmWordPrintDef>> map) {
        HashMap<String, String> xmlMap = new HashMap<String, String>();
        Set<String> set = map.keySet();
        for (String key : set) {
            List<BpmWordPrintDef> wordPrintList = map.get(key);
            String xml = this.getByWordPrintDef(wordPrintList);
            xmlMap.put(key, xml);
        }
        return xmlMap;
    }

    private Map<String, List<BpmWordPrintDef>> getByWordPrint(List<BpmWordPrintDef> wordPrintDefList) {
        HashMap<String, List<BpmWordPrintDef>> map = new HashMap<String, List<BpmWordPrintDef>>();
        for (BpmWordPrintDef def : wordPrintDefList) {
            ArrayList<BpmWordPrintDef> list = (ArrayList<BpmWordPrintDef>)map.get("global");
            if (BeanUtils.isEmpty((Object)list)) {
                list = new ArrayList<BpmWordPrintDef>();
                list.add(def);
                map.put("global", list);
                continue;
            }
            list.add(def);
        }
        return map;
    }

    private String getByWordPrintDef(List<BpmWordPrintDef> wordPrintList) {
        if (BeanUtils.isEmpty(wordPrintList)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("<ext:wordPrints xmlns:ext=\"http://www.jee-soft.cn/bpm\">");
            for (BpmWordPrintDef wordPrint : wordPrintList) {
                XMLBuilder xmlBuilder = XMLBuilder.create((String)"ext:wordPrintDef").e("ext:alias").t(wordPrint.getAlias()).up().e("ext:name").t(wordPrint.getName()).up().e("ext:preview").t(wordPrint.getPreview()).up().e("ext:download").t(wordPrint.getDownload()).up().e("ext:watermark").t(wordPrint.getWatermark()).up().e("ext:range").t(wordPrint.getRange()).up().e("ext:desc").t(StringUtil.isNotEmpty((String)wordPrint.getDesc()) ? wordPrint.getDesc() : "").up();
                sb.append(xmlBuilder.asString() + "\n");
            }
            sb.append("</ext:wordPrints>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }
}

