/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.task.handler;

import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.ActionType;
import com.hotent.bpm.api.model.delegate.BpmDelegateTask;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.plugin.core.def.TaskActionHandlerDef;
import com.hotent.bpm.api.plugin.core.session.TaskActionPluginSession;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.hotent.bpm.engine.task.handler.AbstractTaskActionHandler;
import com.hotent.bpm.natapi.inst.NatProInstanceService;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmExeStackExecutorManager;
import com.hotent.bpm.persistence.manager.BpmExeStackManager;
import com.hotent.bpm.persistence.manager.BpmSignDataManager;
import com.hotent.bpm.persistence.model.BpmExeStack;
import com.hotent.bpm.persistence.util.BpmUtil;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class TaskActionBackHandler
extends AbstractTaskActionHandler {
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    NatProInstanceService natProInstanceService;
    @Resource
    BpmExeStackExecutorManager exeStrackExecutorManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmSignDataManager bpmSignDataManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;

    @Override
    public boolean isNeedCompleteTask() {
        return true;
    }

    @Override
    public void preActionHandler(TaskActionPluginSession pluginSession, TaskActionHandlerDef def) throws Exception {
        this.popStack(pluginSession);
    }

    private void popStack(TaskActionPluginSession pluginSession) throws Exception {
        BpmExeStack stack;
        String currentToken;
        DefaultTaskFinishCmd cmd = (DefaultTaskFinishCmd)pluginSession.getTaskFinishCmd();
        String instId = cmd.getInstId();
        String destinationNode = cmd.getDestination();
        String destinationToken = "";
        String handMode = (String)cmd.getTransitVars("backHandMode");
        BpmTask task = (BpmTask)cmd.getTransitVars("bpmTask_");
        BpmDelegateTask bpmDelegateTask = this.natTaskService.getByTaskId(task.getId());
        String exeId = bpmDelegateTask.getExecutionId();
        task.setExecId(exeId);
        Object objToken = this.natProInstanceService.getVariable(exeId, "token_");
        String string = currentToken = objToken != null ? objToken.toString() : null;
        if (StringUtil.isEmpty((String)destinationNode)) {
            stack = this.bpmExeStackManager.getPrevStack(instId, task.getNodeId(), currentToken);
            destinationToken = currentToken;
        } else {
            stack = this.bpmExeStackManager.getStack(instId, destinationNode, currentToken);
            destinationToken = currentToken;
        }
        if (stack == null) {
            stack = this.bpmExeStackManager.getStack(instId, StringUtil.isEmpty((String)destinationNode) ? task.getNodeId() : destinationNode, null);
            destinationToken = "";
        }
        cmd.setDestinationToken(destinationToken);
        cmd.setDestination(destinationNode);
        if (StringUtil.isNotEmpty((String)destinationNode)) {
            String innerSubStartNodeId;
            BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(task.getProcDefId(), destinationNode);
            if ((cmd.getTransitVars("IsDoneUnused") == null || !((Boolean)cmd.getTransitVars("IsDoneUnused")).booleanValue()) && bpmNodeDef instanceof UserTaskNodeDef) {
                innerSubStartNodeId = BpmUtil.getInnerSubStartNodeId(bpmNodeDef);
                if (destinationNode.equals(innerSubStartNodeId)) {
                    cmd.addBpmIdentity(destinationNode, BpmUtil.gethisOpinionQualfieds(task, innerSubStartNodeId));
                } else {
                    UserTaskNodeDef backTargetNodeDef = (UserTaskNodeDef)bpmNodeDef;
                    NodeProperties nodeProperties = backTargetNodeDef.getLocalProperties();
                    String backUserMode = nodeProperties.getBackUserMode();
                    if (StringUtil.isEmpty((String)backUserMode) || backUserMode.equals("history")) {
                        List<BpmIdentity> identitys = this.bpmCheckOpinionManager.getHistoryBpmIdentityByInstNodeId(task.getProcInstId(), destinationNode);
                        cmd.addBpmIdentity(destinationNode, identitys);
                    }
                }
            }
            if (cmd.getTransitVars("IsDoneUnused") != null && ((Boolean)cmd.getTransitVars("IsDoneUnused")).booleanValue() && !destinationNode.equals(innerSubStartNodeId = BpmUtil.getInnerSubStartNodeId(bpmNodeDef)) && bpmNodeDef instanceof SignNodeDef) {
                List<BpmIdentity> signBpmIdentity = this.bpmSignDataManager.getByInstanIdAndNodeIdAndNo(instId, destinationNode);
                cmd.addBpmIdentity(destinationNode, signBpmIdentity);
                return;
            }
        }
        if ("direct".equals(handMode)) {
            cmd.getTransitVars().put("target_node", task.getNodeId());
        } else {
            cmd.getTransitVars().put("target_node", null);
        }
    }

    @Override
    public void afterActionHandler(TaskActionPluginSession pluginSession, TaskActionHandlerDef def) {
    }

    @Override
    public ActionType getActionType() {
        return ActionType.BACK;
    }
}

