/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.task.service;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.constant.ActionType;
import com.hotent.bpm.api.constant.MultiInstanceType;
import com.hotent.bpm.api.constant.NodeStatus;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.delegate.BpmDelegateExecution;
import com.hotent.bpm.api.plugin.core.execution.sign.SignActionHandler;
import com.hotent.bpm.api.plugin.core.execution.sign.SignResult;
import com.hotent.bpm.api.service.CustomSignComplete;
import com.hotent.bpm.engine.execution.sign.handler.SignActionHandlerContainer;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmProStatusManager;
import com.hotent.bpm.persistence.manager.BpmTaskCandidateManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.transaction.annotation.Transactional;

public class CustomSignCompleteImpl
implements CustomSignComplete {
    @Resource
    SignActionHandlerContainer actionHandlerContainer;
    @Resource
    BpmProStatusManager bpmProStatusManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmTaskCandidateManager bpmTaskCandidateManager;

    @Override
    @Transactional
    public boolean isComplete(BpmDelegateExecution bpmDelegateExecution) throws Exception {
        String instId = (String)bpmDelegateExecution.getVariable("instanceId_");
        TaskFinishCmd taskFinishCmd = (TaskFinishCmd)ContextThreadUtil.getActionCmd();
        if (BeanUtils.isEmpty((Object)this.actionHandlerContainer)) {
            this.actionHandlerContainer = (SignActionHandlerContainer)AppUtil.getBean((String)"signActionHandlerContainer");
        }
        SignActionHandler handler = this.actionHandlerContainer.getSignActionHandler(taskFinishCmd.getActionType().getKey());
        SignResult result = handler.handByActionType(taskFinishCmd, bpmDelegateExecution);
        this.handComplete(result, instId, bpmDelegateExecution, taskFinishCmd.getActionType());
        return result.isComplete();
    }

    private void handComplete(SignResult result, String instId, BpmDelegateExecution bpmDelegateExecution, ActionType actionType) {
        if (!result.isComplete()) {
            return;
        }
        String nodeId = bpmDelegateExecution.getNodeId();
        String nodeName = bpmDelegateExecution.getNodeName();
        if (BeanUtils.isEmpty((Object)this.bpmDefinitionManager)) {
            this.bpmDefinitionManager = (BpmDefinitionManager)AppUtil.getBean(BpmDefinitionManager.class);
        }
        String defId = this.bpmDefinitionManager.getDefIdByBpmnDefId(bpmDelegateExecution.getBpmnDefId());
        NodeStatus signNodeStatus = null;
        if (result.getNodeStatus().getKey().equals(NodeStatus.AGREE.getKey())) {
            signNodeStatus = NodeStatus.SIGN_PASS;
        } else if (result.getNodeStatus().getKey().equals(NodeStatus.OPPOSE.getKey())) {
            signNodeStatus = NodeStatus.SIGN_NO_PASS;
        } else {
            TaskFinishCmd taskFinishCmd = (TaskFinishCmd)ContextThreadUtil.getActionCmd();
            signNodeStatus = this.getNodeStatus(taskFinishCmd);
        }
        if (BeanUtils.isEmpty((Object)this.bpmProStatusManager)) {
            this.bpmProStatusManager = (BpmProStatusManager)AppUtil.getBean(BpmProStatusManager.class);
        }
        this.bpmProStatusManager.createOrUpd(instId, defId, nodeId, nodeName, signNodeStatus);
        boolean isParallel = !MultiInstanceType.SEQUENTIAL.equals((Object)bpmDelegateExecution.multiInstanceType());
        String executeParentId = isParallel ? bpmDelegateExecution.getParentExecution().getParentExecution().getId() : bpmDelegateExecution.getParentId();
        this.updOpinion(executeParentId, nodeId, result.getOpinionStatus().getKey());
        if (ActionType.APPROVE.equals((Object)actionType)) {
            String resultVarName = "signResult_" + nodeId;
            bpmDelegateExecution.setVariable(resultVarName, result.getNodeStatus().getKey());
        }
        String varName = "signUsers_" + nodeId;
        if (MultiInstanceType.SEQUENTIAL.equals((Object)bpmDelegateExecution.multiInstanceType())) {
            bpmDelegateExecution.removeVariable(varName);
        }
    }

    private void updOpinion(String executeParentId, String nodeId, String status) {
        this.bpmTaskManager = (BpmTaskManager)AppUtil.getBean(BpmTaskManager.class);
        this.bpmCheckOpinionManager = (BpmCheckOpinionManager)AppUtil.getBean(BpmCheckOpinionManager.class);
        this.bpmTaskCandidateManager = (BpmTaskCandidateManager)AppUtil.getBean(BpmTaskCandidateManager.class);
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        List<DefaultBpmCheckOpinion> byInstNodeId = this.bpmCheckOpinionManager.getByInstNodeId(actionCmd.getInstId(), nodeId);
        ArrayList<String> taskIds = new ArrayList<String>();
        for (DefaultBpmCheckOpinion opinion : byInstNodeId) {
            if (!OpinionStatus.AWAITING_CHECK.getKey().equals(opinion.getStatus())) continue;
            opinion.setStatus(status);
            if (OpinionStatus.RETRACTED.getKey().equals(status) && StringUtil.isEmpty((String)opinion.getOpinion())) {
                opinion.setOpinion(OpinionStatus.RETRACTED.getValue());
            }
            opinion.setCompleteTime(LocalDateTime.now());
            this.bpmCheckOpinionManager.update((Model)opinion);
            taskIds.add(opinion.getTaskId());
        }
        for (String taskId : taskIds) {
            this.bpmTaskCandidateManager.removeByTaskId(taskId);
            this.bpmTaskManager.remove((Serializable)((Object)taskId));
        }
    }

    private NodeStatus getNodeStatus(TaskFinishCmd cmd) {
        NodeStatus nodeStatus = NodeStatus.AGREE;
        String action = cmd.getActionName();
        Object isDoneUnused = cmd.getTransitVars("IsDoneUnused");
        if (isDoneUnused != null) {
            nodeStatus = NodeStatus.RECOVER;
            return nodeStatus;
        }
        switch (cmd.getActionType()) {
            case APPROVE: {
                nodeStatus = NodeStatus.fromKey(cmd.getActionName());
                break;
            }
            case BACK_TO_START: {
                nodeStatus = NodeStatus.BACK_TO_START;
                break;
            }
            case BACK: {
                if ("toStart".equals(action) || "backToStart".equals(action)) {
                    nodeStatus = NodeStatus.BACK_TO_START;
                    break;
                }
                nodeStatus = NodeStatus.BACK;
                break;
            }
            case RECOVER: {
                nodeStatus = "toStart".equals(action) ? NodeStatus.RECOVER_TO_START : NodeStatus.RECOVER;
            }
        }
        return nodeStatus;
    }
}

