/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.task.service;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.constant.TaskType;
import com.hotent.bpm.api.model.delegate.BpmDelegateTask;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.service.BpmAgentService;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.natapi.task.NatTaskService;
import com.hotent.bpm.persistence.dao.BpmAgentConditionDao;
import com.hotent.bpm.persistence.manager.BpmAgentConditionManager;
import com.hotent.bpm.persistence.manager.BpmAgentSettingManager;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.manager.BpmTaskTurnManager;
import com.hotent.bpm.persistence.manager.TaskTurnAssignManager;
import com.hotent.bpm.persistence.model.BpmAgentCondition;
import com.hotent.bpm.persistence.model.BpmAgentSetting;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.persistence.model.DefaultBpmTaskTurn;
import com.hotent.bpm.persistence.model.TaskTurnAssign;
import com.hotent.bpm.util.BpmCheckOpinionUtil;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.bpm.util.MessageUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultBpmAgentService
implements BpmAgentService {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultBpmAgentService.class);
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmAgentSettingManager bpmAgentSettingManager;
    @Resource
    IUserService userServiceImpl;
    @Resource
    BpmAgentConditionDao bpmAgentConditionDao;
    @Resource
    BpmAgentConditionManager bpmAgentConditionManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    NatTaskService natTaskService;
    @Resource
    BpmTaskTurnManager bpmTaskTurnManager;
    @Resource
    TaskTurnAssignManager taskTurnAssignManager;

    @Override
    public IUser getAgent(String userId, BpmDelegateTask delegateTask, Map<String, Object> vars) {
        DefaultBpmDefinition bpmDef = this.bpmDefinitionManager.getByBpmnDefId(delegateTask.getBpmnDefId());
        String defKey = bpmDef.getDefKey();
        IUser user = null;
        BpmAgentSetting setting = this.bpmAgentSettingManager.getSettingByFlowAndAuthidAndDate(userId, defKey);
        if (setting == null) {
            return null;
        }
        String agentId = setting.getAgentId();
        switch (setting.getType()) {
            case 1: 
            case 2: {
                user = this.userServiceImpl.getUserById(agentId);
                break;
            }
            case 3: {
                user = this.getByCondition(delegateTask, setting.getId());
            }
        }
        return user;
    }

    private IUser getByCondition(BpmDelegateTask delegateTask, String settingId) {
        List<BpmAgentCondition> list = this.bpmAgentConditionDao.getBySettingId(settingId);
        HashSet agentIds = new HashSet();
        IUser user = null;
        for (BpmAgentCondition con : list) {
            if (!this.bpmAgentConditionManager.checkCondition(delegateTask, con)) continue;
            user = this.userServiceImpl.getUserById(con.getAgentId());
            break;
        }
        return user;
    }

    @Override
    @Transactional
    public void retrieveTask(String taskId, String informType, String cause) {
        DefaultBpmTask bpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        String bpmnTaskId = bpmTask.getTaskId();
        BpmDelegateTask delegateTask = this.natTaskService.getByTaskId(bpmnTaskId);
        if (TaskType.DELIVERTO.getKey().equals(bpmTask.getStatus())) {
            DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getByTaskIdStatus(taskId, OpinionStatus.AWAITING_CHECK.getKey());
            checkOpinion.setStatus(OpinionStatus.DELIVERTO_CANCEL.getKey());
            checkOpinion.setCompleteTime(LocalDateTime.now());
            checkOpinion.setAuditor(ContextUtil.getCurrentUserId());
            checkOpinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
            checkOpinion.setOpinion("\u53d6\u6d88\u8f6c\u529e");
            long durMs = TimeUtil.getTime((LocalDateTime)LocalDateTime.now(), (LocalDateTime)checkOpinion.getCreateTime());
            checkOpinion.setDurMs(durMs);
            this.bpmCheckOpinionManager.update((Model)checkOpinion);
            ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
            DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
            bpmIdentity.setType("user");
            bpmIdentity.setId(ContextUtil.getCurrentUserId());
            bpmIdentity.setName(ContextUtil.getCurrentUser().getFullname());
            identityList.add(bpmIdentity);
            checkOpinion.setId(UniqueIdUtil.getSuid());
            checkOpinion.setStatus(OpinionStatus.AWAITING_CHECK.getKey());
            checkOpinion.setCreateTime(LocalDateTime.now());
            checkOpinion.setCompleteTime(null);
            checkOpinion.setDurMs(0L);
            checkOpinion.setQualfieds(BpmCheckOpinionUtil.getIdentityIds(identityList));
            checkOpinion.setQualfiedNames(ContextUtil.getCurrentUser().getFullname());
            checkOpinion.setAuditor(null);
            checkOpinion.setAuditorName(null);
            checkOpinion.setOpinion("");
            this.bpmCheckOpinionManager.create((Model)checkOpinion);
        }
        String ownerId = delegateTask.getOwner();
        delegateTask.setAssignee(ownerId);
        this.natTaskService.save(delegateTask);
        bpmTask.setAssigneeId(ownerId);
        bpmTask.setStatus(TaskType.NORMAL.name());
        this.bpmTaskManager.update((Model)bpmTask);
        DefaultBpmTaskTurn taskTurn = (DefaultBpmTaskTurn)this.bpmTaskTurnManager.getByTaskId(taskId);
        if (taskTurn == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u5904\u4e8e\u5ba1\u6279\u72b6\u6001\u7684\u8f6c\u529e\u4efb\u52a1\u3002");
        }
        taskTurn.setAssigneeId(taskTurn.getOwnerId());
        taskTurn.setAssigneeName(taskTurn.getOwnerName());
        taskTurn.setStatus("cancel");
        taskTurn.setFinishTime(LocalDateTime.now());
        this.bpmTaskTurnManager.update((Model)taskTurn);
        this.notifyUsers(taskTurn, informType, cause);
    }

    private void notifyUsers(DefaultBpmTaskTurn taskTurn, String informType, String cause) {
        TaskTurnAssign turnAssign = this.taskTurnAssignManager.getLastTaskTurn(taskTurn.getId());
        IUser user = BpmUtil.getUser(turnAssign.getReceiverId());
        ArrayList<IUser> recievers = new ArrayList<IUser>();
        recievers.add(user);
        if (BeanUtils.isEmpty(recievers)) {
            return;
        }
        IUser sendUser = ContextUtil.getCurrentUser();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("taskId", taskTurn.getTaskId());
        vars.put("taskSubject", taskTurn.getTaskSubject());
        vars.put("instSubject", taskTurn.getTaskSubject());
        vars.put("nodeName", taskTurn.getTaskName());
        vars.put("cause", cause);
        vars.put("sender", sendUser.getFullname());
        try {
            MessageUtil.sendMsg("bpmTurnCancel", informType, recievers, vars);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage());
        }
    }
}

