/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.task.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.service.BpmSignDataService;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.persistence.dao.BpmSignDataDao;
import com.hotent.bpm.persistence.manager.BpmSignDataManager;
import com.hotent.bpm.persistence.model.BpmSignData;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DefaultBpmSignDataService
implements BpmSignDataService {
    @Resource
    BpmSignDataDao bpmSignDataDao;
    @Resource
    BpmSignDataManager bpmSignDataManager;

    @Override
    public List<BpmIdentity> getHistoryAuditor(String executeId, String nodeId) {
        ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
        List<BpmSignData> list = this.bpmSignDataDao.getVoteByExecuteNode(executeId, nodeId, 0);
        for (BpmSignData data : list) {
            if ("no".equals(data.getVoteResult())) continue;
            BpmIdentity identity = DefaultBpmIdentity.getIdentityByUserId(data.getVoteId(), data.getVoter());
            identityList.add(identity);
        }
        return identityList;
    }

    @Override
    public Set<BpmIdentity> getHistoryAuditorByInstId(String instId, String nodeId) {
        LinkedHashSet<BpmIdentity> identitySet = new LinkedHashSet<BpmIdentity>();
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(BpmSignData::getInstId, (Object)instId);
        lambdaQuery.eq(BpmSignData::getNodeId, (Object)nodeId);
        lambdaQuery.eq(BpmSignData::getIsActive, (Object)0);
        List list = this.bpmSignDataManager.list((Wrapper)lambdaQuery);
        for (BpmSignData data : list) {
            if ("no".equals(data.getVoteResult())) continue;
            BpmIdentity identity = DefaultBpmIdentity.getIdentityByUserId(data.getVoteId(), data.getVoter());
            identitySet.add(identity);
        }
        return identitySet;
    }
}

