/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.task.service;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.context.BaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.BaseActionCmd;
import com.hotent.bpm.api.cmd.ProcessInstCmd;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.constant.AopType;
import com.hotent.bpm.api.constant.EventType;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.constant.ProcessInstanceStatus;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.event.DoNextEvent;
import com.hotent.bpm.api.event.DoNextModel;
import com.hotent.bpm.api.model.delegate.BpmDelegateTask;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.model.process.task.BpmTaskTurn;
import com.hotent.bpm.api.plugin.core.def.TaskActionHandlerDef;
import com.hotent.bpm.api.plugin.core.factory.BpmPluginSessionFactory;
import com.hotent.bpm.api.plugin.core.runtime.TaskActionHandler;
import com.hotent.bpm.api.plugin.core.session.TaskActionPluginSession;
import com.hotent.bpm.api.plugin.core.task.TaskActionHandlerConfig;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmTaskActionService;
import com.hotent.bpm.api.service.RestfulService;
import com.hotent.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.hotent.bpm.listener.BusDataUtil;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.natapi.task.NatTaskService;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskCandidateManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.manager.BpmTaskTurnManager;
import com.hotent.bpm.persistence.manager.TaskTurnAssignManager;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.persistence.model.DefaultBpmTaskTurn;
import com.hotent.bpm.persistence.model.TaskTurnAssign;
import com.hotent.bpm.persistence.util.BpmStackRelationUtil;
import com.hotent.bpm.util.BpmCheckOpinionUtil;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.bpm.util.MessageUtil;
import com.hotent.bpm.util.PortalDataUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;

@Service
public class DefaultBpmTaskActionService
implements BpmTaskActionService {
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    NatTaskService natTaskService;
    @Resource
    BpmPluginSessionFactory bpmPluginSessionFactory;
    @Resource
    TaskActionHandlerConfig taskActionHandlerConfig;
    @Resource
    BpmTaskTurnManager bpmTaskTurnManager;
    @Resource
    TaskTurnAssignManager taskTurnAssignManager;
    @Resource
    BpmTaskCandidateManager bpmTaskCandidateManager;
    @Resource
    IUserService userServiceImpl;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    FormFeignService formRestfulService;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    RestfulService restfulService;

    @Override
    public boolean finishTask(TaskFinishCmd taskCmd) throws Exception {
        DefaultTaskFinishCmd cmd = (DefaultTaskFinishCmd)taskCmd;
        ContextThreadUtil.setActionCmd(cmd);
        BpmTask bpmTask = (BpmTask)cmd.getTransitVars("bpmTask_");
        if (this.isInstanceManualEnd(bpmTask.getProcInstId())) {
            return false;
        }
        Map<String, Object> cmdVariables = taskCmd.getVariables();
        if (BeanUtils.isEmpty(cmdVariables)) {
            cmdVariables = this.natTaskService.getVariables(bpmTask.getTaskId());
        }
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(bpmTask.getProcDefId(), bpmTask.getNodeId());
        if (BpmCheckOpinionUtil.effectNodeTransActions.contains(taskCmd.getActionName()) && NodeType.USERTASK.equals((Object)bpmNodeDef.getType())) {
            BaseContext context = (BaseContext)AppUtil.getBean(BaseContext.class);
            cmdVariables.put("nodeAuditor_" + bpmTask.getNodeId(), context.getCurrentUserAccout());
        }
        taskCmd.setVariables(cmdVariables);
        BpmDelegateTask task = null;
        if (StringUtil.isNotZeroEmpty((String)bpmTask.getTaskId())) {
            task = this.natTaskService.getByTaskId(bpmTask.getTaskId());
        }
        DoNextModel donextModel = new DoNextModel(cmd, AopType.PREVIOUS);
        DoNextEvent donextEv = new DoNextEvent(donextModel);
        AppUtil.publishEvent((ApplicationEvent)donextEv);
        TaskActionPluginSession taskActionPluginSession = this.bpmPluginSessionFactory.buildTaskActionPluginSession(task, taskCmd);
        String actionName = "";
        actionName = StringUtil.isNotEmpty((String)taskCmd.getAddSignAction()) ? taskCmd.getAddSignAction() : taskCmd.getActionName();
        TaskActionHandler handler = this.taskActionHandlerConfig.getTaskActionHandler(actionName);
        TaskActionHandlerDef def = this.taskActionHandlerConfig.getTaskActionHandlerDef(taskCmd.getActionName());
        boolean result = (Boolean)handler.execute(taskActionPluginSession, def);
        if (StringUtil.isNotEmpty((String)taskCmd.getAddSignTaskId())) {
            DefaultBpmCheckOpinion defaultBpmCheckOpinion = this.bpmCheckOpinionManager.getByTaskId(taskCmd.getAddSignTaskId());
            defaultBpmCheckOpinion.setStatus(OpinionStatus.REJECT.getKey());
            defaultBpmCheckOpinion.setAuditor(ContextUtil.getCurrentUser().getUserId());
            defaultBpmCheckOpinion.setOpinion(((DefaultTaskFinishCmd)taskCmd).getApprovalOpinion());
            defaultBpmCheckOpinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
            defaultBpmCheckOpinion.setCompleteTime(LocalDateTime.now());
            this.bpmCheckOpinionManager.update((Model)defaultBpmCheckOpinion);
        }
        DoNextModel donextAfterModel = new DoNextModel(cmd, AopType.POST);
        DoNextEvent donextAfterEv = new DoNextEvent(donextAfterModel);
        AppUtil.publishEvent((ApplicationEvent)donextAfterEv);
        ActionCmd finsActionCmd = ContextThreadUtil.getActionCmd();
        Object rejectAfterExecutionId = finsActionCmd.getTransitVars("rejectAfterExecutionId");
        if (BeanUtils.isNotEmpty((Object)rejectAfterExecutionId)) {
            BpmStackRelationUtil.multipleInstancesRejectAdjust(rejectAfterExecutionId.toString());
        } else {
            Object rejectSingleExecutionId = finsActionCmd.getTransitVars("rejectSingleExecutionId");
            if (BeanUtils.isNotEmpty((Object)rejectSingleExecutionId)) {
                BpmStackRelationUtil.singleInstancesRejectAdjust(rejectSingleExecutionId.toString());
            }
        }
        Object rejectDirectExecutionId = finsActionCmd.getTransitVars("rejectDirectExecutionId");
        if (BeanUtils.isNotEmpty((Object)rejectDirectExecutionId)) {
            BpmStackRelationUtil.instancesRejectDirectAdjust(rejectDirectExecutionId.toString());
        }
        MessageUtil.sendNodeBtnNotify(cmd.getActionName(), bpmTask.getNodeId(), bpmTask.getProcInstId(), "", cmd);
        this.processSubflowJumpRule();
        this.updateSignTaskSubjectAfterCompleteTask(bpmTask);
        EventType actionType = EventType.fromKey(cmd.getActionName());
        if (EventType.BACK_TO_START == actionType) {
            actionType = EventType.REJECT;
        }
        if (EventType.RECOVER_TO_START == actionType) {
            actionType = EventType.TASK_REVOKE;
        }
        this.restfulService.executePluginByTask(bpmTask, actionType);
        return result;
    }

    private boolean isInstanceManualEnd(String procInstId) {
        if (BeanUtils.isEmpty((Object)procInstId)) {
            return false;
        }
        DefaultBpmProcessInstance processInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)procInstId));
        String status = Optional.ofNullable(processInstance).map(DefaultBpmProcessInstance::getStatus).orElse(ProcessInstanceStatus.STATUS_DRAFT.getKey());
        return status.equals(ProcessInstanceStatus.STATUS_MANUAL_END.getKey());
    }

    private void updateSignTaskSubjectAfterCompleteTask(BpmTask bpmTask) {
        Object signTaskSubject = ContextThreadUtil.getCommuVar("sign_task_subject_for_update", null);
        if (BeanUtils.isNotEmpty((Object)signTaskSubject)) {
            String subject = signTaskSubject.toString();
            this.bpmTaskManager.updateSubjectByInstId(bpmTask.getProcInstId(), subject);
        }
    }

    private void processSubflowJumpRule() {
        Map<String, Set<BpmTask>> taskMap = ContextThreadUtil.getTaskMap();
        BaseActionCmd baseCmd = (BaseActionCmd)ContextThreadUtil.getActionCmd();
        if (BeanUtils.isNotEmpty(taskMap) && baseCmd instanceof ProcessInstCmd) {
            DefaultTaskFinishCmd skipCmd = new DefaultTaskFinishCmd();
            skipCmd.setInstId(baseCmd.getInstId());
            skipCmd.setActionName(baseCmd.getActionName());
            skipCmd.setBpmIdentities(baseCmd.getBpmIdentities());
            skipCmd.setVariables(baseCmd.getVariables());
            skipCmd.putTransitVars(baseCmd.getTransitVars());
            ContextThreadUtil.setActionCmd(skipCmd);
            ArrayList list = new ArrayList();
            for (String string : taskMap.keySet()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("instId", string);
                map.put("bpmTasks", taskMap.get(string));
                list.add(map);
            }
            for (Map map : list) {
                ContextThreadUtil.clearTaskByInstId(MapUtil.getString((Map)map, (String)"instId"));
                Set bpmTasks = (Set)map.get("bpmTasks");
                bpmTasks.forEach(currentTask -> {
                    if (!currentTask.isGateWay()) {
                        try {
                            BpmUtil.setTaskSkip(currentTask);
                            if (currentTask.getSkipResult().isSkipTask()) {
                                BpmUtil.finishTask(currentTask);
                            }
                        }
                        catch (Exception e) {
                            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)e);
                            throw new BaseException(rootCauseMessage, (Throwable)e);
                        }
                    }
                });
            }
        }
    }

    @Override
    public void create(BpmDelegateTask delegateTask) throws Exception {
        BpmTask task = BpmUtil.convertTask(delegateTask);
        this.bpmTaskManager.createTaskSign((DefaultBpmTask)task, false);
    }

    @Override
    public void remove(String taskId) {
        this.bpmTaskManager.delByRelateTaskId(taskId);
    }

    @Override
    public void delegate(String taskId, String toUser, String opinion, String files, String formData) throws Exception {
        BpmTask bpmTask = (BpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        BpmTaskTurn bpmTaskTurn = this.bpmTaskTurnManager.getByTaskId(taskId);
        IUser user = this.userServiceImpl.getUserById(toUser);
        this.bpmTaskManager.delegate(taskId, user);
        ArrayList<IUser> userList = new ArrayList<IUser>();
        userList.add(user);
        if (bpmTaskTurn == null) {
            this.bpmTaskTurnManager.add((DefaultBpmTask)bpmTask, ContextUtil.getCurrentUser(), user, opinion, "turn");
        } else {
            if (bpmTaskTurn.getAssigneeId().equals(toUser)) {
                throw new RuntimeException("\u4efb\u52a1\u5df2\u4ea4\u7531\u3010" + bpmTaskTurn.getAssigneeName() + "\u3011\u5904\u7406\uff01");
            }
            List<TaskTurnAssign> turnAssign = this.bpmTaskTurnManager.getTurnAssignByTaskTurnId(bpmTaskTurn.getId());
            for (TaskTurnAssign taskTurnAssign : turnAssign) {
                if (!toUser.equals(taskTurnAssign.getReceiverId()) && !toUser.equals(taskTurnAssign.getFromUserId())) continue;
                throw new RuntimeException("\u3010" + user.getFullname() + "\u3011\u5df2\u7ecf\u8f6c\u529e\u8fc7,\u4e0d\u80fd\u91cd\u590d\u8f6c\u529e,\u8bf7\u8054\u7cfb\u8be5\u7528\u6237\u53d6\u56de\uff01");
            }
            DefaultBpmTaskTurn turn = (DefaultBpmTaskTurn)bpmTaskTurn;
            turn.setStatus("running");
            turn.setAssigneeId(user.getUserId());
            turn.setAssigneeName(user.getFullname());
            this.bpmTaskTurnManager.update((Model)turn);
            this.bpmTaskTurnManager.addTurnAssign(turn.getId(), user, opinion);
        }
        DefaultBpmCheckOpinion delegeteCheckOpinion = this.bpmCheckOpinionManager.getByTaskIdStatus(taskId, OpinionStatus.AWAITING_CHECK.getKey());
        delegeteCheckOpinion.setId(UniqueIdUtil.getSuid());
        delegeteCheckOpinion.setStatus(OpinionStatus.DELIVERTO.getKey());
        delegeteCheckOpinion.setCompleteTime(LocalDateTime.now());
        delegeteCheckOpinion.setAuditor(ContextUtil.getCurrentUserId());
        delegeteCheckOpinion.setAuditorName(ContextUtil.getCurrentUser().getFullname());
        delegeteCheckOpinion.setOpinion(StringUtil.isEmpty((String)opinion) ? "\u4efb\u52a1\u8f6c\u529e" : opinion);
        long durMs = TimeUtil.getTime((LocalDateTime)LocalDateTime.now(), (LocalDateTime)delegeteCheckOpinion.getCreateTime());
        delegeteCheckOpinion.setDurMs(durMs);
        delegeteCheckOpinion.setQualfieds("");
        delegeteCheckOpinion.setFiles(files);
        delegeteCheckOpinion.setQualfiedNames(user.getFullname());
        this.bpmCheckOpinionManager.create((Model)delegeteCheckOpinion);
        ThreadMsgUtil.addMapMsg((String)"leaderId", (String)"");
        DefaultBpmCheckOpinion checkOpinion = this.bpmCheckOpinionManager.getByTaskId(taskId);
        if (BeanUtils.isNotEmpty((Object)checkOpinion)) {
            checkOpinion.setCreateTime(LocalDateTime.now());
            ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
            DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
            bpmIdentity.setType("user");
            bpmIdentity.setId(user.getUserId());
            bpmIdentity.setName(user.getFullname());
            identityList.add(bpmIdentity);
            checkOpinion.setFiles(files);
            checkOpinion.setIsRead(0);
            checkOpinion.setQualfieds(BpmCheckOpinionUtil.getIdentityIds(identityList));
            checkOpinion.setQualfiedNames(user.getFullname());
            this.bpmCheckOpinionManager.update((Model)checkOpinion);
        }
        if (BeanUtils.isNotEmpty((Object)formData)) {
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)bpmTask.getProcInstId()));
            BusDataUtil.updateBoData(instance, bpmTask.getNodeId(), formData);
        }
        Map<String, Object> vars = this.getVars(bpmTask, opinion);
        String notifyType = BpmUtil.getNotifyType(bpmTask);
        MessageUtil.sendMsg("bpmHandTo", notifyType, userList, vars);
        MessageUtil.sendNodeBtnNotify("delegate", bpmTask.getNodeId(), bpmTask.getProcInstId(), formData, null);
    }

    private Map<String, Object> getVars(BpmTask task, String opinion) {
        String baseUrl = PortalDataUtil.getPropertyByAlias("baseUrl");
        String front = PortalDataUtil.getPropertyByAlias("frontBaseUrl");
        String manage = PortalDataUtil.getPropertyByAlias("manageBaseUrl");
        String mobile = PortalDataUtil.getPropertyByAlias("mobileBaseUrl");
        IUser user = ContextUtil.getCurrentUser();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("delegate", user.getFullname());
        map.put("taskSubject", task.getSubject());
        map.put("baseUrl", baseUrl);
        map.put("manageBaseUrl", manage);
        map.put("frontBaseUrl", front);
        map.put("mobileBaseUrl", mobile);
        map.put("taskId", task.getId());
        map.put("cause", opinion);
        map.put("nodeName", task.getName());
        map.put("instSubject", task.getSubject());
        return map;
    }

    @Override
    public void endProcessByTaskId(String taskId, String informType, String cause, String files) throws Exception {
        this.bpmTaskManager.endProcessByTaskId(taskId, informType, cause, files, JsonUtil.getMapper().createObjectNode());
    }

    @Override
    public DefaultBpmTask create(BpmDelegateTask delegateTask, List<BpmIdentity> identityList) throws Exception {
        BpmTask task = BpmUtil.convertTask(delegateTask, identityList);
        return (DefaultBpmTask)task;
    }
}

