/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.task.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.jwt.JwtTokenHandler;
import com.hotent.base.model.HtJsonNodeFactory;
import com.hotent.base.model.HtObjectNode;
import com.hotent.base.util.ApiTokenUtil;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMethodUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.BaseActionCmd;
import com.hotent.bpm.api.cmd.ProcessInstCmd;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.constant.EventType;
import com.hotent.bpm.api.context.BpmContextUtil;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.model.delegate.BpmDelegateExecution;
import com.hotent.bpm.api.model.delegate.BpmDelegateTask;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.def.Restful;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.plugin.core.context.BpmPluginContext;
import com.hotent.bpm.api.plugin.core.def.BpmExecutionPluginDef;
import com.hotent.bpm.api.plugin.core.def.BpmPluginDef;
import com.hotent.bpm.api.plugin.core.def.BpmTaskPluginDef;
import com.hotent.bpm.api.plugin.core.execution.sign.SignResult;
import com.hotent.bpm.api.plugin.core.session.BpmExecutionPluginSession;
import com.hotent.bpm.api.plugin.core.session.BpmTaskPluginSession;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.RestfulService;
import com.hotent.bpm.engine.identity.DefaultBpmIdentityService;
import com.hotent.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.hotent.bpm.natapi.inst.NatProInstanceService;
import com.hotent.bpm.persistence.manager.BpmCallLogManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.BpmCallLog;
import com.hotent.bpm.persistence.model.BpmIdentityResult;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.plugin.core.plugindef.AbstractBpmPluginDef;
import com.hotent.bpm.plugin.execution.globalRestful.def.GlobalRestfulInvokePluginDef;
import com.hotent.bpm.plugin.task.restful.def.RestfulInvokePluginDef;
import com.hotent.bpm.util.BoDataUtil;
import com.hotent.bpm.util.ParserUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserService;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DefaultRestfulService
implements RestfulService {
    private static Logger log = LoggerFactory.getLogger(DefaultRestfulService.class);
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    IUserService userServiceImpl;
    @Resource
    DefaultBpmIdentityService bpmIdentityService;
    @Resource
    BpmCallLogManager bpmCallLogManager;
    @Resource
    BpmIdentityExtractService extractService;
    @Resource
    BoDataService boDataService;
    @Resource
    NatProInstanceService natProInstanceService;
    @Resource
    PortalFeignService portalFeignService;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;

    @Override
    public Void taskPluginExecute(BpmTaskPluginSession pluginSession, BpmTaskPluginDef pluginDef, List<Restful> restfuls) {
        EventType eventType = pluginSession.getEventType();
        BpmDelegateTask bpmDelegateTask = pluginSession.getBpmDelegateTask();
        return this.doTaskPluginExecute(bpmDelegateTask, eventType, restfuls);
    }

    @Override
    public Void taskPluginExecute(EventType eventType, BpmTask bpmTask, BpmTaskPluginDef pluginDef, List<Restful> restfuls) {
        return this.doTaskPluginExecute(bpmTask, eventType, restfuls);
    }

    @Override
    public Void executionPluginExecute(BpmExecutionPluginSession pluginSession, BpmExecutionPluginDef pluginDef, List<Restful> restfuls) {
        EventType eventType = pluginSession.getEventType();
        BpmDelegateExecution belegateExecution = pluginSession.getBpmDelegateExecution();
        return this.doExecutionPluginExecute(belegateExecution, eventType, restfuls);
    }

    @Override
    public Void executionPluginExecute(EventType eventType, BpmTask bpmTask, BpmExecutionPluginDef pluginDef, List<Restful> restfuls) {
        return this.doExecutionPluginExecute(bpmTask, eventType, restfuls);
    }

    @Override
    public Void outTaskPluginExecute(BpmTask task, List<Restful> restfuls, EventType eventType) throws Exception {
        try {
            for (Restful restful : restfuls) {
                String callTime = restful.getCallTime();
                String callNode = restful.getCallNodes();
                if (StringUtils.isEmpty((CharSequence)callTime) || !callTime.contains(eventType.getKey()) || !this.isGlobalNode(task, callNode, eventType)) continue;
                RestfulParam param = this.genartor(task, eventType);
                param.setTimestamp(System.currentTimeMillis());
                param.setEventType(eventType.getKey());
                String url = restful.getUrl();
                String customParamString = this.genartorCustomParam(restful.getParameterTemplate(), param);
                this.setThreadMethod("compensation_interface", () -> this.setCompensationInterface(restful, param));
                boolean status = this.executeInterfaceRestful(url, restful, param, customParamString);
                if (!status) continue;
                ((DefaultRestfulService)AppUtil.getBean(DefaultRestfulService.class)).submitLogNewTransactional();
                throw new WorkFlowException("\u4e8b\u4ef6\u4e2d\u8c03\u7528Restful\u63a5\u53e3\u5f02\u5e38");
            }
        }
        catch (Exception ex) {
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            log.error("[\u4e8b\u4ef6\u4e2d\u8c03\u7528Restful\u63a5\u53e3\u5f02\u5e38]:" + rootCauseMessage);
            throw new WorkFlowException(rootCauseMessage);
        }
        this.submitLog();
        return null;
    }

    @Override
    public void executePluginByInstId(String instId, EventType eventType) throws Exception {
        List<DefaultBpmTask> tasks = this.bpmTaskManager.getByInstId(instId);
        if (BeanUtils.isEmpty(tasks)) {
            return;
        }
        if (BeanUtils.isEmpty((Object)ContextThreadUtil.getActionCmd())) {
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
            BaseActionCmd cmd = new BaseActionCmd();
            cmd.addTransitVars("processInstance", instance);
            ContextThreadUtil.setActionCmd(cmd);
        }
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(tasks.get(0).getProcDefId());
        for (BpmTask bpmTask : tasks) {
            ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
            actionCmd.addTransitVars("bpmTask_", bpmTask);
            this.doExecute(bpmProcessDef, bpmTask, eventType);
        }
        log.info("\u6267\u884c\u6d41\u7a0b\u63a5\u53e3\u4e8b\u4ef6\uff1a\u5b9e\u4f8b\u4e3b\u952e\u4e3a\uff1a{}\uff0c\u4e8b\u4ef6\u7c7b\u578b\uff1a{}({})", new Object[]{instId, eventType.getValue(), eventType.getKey()});
    }

    @Override
    public void executePluginByTaskId(String taskId, EventType eventType) throws Exception {
        DefaultBpmTask task = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        if (task == null) {
            return;
        }
        this.executePluginByTask(task, eventType);
    }

    @Override
    public void executePluginByTask(BpmTask task, EventType eventType) throws Exception {
        if (BeanUtils.isEmpty((Object)ContextThreadUtil.getActionCmd())) {
            BaseActionCmd cmd = new BaseActionCmd();
            cmd.addTransitVars("bpmTask_", task);
            ContextThreadUtil.setActionCmd(cmd);
        }
        if (ContextThreadUtil.getActionCmd().getTransitVars("processInstance") == null) {
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)task.getProcInstId()));
            ContextThreadUtil.getActionCmd().addTransitVars("processInstance", instance);
        }
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(task.getProcDefId());
        this.doExecute(bpmProcessDef, task, eventType);
        log.info("\u6267\u884c\u6d41\u7a0b\u63a5\u53e3\u4e8b\u4ef6\uff1a\u4efb\u52a1\u4e3b\u952e\u4e3a\uff1a{}\uff0c\u4e8b\u4ef6\u7c7b\u578b\uff1a{}({})", new Object[]{task.getTaskId(), eventType.getValue(), eventType.getKey()});
    }

    private void doExecute(BpmProcessDef<BpmProcessDefExt> bpmProcessDef, BpmTask task, EventType eventType) {
        this.doExecuteByPluginDef(eventType, task, bpmProcessDef.getProcessDefExt().getBpmPluginContexts());
        for (BpmNodeDef bpmnNodeDef : bpmProcessDef.getBpmnNodeDefs()) {
            this.doExecuteByPluginDef(eventType, task, bpmnNodeDef.getBpmPluginContexts(), bpmnNodeDef.getNodeId());
        }
    }

    void doExecuteByPluginDef(EventType eventType, BpmTask task, List<BpmPluginContext> pluginContextList, String nodeId) {
        if (BeanUtils.isEmpty(pluginContextList)) {
            return;
        }
        for (BpmPluginContext bpmPluginContext : pluginContextList) {
            List<Restful> restfulList;
            AbstractBpmPluginDef restfulPluginDef;
            BpmPluginDef bpmPluginDef = bpmPluginContext.getBpmPluginDef();
            if (bpmPluginDef instanceof GlobalRestfulInvokePluginDef) {
                restfulPluginDef = (GlobalRestfulInvokePluginDef)bpmPluginDef;
                restfulList = ((GlobalRestfulInvokePluginDef)restfulPluginDef).getRestfulList();
                this.doExecutionPluginExecute(task, eventType, restfulList);
            }
            if (!(bpmPluginDef instanceof RestfulInvokePluginDef)) continue;
            restfulPluginDef = (RestfulInvokePluginDef)bpmPluginDef;
            restfulList = ((RestfulInvokePluginDef)restfulPluginDef).getRestfulList();
            restfulList.forEach(restful -> restful.setCallNodes(nodeId));
            this.doExecutionPluginExecute(task, eventType, restfulList);
        }
    }

    void doExecuteByPluginDef(EventType eventType, BpmTask task, List<BpmPluginContext> pluginContextList) {
        this.doExecuteByPluginDef(eventType, task, pluginContextList, null);
    }

    private Void doExecutionPluginExecute(Object object, EventType eventType, List<Restful> restfuls) {
        try {
            for (Restful restful : restfuls) {
                String callTime = restful.getCallTime();
                String callNode = restful.getCallNodes();
                if (StringUtils.isEmpty((CharSequence)callTime) || !callTime.contains(eventType.getKey()) || !this.isGlobalNode(object, callNode, eventType)) continue;
                RestfulParam param = this.genartor(object, eventType);
                param.setTimestamp(System.currentTimeMillis());
                param.setEventType(eventType.getKey());
                String url = restful.getUrl();
                String customParamString = this.genartorCustomParam(restful.getParameterTemplate(), param);
                this.setThreadMethod("compensation_interface", () -> this.setCompensationInterface(restful, param));
                boolean status = this.executeInterfaceRestful(url, restful, param, customParamString);
                if (!status) continue;
                ((DefaultRestfulService)AppUtil.getBean(DefaultRestfulService.class)).submitLogNewTransactional();
                throw new WorkFlowException("\u4e8b\u4ef6\u4e2d\u8c03\u7528Restful\u63a5\u53e3\u5f02\u5e38");
            }
        }
        catch (Exception ex) {
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            log.error("[\u4e8b\u4ef6\u4e2d\u8c03\u7528Restful\u63a5\u53e3\u5f02\u5e38]:" + rootCauseMessage);
            throw new WorkFlowException(rootCauseMessage);
        }
        this.submitLog();
        return null;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void submitLogNewTransactional() {
        List serviceLogfactoryList;
        List callLogfactoryList;
        List compensationfactoryList = ThreadMethodUtil.getMapFactory((String)"compensation_interface", (boolean)true);
        if (BeanUtils.isNotEmpty((Object)compensationfactoryList)) {
            compensationfactoryList.forEach(ObjectFactory::getObject);
        }
        if (BeanUtils.isNotEmpty((Object)(callLogfactoryList = ThreadMethodUtil.getMapFactory((String)"call_log", (boolean)true)))) {
            callLogfactoryList.forEach(ObjectFactory::getObject);
        }
        if (BeanUtils.isNotEmpty((Object)(serviceLogfactoryList = ThreadMethodUtil.getMapFactory((String)"service_log", (boolean)true)))) {
            serviceLogfactoryList.forEach(ObjectFactory::getObject);
        }
    }

    private void submitLog() {
        List callLogfactoryList;
        List serviceLogfactoryList = ThreadMethodUtil.getMapFactory((String)"service_log", (boolean)true);
        if (BeanUtils.isNotEmpty((Object)serviceLogfactoryList)) {
            serviceLogfactoryList.forEach(ObjectFactory::getObject);
        }
        if (BeanUtils.isNotEmpty((Object)(callLogfactoryList = ThreadMethodUtil.getMapFactory((String)"call_log", (boolean)true)))) {
            callLogfactoryList.forEach(ObjectFactory::getObject);
        }
    }

    private boolean setCompensationInterface(Restful restful, RestfulParam param) {
        boolean set;
        boolean bl = set = restful.getInvokeMode() == 0 && restful.getStop() == 1 && restful.getCompensation() == 1;
        if (!set) {
            return false;
        }
        BpmCallLog callLog = this.getCallLog(param, restful);
        boolean isSuccess = true;
        try {
            String url = restful.getCompensationUrl();
            String header = restful.getCompensationHeader();
            String parameterTemplate = restful.getCompensationParameterTemplate();
            String customParamString = this.genartorCustomParam(parameterTemplate, param);
            String response = this.post(url, customParamString, header, callLog, new HashMap<String, String>(), "POST", new HashMap<String, Object>()).returnContent().toString();
            callLog.setResponse(response);
        }
        catch (Exception e) {
            callLog.setResponse(ExceptionUtils.getRootCauseMessage((Throwable)e));
            log.error("\u8c03\u7528API\u4e8b\u4ef6\u8865\u507f\u63a5\u53e3\u5f02\u5e38\uff01", (Throwable)e);
            isSuccess = false;
        }
        callLog.setIsSuccess(isSuccess ? BpmCallLog.SUCCESS_YES : BpmCallLog.SUCCESS_NO);
        callLog.setIsCompensation(1);
        this.buildCallLog(callLog);
        return true;
    }

    private boolean executeInterfaceRestful(String url, Restful restful, RestfulParam param, String paramString) throws Exception {
        String apiAlias;
        ObjectNode portalInterfaceManager;
        boolean syncShop;
        StringBuilder requestType = new StringBuilder();
        HashMap<String, String> mapHeader = new HashMap<String, String>(1);
        HashMap<String, Object> conditionMap = new HashMap<String, Object>();
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)cmd.getTransitVars("processInstance");
        DefaultBpmTask bpmTask = (DefaultBpmTask)cmd.getTransitVars("bpmTask_");
        boolean rollback = false;
        boolean bl = syncShop = restful.getInvokeMode() == 0 && restful.getStop() == 1;
        if (Objects.equals(restful.getConfigType(), 0) && StringUtil.isNotEmpty((String)restful.getApiAlias()) && (portalInterfaceManager = this.portalFeignService.getApiDetailByAlias(apiAlias = restful.getApiAlias())) != null) {
            int sourceType;
            int n = sourceType = portalInterfaceManager.get("sourceType") == null ? 0 : portalInterfaceManager.get("sourceType").asInt();
            if (sourceType == 1) {
                StringBuilder urlBizSystem = new StringBuilder();
                this.executeInterfaceBizSystem(portalInterfaceManager, urlBizSystem, requestType, conditionMap, param, mapHeader);
                if (StringUtil.isNotEmpty((String)urlBizSystem.toString())) {
                    url = urlBizSystem.toString();
                }
                if (param != null && param.getPostParams() != null) {
                    ObjectNode paramNode = (ObjectNode)JsonUtil.toJsonNode((String)paramString);
                    paramNode.setAll((ObjectNode)param.getPostParams());
                    paramString = JsonUtil.toJson((Object)paramNode);
                }
            } else {
                BpmCallLog callLog = this.getCallLog(param, restful);
                if (restful.getInvokeMode() == 1) {
                    ExecutorService executorService = Executors.newCachedThreadPool();
                    String finalParamString = paramString;
                    executorService.execute(() -> this.executeInterfaceJob(apiAlias, callLog, instance, bpmTask, finalParamString));
                } else {
                    this.executeInterfaceJob(apiAlias, callLog, instance, bpmTask, paramString);
                    if (Objects.equals(callLog.getIsSuccess(), BpmCallLog.SUCCESS_NO) && syncShop) {
                        rollback = true;
                    }
                }
                return rollback;
            }
        }
        if (BeanUtils.isNotEmpty((Object)url)) {
            BpmCallLog callLog = this.getCallLog(param, restful);
            if (restful.getInvokeMode() == 1) {
                String finalUrl = url;
                String finalParamString = paramString;
                this.setThreadMethod("post_async", () -> this.postAsync(finalUrl, finalParamString, restful.getHeader(), callLog, mapHeader, requestType.toString(), conditionMap, restful.getApiAlias(), instance, bpmTask));
            } else {
                boolean isSuccess = true;
                try {
                    HttpResponse httpResponse;
                    int statusCode;
                    Response response = this.post(url, paramString, restful.getHeader(), callLog, mapHeader, requestType.toString(), conditionMap);
                    if (syncShop && BeanUtils.isNotEmpty((Object)restful.getStatusCode()) && (statusCode = (httpResponse = response.returnResponse()).getStatusLine().getStatusCode()) != Integer.parseInt(restful.getStatusCode())) {
                        isSuccess = false;
                        rollback = true;
                    }
                    String post = response.returnContent().toString();
                    callLog.setResponse(post);
                }
                catch (Exception e) {
                    callLog.setResponse(ExceptionUtils.getRootCauseMessage((Throwable)e));
                    log.error("\u8c03\u7528API\u4e8b\u4ef6\u5f02\u5e38\uff01", (Throwable)e);
                    isSuccess = false;
                    rollback = syncShop;
                }
                callLog.setIsSuccess(isSuccess ? BpmCallLog.SUCCESS_YES : BpmCallLog.SUCCESS_NO);
                this.buildCallLog(callLog);
                if (StringUtil.isNotEmpty((String)restful.getApiAlias())) {
                    this.buildServiceLog(isSuccess, callLog.getResponse(), restful.getApiAlias(), instance, bpmTask);
                }
            }
        }
        return rollback;
    }

    private void setThreadMethod(String key, ObjectFactory<?> method) {
        List<Object> factoryList = new ArrayList();
        List mapFactory = ThreadMethodUtil.getMapFactory((String)key, (boolean)true);
        if (BeanUtils.isNotEmpty((Object)mapFactory)) {
            factoryList = mapFactory;
        }
        factoryList.add(method);
        ThreadMethodUtil.addMapFactory((String)key, factoryList);
    }

    private void buildServiceLog(boolean isSuccess, String response, String alias, DefaultBpmProcessInstance instance, DefaultBpmTask bpmTask) {
        try {
            IUser user = ContextUtil.getCurrentUser();
            ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
            objectNode.put("isSuccess", isSuccess ? "1" : "0");
            objectNode.put("alias", alias);
            objectNode.put("type", "interface");
            objectNode.put("userId", user.getUserId());
            objectNode.put("userAccount", user.getAccount());
            objectNode.put("userName", user.getFullname());
            objectNode.putPOJO("callTime", (Object)DateUtil.getCurrentDate());
            objectNode.put("response", response);
            if (instance != null) {
                objectNode.put("subject", instance.getSubject());
                objectNode.put("procDefId", instance.getProcDefId());
                objectNode.put("procDefKey", instance.getProcDefKey());
                objectNode.put("procInstId", instance.getId());
                objectNode.put("procDefName", instance.getProcDefName());
            }
            if (BeanUtils.isNotEmpty((Object)bpmTask)) {
                objectNode.put("taskId", bpmTask.getId());
                objectNode.put("nodeId", bpmTask.getNodeId());
            }
            this.setThreadMethod("service_log", () -> this.portalFeignService.saveServiceLog(objectNode));
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58restful\u63a5\u53e3\u4e8b\u4ef6-\u670d\u52a1\u63a5\u53e3\u8c03\u7528\u65e5\u5fd7\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private void executeInterfaceBizSystem(ObjectNode portalInterfaceManager, StringBuilder url, StringBuilder requestType, Map<String, Object> conditionMap, RestfulParam param, Map<String, String> mapHeader) throws Exception {
        Map mapTemp;
        if (portalInterfaceManager.get("refId") == null || portalInterfaceManager.get("restfulDetail") == null) {
            return;
        }
        String bizSystemId = portalInterfaceManager.get("refId").asText();
        JsonNode restfulDetail = portalInterfaceManager.get("restfulDetail");
        ObjectNode portalBizSystem = this.portalFeignService.getBizSystem(bizSystemId);
        if (portalBizSystem == null) {
            return;
        }
        String rootAddress = portalBizSystem.get("rootAddress") == null ? "" : portalBizSystem.get("rootAddress").asText();
        url.append(rootAddress);
        if (restfulDetail.get("url") != null) {
            url.append(restfulDetail.get("url").asText());
        }
        if (restfulDetail.get("requestType") != null) {
            requestType.append(restfulDetail.get("requestType").asText());
        }
        if ((mapTemp = ApiTokenUtil.buildInputs((JsonNode)restfulDetail, (String)"conditionfield", (String)"field", (String)"defaultType", (String)"defaultValue", null)) != null) {
            conditionMap.putAll(mapTemp);
        }
        JsonNode postParams = null;
        try {
            String dataParam;
            String string = dataParam = restfulDetail.get("dataParam") == null ? "" : restfulDetail.get("dataParam").asText();
            if (BeanUtils.isNotEmpty((Object)dataParam)) {
                dataParam = ParserUtil.replaceWithMap(dataParam, conditionMap);
                postParams = JsonUtil.toJsonNode((String)dataParam);
            }
        }
        catch (Exception e) {
            log.debug("API\u4e8b\u4ef6-\u83b7\u53d6post\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38\uff01", (Throwable)e);
            postParams = null;
        }
        if (postParams != null) {
            param.setPostParams(postParams);
        }
        if (portalBizSystem.get("sysCode") == null || portalBizSystem.get("tokenKey") == null) {
            return;
        }
        String sysCode = portalBizSystem.get("sysCode").asText();
        String tokenKey = portalBizSystem.get("tokenKey").asText();
        if (StringUtil.isEmpty((String)sysCode) || StringUtil.isEmpty((String)tokenKey)) {
            return;
        }
        int tokenType = portalBizSystem.get("tokenType") == null ? 0 : portalBizSystem.get("tokenType").asInt();
        int tokenExpire = portalBizSystem.get("tokenExpire") == null ? 0 : portalBizSystem.get("tokenExpire").asInt();
        String tokenApiInfo = portalBizSystem.get("tokenApiInfo") == null ? "" : portalBizSystem.get("tokenApiInfo").asText();
        String tokenValue = "";
        if (StringUtil.isNotEmpty((String)tokenApiInfo)) {
            JsonNode jsonNode = JsonUtil.toJsonNode((String)tokenApiInfo);
            tokenValue = ApiTokenUtil.getToken((JsonNode)jsonNode, (Integer)tokenExpire, (String)sysCode);
        }
        if ("Authorization".equalsIgnoreCase(tokenKey)) {
            tokenValue = "Bearer " + tokenValue;
        }
        if (tokenType == 0) {
            mapHeader.put(tokenKey, tokenValue);
        } else {
            if (url.toString().contains("?")) {
                url.append("&");
            } else {
                url.append("?");
            }
            url.append(tokenKey).append("=").append(tokenValue);
        }
    }

    private void executeInterfaceJob(String apiAlias, BpmCallLog callLog, DefaultBpmProcessInstance instance, DefaultBpmTask bpmTask, String paramData) {
        boolean isSuccess = true;
        try {
            Object CommonResult2 = this.portalFeignService.executeIntefaceJob(apiAlias, null, null, paramData);
            callLog.setUrl("apiAlias:" + apiAlias);
            callLog.setParams(paramData);
            callLog.setResponse(CommonResult2 == null ? "" : JsonUtil.toJson((Object)CommonResult2));
        }
        catch (Exception e) {
            callLog.setResponse(ExceptionUtils.getRootCauseMessage((Throwable)e));
            log.error("\u8c03\u7528API\u4e8b\u4ef6\u5f02\u5e38-\u63a5\u53e3\u65b9\u5f0f\uff01", (Throwable)e);
            isSuccess = false;
        }
        callLog.setIsSuccess(isSuccess ? BpmCallLog.SUCCESS_YES : BpmCallLog.SUCCESS_NO);
        this.buildCallLog(callLog);
        if (StringUtil.isNotEmpty((String)apiAlias)) {
            this.buildServiceLog(isSuccess, callLog.getResponse(), apiAlias, instance, bpmTask);
        }
    }

    private Void doTaskPluginExecute(Object object, EventType eventType, List<Restful> restfuls) {
        try {
            for (Restful restful : restfuls) {
                String callTime = restful.getCallTime();
                if (StringUtils.isEmpty((CharSequence)callTime) || !callTime.contains(eventType.getKey())) continue;
                RestfulParam param = this.genartor(object, eventType);
                param.setTimestamp(System.currentTimeMillis());
                param.setEventType(eventType.getKey());
                if (restful.getInvokeMode() == 1 && BeanUtils.isNotEmpty(param.getVars()) && BeanUtils.isNotEmpty((Object)param.getVars().get("restful_task"))) {
                    param.getVars().remove("restful_task");
                }
                String customParamString = this.genartorCustomParam(restful.getParameterTemplate(), param);
                String url = restful.getUrl();
                this.setThreadMethod("compensation_interface", () -> this.setCompensationInterface(restful, param));
                boolean status = this.executeInterfaceRestful(url, restful, param, customParamString);
                if (!status) continue;
                ((DefaultRestfulService)AppUtil.getBean(DefaultRestfulService.class)).submitLogNewTransactional();
                throw new WorkFlowException("\u4e8b\u4ef6\u4e2d\u8c03\u7528Restful\u63a5\u53e3\u5f02\u5e38");
            }
        }
        catch (Exception ex) {
            String rootCauseMessage = ExceptionUtils.getRootCauseMessage((Throwable)ex);
            log.error("[\u4e8b\u4ef6\u4e2d\u8c03\u7528Restful\u63a5\u53e3\u5f02\u5e38]:" + rootCauseMessage);
            throw new WorkFlowException(rootCauseMessage);
        }
        this.submitLog();
        return null;
    }

    private String genartorCustomParam(String parameterTemplate, RestfulParam restfulParam) throws IOException {
        if (StringUtil.isEmpty((String)parameterTemplate)) {
            return null;
        }
        String json = parameterTemplate;
        if (Base64.isBase64((String)json)) {
            json = Base64.getFromBase64((String)parameterTemplate);
        }
        JsonNode jsonNode = JsonUtil.toJsonNode((String)json);
        ObjectNode result = JsonUtil.createObjectNode();
        this.genartorCustomParamFromJsonNode(jsonNode, this.prepareGroovyVars(restfulParam), result);
        return JsonUtil.toJsonString((Object)result);
    }

    private Map<String, Object> prepareGroovyVars(RestfulParam restfulParam) throws IOException {
        HashMap<String, Object> maps = new HashMap<String, Object>();
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        if (cmd instanceof TaskFinishCmd) {
            TaskFinishCmd taskCmd = (TaskFinishCmd)cmd;
            SignResult signResult = (SignResult)cmd.getTransitVars("task_sign_result");
            if (BeanUtils.isEmpty((Object)signResult) || taskCmd.getActionName().equals(signResult.getNodeStatus().getKey())) {
                maps.put("taskCmd", taskCmd);
            } else {
                try {
                    DefaultTaskFinishCmd defaultTaskFinishCmd = (DefaultTaskFinishCmd)taskCmd;
                    DefaultTaskFinishCmd clone = defaultTaskFinishCmd.clone();
                    clone.setActionName(signResult.getNodeStatus().getKey());
                    maps.put("taskCmd", clone);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    maps.put("taskCmd", taskCmd);
                }
            }
        } else if (cmd instanceof ProcessInstCmd) {
            maps.put("taskCmd", cmd);
        }
        Map<String, ObjectNode> boMap = BpmContextUtil.getBoFromContext();
        if (StringUtil.isNotEmpty((String)restfulParam.getBoData())) {
            JsonUtil.toJsonNode((String)restfulParam.getBoData()).fields().forEachRemaining(json -> {
                HtObjectNode htObjectNode = HtJsonNodeFactory.build().htObjectNode((ObjectNode)json.getValue());
                maps.put((String)json.getKey(), htObjectNode);
            });
        } else if (BeanUtils.isNotEmpty(boMap)) {
            HashMap<String, HtObjectNode> newMap = new HashMap<String, HtObjectNode>();
            for (Map.Entry<String, ObjectNode> next : boMap.entrySet()) {
                ObjectNode obj = next.getValue();
                if (obj.hasNonNull("data") && obj.get("data") instanceof ObjectNode) {
                    obj = (ObjectNode)obj.get("data");
                }
                HtObjectNode htObjectNode = HtJsonNodeFactory.build().htObjectNode(obj);
                newMap.put(next.getKey(), htObjectNode);
                maps.put(next.getKey(), htObjectNode);
            }
            maps.putAll(newMap);
        }
        maps.put("boMap", boMap);
        maps.putAll(JsonUtil.toMap((String)JsonUtil.toJson((Object)restfulParam)));
        maps.put("restfulParam", restfulParam);
        return maps;
    }

    private void genartorCustomParamFromJsonNode(JsonNode jsonNode, Map<String, Object> vars, ObjectNode result) {
        jsonNode.fields().forEachRemaining(json -> {
            JsonNode value = (JsonNode)json.getValue();
            if (value.isArray()) {
                ArrayNode arrayNode = (ArrayNode)value;
                ArrayNode list = JsonUtil.createArrayNode();
                for (int i = 0; i < arrayNode.size(); ++i) {
                    ObjectNode objectNode = JsonUtil.createObjectNode();
                    list.add((JsonNode)objectNode);
                    this.genartorCustomParamFromJsonNode(arrayNode.get(i), vars, objectNode);
                }
                result.set((String)json.getKey(), (JsonNode)list);
            } else if (value.isObject()) {
                ObjectNode objectNode = JsonUtil.createObjectNode();
                result.set((String)json.getKey(), (JsonNode)objectNode);
                this.genartorCustomParamFromJsonNode(value, vars, objectNode);
            } else if (value.isTextual()) {
                String str = value.textValue().replaceAll("\"", "");
                if (str.startsWith("${")) {
                    Object newValue = this.executionGroovyScript(str, vars);
                    try {
                        result.set((String)json.getKey(), JsonUtil.toJsonNode((Object)newValue));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new BaseException("\u81ea\u5b9a\u4e49\u53c2\u6570\u8f6c\u6362\u5931\u8d25", (Throwable)e);
                    }
                } else {
                    result.set((String)json.getKey(), value);
                }
            } else {
                result.set((String)json.getKey(), (JsonNode)json.getValue());
            }
        });
    }

    private Object executionGroovyScript(String script, Map<String, Object> vars) {
        script = this.replaceSpecialChar(script);
        GroovyScriptEngine engine = (GroovyScriptEngine)AppUtil.getBean(GroovyScriptEngine.class);
        return engine.executeScript(script, vars);
    }

    private String replaceSpecialChar(String str) {
        if (StringUtil.isEmpty((String)str)) {
            return "";
        }
        if ((str = str.trim()).startsWith("${")) {
            return str.substring(2, str.length() - 1);
        }
        return str;
    }

    private BpmCallLog getCallLog(RestfulParam param, Restful restful) {
        BpmCallLog callLog = new BpmCallLog();
        callLog.setId(UniqueIdUtil.getSuid());
        callLog.setSubject(param.getSubject());
        callLog.setProcDefId(param.getProcDefId());
        callLog.setEventType(param.getEventType());
        callLog.setProcDefKey(param.getFlowKey());
        callLog.setTaskId(param.getTaskId());
        callLog.setProcInstId(param.getInstId());
        callLog.setTaskKey(param.getNodeId());
        callLog.setTaskName(param.getNodeName());
        callLog.setUrl(restful.getUrl());
        callLog.setDesc(restful.getDesc());
        callLog.setInvokeMode(restful.getInvokeMode());
        callLog.setCallTime(LocalDateTime.now());
        callLog.setUserId(ContextUtil.getCurrentUserId());
        callLog.setIsCompensation(0);
        return callLog;
    }

    private String postAsync(String url, String params, String headerStr, BpmCallLog callLog, final Map<String, String> mapHeader, final String requestType, final Map<String, Object> conditionMap, final String apiAlias, final DefaultBpmProcessInstance instance, final DefaultBpmTask bpmTask) {
        String postMsg = "";
        callLog.setHeader(headerStr);
        callLog.setParams(params);
        try {
            class RestfulPostAsync {
                private String url;
                private String params;
                private String header;
                private String result;
                private BpmCallLog callLog;

                public RestfulPostAsync(String url, String params, String header, BpmCallLog callLog) {
                    this.url = url;
                    this.params = params;
                    this.header = header;
                    this.callLog = callLog;
                }

                public String getResult() {
                    return this.result;
                }

                public void toPost() {
                    new Thread(){

                        @Override
                        public void run() {
                            callLog.setCallTime(LocalDateTime.now());
                            Boolean isSuccess = true;
                            try {
                                String response = DefaultRestfulService.this.post(url, params, header, callLog, mapHeader, requestType, conditionMap).returnContent().toString();
                                callLog.setResponse(response);
                            }
                            catch (Exception e) {
                                isSuccess = false;
                                log.error("\u8c03\u7528API\u4e8b\u4ef6\u5f02\u5e38-\u5f02\u6b65\uff01", (Throwable)e);
                                callLog.setResponse(ExceptionUtils.getRootCauseMessage((Throwable)e));
                            }
                            callLog.setIsSuccess(isSuccess != false ? BpmCallLog.SUCCESS_YES : BpmCallLog.SUCCESS_NO);
                            DefaultRestfulService.this.buildCallLog(callLog);
                            if (StringUtil.isNotEmpty((String)apiAlias)) {
                                DefaultRestfulService.this.buildServiceLog(isSuccess, callLog.getResponse(), apiAlias, instance, bpmTask);
                            }
                        }
                    }.start();
                }
            }
            RestfulPostAsync restfulPost = new RestfulPostAsync(url, params, headerStr, callLog);
            restfulPost.toPost();
            postMsg = restfulPost.getResult();
        }
        catch (Exception ex) {
            callLog.setCallTime(LocalDateTime.now());
            callLog.setIsSuccess(BpmCallLog.SUCCESS_NO);
            callLog.setResponse(ExceptionUtils.getRootCauseMessage((Throwable)ex));
            this.buildCallLog(callLog);
            log.error("\u8c03\u7528API\u4e8b\u4ef6\u5f02\u5e38-\u5f02\u6b652\uff01", (Throwable)ex);
        }
        return postMsg;
    }

    private Request setHeaders(Request request, String headerStr) {
        boolean hasAuthorization = false;
        if (StringUtil.isNotEmpty((String)headerStr)) {
            try {
                if (Base64.isBase64((String)headerStr)) {
                    headerStr = Base64.getFromBase64((String)headerStr);
                }
                if (StringUtil.isNotEmpty((String)headerStr) && !"\"\"".equals(headerStr)) {
                    ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode((String)headerStr);
                    Iterator it = obj.fieldNames();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        request.setHeader(key, obj.get(key).asText());
                        if (!StringUtils.equals((CharSequence)key, (CharSequence)"Authorization")) continue;
                        hasAuthorization = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!hasAuthorization) {
            JwtTokenHandler jwtTokenHandler = (JwtTokenHandler)AppUtil.getBean(JwtTokenHandler.class);
            String proxyToken = "Bearer " + jwtTokenHandler.generateFeignToken();
            request.setHeader("Authorization", proxyToken);
        }
        return request;
    }

    private Response post(String url, String params, String headerStr, BpmCallLog callLog, Map<String, String> mapHeader, String requestType, Map<String, Object> conditionMap) throws ClientProtocolException, IOException {
        Response response;
        Request request;
        HashMap microServiceMap = Maps.newHashMap();
        List result = this.portalFeignService.getServiceList();
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            for (ObjectNode on : result) {
                microServiceMap.put(on.get("sysCode").asText(), on.get("rootAddress").asText());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)callLog.getParams())) {
            microServiceMap.putAll(JsonUtil.toMap((String)callLog.getParams()));
        }
        url = this.formatUrl(url, microServiceMap);
        callLog.setHeader(headerStr);
        callLog.setParams(params);
        callLog.setUrl(url);
        if ("GET".equalsIgnoreCase(requestType)) {
            if (conditionMap != null) {
                StringBuilder urlBuilder = new StringBuilder(url);
                for (String key : conditionMap.keySet()) {
                    Object value = conditionMap.get(key);
                    if (value == null) continue;
                    if (urlBuilder.toString().contains("?")) {
                        urlBuilder.append("&");
                    } else {
                        urlBuilder.append("?");
                    }
                    urlBuilder.append(key).append("=").append(value.toString());
                }
                url = urlBuilder.toString();
            }
            request = Request.Get((String)url);
            request = this.setRequestHeader(request, headerStr, mapHeader);
            response = request.execute();
        } else {
            request = Request.Post((String)url);
            request = this.setRequestHeader(request, headerStr, mapHeader);
            response = request.bodyString(Optional.ofNullable(callLog.getParams()).orElse("{}"), ContentType.APPLICATION_JSON).execute();
        }
        return response;
    }

    private Request setRequestHeader(Request request, String headerStr, Map<String, String> mapHeader) {
        request = this.setHeaders(request, headerStr);
        if (mapHeader != null && mapHeader.size() > 0) {
            for (String key : mapHeader.keySet()) {
                request.setHeader(key, mapHeader.get(key));
            }
        }
        return request;
    }

    private String formatUrl(String url, Map<String, String> params) {
        Pattern pattern = Pattern.compile("(\\$\\{[^\\}]+})");
        Matcher matcher = pattern.matcher(url);
        while (matcher.find()) {
            String group = matcher.group(1);
            String paramName = this.formatParamName(group);
            url = url.replace("${" + paramName + "}", params.getOrDefault(paramName, ""));
        }
        return url;
    }

    private String formatParamName(String group) {
        return group.replaceAll("\\$", "").replaceAll("\\{", "").replaceAll("\\}", "");
    }

    private void buildCallLog(BpmCallLog callLog) {
        try {
            if (StringUtil.isNotEmpty((String)callLog.getResponse()) && callLog.getResponse().length() > 1999) {
                callLog.setResponse(callLog.getResponse().substring(0, 1999));
            }
            callLog.setRetryCount(0);
            callLog.setElapsedTime((double)DateUtil.getTime((LocalDateTime)callLog.getCallTime(), (LocalDateTime)LocalDateTime.now()) / 1000.0);
            this.setThreadMethod("call_log", () -> this.bpmCallLogManager.save((Object)callLog));
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58restful\u63a5\u53e3\u4e8b\u4ef6\u8c03\u7528\u65e5\u5fd7\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private boolean isGlobalNode(Object object, String callNodes, EventType eventType) {
        if (object instanceof BpmDelegateExecution) {
            return this.isGlobalNode((BpmDelegateExecution)object, callNodes, eventType);
        }
        if (object instanceof BpmTask) {
            return this.isGlobalNode((BpmTask)object, callNodes, eventType);
        }
        return false;
    }

    private boolean isGlobalNode(BpmDelegateExecution execution, String callNodes, EventType eventType) {
        String nodeId;
        if (EventType.START_EVENT.getKey().equals(eventType.getKey()) || EventType.END_EVENT.getKey().equals(eventType.getKey())) {
            return true;
        }
        if (execution.isEnded()) {
            return true;
        }
        String string = nodeId = StringUtil.isNotEmpty((String)execution.getNodeId()) ? execution.getNodeId() : "";
        if (StringUtil.isNotEmpty((String)nodeId)) {
            return StringUtil.isEmpty((String)callNodes) || callNodes.contains(nodeId);
        }
        return true;
    }

    private boolean isGlobalNode(BpmTask bpmTask, String callNodes, EventType eventType) {
        String nodeId;
        if (EventType.START_EVENT.getKey().equals(eventType.getKey()) || EventType.END_EVENT.getKey().equals(eventType.getKey())) {
            return true;
        }
        String string = nodeId = StringUtil.isNotEmpty((String)bpmTask.getNodeId()) ? bpmTask.getNodeId() : "";
        if (StringUtil.isNotEmpty((String)nodeId)) {
            return StringUtil.isEmpty((String)callNodes) || callNodes.contains(nodeId);
        }
        return true;
    }

    private RestfulParam genartor(Object object, EventType eventType) {
        if (object instanceof BpmDelegateExecution) {
            return this.genartor((BpmDelegateExecution)object, eventType);
        }
        if (object instanceof BpmTask) {
            return this.genartor((BpmTask)object, eventType);
        }
        if (object instanceof BpmDelegateTask) {
            return this.genartor((BpmDelegateTask)object, eventType);
        }
        return null;
    }

    private RestfulParam genartor(BpmDelegateExecution execution, EventType eventType) {
        DefaultBpmProcessInstance defaultBpmProcessInstance;
        BpmDelegateTask delegateTask;
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        RestfulParam param = new RestfulParam();
        String instId = (String)execution.getVariable("instanceId_");
        param.setActionName(taskCmd.getActionName());
        param.setNodeId(execution.getNodeId());
        param.setNodeName(execution.getNodeName());
        param.setOption(taskCmd.getApprovalOpinion());
        if ((EventType.TASK_COMPLETE_EVENT.equals((Object)eventType) || EventType.TASK_CREATE_EVENT.equals((Object)eventType)) && BeanUtils.isNotEmpty((Object)(delegateTask = (BpmDelegateTask)taskCmd.getVariables().get("restful_task")))) {
            param.setNodeId(delegateTask.getTaskDefinitionKey());
            param.setNodeName(delegateTask.getName());
            param.setTaskId(delegateTask.getId());
            param.setCandidate(this.getCandidates(delegateTask, eventType));
            if (EventType.TASK_COMPLETE_EVENT.equals((Object)eventType)) {
                param.setAssignee(this.getBpmIdentityResult(ContextUtil.getCurrentUserId()));
            }
        }
        if (BeanUtils.isEmpty((Object)(defaultBpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId)))) && BeanUtils.isEmpty((Object)(defaultBpmProcessInstance = (DefaultBpmProcessInstance)taskCmd.getTransitVars("processInstance")))) {
            return param;
        }
        String bpmnInstId = defaultBpmProcessInstance.getBpmnInstId();
        if (StringUtil.isNotEmpty((String)bpmnInstId)) {
            Map<String, Object> variables = this.natProInstanceService.getVariables(bpmnInstId);
            param.setVars(variables);
        }
        this.setBoData(param, defaultBpmProcessInstance);
        param.setSubject(defaultBpmProcessInstance.getSubject());
        param.setInstId(instId);
        param.setProcDefId(defaultBpmProcessInstance.getProcDefId());
        param.setFlowKey(defaultBpmProcessInstance.getProcDefKey());
        param.setBusinesskey(defaultBpmProcessInstance.getBizKey());
        param.setSysCode(defaultBpmProcessInstance.getSysCode());
        param.setCreateTime(defaultBpmProcessInstance.getCreateTime());
        param.setProcDefName(defaultBpmProcessInstance.getProcDefName());
        param.setCreator(this.getBpmIdentityResult(defaultBpmProcessInstance.getCreateBy()));
        return param;
    }

    private RestfulParam genartor(BpmTask task, EventType eventType) {
        RestfulParam param = new RestfulParam();
        String instId = task.getProcInstId();
        param.setSubject(task.getSubject());
        param.setNodeId(task.getNodeId());
        param.setNodeName(task.getName());
        param.setTaskId(task.getId());
        param.setActionName(task.getStatus());
        if (EventType.TASK_COMPLETE_EVENT.equals((Object)eventType)) {
            param.setAssignee(this.getBpmIdentityResult(task.getAssigneeId()));
        }
        ArrayList<BpmIdentityResult> candidates = new ArrayList<BpmIdentityResult>();
        candidates.add(this.getBpmIdentityResult(task.getAssigneeId()));
        param.setCandidate(candidates);
        this.completeInstInfo(instId, param);
        return param;
    }

    private RestfulParam genartor(BpmDelegateTask delegateTask, EventType eventType) {
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        RestfulParam param = new RestfulParam();
        String instId = (String)delegateTask.getVariable("instanceId_");
        try {
            param.setSubject((String)delegateTask.getVariable("subject_"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        param.setNodeId(delegateTask.getTaskDefinitionKey());
        param.setNodeName(delegateTask.getName());
        param.setTaskId(delegateTask.getId());
        param.setActionName(taskCmd.getActionName());
        if (EventType.TASK_COMPLETE_EVENT.equals((Object)eventType)) {
            param.setAssignee(this.getBpmIdentityResult(ContextUtil.getCurrentUserId()));
        }
        param.setCandidate(this.getCandidates(delegateTask, eventType));
        this.completeInstInfo(instId, param);
        return param;
    }

    private void completeInstInfo(String instId, RestfulParam param) {
        DefaultBpmProcessInstance defaultBpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        this.setBoData(param, defaultBpmProcessInstance);
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        if (BeanUtils.isEmpty((Object)defaultBpmProcessInstance) && BeanUtils.isEmpty((Object)(defaultBpmProcessInstance = (DefaultBpmProcessInstance)taskCmd.getTransitVars("processInstance")))) {
            return;
        }
        if (BeanUtils.isNotEmpty((Object)taskCmd)) {
            Map<String, Object> variables = taskCmd.getVariables();
            param.setVars(variables);
        }
        param.setInstId(instId);
        param.setProcDefId(defaultBpmProcessInstance.getProcDefId());
        param.setFlowKey(defaultBpmProcessInstance.getProcDefKey());
        param.setBusinesskey(defaultBpmProcessInstance.getBizKey());
        param.setSysCode(defaultBpmProcessInstance.getSysCode());
        param.setCreateTime(defaultBpmProcessInstance.getCreateTime());
        param.setProcDefName(defaultBpmProcessInstance.getProcDefName());
        param.setCreator(this.getBpmIdentityResult(defaultBpmProcessInstance.getCreateBy()));
    }

    private void setBoData(RestfulParam param, DefaultBpmProcessInstance instance) {
        try {
            if (BeanUtils.isNotEmpty((Object)instance)) {
                List<ObjectNode> boDatas = this.boDataService.getDataByInst(instance);
                ObjectNode jsondata = (ObjectNode)BoDataUtil.hanlerData(boDatas);
                param.setBoData(JsonUtil.toJson((Object)jsondata));
            }
        }
        catch (Exception e) {
            System.out.println("\u83b7\u53d6bo\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private BpmIdentityResult getBpmIdentityResult(String userId) {
        BpmIdentityResult bpmIdentity = null;
        try {
            IUser user;
            if (StringUtil.isNotEmpty((String)userId) && BeanUtils.isNotEmpty((Object)(user = this.userServiceImpl.getUserById(userId)))) {
                bpmIdentity = new BpmIdentityResult(user);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bpmIdentity;
    }

    private List<BpmIdentityResult> getCandidates(BpmDelegateTask delegateTask, EventType eventType) {
        ArrayList<BpmIdentityResult> list;
        block12: {
            list = new ArrayList<BpmIdentityResult>();
            try {
                if (EventType.TASK_COMPLETE_EVENT.equals((Object)eventType)) {
                    List<BpmIdentity> bpmIdentitys = this.bpmIdentityService.queryByTask(delegateTask.getId());
                    if (!BeanUtils.isNotEmpty(bpmIdentitys)) break block12;
                    for (BpmIdentity bpmIdentity : bpmIdentitys) {
                        if (!"user".equals(bpmIdentity.getType())) {
                            List userList = this.userServiceImpl.getUserListByGroup(bpmIdentity.getGroupType(), bpmIdentity.getId(), bpmIdentity.getCode());
                            for (IUser iUser : userList) {
                                list.add(new BpmIdentityResult(iUser));
                            }
                            continue;
                        }
                        BpmIdentityResult identityResult = this.getBpmIdentityResult(bpmIdentity.getId());
                        if (!BeanUtils.isNotEmpty((Object)identityResult)) continue;
                        list.add(identityResult);
                    }
                    break block12;
                }
                String nodeId = delegateTask.getTaskDefinitionKey();
                ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
                List<Object> identityList = new ArrayList();
                Map nodeUsers = (Map)taskCmd.getTransitVars("bpm_node_users_");
                if (taskCmd.getTransitVars("bpm_next_node_users_") != null) {
                    identityList = (List)taskCmd.getTransitVars("bpm_next_node_users_");
                }
                if (nodeUsers != null && nodeUsers.containsKey(nodeId)) {
                    identityList = (List)nodeUsers.get(nodeId);
                }
                if (BeanUtils.isEmpty(identityList)) {
                    identityList = delegateTask.getExecutors();
                }
                if (BeanUtils.isEmpty(identityList)) {
                    Map<String, List<BpmIdentity>> identityMap = taskCmd.getBpmIdentities();
                    identityList = identityMap.get(nodeId);
                }
                if (BeanUtils.isNotEmpty(identityList)) {
                    identityList = this.extractService.extractBpmIdentity(identityList);
                }
                for (BpmIdentity bpmIdentity : identityList) {
                    list.add(this.getBpmIdentityResult(bpmIdentity.getId()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    class RestfulParam {
        private long timestamp;
        private String procDefId;
        private String flowKey;
        private String instId;
        private String taskId;
        private String nodeId;
        private String nodeName;
        private String eventType;
        private String businesskey;
        private String sysCode;
        private String procDefName;
        private BpmIdentityResult creator;
        private BpmIdentityResult assignee;
        private List<BpmIdentityResult> candidate;
        private String actionName;
        private String nodeType;
        private LocalDateTime createTime;
        private LocalDateTime completeTime;
        private String subject;
        private String boData;
        private Map<String, Object> vars;
        private Object postParams;
        private String option;

        RestfulParam() {
        }

        public String getOption() {
            return this.option;
        }

        public void setOption(String option) {
            this.option = option;
        }

        public Object getPostParams() {
            return this.postParams;
        }

        public void setPostParams(Object postParams) {
            this.postParams = postParams;
        }

        public String getFlowKey() {
            return this.flowKey;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public void setFlowKey(String flowKey) {
            this.flowKey = flowKey;
        }

        public String getEventType() {
            return this.eventType;
        }

        public void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public String getProcDefId() {
            return this.procDefId;
        }

        public void setProcDefId(String procDefId) {
            this.procDefId = procDefId;
        }

        public String getInstId() {
            return this.instId;
        }

        public void setInstId(String instId) {
            this.instId = instId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public String getBusinesskey() {
            return this.businesskey;
        }

        public void setBusinesskey(String businesskey) {
            this.businesskey = businesskey;
        }

        public String getSysCode() {
            return this.sysCode;
        }

        public void setSysCode(String sysCode) {
            this.sysCode = sysCode;
        }

        public String getProcDefName() {
            return this.procDefName;
        }

        public void setProcDefName(String procDefName) {
            this.procDefName = procDefName;
        }

        public BpmIdentityResult getCreator() {
            return this.creator;
        }

        public void setCreator(BpmIdentityResult creator) {
            this.creator = creator;
        }

        public BpmIdentityResult getAssignee() {
            return this.assignee;
        }

        public void setAssignee(BpmIdentityResult assignee) {
            this.assignee = assignee;
        }

        public List<BpmIdentityResult> getCandidate() {
            return this.candidate;
        }

        public void setCandidate(List<BpmIdentityResult> candidate) {
            this.candidate = candidate;
        }

        public LocalDateTime getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(LocalDateTime localDateTime) {
            this.createTime = localDateTime;
        }

        public LocalDateTime getCompleteTime() {
            return this.completeTime;
        }

        public void setCompleteTime(LocalDateTime completeTime) {
            this.completeTime = completeTime;
        }

        public String getActionName() {
            return this.actionName;
        }

        public void setActionName(String actionName) {
            this.actionName = actionName;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public Map<String, Object> getVars() {
            return this.vars;
        }

        public void setVars(Map<String, Object> vars) {
            this.vars = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : vars.entrySet()) {
                String canonicalName;
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value != null && value instanceof Object && (canonicalName = value.getClass().getCanonicalName()).endsWith("BpmDelegateTaskImpl")) continue;
                this.vars.put(key, value);
            }
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getBoData() {
            return this.boData;
        }

        public void setBoData(String boData) {
            this.boData = boData;
        }
    }
}

