/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.engine.task.skip;

import cn.hutool.core.collection.CollUtil;
import com.hotent.base.util.AppUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.inst.ISkipCondition;
import com.hotent.bpm.api.model.delegate.BpmDelegateTask;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.service.BpmAgentService;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.natapi.task.NatTaskService;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.uc.api.model.IUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SkipConditionUtil {
    private static Map<String, ISkipCondition> conditionMap = new HashMap<String, ISkipCondition>();

    public static List<ISkipCondition> getSkipConditions() {
        List list = (List)AppUtil.getBean((String)"skipRules");
        return list;
    }

    public static ISkipCondition getSkipConditionByType(String type) {
        return conditionMap.get(type.toLowerCase());
    }

    public static String getTitleByType(String type) {
        ISkipCondition condition = conditionMap.get(type.toLowerCase());
        return condition.getTitle();
    }

    public static String getOpinion(DefaultBpmTask task, String type) {
        ISkipCondition condition = conditionMap.get(type.toLowerCase());
        return condition.getOpinion(task);
    }

    public static List<IUser> convertUserAgent(List<IUser> userList, String taskId) {
        try {
            ArrayList<IUser> userListCvt = new ArrayList<IUser>();
            if (CollUtil.isNotEmpty(userList)) {
                BpmAgentService bpmAgentService = (BpmAgentService)AppUtil.getBean(BpmAgentService.class);
                BpmDelegateTask bpmDelegateTask = SkipConditionUtil.getBpmDelegateTask(taskId);
                if (bpmDelegateTask != null) {
                    Map<String, Object> vars = bpmDelegateTask.getVariables();
                    for (IUser user : userList) {
                        IUser agent = bpmAgentService.getAgent(user.getUserId(), bpmDelegateTask, vars);
                        userListCvt.add(agent != null ? agent : user);
                    }
                } else {
                    userListCvt = new ArrayList<IUser>(userList);
                }
            }
            return userListCvt;
        }
        catch (Exception ignore) {
            return userList;
        }
    }

    public static List<BpmIdentity> convertIdentityAgent(List<BpmIdentity> identityList, String taskId) {
        try {
            ArrayList<BpmIdentity> userListCvt = new ArrayList<BpmIdentity>();
            if (CollUtil.isNotEmpty(identityList)) {
                BpmAgentService bpmAgentService = (BpmAgentService)AppUtil.getBean(BpmAgentService.class);
                BpmDelegateTask bpmDelegateTask = SkipConditionUtil.getBpmDelegateTask(taskId);
                if (bpmDelegateTask != null) {
                    Map<String, Object> vars = bpmDelegateTask.getVariables();
                    for (BpmIdentity identity : identityList) {
                        IUser agent = bpmAgentService.getAgent(identity.getId(), bpmDelegateTask, vars);
                        if (agent == null) {
                            userListCvt.add(identity);
                            continue;
                        }
                        DefaultBpmIdentity identityAgent = new DefaultBpmIdentity(agent);
                        userListCvt.add(identityAgent);
                    }
                } else {
                    userListCvt = new ArrayList<BpmIdentity>(identityList);
                }
            }
            return userListCvt;
        }
        catch (Exception ignore) {
            return identityList;
        }
    }

    private static BpmDelegateTask getBpmDelegateTask(String taskId) {
        BpmDelegateTask bpmDelegateTask = null;
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        if (actionCmd != null && actionCmd.getVariables() != null && actionCmd.getVariables().containsKey("restful_task")) {
            bpmDelegateTask = (BpmDelegateTask)actionCmd.getVariables().get("restful_task");
        }
        if (bpmDelegateTask == null) {
            NatTaskService natTaskService = (NatTaskService)AppUtil.getBean(NatTaskService.class);
            bpmDelegateTask = natTaskService.getByTaskId(taskId);
        }
        return bpmDelegateTask;
    }

    static {
        List list = (List)AppUtil.getBean((String)"skipRules");
        for (ISkipCondition condition : list) {
            conditionMap.put(condition.getType().toLowerCase(), condition);
        }
    }
}

