/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.helper.identity;

import com.hotent.base.exception.BaseException;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.bpm.api.helper.identity.BpmIdentityConverter;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.model.IUser;
import com.hotent.uc.api.service.IUserGroupService;
import com.hotent.uc.api.service.IUserService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DefaultBpmIdentityConverter
implements BpmIdentityConverter {
    @Resource
    IUserService userServiceImpl;
    @Resource
    IUserGroupService userGroupService;

    @Override
    public BpmIdentity convertUser(IUser user) {
        if (user == null) {
            return null;
        }
        DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
        bpmIdentity.setId(user.getUserId());
        bpmIdentity.setName(user.getFullname());
        bpmIdentity.setCode(user.getAccount());
        bpmIdentity.setType("user");
        return bpmIdentity;
    }

    @Override
    public List<BpmIdentity> convertUserList(List<IUser> userList) {
        ArrayList<BpmIdentity> bpmIdentities = new ArrayList<BpmIdentity>();
        for (IUser user : userList) {
            if (user == null) continue;
            BpmIdentity bpmIdentity = this.convertUser(user);
            bpmIdentities.add(bpmIdentity);
        }
        return bpmIdentities;
    }

    @Override
    public BpmIdentity convertGroup(IGroup group) {
        if (group == null) {
            return null;
        }
        DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
        bpmIdentity.setId(group.getGroupId());
        bpmIdentity.setName(group.getName());
        bpmIdentity.setCode(group.getGroupCode());
        bpmIdentity.setType("group");
        bpmIdentity.setGroupType(group.getGroupType());
        return bpmIdentity;
    }

    @Override
    public List<BpmIdentity> convertGroupList(List<IGroup> groupList) {
        ArrayList<BpmIdentity> bpmIdentities = new ArrayList<BpmIdentity>();
        for (IGroup group : groupList) {
            if (group == null) continue;
            BpmIdentity bpmIdentity = this.convertGroup(group);
            bpmIdentities.add(bpmIdentity);
        }
        return bpmIdentities;
    }

    @Override
    public BpmIdentity convert(String type, String id) {
        DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
        bpmIdentity.setId(id);
        bpmIdentity.setGroupType(type);
        bpmIdentity.setType(type);
        if ("job".equals(type) || "role".equals(type) || "org".equals(type) || "org".equals(type)) {
            bpmIdentity.setType("group");
        }
        return bpmIdentity;
    }

    @Override
    public BpmIdentity convertValue(String type, String id) {
        DefaultBpmIdentity bpmIdentity = new DefaultBpmIdentity();
        if ("user".equalsIgnoreCase(type)) {
            IUser user = this.userServiceImpl.getUserById(id);
            bpmIdentity.setType(type);
            if (user != null) {
                bpmIdentity.setName(user.getFullname());
            }
        } else {
            IGroup group = this.userGroupService.getGroupByIdOrCode(type, id);
            if (BeanUtils.isEmpty((Object)group)) {
                if ("true".equals(ThreadMsgUtil.getMapMsg((String)"group_deleted"))) {
                    return null;
                }
                throw new BaseException(String.format("\u6ca1\u6709\u83b7\u53d6\u5230\u7528\u6237\u7ec4\uff1a%s\u4e2did\u4e3a\uff1a%s\u7684\u6570\u636e\u3002", type, id));
            }
            bpmIdentity.setType("group");
            bpmIdentity.setGroupType(group.getGroupType());
            bpmIdentity.setName(group.getName());
        }
        bpmIdentity.setId(id);
        return bpmIdentity;
    }
}

