/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.enums.CommonEnum;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.model.BoDataModifyRecord;
import com.hotent.bpm.persistence.dao.BoDataModifyRecordDao;
import com.hotent.bpm.persistence.manager.BoDataModifyRecordManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="boDataModifyRecordManager")
public class BoDataModifyRecordManagerImpl
extends BaseManagerImpl<BoDataModifyRecordDao, BoDataModifyRecord>
implements BoDataModifyRecordManager {
    @Resource
    BoDataModifyRecordDao boDataModifyRecordDao;
    @Resource
    private BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    private BpmDefinitionManager bpmDefinitionManager;

    @Override
    public void handleBoDateModify(Map<String, Object> params) throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        String modifyRes = "";
        String refId = "";
        String boAlias = "";
        JsonNode boResult = JsonUtil.toJsonNode((Object)params.get("boResult"));
        for (JsonNode objectNode : boResult) {
            if (!objectNode.hasNonNull("modifyDetail") || !StringUtil.isNotEmpty((String)objectNode.get("modifyDetail").asText())) continue;
            modifyRes = JsonUtil.getString((JsonNode)objectNode, (String)"modifyDetail", (String)"");
            refId = JsonUtil.getString((JsonNode)objectNode, (String)"pk", (String)"");
            boAlias = JsonUtil.getString((JsonNode)objectNode, (String)"boAlias", (String)"");
            break;
        }
        if (StringUtil.isEmpty((String)modifyRes)) {
            return;
        }
        BoDataModifyRecord record = new BoDataModifyRecord();
        if (StringUtil.isNotEmpty((String)refId)) {
            record.setRefId(refId);
        }
        if (StringUtil.isNotEmpty((String)boAlias)) {
            record.setBoAlias(boAlias);
        }
        if (BeanUtils.isNotEmpty((Object)params.get("data"))) {
            record.setData(JsonUtil.toJson((Object)params.get("data")));
        }
        record.setUserId(currentUser.getUserId());
        record.setUserName(currentUser.getFullname());
        record.setDetail(modifyRes);
        record.setModifyTime(LocalDateTime.now());
        this.create((Model)record);
    }

    @Override
    public List<BoDataModifyRecord> getListByRefId(String refId) {
        return this.boDataModifyRecordDao.getListByRefId(refId);
    }

    @Override
    public boolean checkShowModifyRecordByInstId(String instId) {
        DefaultBpmProcessInstance bpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
        DefaultBpmDefinition defaultBpmDefinition = (DefaultBpmDefinition)this.bpmDefinitionManager.get((Serializable)((Object)bpmProcessInstance.getProcDefId()));
        return defaultBpmDefinition == null || !CommonEnum.YesOrNo.NO.getValue().equals(defaultBpmDefinition.getShowModifyRecord());
    }

    @Override
    public void batchHandleBoDateModify(List<Map<String, Object>> params) throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        ArrayList<BoDataModifyRecord> records = new ArrayList<BoDataModifyRecord>();
        for (Map<String, Object> param : params) {
            JsonNode boResult = JsonUtil.toJsonNode((Object)param.get("boResult"));
            String modifyRes = "";
            String refId = "";
            String boAlias = "";
            for (JsonNode objectNode : boResult) {
                if (!objectNode.hasNonNull("modifyDetail") || !StringUtil.isNotEmpty((String)objectNode.get("modifyDetail").asText())) continue;
                modifyRes = JsonUtil.getString((JsonNode)objectNode, (String)"modifyDetail", (String)"");
                refId = JsonUtil.getString((JsonNode)objectNode, (String)"pk", (String)"");
                boAlias = JsonUtil.getString((JsonNode)objectNode, (String)"boAlias", (String)"");
                break;
            }
            if (StringUtil.isEmpty((String)modifyRes)) continue;
            BoDataModifyRecord record = new BoDataModifyRecord();
            if (StringUtil.isNotEmpty((String)refId)) {
                record.setRefId(refId);
            }
            if (StringUtil.isNotEmpty((String)boAlias)) {
                record.setBoAlias(boAlias);
            }
            if (BeanUtils.isNotEmpty((Object)param.get("data"))) {
                record.setData(JsonUtil.toJson((Object)param.get("data")));
            }
            record.setUserId(currentUser.getUserId());
            record.setUserName(currentUser.getFullname());
            record.setDetail(modifyRes);
            record.setModifyTime(LocalDateTime.now());
            records.add(record);
        }
        this.saveBatch(records);
    }
}

