/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.jwt.JwtTokenHandler;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.HttpUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.persistence.dao.BpmCallLogDao;
import com.hotent.bpm.persistence.manager.BpmCallLogManager;
import com.hotent.bpm.persistence.model.BpmCallLog;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmCallLogManager")
public class BpmCallLogManagerImpl
extends BaseManagerImpl<BpmCallLogDao, BpmCallLog>
implements BpmCallLogManager {
    @Resource
    BpmCallLogDao bpmCallLogDao;
    @Autowired
    PortalFeignService portalFeignService;

    @Override
    @Transactional
    public void reinvoke(String id) throws Exception {
        BpmCallLog bpmCallLog = (BpmCallLog)this.get((Serializable)((Object)id));
        try {
            String response = this.reinvokeByLog(bpmCallLog);
            bpmCallLog.setResponse(response);
            int time = BeanUtils.isEmpty((Object)bpmCallLog.getRetryCount()) ? 0 : bpmCallLog.getRetryCount();
            bpmCallLog.setRetryCount(time + 1);
            bpmCallLog.setIsSuccess(BpmCallLog.SUCCESS_YES);
            this.update((Model)bpmCallLog);
        }
        catch (Exception e) {
            bpmCallLog.setIsSuccess(BpmCallLog.SUCCESS_NO);
            this.update((Model)bpmCallLog);
            throw new WorkFlowException("\u91cd\u8c03\u5931\u8d25\uff1a" + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    @Override
    @Transactional
    public void signSuccess(String id) {
        BpmCallLog bpmCallLog = (BpmCallLog)this.get((Serializable)((Object)id));
        if (BeanUtils.isNotEmpty((Object)((Object)bpmCallLog))) {
            bpmCallLog.setIsSuccess(BpmCallLog.SUCCESS_YES);
            this.update((Model)bpmCallLog);
        }
    }

    private String reinvokeByLog(BpmCallLog bpmCallLog) throws Exception {
        String url = bpmCallLog.getUrl();
        if (url.startsWith("apiAlias:")) {
            String alias = url.replace("apiAlias:", "");
            Object result = this.portalFeignService.executeIntefaceJob(alias, null, null, bpmCallLog.getParams());
            return JsonUtil.toJsonString((Object)result);
        }
        HashMap microServiceMap = Maps.newHashMap();
        List result = this.portalFeignService.getServiceList();
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            for (ObjectNode on : result) {
                microServiceMap.put(on.get("sysCode").asText(), on.get("rootAddress").asText());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)bpmCallLog.getParams())) {
            microServiceMap.putAll(JsonUtil.toMap((String)bpmCallLog.getParams()));
        }
        url = this.formatUrl(url, microServiceMap);
        Request request = Request.Post((String)url);
        request = this.setHeaders(request, bpmCallLog.getHeader());
        String response = request.bodyString(Optional.ofNullable(bpmCallLog.getParams()).orElse("{}"), ContentType.APPLICATION_JSON).execute().returnContent().toString();
        return response;
    }

    private String formatUrl(String url, Map<String, String> params) {
        Pattern pattern = Pattern.compile("(\\$\\{[^\\}]+})");
        Matcher matcher = pattern.matcher(url);
        while (matcher.find()) {
            String group = matcher.group(1);
            String paramName = this.formatParamName(group);
            url = url.replace("${" + paramName + "}", params.getOrDefault(paramName, ""));
        }
        return url;
    }

    private String formatParamName(String group) {
        return group.replaceAll("\\$", "").replaceAll("\\{", "").replaceAll("\\}", "");
    }

    private Request setHeaders(Request request, String headerStr) {
        boolean hasAuthorization = false;
        if (StringUtil.isNotEmpty((String)headerStr)) {
            try {
                headerStr = Base64.getFromBase64((String)headerStr);
                if (StringUtil.isEmpty((String)headerStr) || "\"\"".equals(headerStr)) {
                    HttpServletRequest req = HttpUtil.getRequest();
                    if (req != null) {
                        request.setHeader("Authorization", req.getHeader("Authorization"));
                    }
                    return request;
                }
                ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode((String)headerStr);
                Iterator it = obj.fieldNames();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    request.setHeader(key, obj.get(key).asText());
                    if (!StringUtils.equals((CharSequence)key, (CharSequence)"Authorization")) continue;
                    hasAuthorization = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!hasAuthorization) {
            JwtTokenHandler jwtTokenHandler = (JwtTokenHandler)AppUtil.getBean(JwtTokenHandler.class);
            String proxyToken = "Bearer " + jwtTokenHandler.generateFeignToken();
            request.setHeader("Authorization", proxyToken);
        }
        return request;
    }
}

