/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.feign.FormFeignService;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.manager.CommonManager;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.Dom4jUtil;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.MapUtil;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bpm.api.constant.DesignerType;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.event.BpmDefinitionDelEvent;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.BpmDefinition;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.CallActivityNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.extmodel.FormExt;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.api.service.BpmInstService;
import com.hotent.bpm.api.service.BpmTaskService;
import com.hotent.bpm.api.service.DiagramService;
import com.hotent.bpm.engine.def.DefXmlTransForm;
import com.hotent.bpm.engine.def.impl.DefaultBpmDefConditionService;
import com.hotent.bpm.model.BpmFreeProcessDef;
import com.hotent.bpm.model.BpmNodeSetting;
import com.hotent.bpm.model.form.BpmForm;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.natapi.def.DefTransform;
import com.hotent.bpm.natapi.def.NatProDefinitionService;
import com.hotent.bpm.params.SearchDefNodeVO;
import com.hotent.bpm.persistence.dao.BpmDefinitionDao;
import com.hotent.bpm.persistence.dao.BpmProcessInstanceDao;
import com.hotent.bpm.persistence.manager.ActExecutionManager;
import com.hotent.bpm.persistence.manager.BpmDefAuthorizeManager;
import com.hotent.bpm.persistence.manager.BpmDefDataManager;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmFreeProcessDefManager;
import com.hotent.bpm.persistence.manager.BpmInstFormManager;
import com.hotent.bpm.persistence.manager.BpmNodeSettingManager;
import com.hotent.bpm.persistence.manager.BpmProBoManager;
import com.hotent.bpm.persistence.manager.BpmProStatusManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmSecretaryManageManager;
import com.hotent.bpm.persistence.manager.BpmTaskCandidateManager;
import com.hotent.bpm.persistence.manager.BpmTaskNoticeDoneManager;
import com.hotent.bpm.persistence.manager.BpmTaskNoticeManager;
import com.hotent.bpm.persistence.manager.BpmTaskTurnManager;
import com.hotent.bpm.persistence.model.AuthorizeRight;
import com.hotent.bpm.persistence.model.BpmDefData;
import com.hotent.bpm.persistence.model.BpmProBo;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.query.BpmDefFieldSorts;
import com.hotent.bpm.persistence.model.query.BpmDefQueryFields;
import com.hotent.bpm.persistence.util.BpmnXmlValidateUtil;
import com.hotent.bpm.plugin.task.userassign.UserDefBpmDefXmlHandler;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import io.seata.spring.annotation.GlobalTransactional;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Clob;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Workbook;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.XPath;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMCDATA;
import org.dom4j.dom.DOMElement;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import poi.easypoi.util.ExcelUtils;
import poi.util.ExcelUtil;

@Service
public class BpmDefinitionManagerImpl
extends BaseManagerImpl<BpmDefinitionDao, DefaultBpmDefinition>
implements BpmDefinitionManager {
    private final Log logger = LogFactory.getLog(this.getClass());
    @Resource
    BpmDefinitionDao bpmDefinitionDao;
    @Resource
    BpmDefDataManager bpmDefDataManager;
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    NatProDefinitionService natProDefinitionService;
    @Resource
    DefXmlTransForm defXmlTransForm;
    @Resource
    BpmDefAuthorizeManager bpmDefAuthorizeManager;
    @Resource
    BpmProBoManager bpmProBoManager;
    @Resource
    FormFeignService formRestfulService;
    @Resource
    DefaultBpmDefConditionService bpmDefHandler;
    @Resource
    BpmTaskNoticeManager bpmTaskNoticeManager;
    @Resource
    BpmTaskNoticeDoneManager bpmTaskNoticeDoneManager;
    @Resource
    BpmTaskTurnManager bpmTaskTurnManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmProcessInstanceDao bpmProcessInstanceDao;
    @Resource
    BpmInstFormManager bpmInstFromManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    DiagramService diagramService;
    @Resource
    BpmTaskService bpmTaskService;
    @Resource
    CommonManager commonManager;
    @Resource
    ActExecutionManager actExecutionManager;
    @Resource
    BpmTaskCandidateManager bpmTaskCandidateManager;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    FormFeignService formFeignService;
    @Resource
    BpmFreeProcessDefManager bpmFreeProcessDefManager;
    @Resource
    BpmNodeSettingManager bpmNodeSettingManager;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    PortalFeignService portalFeignService;

    private void addCache(DefaultBpmDefinition def) {
        Assert.notNull((Object)def, (String)"\u6d41\u7a0b\u5b9a\u4e49\u4e3a\u7a7a");
        String defId = def.getDefId();
        BpmDefinitionManagerImpl bean = (BpmDefinitionManagerImpl)AppUtil.getBean(this.getClass());
        bean.putDefInCache(def);
        bean.putBpmnDefIdInCache(def.getBpmnDefId(), defId);
        if (def.isMain()) {
            bean.putFlowKeyInCache(def.getDefKey(), defId);
        }
    }

    @CachePut(value={"eip:bpm:definition"}, key="#def.defId")
    protected DefaultBpmDefinition putDefInCache(DefaultBpmDefinition def) {
        return def;
    }

    @CachePut(value={"eip:bpm:definitionBpmnId"}, key="#bpmnDefId")
    protected String putBpmnDefIdInCache(String bpmnDefId, String defId) {
        return defId;
    }

    @CachePut(value={"eip:bpm:definitionFlowKey"}, key="#flowKey")
    protected String putFlowKeyInCache(String flowKey, String defId) {
        return defId;
    }

    @Cacheable(value={"eip:bpm:definition"}, key="#defId")
    protected DefaultBpmDefinition getFromCache(String defId) {
        return null;
    }

    @Cacheable(value={"eip:bpm:definitionBpmnId"}, key="#bpmnDefId")
    protected String getDefIdByBpmnIdFromCache(String bpmnDefId) {
        return null;
    }

    private void publishEvent(BpmDefinition def) {
        List<DefaultBpmDefinition> defList = this.bpmDefinitionDao.getByDefKey(def.getDefKey());
        for (DefaultBpmDefinition defEntity : defList) {
            AppUtil.publishEvent((ApplicationEvent)new BpmDefinitionDelEvent(defEntity));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DefaultBpmDefinition getById(String entityId) {
        BpmDefData bpmDefData;
        LinkedHashSet mapMsg2 = ThreadMsgUtil.getMapMsg2((String)"null_definition");
        if (StringUtil.isEmpty((String)entityId) || mapMsg2 != null && mapMsg2.contains(entityId)) {
            return null;
        }
        BpmDefinitionManagerImpl bean = (BpmDefinitionManagerImpl)AppUtil.getBean(this.getClass());
        DefaultBpmDefinition bpmDef = bean.getFromCache(entityId);
        if (bpmDef != null) {
            return bpmDef;
        }
        DefaultBpmDefinition defaultBpmDefinition = (DefaultBpmDefinition)this.get((Serializable)((Object)entityId));
        boolean flag = false;
        if (BeanUtils.isEmpty((Object)defaultBpmDefinition)) {
            if (mapMsg2 != null && mapMsg2.contains(entityId)) {
                return null;
            }
            ThreadMsgUtil.addMapMsg2((String)"null_definition", (String)entityId);
            BpmFreeProcessDef bpmFreeProcessDef = (BpmFreeProcessDef)this.bpmFreeProcessDefManager.get((Serializable)((Object)entityId));
            if (bpmFreeProcessDef == null) {
                return null;
            }
            defaultBpmDefinition = this.bpmDefinitionManager.getById(bpmFreeProcessDef.getSourceDefId());
            ThreadMsgUtil.deleteMapMsg2((String)"null_definition");
            if (defaultBpmDefinition == null) {
                return null;
            }
            defaultBpmDefinition.setDefId(bpmFreeProcessDef.getId());
            if (BeanUtils.isNotEmpty((Object)defaultBpmDefinition)) {
                defaultBpmDefinition.setBpmnXml(bpmFreeProcessDef.getBpmnXml());
                flag = true;
            }
        }
        if (!flag) {
            bpmDefData = (BpmDefData)this.bpmDefDataManager.get((Serializable)((Object)entityId));
            defaultBpmDefinition.setBpmDefData(bpmDefData);
        }
        bpmDefData = (BpmDefData)this.bpmDefDataManager.get((Serializable)((Object)entityId));
        defaultBpmDefinition.setBpmDefData(bpmDefData);
        this.addCache(defaultBpmDefinition);
        return defaultBpmDefinition;
    }

    @Override
    public DefaultBpmDefinition getMainByDefKey(String defKey) {
        return this.getMainByDefKey(defKey, false);
    }

    @Override
    public DefaultBpmDefinition getMainByDefKey(String defKey, boolean needData) {
        DefaultBpmDefinition bpmDef = this.bpmDefinitionDao.getMainByDefKey(defKey);
        if (bpmDef == null || !needData) {
            return bpmDef;
        }
        BpmDefData bpmDefData = (BpmDefData)this.bpmDefDataManager.get((Serializable)((Object)bpmDef.getDefId()));
        bpmDef.setBpmDefData(bpmDefData);
        return bpmDef;
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(DefaultBpmDefinition entity) {
        super.create((Model)entity);
        if (StringUtil.isEmpty((String)entity.getBpmDefData().getId())) {
            entity.getBpmDefData().setId(entity.getDefId());
        }
        this.bpmDefDataManager.create((Model)entity.getBpmDefData());
    }

    @Transactional
    public void update(DefaultBpmDefinition entity) {
        super.update((Model)entity);
        if (StringUtil.isNotEmpty((String)entity.getBpmDefData().getId())) {
            this.bpmDefDataManager.update((Model)entity.getBpmDefData());
        }
        this.publishEvent(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCascade(String defId) throws Exception {
        BpmDefinition bpmDef = (BpmDefinition)this.get((Serializable)((Object)defId));
        String defKey = bpmDef.getDefKey();
        List<DefaultBpmDefinition> defList = this.bpmDefinitionDao.getByDefKey(defKey);
        for (DefaultBpmDefinition def : defList) {
            this.publishEvent(def);
        }
        List<DefaultBpmProcessInstance> instList = this.bpmProcessInstanceManager.getListByBpmnDefKey(defKey);
        for (DefaultBpmProcessInstance inst : instList) {
            this.bpmProcessInstanceManager.physicsRemove(inst.getId());
        }
        if (StringUtil.isNotEmpty((String)bpmDef.getBpmnDefId())) {
            this.bpmDefinitionDao.delActTask(bpmDef.getBpmnDefId());
        }
        this.removeActviti(defKey);
        this.removeDef(defKey);
    }

    private void removeDef(String defKey) {
        this.bpmDefDataManager.delByDefKey(defKey);
        this.bpmDefinitionDao.delByKey(defKey);
        ObjectNode params = JsonUtil.getMapper().createObjectNode();
        params.put("flowKey", defKey);
        params.put("parentFlowKey", "");
        params.put("permissionType", 1);
        this.formRestfulService.removeFormRightByFlowKey(params);
        ObjectNode params1 = JsonUtil.getMapper().createObjectNode();
        params1.put("flowKey", defKey);
        params1.put("parentFlowKey", "");
        params1.put("permissionType", 2);
        this.formRestfulService.removeFormRightByFlowKey(params1);
    }

    private void removeActviti(String defKey) {
        this.bpmDefinitionDao.delActByteArray(defKey);
        this.bpmDefinitionDao.delActDeploy(defKey);
        this.bpmDefinitionDao.delActRunIdentitylink(defKey);
        this.bpmDefinitionDao.delActRunVariable(defKey);
        this.bpmDefinitionDao.delActRunExecution(defKey);
        this.bpmDefinitionDao.delActDef(defKey);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DefaultBpmDefinition cloneToMain(DefaultBpmDefinition bpmDefinition, String defId) {
        DefaultBpmDefinition newBpmDefinition = (DefaultBpmDefinition)bpmDefinition.clone();
        if (StringUtil.isNotEmpty((String)defId)) {
            newBpmDefinition.setDefId(defId);
        } else {
            newBpmDefinition.setDefId(UniqueIdUtil.getSuid());
        }
        newBpmDefinition.setIsMain("N");
        Integer maxVersion = this.getMaxVersion(bpmDefinition.getDefKey());
        newBpmDefinition.setVersion(maxVersion);
        newBpmDefinition.setCreateTime(LocalDateTime.now());
        super.create((Model)newBpmDefinition);
        this.updMainVersion(newBpmDefinition.getDefId(), true);
        newBpmDefinition.getBpmDefData().setId(newBpmDefinition.getDefId());
        this.bpmDefDataManager.create((Model)newBpmDefinition.getBpmDefData());
        return newBpmDefinition;
    }

    @Override
    public List<DefaultBpmDefinition> queryByDefKey(String defKey) {
        return this.bpmDefinitionDao.queryByDefKey(defKey);
    }

    @Override
    public List<DefaultBpmDefinition> queryByDefKeyUppercase(String defKey) {
        return this.bpmDefinitionDao.queryByDefKeyUppercase(defKey);
    }

    @Override
    public List<DefaultBpmDefinition> queryHistorys(String defKey) {
        return this.bpmDefinitionDao.queryHistorys(defKey);
    }

    @Override
    public Integer getMaxVersion(String defKey) {
        Integer version = this.bpmDefinitionDao.getMaxVersion(defKey);
        if (version != null) {
            return version + 1;
        }
        return 1;
    }

    @Override
    public List<DefaultBpmDefinition> query(BpmDefQueryFields bpmDefQueryFields, FieldRelation fieldRelation, BpmDefFieldSorts bpmDefFieldSorts) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.setQuerys(bpmDefQueryFields.getQueryFields());
        queryFilter.setSorter(bpmDefFieldSorts.getFieldSorts());
        queryFilter.setPageBean(null);
        return this.query((QueryFilter<DefaultBpmDefinition>)queryFilter).getRows();
    }

    @Override
    public String getDefIdByBpmnDefId(String bpmnDefId) {
        BpmDefinitionManagerImpl bean = (BpmDefinitionManagerImpl)AppUtil.getBean(this.getClass());
        String defId = bean.getDefIdByBpmnIdFromCache(bpmnDefId);
        if (StringUtil.isNotEmpty((String)defId)) {
            return defId;
        }
        return this.bpmDefinitionDao.getDefIdByBpmnDefId(bpmnDefId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updMainVersion(String entityId, boolean ifPresent) {
        BpmDefinition def = (BpmDefinition)this.get((Serializable)((Object)entityId));
        if (ifPresent) {
            List<DefaultBpmDefinition> byDefKey = this.bpmDefinitionDao.getByDefKey(def.getDefKey());
            if (BeanUtils.isNotEmpty(byDefKey) && byDefKey.size() == 1) {
                this.bpmDefinitionDao.updateToMainVersion(entityId);
            }
        } else {
            this.bpmDefinitionDao.updateNotMainVersion(entityId);
            this.bpmDefinitionDao.updateToMainVersion(entityId);
        }
        this.publishEvent(def);
    }

    @Override
    public DefaultBpmDefinition getByBpmnDefId(String bpmnDefId) {
        DefaultBpmDefinition bpmDef = null;
        BpmDefinitionManagerImpl bean = (BpmDefinitionManagerImpl)AppUtil.getBean(this.getClass());
        String defId = bean.getDefIdByBpmnIdFromCache(bpmnDefId);
        if (StringUtil.isNotEmpty((String)defId)) {
            bpmDef = bean.getFromCache(defId);
        }
        if (bpmDef == null) {
            bpmDef = this.bpmDefinitionDao.getByBpmnDefId(bpmnDefId);
        }
        return bpmDef;
    }

    @Override
    public DefaultBpmDefinition getByBpmnDeployId(String bpmnDeployId) {
        return this.bpmDefinitionDao.getByBpmnDeployId(bpmnDeployId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(String defId, String status) {
        this.bpmDefinitionDao.updateStatus(defId, status);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updBpmData(String defId, BpmDefData bpmDefData) {
        DefaultBpmDefinition bpmDefinition = (DefaultBpmDefinition)super.get((Serializable)((Object)defId));
        this.bpmDefDataManager.update((Model)bpmDefData);
        String deployId = bpmDefinition.getBpmnDeployId();
        this.natProDefinitionService.writeDefXml(deployId, bpmDefData.getBpmnXml());
        this.publishEvent(bpmDefinition);
    }

    @Override
    public List<String> queryByCreateBy(String userId) {
        return this.bpmDefinitionDao.queryDefKeyByCreateBy(userId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void removeByIds(String ... ids) {
        for (String id : ids) {
            try {
                this.removeCascade(id);
            }
            catch (Exception e) {
                throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deploy(BpmDefinition bpmDefinition, String defId) throws Exception {
        String bpmnXml;
        if (!this.isAvailable(bpmDefinition)) {
            return false;
        }
        boolean isNewDef = StringUtil.isEmpty((String)bpmDefinition.getDefId());
        boolean isDraft = false;
        String oldDefId = bpmDefinition.getDefId();
        String oldBpmnXml = "";
        if (isNewDef) {
            DefaultBpmDefinition mainBpmDefinition = this.getMainByDefKey(bpmDefinition.getDefKey(), false);
            if (mainBpmDefinition != null) {
                this.logger.error((Object)("defKey '" + bpmDefinition.getDefKey() + "' is exists "));
                return false;
            }
        } else {
            DefaultBpmDefinition tempDef = this.getById(bpmDefinition.getDefId());
            oldBpmnXml = tempDef.getBpmnXml();
            if (tempDef != null && StringUtil.isEmpty((String)tempDef.getBpmnDefId())) {
                isDraft = true;
            }
        }
        if (StringUtil.isEmpty((String)(bpmnXml = this.getBpmnXmlByDesignFile(bpmDefinition)))) {
            throw new RuntimeException("\u6d41\u7a0b\u53d1\u5e03\u5931\u8d25\uff01\u6d41\u7a0b\u56fe\u4e0d\u80fd\u4e3a\u7a7a");
        }
        bpmnXml = this.updateBpmnXmlPlugins(bpmnXml, oldBpmnXml);
        if (StringUtil.isNotEmpty((String)bpmDefinition.getDefId())) {
            bpmnXml = this.updateBpmnXmlGatewayConditionExpress(bpmnXml, oldBpmnXml);
        }
        ArrayList<BpmNodeDef> nodeDefs = new ArrayList();
        try {
            nodeDefs = BpmnXmlValidateUtil.getNodeDefs(bpmnXml);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6d41\u7a0b\u5b9a\u4e49\u89e3\u6790\u5931\u8d25\uff08\u53ef\u80fd\u662f\u672a\u6267\u884c\u66f4\u65b0\u6d41\u7a0b\u5f15\u64ce\u64cd\u4f5c\uff09\uff1a" + e.getMessage());
        }
        ObjectNode msg = BpmnXmlValidateUtil.vilateBpmXml(nodeDefs);
        if (!msg.get("isTrue").asBoolean()) {
            throw new RuntimeException("\u6d41\u7a0b\u5b9a\u4e49\u6821\u9a8c\u5931\u8d25\uff1a" + msg.get("errorMsgs").asText());
        }
        String deployId = null;
        String bpmnDefId = null;
        try {
            deployId = this.natProDefinitionService.deploy("", bpmDefinition.getName(), bpmnXml);
            bpmnDefId = this.natProDefinitionService.getProcessDefinitionIdByDeployId(deployId);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error((Object)("Invoke natProDefinitionService.deploy method error = " + e.getMessage()));
            return false;
        }
        DefaultBpmDefinition def = (DefaultBpmDefinition)bpmDefinition;
        if (isNewDef) {
            def.setDefId(UniqueIdUtil.getSuid());
            def.setVersion(1);
            def.setMainDefId(bpmDefinition.getDefId());
            def.setIsMain("Y");
            def.setStatus("deploy");
            def.setTestStatus("test");
            def.setBpmnDefId(bpmnDefId);
            def.setBpmnDeployId(deployId);
            def.setBpmnXml(bpmnXml);
            def.setCreateTime(LocalDateTime.now());
            this.create(def);
        } else if (isDraft) {
            def.setStatus("deploy");
            def.setTestStatus("test");
            def.setVersion(1);
            def.setMainDefId(bpmDefinition.getDefId());
            def.setIsMain("Y");
            def.setBpmnDefId(bpmnDefId);
            def.setBpmnDeployId(deployId);
            def.setBpmnXml(bpmnXml);
            this.update(def);
        } else {
            DefaultBpmDefinition oldBpmDefinition = (DefaultBpmDefinition)bpmDefinition;
            oldBpmDefinition.setStatus("deploy");
            oldBpmDefinition.setTestStatus("test");
            oldBpmDefinition.setBpmnDefId(bpmnDefId);
            oldBpmDefinition.setBpmnDeployId(deployId);
            oldBpmDefinition.setBpmnXml(bpmnXml);
            DefaultBpmDefinition cloneToMain = this.cloneToMain(oldBpmDefinition, defId);
            oldBpmDefinition.setId(cloneToMain.getId());
            this.copyBpmNodeSettings(oldDefId, cloneToMain.getId());
        }
        this.publishEvent(def);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateBpmDefinition(BpmDefinition bpmDefinition) throws Exception {
        if (!this.isAvailable(bpmDefinition)) {
            return false;
        }
        DefaultBpmDefinition oldBpmDefinition = this.getById(bpmDefinition.getDefId());
        return this.updateBpmDefinition(bpmDefinition, oldBpmDefinition);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateBpmDefinition(BpmDefinition bpmDefinition, BpmDefinition oldBpmDefinition) throws Exception {
        if (!this.isAvailable(bpmDefinition)) {
            return false;
        }
        String bpmnXml = this.getBpmnXmlByDesignFile(bpmDefinition);
        if (StringUtil.isEmpty((String)bpmnXml)) {
            return false;
        }
        ArrayList<BpmNodeDef> nodeDefs = new ArrayList();
        try {
            nodeDefs = BpmnXmlValidateUtil.getNodeDefs(bpmnXml);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6d41\u7a0b\u5b9a\u4e49\u89e3\u6790\u5931\u8d25\uff08\u53ef\u80fd\u662f\u672a\u6267\u884c\u66f4\u65b0\u6d41\u7a0b\u5f15\u64ce\u64cd\u4f5c\uff09\uff1a" + e.getMessage());
        }
        ObjectNode msg = BpmnXmlValidateUtil.vilateBpmXml(nodeDefs);
        if (!msg.get("isTrue").asBoolean()) {
            throw new RuntimeException("\u6d41\u7a0b\u5b9a\u4e49\u6821\u9a8c\u5931\u8d25\uff1a" + msg.get("errorMsgs").asText());
        }
        String oldBpmnXml = oldBpmDefinition.getBpmnXml();
        bpmnXml = this.updateBpmnXmlPlugins(bpmnXml, oldBpmnXml);
        boolean isBpmnXmlChange = !(bpmnXml = this.updateBpmnXmlGatewayConditionExpress(bpmnXml, oldBpmnXml)).equals(bpmDefinition.getBpmnXml());
        DefaultBpmDefinition def = (DefaultBpmDefinition)bpmDefinition;
        if (isBpmnXmlChange) {
            if (StringUtil.isEmpty((String)def.getStatus())) {
                def.setStatus(oldBpmDefinition.getStatus());
            }
            def.setBpmnXml(bpmnXml);
            if (StringUtil.isNotEmpty((String)bpmDefinition.getBpmnDeployId())) {
                this.natProDefinitionService.writeDefXml(bpmDefinition.getBpmnDeployId(), bpmnXml);
            }
        }
        this.update(def);
        this.publishEvent(def);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveDraft(BpmDefinition bpmDefinition) throws Exception {
        if (bpmDefinition == null || StringUtil.isEmpty((String)bpmDefinition.getDefKey())) {
            // empty if block
        }
        DefaultBpmDefinition def = (DefaultBpmDefinition)bpmDefinition;
        String bpmnXml = this.getBpmnXmlByDesignFile(bpmDefinition);
        if (StringUtil.isEmpty((String)bpmnXml)) {
            throw new RuntimeException("\u6d41\u7a0b\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        def.setBpmnXml(bpmnXml);
        def.setIsMain("Y");
        def.setStatus("draft");
        def.setTestStatus("test");
        def.setVersion(0);
        String defId = UniqueIdUtil.getSuid();
        def.setDefId(defId);
        def.setMainDefId(defId);
        def.setCreateTime(LocalDateTime.now());
        this.create(def);
        return true;
    }

    private String getBpmnXmlByDesignFile(BpmDefinition bpmDefinition) throws Exception {
        String bpmnXml = "";
        DesignerType designType = DesignerType.valueOf(bpmDefinition.getDesigner());
        DefTransform trans = this.natProDefinitionService.getDefTransform(designType);
        if (DesignerType.WEB.name().equals(bpmDefinition.getDesigner())) {
            DefaultBpmDefinition def = (DefaultBpmDefinition)bpmDefinition;
            bpmnXml = trans.convert(bpmDefinition.getDefKey(), bpmDefinition.getName(), def.getDefJson());
        } else {
            bpmnXml = DesignerType.BPMNJS.name().equals(bpmDefinition.getDesigner()) ? trans.convert(bpmDefinition.getDefKey(), bpmDefinition.getName(), bpmDefinition.getBpmnXml()) : trans.convert(bpmDefinition.getDefKey(), bpmDefinition.getName(), bpmDefinition.getDefXml());
        }
        if (StringUtil.isNotEmpty((String)bpmDefinition.getDefId()) && DesignerType.WEB.name().equals(bpmDefinition.getDesigner())) {
            List<BpmNodeDef> nodeDefs = this.bpmDefinitionAccessor.getAllNodeDef(bpmDefinition.getDefId());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("xml", bpmnXml);
            this.copyBranchConfig(nodeDefs, map);
            bpmnXml = (String)map.get("xml");
        }
        return bpmnXml;
    }

    private void copyBranchConfig(List<BpmNodeDef> nodeDefs, Map<String, String> map) {
        if (BeanUtils.isEmpty(nodeDefs)) {
            return;
        }
        for (BpmNodeDef bpmNodeDef : nodeDefs) {
            if (NodeType.EXCLUSIVEGATEWAY.equals((Object)bpmNodeDef.getType()) || NodeType.INCLUSIVEGATEWAY.equals((Object)bpmNodeDef.getType())) {
                Map<String, String> conditionsMap = bpmNodeDef.getConditions();
                if (!BeanUtils.isNotEmpty(conditionsMap)) continue;
                try {
                    map.put("xml", DefaultBpmDefConditionService.converConditionXml(bpmNodeDef.getNodeId(), conditionsMap, map.get("xml")));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!NodeType.SUBPROCESS.equals((Object)bpmNodeDef.getType())) continue;
            SubProcessNodeDef subProcessNodeDef = (SubProcessNodeDef)bpmNodeDef;
            this.copyBranchConfig(subProcessNodeDef.getChildBpmProcessDef().getBpmnNodeDefs(), map);
        }
    }

    private String updateBpmnXmlPlugins(String newBpmnXml, String oldBpmnXml) {
        if (StringUtil.isEmpty((String)oldBpmnXml)) {
            return newBpmnXml;
        }
        return this.defXmlTransForm.transform(oldBpmnXml, newBpmnXml);
    }

    private String updateBpmnXmlGatewayConditionExpress(String bpmnXml, String oldBpmnXml) {
        Document document = Dom4jUtil.loadXml((String)bpmnXml);
        Map<String, String> conditionMap = this.getConditionMap(oldBpmnXml);
        HashMap<String, String> nsMap = new HashMap<String, String>();
        String bpmnNamespace = "http://www.omg.org/spec/BPMN/20100524/MODEL";
        String xsiNamespace = "http://www.w3.org/2001/XMLSchema-instance";
        nsMap.put("bpmn2", bpmnNamespace);
        XPath xpath = document.createXPath("//bpmn2:*[@sourceRef]");
        xpath.setNamespaceURIs(nsMap);
        List list = xpath.selectNodes((Object)document);
        for (Node node : list) {
            Element sequenceFlow = (Element)node;
            if (!StringUtils.equalsIgnoreCase((String)sequenceFlow.getQName().getName(), (String)"sequenceFlow")) continue;
            String id = sequenceFlow.attributeValue("id");
            if (BeanUtils.isEmpty((Object)sequenceFlow.element("conditionExpression")) && !conditionMap.containsKey(id)) continue;
            String conditionExpression = conditionMap.getOrDefault(id, sequenceFlow.elementText("conditionExpression"));
            if (conditionExpression.contains("<![CDATA[")) {
                conditionExpression = conditionExpression.replaceAll("\\<\\!\\[CDATA\\[", "");
                conditionExpression = conditionExpression.replaceAll("\\]\\]\\>", "");
            }
            this.removeChildConditionExpress(sequenceFlow);
            Namespace namespace = new Namespace("", bpmnNamespace);
            DOMElement conditionEl = new DOMElement("conditionExpression", namespace);
            Namespace namespaceXsi = new Namespace("xsi", xsiNamespace);
            QName qName = new QName("type", namespaceXsi);
            DOMAttribute attr = new DOMAttribute(qName, "tFormalExpression");
            conditionEl.add((Attribute)attr);
            DOMCDATA cdata = new DOMCDATA(conditionExpression);
            conditionEl.add((CDATA)cdata);
            sequenceFlow.add((Element)conditionEl);
        }
        return document.asXML();
    }

    private Map<String, String> getConditionMap(String oldBpmnXml) {
        HashMap<String, String> result = new HashMap<String, String>();
        Document oldDocument = Dom4jUtil.loadXml((String)oldBpmnXml);
        HashMap<String, String> nsMap = new HashMap<String, String>();
        String bpmnNamespace = "http://www.omg.org/spec/BPMN/20100524/MODEL";
        nsMap.put("bpmn2", bpmnNamespace);
        XPath xpath = oldDocument.createXPath("//bpmn2:*[@sourceRef]");
        xpath.setNamespaceURIs(nsMap);
        List list = xpath.selectNodes((Object)oldDocument);
        for (Node node : list) {
            Element sequenceFlow = (Element)node;
            if (!StringUtils.equalsIgnoreCase((String)sequenceFlow.getQName().getName(), (String)"sequenceFlow") || BeanUtils.isEmpty((Object)sequenceFlow.element("conditionExpression"))) continue;
            String id = sequenceFlow.attributeValue("id");
            String conditionExpression = sequenceFlow.element("conditionExpression").getText();
            result.put(id, conditionExpression);
        }
        return result;
    }

    private void removeChildConditionExpress(Element el) {
        List childs = el.elements();
        for (Element node : childs) {
            if (!StringUtils.equalsIgnoreCase((String)node.getQName().getName(), (String)"conditionExpression")) continue;
            el.remove(node);
        }
    }

    private boolean isAvailable(BpmDefinition bpmDefinition) {
        if (bpmDefinition == null || StringUtil.isEmpty((String)bpmDefinition.getName()) || StringUtil.isEmpty((String)bpmDefinition.getDefKey())) {
            this.logger.error((Object)("DefaultBpmDefinitionService.deploy data error, bpmDefinition=" + bpmDefinition));
            return false;
        }
        return true;
    }

    @Override
    public PageList<DefaultBpmDefinition> queryList(QueryFilter<DefaultBpmDefinition> queryFilter) throws IOException {
        IUser user = ContextUtil.getCurrentUser();
        PageList<DefaultBpmDefinition> pageList = this.queryList(queryFilter, user);
        this.mapTagName(pageList.getRows());
        return pageList;
    }

    private void mapTagName(List<DefaultBpmDefinition> definitions) throws IOException {
        List types = this.portalFeignService.getTypeTags("flow");
        ArrayList list = new ArrayList();
        for (JsonNode type : types) {
            ArrayNode tags = (ArrayNode)type.get("tags");
            list.addAll(JsonUtil.arrayToList((ArrayNode)tags));
        }
        Map<String, String> map = list.stream().collect(Collectors.toMap(item -> JsonUtil.getString((JsonNode)item, (String)"key"), item -> JsonUtil.getString((JsonNode)item, (String)"name")));
        definitions.forEach(def -> {
            if (BeanUtils.isEmpty((Object)def.getTags())) {
                return;
            }
            String[] tagArray = def.getTags().split(",");
            ArrayList tagNames = new ArrayList();
            for (String tag : tagArray) {
                if (!map.containsKey(tag)) continue;
                tagNames.add(map.get(tag));
            }
            def.setTagNames(String.join((CharSequence)",", tagNames));
        });
    }

    @Override
    public PageList<DefaultBpmDefinition> queryList(QueryFilter<DefaultBpmDefinition> queryFilter, IUser user) throws IOException {
        String oldDefKeys;
        String userId = user.getUserId();
        Map<String, ObjectNode> authorizeRightMap = null;
        boolean isAdmin = user.isAdmin();
        queryFilter.addParams("isAdmin", (Object)(isAdmin ? 1 : 0));
        if (!isAdmin) {
            authorizeRightMap = this.getCommUserCondition(userId, queryFilter);
        }
        BpmSecretaryManageManager secretaryManageManager = (BpmSecretaryManageManager)AppUtil.getBean(BpmSecretaryManageManager.class);
        Map<String, Object> leaderHasRightShareDefs = secretaryManageManager.getLeadersRigthMapBySecretaryId(userId, "1", true);
        HashMap defShareMap = new HashMap();
        HashSet allShareDefs = new HashSet();
        for (Map.Entry<String, Object> next : leaderHasRightShareDefs.entrySet()) {
            Map<String, Object> leaderActRightMap;
            String defKeys;
            String leaderId = next.getKey();
            Map value = (Map)next.getValue();
            Map leaderRightMap = (Map)value.get("groupMap");
            String shareDefKeys = (String)value.get("defKeys");
            if (StringUtil.isEmpty((String)shareDefKeys) || StringUtil.isEmpty((String)(defKeys = (String)(leaderActRightMap = this.bpmDefAuthorizeManager.getActRightByRightMapAndUserId(leaderId, "start", true, true, leaderRightMap)).get("defKeys")))) continue;
            defKeys = defKeys.replaceAll("'", "");
            HashSet<String> hasRightDefs = new HashSet<String>(Arrays.asList(defKeys.split(",")));
            HashSet<String> set = new HashSet<String>();
            set.addAll(hasRightDefs);
            if (!StringUtil.isNotEmpty((String)shareDefKeys)) continue;
            shareDefKeys = shareDefKeys.replaceAll("'", "");
            set.retainAll(new HashSet<String>(Arrays.asList(shareDefKeys.split(","))));
            for (String defKey : set) {
                Set<String> leaderIdSet = defShareMap.containsKey(defKey) ? (Set)defShareMap.get(defKey) : new HashSet();
                leaderIdSet.add(leaderId);
                defShareMap.put(defKey, leaderIdSet);
            }
            allShareDefs.addAll(set);
        }
        String string = oldDefKeys = BeanUtils.isEmpty(queryFilter.getParams().get("defKeys")) ? "''" : (String)queryFilter.getParams().get("defKeys");
        if (!allShareDefs.isEmpty()) {
            oldDefKeys = oldDefKeys + ",'" + StringUtil.join(new ArrayList(allShareDefs), (String)"','") + "'";
        }
        queryFilter.addParams("defKeys", (Object)oldDefKeys);
        List querys = queryFilter.getQuerys();
        boolean isMain = false;
        for (QueryField query : querys) {
            if (!"is_main_".equals(query.getProperty().toLowerCase())) continue;
            isMain = true;
        }
        PageList<DefaultBpmDefinition> list = null;
        list = isMain ? this.query(queryFilter) : this.queryMaxVersion(queryFilter);
        if (list == null) {
            return list;
        }
        ArrayNode users = this.ucFeignService.getUserByIdsOrAccounts(StringUtil.join(new ArrayList<String>(leaderHasRightShareDefs.keySet()), (String)","));
        HashMap<String, String> userNameMap = new HashMap<String, String>();
        for (JsonNode jsonNode : users) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            userNameMap.put(objectNode.get("id").asText(), objectNode.get("fullname").asText());
        }
        for (DefaultBpmDefinition bpmDefinition : list.getRows()) {
            ObjectNode authorizeRight = null;
            authorizeRight = isAdmin ? AuthorizeRight.getAdminRight() : authorizeRightMap.get(bpmDefinition.getDefKey());
            bpmDefinition.setAuthorizeRight(authorizeRight);
            if (!defShareMap.containsKey(bpmDefinition.getDefKey())) continue;
            ArrayList<BpmIdentity> lIdentities = new ArrayList<BpmIdentity>();
            lIdentities.add(new DefaultBpmIdentity("0", "\u81ea\u5df1", "user"));
            Set leaderIdSet = (Set)defShareMap.get(bpmDefinition.getDefKey());
            for (String leaderId : leaderIdSet) {
                lIdentities.add(new DefaultBpmIdentity(leaderId, (String)userNameMap.get(leaderId) + "(\u9886\u5bfc)", "user"));
            }
            bpmDefinition.setLeaders(lIdentities);
        }
        return list;
    }

    @Override
    public List<DefaultBpmDefinition> getLeaders(IUser user, QueryFilter queryFilter, List<DefaultBpmDefinition> list) throws Exception {
        String userId = user == null ? null : user.getUserId();
        boolean isAdmin = user != null && user.isAdmin();
        Map<String, ObjectNode> authorizeRightMap = null;
        queryFilter.addParams("isAdmin", (Object)(isAdmin ? 1 : 0));
        if (!isAdmin) {
            authorizeRightMap = this.getCommUserCondition(userId, queryFilter);
        }
        BpmSecretaryManageManager secretaryManageManager = (BpmSecretaryManageManager)AppUtil.getBean(BpmSecretaryManageManager.class);
        Map<String, Object> leaderHasRightShareDefs = secretaryManageManager.getLeadersRigthMapBySecretaryId(userId, "1", true);
        HashMap defShareMap = new HashMap();
        HashSet allShareDefs = new HashSet();
        for (Map.Entry<String, Object> next : leaderHasRightShareDefs.entrySet()) {
            Map<String, Object> leaderActRightMap;
            String defKeys;
            String leaderId = next.getKey();
            Map value = (Map)next.getValue();
            Map leaderRightMap = (Map)value.get("groupMap");
            String shareDefKeys = (String)value.get("defKeys");
            if (StringUtil.isEmpty((String)shareDefKeys) || StringUtil.isEmpty((String)(defKeys = (String)(leaderActRightMap = this.bpmDefAuthorizeManager.getActRightByRightMapAndUserId(leaderId, "start", true, true, leaderRightMap)).get("defKeys")))) continue;
            defKeys = defKeys.replaceAll("'", "");
            HashSet<String> hasRightDefs = new HashSet<String>(Arrays.asList(defKeys.split(",")));
            HashSet<String> set = new HashSet<String>();
            set.addAll(hasRightDefs);
            if (!StringUtil.isNotEmpty((String)shareDefKeys)) continue;
            shareDefKeys = shareDefKeys.replaceAll("'", "");
            set.retainAll(new HashSet<String>(Arrays.asList(shareDefKeys.split(","))));
            for (String defKey : set) {
                Set<String> leaderIdSet = defShareMap.containsKey(defKey) ? (Set)defShareMap.get(defKey) : new HashSet();
                leaderIdSet.add(leaderId);
                defShareMap.put(defKey, leaderIdSet);
            }
            allShareDefs.addAll(set);
        }
        ArrayNode users = this.ucFeignService.getUserByIdsOrAccounts(StringUtil.join(new ArrayList<String>(leaderHasRightShareDefs.keySet()), (String)","));
        HashMap<String, String> userNameMap = new HashMap<String, String>();
        for (JsonNode jsonNode : users) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            userNameMap.put(objectNode.get("id").asText(), objectNode.get("fullname").asText());
        }
        for (DefaultBpmDefinition bpmDefinition : list) {
            ObjectNode authorizeRight = null;
            authorizeRight = isAdmin ? AuthorizeRight.getAdminRight() : authorizeRightMap.get(bpmDefinition.getDefKey());
            bpmDefinition.setAuthorizeRight(authorizeRight);
            if (!defShareMap.containsKey(bpmDefinition.getDefKey())) continue;
            ArrayList<BpmIdentity> lIdentities = new ArrayList<BpmIdentity>();
            lIdentities.add(new DefaultBpmIdentity("0", "\u81ea\u5df1", "user"));
            Set leaderIdSet = (Set)defShareMap.get(bpmDefinition.getDefKey());
            for (String leaderId : leaderIdSet) {
                lIdentities.add(new DefaultBpmIdentity(leaderId, (String)userNameMap.get(leaderId) + "(\u9886\u5bfc)", "user"));
            }
            bpmDefinition.setLeaders(lIdentities);
        }
        return list;
    }

    public PageList<DefaultBpmDefinition> query(QueryFilter<DefaultBpmDefinition> queryFilter) {
        Map params = queryFilter.getParams();
        if (BeanUtils.isNotEmpty((Object)params) && (Integer)params.get("isAdmin") == 0) {
            String defKeys = (String)params.get("defKeys");
            if (BeanUtils.isEmpty((Object)defKeys)) {
                return new PageList();
            }
            queryFilter.addFilter("def_key_", (Object)defKeys, QueryOP.IN, FieldRelation.AND, "a");
        }
        queryFilter.setDefaultSort("version", Direction.DESC);
        queryFilter.setParams(new HashMap());
        return super.query(queryFilter);
    }

    public PageList<DefaultBpmDefinition> queryMaxVersion(QueryFilter<DefaultBpmDefinition> queryFilter) {
        Map params = queryFilter.getParams();
        if (BeanUtils.isNotEmpty((Object)params) && (Integer)params.get("isAdmin") == 0) {
            String defKeys = (String)params.get("defKeys");
            if (BeanUtils.isEmpty((Object)defKeys)) {
                return new PageList();
            }
            queryFilter.addFilter("def_key_", (Object)defKeys, QueryOP.IN, FieldRelation.AND, "a");
        }
        queryFilter.setDefaultSort("createTime", Direction.DESC);
        queryFilter.setParams(new HashMap());
        PageBean pageBean = queryFilter.getPageBean();
        IPage<DefaultBpmDefinition> result = this.bpmDefinitionDao.queryMaxVersionPage((IPage<DefaultBpmDefinition>)this.convert2IPage(pageBean), (Wrapper<DefaultBpmDefinition>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        Set defKeys = result.getRecords().stream().map(DefaultBpmDefinition::getDefKey).collect(Collectors.toSet());
        if (BeanUtils.isNotEmpty(defKeys)) {
            Map<String, DefaultBpmDefinition> mainDefaultBpmDefinitionMap = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{DefaultBpmDefinition::getDefId, DefaultBpmDefinition::getVersion, DefaultBpmDefinition::getDefKey}).in(DefaultBpmDefinition::getDefKey, defKeys)).eq(DefaultBpmDefinition::getIsMain, (Object)"Y")).stream().collect(Collectors.toMap(DefaultBpmDefinition::getDefKey, item -> item));
            result.getRecords().forEach(item -> {
                if (mainDefaultBpmDefinitionMap.containsKey(item.getDefKey())) {
                    DefaultBpmDefinition definition = (DefaultBpmDefinition)mainDefaultBpmDefinitionMap.get(item.getDefKey());
                    item.setMainId(definition.getDefId());
                    item.setMainVersion(definition.getVersion());
                }
            });
        }
        return new PageList(result);
    }

    private Map<String, ObjectNode> getCommUserCondition(String userId, QueryFilter queryFilter) throws IOException {
        Map<String, Object> actRightMap;
        String defKeys;
        String bpmDefAuthorizeRightType = "management";
        Map params = queryFilter.getParams();
        String right = (String)params.get("bpmDefAuthorizeRightType");
        if (StringUtil.isNotEmpty((String)right)) {
            bpmDefAuthorizeRightType = right;
        }
        if (StringUtil.isNotEmpty((String)(defKeys = (String)(actRightMap = this.bpmDefAuthorizeManager.getActRightByUserId(userId, bpmDefAuthorizeRightType, true, true)).get("defKeys")))) {
            queryFilter.addParams("defKeys", (Object)defKeys);
        }
        Map authorizeRightMap = (Map)actRightMap.get("authorizeRightMap");
        return authorizeRightMap;
    }

    @Override
    public Map<String, Object> webDefDesign(String defId) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DefaultBpmDefinition mainByDefKey = this.bpmDefinitionManager.getMainByDefKey(defId);
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        if (BeanUtils.isNotEmpty((Object)def)) {
            map.put("defId", def.getDefId());
            map.put("name", def.getName());
            map.put("desc", def.getDesc());
            map.put("defKey", def.getDefKey());
            map.put("modelId", def.getDefId());
            map.put("model", def.getDefJson());
            map.put("reason", def.getReason());
            map.put("version", def.getVersion());
            map.put("showUrgentState", def.getShowUrgentState());
            map.put("showModifyRecord", def.getShowModifyRecord());
            map.put("isReadRevoke", def.getIsReadRevoke());
            map.put("urgentMailTel", def.getUrgentMailTel());
            map.put("urgentSmsTel", def.getUrgentSmsTel());
            map.put("bpmnXml", def.getBpmnXml());
            map.put("designPattern", def.getDesignPattern());
            map.put("deployDesc", def.getDeployDesc());
            map.put("isMain", def.getIsMain());
            ObjectNode type = null;
            if (BeanUtils.isNotEmpty((Object)def.getTypeId())) {
                type = this.portalFeignService.getSysTypeById(def.getTypeId());
            }
            if (BeanUtils.isNotEmpty(type)) {
                map.put("typeId", def.getTypeId());
                map.put("typeName", type.get("name").asText());
            }
            if (ContextUtil.getCurrentUser().isAdmin()) {
                map.put("authorizeRight", AuthorizeRight.getAdminRight());
            } else {
                ObjectNode right = this.bpmDefAuthorizeManager.getRight(def.getDefKey(), "management");
                map.put("authorizeRight", right);
            }
        }
        return map;
    }

    @Override
    public void image(String defId, String bpmnInstId, String taskId, HttpServletResponse response) throws Exception {
        InputStream is = null;
        if (StringUtils.isNotEmpty((String)defId)) {
            is = this.diagramService.getDiagramByBpmnDefId(defId);
        } else if (StringUtils.isNotEmpty((String)bpmnInstId)) {
            is = this.getDiagramByInstance(this.diagramService, bpmnInstId);
        } else if (StringUtils.isNotEmpty((String)taskId)) {
            BpmTask bpmTask = this.bpmTaskService.getByTaskId(taskId);
            is = this.getDiagramByInstance(this.diagramService, bpmTask.getBpmnInstId());
        }
        if (is == null) {
            return;
        }
        response.setContentType("image/png");
        ServletOutputStream out = response.getOutputStream();
        FileUtil.writeInput((InputStream)is, (OutputStream)out);
    }

    @Override
    public Map<String, Object> subFlowDetail(String defId, String nodeId) throws Exception {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        BpmNodeDef node = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        if (node.getType() != NodeType.CALLACTIVITY) {
            throw new RuntimeException("\u8fd9\u4e0d\u662f\u4e00\u4e2a\u5916\u90e8\u5b50\u6d41\u7a0b\u8282\u70b9\uff01");
        }
        resMap.put("topDefKey", node.getBpmProcessDef().getDefKey());
        CallActivityNodeDef callActivityNode = (CallActivityNodeDef)node;
        String childFlowKey = callActivityNode.getFlowKey();
        DefaultBpmDefinition subProcessDef = this.bpmDefinitionManager.getMainByDefKey(childFlowKey);
        if (BeanUtils.isEmpty((Object)subProcessDef)) {
            throw new RuntimeException("\u6839\u636e\u7ed1\u5b9a\u7684\u5b50\u6d41\u7a0bkey\u672a\u627e\u5230\u5bf9\u5e94\u6d41\u7a0b\uff01");
        }
        resMap.put("defId", subProcessDef.getDefId());
        return resMap;
    }

    @Override
    public PageList<BpmNodeDef> getNodeBtns(String defId) throws Exception {
        List<BpmNodeDef> nodeDefs = this.bpmDefinitionAccessor.getSignUserNode(defId);
        ArrayList list = new ArrayList();
        if (nodeDefs != null && !nodeDefs.isEmpty()) {
            for (BpmNodeDef bnd : nodeDefs) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("nodeId", bnd.getNodeId());
                map.put("name", bnd.getName());
                map.put("type", (Object)bnd.getType());
                map.put("btns", JsonUtil.toJson(bnd.getButtons()));
                list.add(map);
            }
        }
        return new PageList(list);
    }

    @Override
    public PageList<DefaultBpmDefinition> versions(String defId, String defKey, QueryFilter<DefaultBpmDefinition> queryFilter) {
        DefaultBpmDefinition defaultBpmDefinition = null;
        if (StringUtil.isEmpty((String)defKey) && StringUtil.isNotEmpty((String)defId)) {
            defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
            if (defaultBpmDefinition != null) {
                queryFilter.addFilter("def_key_", (Object)defaultBpmDefinition.getDefKey(), QueryOP.EQUAL);
            } else {
                queryFilter.addFilter("def_key_", (Object)"", QueryOP.EQUAL);
            }
        } else {
            queryFilter.addFilter("def_key_", (Object)defKey, QueryOP.EQUAL);
        }
        PageList pageList = this.bpmDefinitionManager.query(queryFilter);
        this.setUser(pageList.getRows());
        return pageList;
    }

    private void setUser(List<DefaultBpmDefinition> definitions) {
        String ids = definitions.stream().map(item -> {
            if (BeanUtils.isNotEmpty((Object)item.getUpdateBy())) {
                return item.getUpdateBy();
            }
            return item.getCreateBy();
        }).filter(StringUtil::isNotEmpty).collect(Collectors.joining(","));
        ArrayNode users = this.ucFeignService.getUserByIds(ids);
        HashMap<String, JsonNode> userMap = new HashMap<String, JsonNode>();
        for (JsonNode user : users) {
            userMap.put(JsonUtil.getString((JsonNode)user, (String)"id"), user);
        }
        definitions.forEach(item -> {
            String userId = Optional.ofNullable(item.getUpdateBy()).orElse(item.getCreateBy());
            if (userMap.containsKey(userId)) {
                JsonNode userNode = (JsonNode)userMap.get(userId);
                item.setUpdaterName(JsonUtil.getString((JsonNode)userNode, (String)"fullname"));
                item.setUpdaterAccount(JsonUtil.getString((JsonNode)userNode, (String)"account"));
            }
        });
    }

    @Override
    public CommonResult<String> isLatestVersion(String defId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        DefaultBpmDefinition currentBpmDefinition = this.bpmDefinitionManager.getById(defId);
        if (BeanUtils.isEmpty((Object)currentBpmDefinition)) {
            throw new RuntimeException("defId\u4e0d\u5b58\u5728\u5bf9\u5e94\u6d41\u7a0b");
        }
        queryWrapper.orderByDesc((Object)"CREATE_TIME_");
        queryWrapper.eq((Object)"def_key_", (Object)currentBpmDefinition.getDefKey());
        queryWrapper.last("LIMIT 1");
        DefaultBpmDefinition latestBpmDefinition = (DefaultBpmDefinition)this.bpmDefinitionManager.getOne((Wrapper)queryWrapper);
        if (latestBpmDefinition.getCreateTime().isEqual(currentBpmDefinition.getCreateTime())) {
            return new CommonResult(true, "\u5f53\u524d\u7248\u672c\u662f\u6700\u65b0\u7248\u672c");
        }
        return new CommonResult(false, "\u5f53\u524d\u7248\u672c\u4e0d\u662f\u6700\u65b0\u7248\u672c");
    }

    @Override
    public List<DefaultBpmDefinition> queryListByMap(Map<String, Object> map) {
        return this.bpmDefinitionDao.queryListByMap(map);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeDefByDefId(String defId) {
        this.bpmDefDataManager.remove((Serializable)((Object)defId));
        super.remove((Serializable)((Object)defId));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeActvitiByDefId(String defId) {
        this.bpmDefinitionDao.delActByteArrayByDefId(defId);
        this.bpmDefinitionDao.delActDeployByDefId(defId);
        this.bpmDefinitionDao.delActDefByDefId(defId);
    }

    private boolean validDeleteDefPermission(DefaultBpmDefinition defaultBpmDefinition) throws IOException {
        IUser user = ContextUtil.getCurrentUser();
        boolean isAdmin = user.isAdmin();
        if (isAdmin) {
            return true;
        }
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addParams("bpmDefAuthorizeRightType", (Object)"management");
        Map<String, ObjectNode> authorizeRightMap = this.getCommUserCondition(user.getUserId(), queryFilter);
        System.out.println("=====authorizeRightMap: " + authorizeRightMap);
        ObjectNode jsonNodes = authorizeRightMap.get(defaultBpmDefinition.getDefKey());
        return jsonNodes.get("m_del").asBoolean();
    }

    @Override
    @GlobalTransactional
    @Transactional(rollbackFor={Exception.class})
    public void removeDefIds(boolean cascade, Boolean isVersion, String ... defIds) throws Exception {
        for (String defId : defIds) {
            DefaultBpmDefinition defaultBpmDefinition = this.bpmDefinitionManager.getById(defId);
            if (!this.validDeleteDefPermission(defaultBpmDefinition)) {
                throw new Exception("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49\uff1a" + defaultBpmDefinition.getDefKey());
            }
            List<DefaultBpmProcessInstance> instances = null;
            instances = isVersion != false ? this.bpmProcessInstanceManager.getListByDefId(defId) : this.bpmProcessInstanceDao.getListByBpmnDefKey(defaultBpmDefinition.getDefKey());
            if (BeanUtils.isNotEmpty(instances)) {
                for (DefaultBpmProcessInstance entity : instances) {
                    List<DefaultBpmProcessInstance> instancesSub = this.bpmProcessInstanceDao.getByParentId(entity.getId());
                    if (!BeanUtils.isNotEmpty(instancesSub)) continue;
                    ArrayList<String> listStr = new ArrayList<String>();
                    for (DefaultBpmProcessInstance instance : instancesSub) {
                        String instId = instance.getId();
                        this.bpmProcessInstanceManager.remove((Serializable)((Object)instId));
                        this.bpmInstFromManager.removeDataByInstId(instId);
                        this.bpmTaskNoticeManager.delBpmTaskNoticeByInstId(instId);
                        this.bpmTaskNoticeDoneManager.delBpmTaskNoticeDoneByInstId(instId);
                        listStr.add(instId);
                    }
                    if (!BeanUtils.isNotEmpty(listStr)) continue;
                    this.bpmTaskTurnManager.delByInstList(listStr);
                }
            }
            List<DefaultBpmDefinition> listDefaultBpmDefinition = new ArrayList<DefaultBpmDefinition>();
            if (isVersion.booleanValue()) {
                listDefaultBpmDefinition.add(defaultBpmDefinition);
            } else {
                listDefaultBpmDefinition = this.bpmDefinitionManager.queryByDefKey(defaultBpmDefinition.getDefKey());
            }
            for (DefaultBpmDefinition entity : listDefaultBpmDefinition) {
                defId = entity.getDefId();
                DefaultBpmDefinition bpmDef = entity;
                this.bpmTaskNoticeManager.delBpmTaskNoticeByDefId(defId);
                this.bpmTaskNoticeDoneManager.delBpmTaskNoticeDoneByDefId(defId);
                List<DefaultBpmProcessInstance> list = this.bpmProcessInstanceManager.getListByDefId(defId);
                ArrayList<String> listStr = new ArrayList<String>();
                if (BeanUtils.isNotEmpty(list)) {
                    for (DefaultBpmProcessInstance defaultBpmProcessInstance : list) {
                        listStr.add(defaultBpmProcessInstance.getId());
                    }
                }
                if (BeanUtils.isNotEmpty(listStr)) {
                    this.bpmTaskTurnManager.delByInstList(listStr);
                }
                if (cascade) {
                    this.removeCascadeByDef(bpmDef);
                    continue;
                }
                this.removeDefByDef(bpmDef);
            }
            this.ucFeignService.removeMatrixProcRelationByProcDefKey(defaultBpmDefinition.getDefKey());
        }
    }

    private void removeCascadeByDef(BpmDefinition bpmDef) throws Exception {
        String defKey = bpmDef.getDefKey();
        List<DefaultBpmDefinition> defList = this.bpmDefinitionDao.getByDefKey(defKey);
        for (DefaultBpmDefinition def : defList) {
            this.publishEvent(def);
        }
        List<DefaultBpmProcessInstance> instList = this.bpmProcessInstanceManager.getListByBpmnDefKey(defKey);
        for (DefaultBpmProcessInstance inst : instList) {
            this.bpmProcessInstanceManager.physicsRemove(inst.getId());
        }
        if (StringUtil.isNotEmpty((String)bpmDef.getBpmnDefId())) {
            this.bpmDefinitionDao.delActTask(bpmDef.getBpmnDefId());
        }
        this.removeActviti(defKey);
        this.removeDef(defKey);
    }

    private void removeDefByDef(BpmDefinition bpmDef) {
        if (bpmDef.isMain()) {
            throw new RuntimeException("\u975e\u7ea7\u8054\u5220\u9664\u65f6\uff0c\u4e0d\u80fd\u5220\u9664\u5f53\u524d\u4e3b\u7248\u672c\u7684\u6d41\u7a0b\u5b9a\u4e49");
        }
        this.publishEvent(bpmDef);
        List<DefaultBpmProcessInstance> instList = this.bpmProcessInstanceManager.getListByDefId(bpmDef.getDefId());
        for (DefaultBpmProcessInstance inst : instList) {
            this.bpmProcessInstanceManager.physicsRemove(inst.getId());
        }
        this.removeActvitiByDefId(bpmDef.getDefId());
        this.removeDefByDefId(bpmDef.getDefId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void copyDef(String defId, String name, String defKey, String typeId, String typeName) throws Exception {
        DefaultBpmDefinition bpmDefinition = (DefaultBpmDefinition)super.get((Serializable)((Object)defId));
        BpmDefData bpmDefData = (BpmDefData)this.bpmDefDataManager.get((Serializable)((Object)defId));
        String bpmnXml = bpmDefData.getBpmnXml();
        String oldDefKey = bpmDefinition.getDefKey();
        bpmnXml = this.updateBpmXml(bpmnXml, defKey, name);
        bpmDefinition.setDefKey(defKey);
        bpmDefinition.setName(name);
        bpmDefData.setBpmnXml(bpmnXml);
        String deployId = null;
        String bpmnDefId = null;
        try {
            deployId = this.natProDefinitionService.deploy("", bpmDefinition.getName(), bpmnXml);
            bpmnDefId = this.natProDefinitionService.getProcessDefinitionIdByDeployId(deployId);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error((Object)("Invoke natProDefinitionService.deploy method error = " + e.getMessage()));
        }
        bpmDefinition.setDefId(UniqueIdUtil.getSuid());
        bpmDefinition.setVersion(1);
        bpmDefinition.setMainDefId(bpmDefinition.getDefId());
        bpmDefinition.setIsMain("Y");
        bpmDefinition.setStatus("deploy");
        bpmDefinition.setTestStatus("test");
        bpmDefinition.setDesc("");
        bpmDefinition.setBpmnDefId(bpmnDefId);
        bpmDefinition.setBpmnDeployId(deployId);
        bpmDefinition.setBpmnXml(bpmnXml);
        bpmDefData.setId(bpmDefinition.getDefId());
        bpmDefinition.setCreateTime(LocalDateTime.now());
        if (StringUtil.isNotEmpty((String)typeId)) {
            bpmDefinition.setTypeId(typeId);
        }
        if (StringUtil.isNotEmpty((String)typeName)) {
            bpmDefinition.setTypeName(typeName);
        }
        super.create((Model)bpmDefinition);
        this.bpmDefDataManager.create((Model)bpmDefData);
        this.copyBpmProByDefId(defId, bpmDefinition.getDefId());
        this.copyBpmFormRightByFlowKey(oldDefKey, defKey);
        this.copyBpmNodeSettings(defId, bpmDefinition.getDefId());
    }

    private void copyBpmNodeSettings(String oldDefId, String newDefId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BpmNodeSetting::getDefId, (Object)oldDefId);
        List list = this.bpmNodeSettingManager.list((Wrapper)wrapper);
        list.forEach(item -> {
            BpmNodeSetting bpmNodeSetting = new BpmNodeSetting();
            bpmNodeSetting.setDefId(newDefId);
            bpmNodeSetting.setNodeId(item.getNodeId());
            bpmNodeSetting.setConditionJson(item.getConditionJson());
            bpmNodeSetting.setForecast(item.getForecast());
            this.bpmNodeSettingManager.save((Object)bpmNodeSetting);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void copyBpmFormRightByFlowKey(String oldDefKey, String defKey) throws Exception {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("flow_key_", (Object)oldDefKey, QueryOP.EQUAL);
        queryFilter.addFilter("permission_type_", (Object)1, QueryOP.EQUAL);
        queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        List lists = this.formRestfulService.queryFormRight(queryFilter);
        for (ObjectNode bpmFormRight : lists) {
            bpmFormRight.put("id", UniqueIdUtil.getSuid());
            bpmFormRight.put("flowKey", defKey);
            this.formRestfulService.createFormRight(bpmFormRight);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void copyBpmProByDefId(String oldDefId, String newDefId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", oldDefId);
        List<BpmProBo> lists = this.bpmProBoManager.getByProcess(params);
        for (BpmProBo bpmProBo : lists) {
            bpmProBo.setId(UniqueIdUtil.getSuid());
            bpmProBo.setProcessId(newDefId);
            this.bpmProBoManager.create((Model)bpmProBo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String updateBpmXml(String bpmnXml, String defKey, String name) {
        List participants;
        List collaborations;
        Document loadXml = Dom4jUtil.loadXml((String)bpmnXml);
        Element root = loadXml.getRootElement();
        List nodes = root.elements("process");
        if (nodes != null && nodes.size() == 1) {
            Element element = (Element)nodes.get(0);
            element.attribute("id").setText(defKey);
            element.attribute("name").setText(name);
        }
        if ((collaborations = root.elements("collaboration")) != null && collaborations.size() == 1 && (participants = ((Element)collaborations.get(0)).elements("participant")) != null) {
            for (Object participant : participants) {
                Element ptcp = (Element)participant;
                ptcp.attribute("processRef").setText(defKey);
            }
        }
        return Dom4jUtil.docToString((Document)loadXml);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updBpmDefinitionStatus(DefaultBpmDefinition bpmDefinition, String oldStatus) throws Exception {
    }

    @Override
    public DefaultBpmDefinition getBpmDefinitionByRev(Map<String, Object> map) {
        return this.bpmDefinitionDao.getBpmDefinitionByRev(map);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateTypeIdByDefKey(String defKey, String typeId) {
        this.bpmDefinitionDao.updateInstTypeIdByDefKey(defKey, typeId);
        this.bpmDefinitionDao.updateInstHiTypeIdByDefKey(defKey, typeId);
        this.bpmDefinitionDao.updateTaskTypeIdByDefKey(defKey, typeId);
        this.bpmDefinitionDao.updateTaskNoticeTypeIdByDefKey(defKey, typeId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> setDefType(String typeName, String typeId, List<String> defIds) {
        this.bpmDefinitionDao.updDefType(typeId, typeName, defIds);
        BpmUtil.clearCacheByDefIds(defIds);
        return new CommonResult("\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public List<Map<String, Object>> getDefCount(QueryFilter queryFilter) throws Exception {
        String oldDefKeys;
        IUser user = ContextUtil.getCurrentUser();
        String userId = user.getUserId();
        Map<String, ObjectNode> authorizeRightMap = null;
        boolean isAdmin = user.isAdmin();
        queryFilter.addParams("isAdmin", (Object)(isAdmin ? 1 : 0));
        if (!isAdmin) {
            authorizeRightMap = this.getCommUserCondition(userId, queryFilter);
        }
        BpmSecretaryManageManager secretaryManageManager = (BpmSecretaryManageManager)AppUtil.getBean(BpmSecretaryManageManager.class);
        Map<String, Object> leaderHasRightShareDefs = secretaryManageManager.getLeadersRigthMapBySecretaryId(userId, "1", true);
        HashMap defShareMap = new HashMap();
        HashSet allShareDefs = new HashSet();
        for (Map.Entry<String, Object> next : leaderHasRightShareDefs.entrySet()) {
            Map<String, Object> leaderActRightMap;
            String defKeys;
            String leaderId = next.getKey();
            Map value = (Map)next.getValue();
            Map laederRightMap = (Map)value.get("groupMap");
            String shaerDefKeys = (String)value.get("defKeys");
            if (StringUtil.isEmpty((String)shaerDefKeys) || StringUtil.isEmpty((String)(defKeys = (String)(leaderActRightMap = this.bpmDefAuthorizeManager.getActRightByRightMapAndUserId(leaderId, "start", true, true, laederRightMap)).get("defKeys")))) continue;
            defKeys = defKeys.replaceAll("'", "");
            HashSet<String> hasRightDefs = new HashSet<String>(Arrays.asList(defKeys.split(",")));
            HashSet<String> set = new HashSet<String>();
            set.addAll(hasRightDefs);
            if (!StringUtil.isNotEmpty((String)shaerDefKeys)) continue;
            shaerDefKeys = shaerDefKeys.replaceAll("'", "");
            set.retainAll(new HashSet<String>(Arrays.asList(shaerDefKeys.split(","))));
            for (String defKey : set) {
                Set<String> leaderIdSet = defShareMap.containsKey(defKey) ? (Set)defShareMap.get(defKey) : new HashSet();
                leaderIdSet.add(leaderId);
                defShareMap.put(defKey, leaderIdSet);
            }
            allShareDefs.addAll(set);
        }
        String string = oldDefKeys = BeanUtils.isEmpty(queryFilter.getParams().get("defKeys")) ? "''" : (String)queryFilter.getParams().get("defKeys");
        if (!allShareDefs.isEmpty()) {
            oldDefKeys = oldDefKeys + ",'" + StringUtil.join(new ArrayList(allShareDefs), (String)"','") + "'";
        }
        queryFilter.addParams("defKeys", (Object)oldDefKeys);
        this.copyQuerysInParams(queryFilter);
        return this.bpmDefinitionDao.getDefCount((Wrapper<DefaultBpmDefinition>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    public List<String> queryByTypeId(List<String> typeIds) {
        return ((BpmDefinitionDao)this.baseMapper).queryDefKeyByTypeId(typeIds);
    }

    @Override
    public Map<String, Object> getBindRelation(String defId) throws Exception {
        FormExt mobileFrm;
        BpmProcessDef<BpmProcessDefExt> bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        String defKey = bpmProcessDefExt.getDefKey();
        DefaultBpmProcessDefExt defExt = (DefaultBpmProcessDefExt)bpmProcessDefExt.getProcessDefExt();
        FormExt frm = defExt.getGlobalForm();
        HashMap<String, String> pcForm = new HashMap<String, String>();
        HashMap<String, String> mobileForm = new HashMap<String, String>();
        HashMap<String, Object> result = new HashMap<String, Object>();
        DefaultBpmDefinition defaultBpmDefinition = (DefaultBpmDefinition)this.get((Serializable)((Object)defId));
        DefaultBpmDefinition mainByDefKey = this.getMainByDefKey(defKey);
        String mainDefId = mainByDefKey.getDefId();
        String name = mainByDefKey.getName();
        result.put("defKey", defKey);
        result.put("mainDefId", mainDefId);
        result.put("defName", name);
        result.put("version", defaultBpmDefinition.getVersion());
        if (frm != null) {
            pcForm.put("pcName", frm.getName());
            pcForm.put("pcAlias", frm.getFormValue());
            ObjectNode objectNode = this.formRestfulService.getByFormKey(frm.getFormValue());
            BpmForm bpmForm = (BpmForm)JsonUtil.toBean((JsonNode)objectNode, BpmForm.class);
            pcForm.put("pcDefId", bpmForm.getDefId());
            pcForm.put("pcFormId", bpmForm.getId());
            Map pcEnt = this.formRestfulService.getFormData(frm.getFormValue(), "");
            result.put("pcForm", pcForm);
            result.put("pcEnt", pcEnt.get("pcEnt"));
        }
        if ((mobileFrm = defExt.getGlobalMobileForm()) != null) {
            mobileForm.put("mobileName", mobileFrm.getName());
            mobileForm.put("mobileAlias", mobileFrm.getFormValue());
            ObjectNode objectNode = this.formRestfulService.getByFormKey(mobileFrm.getFormValue());
            BpmForm bpmForm = (BpmForm)JsonUtil.toBean((JsonNode)objectNode, BpmForm.class);
            mobileForm.put("mobileDefId", bpmForm.getDefId());
            mobileForm.put("mobileFormId", bpmForm.getId());
            Map mobileEnt = this.formRestfulService.getFormData("", mobileFrm.getFormValue());
            result.put("mobileForm", mobileForm);
            result.put("mobileEnt", mobileEnt.get("mobileEnt"));
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> bpmDefinitionData(String alias) {
        return this.bpmDefinitionDao.getBpmDefinitionData(alias);
    }

    @Override
    @CachePut(value={"eip:bpm:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String putImportFileInCache(String fileId, String fileJson) {
        return fileJson;
    }

    @Override
    @Cacheable(value={"eip:bpm:importFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String getImportFileFromCache(String fileId) {
        return null;
    }

    @Override
    @CacheEvict(value={"eip:bpm:importFile"}, key="#fileId")
    public void delImportFileFromCache(String fileId) {
    }

    private InputStream getDiagramByInstance(DiagramService diagramService, String bpmnInstId) {
        BpmInstService bpmInstService = (BpmInstService)AppUtil.getBean(BpmInstService.class);
        BpmProcessInstance bpmProcessInstance = bpmInstService.getProcessInstanceByBpmnInstId(bpmnInstId);
        BpmProStatusManager bpmProStatusManager = (BpmProStatusManager)AppUtil.getBean(BpmProStatusManager.class);
        Map<String, String> colorMap = bpmProStatusManager.getProcessInstanceStatus(bpmProcessInstance.getId());
        return diagramService.getDiagramByDefId(bpmProcessInstance.getProcDefId(), colorMap);
    }

    @Override
    public List<DefaultBpmDefinition> getByMobileTypeKey(String typeKey, List<String> defKey) {
        String userId = "default".equals(typeKey) ? ContextUtil.getCurrentUserId() : "";
        return ((BpmDefinitionDao)this.baseMapper).getByMobileTypeKey(typeKey, userId, defKey);
    }

    @Override
    public PageList<DefaultBpmDefinition> getByMobileTypeId(String typeId, QueryFilter<DefaultBpmDefinition> queryFilter) {
        IPage<DefaultBpmDefinition> list = ((BpmDefinitionDao)this.baseMapper).getByMobileTypeId(typeId, (Wrapper<DefaultBpmDefinition>)this.convert2Wrapper(queryFilter, DefaultBpmDefinition.class), this.convert2IPage(queryFilter.getPageBean()));
        PageList pageList = new PageList(this.convert2IPage(queryFilter.getPageBean()));
        pageList.setTotal(list.getTotal());
        pageList.setRows(list.getRecords());
        return pageList;
    }

    public List<Map<String, Object>> getDefNodeUserByTeam(Map<String, Object> map) throws Exception {
        return ((BpmDefinitionDao)this.baseMapper).getDefNodeUserByTeam(map);
    }

    @Override
    public CommonResult<ObjectNode> getAllDefNodeUserByTeam(SearchDefNodeVO searchDefNodeVO) throws Exception {
        try {
            ObjectMapper mapper = JsonUtil.getMapper();
            ObjectNode objectNode = mapper.createObjectNode();
            HashMap<String, Object> map = new HashMap<String, Object>();
            String val = searchDefNodeVO.getVal();
            String type = searchDefNodeVO.getType();
            String tableData = searchDefNodeVO.getTableData();
            String dbType = SQLUtil.getDbType();
            map.put("val", val);
            map.put("tableData", tableData);
            map.put("type", type);
            map.put("dbType", dbType);
            if (DbType.POSTGRE_SQL.getDb().equals(dbType) || DbType.KINGBASE_ES.getDb().equals(dbType)) {
                map.put("customSql", "'\\<userAssign.*\\<calcs\\>.*" + val + ".*\\</calcs\\>.*userAssign\\>'");
            }
            List<Map<String, Object>> list = this.getDefNodeUserByTeam(map);
            ArrayNode results = mapper.createArrayNode();
            String rgexValue = "(<userAssign [\\s\\S]*?>[\\s\\S]*?</userAssign>)";
            String rgexSignScope = "(<ext:signNode [\\s\\S]*?>[\\s\\S]*?</ext:signNode>)";
            String rgexUserScope = "(<ext:userNode [\\s\\S]*?>[\\s\\S]*?</ext:userNode>)";
            String rgexTask = "<userTask id=\"[\\s\\S]*?\" name=\"[\\s\\S]*?\">[\\s\\S]";
            String taskXml = "<userTask id=\"(?<nameOne>.*?)\" name=\"(?<nameTwo>.*?)\">";
            String signXml = "<ext:signNode nodeType=\"common\" name=\"(?<nameOne>.*?)\" bpmnElement=\"(?<nameTwo>.*?)\">";
            String userXml = "<ext:userNode nodeType=\"common\" name=\"(?<nameOne>.*?)\" bpmnElement=\"(?<nameTwo>.*?)\">";
            String nameXml = "";
            if ("user".equals(type)) {
                nameXml = "<members account=\"(?<nameOne>.*?)\" userName=\"(?<nameTwo>.*?)\"/>";
            } else if ("org".equals(type)) {
                nameXml = "<org [\\s\\S]*? orgCode=\"(?<nameOne>.*?)\" orgName=\"(?<nameTwo>.*?)\">";
            } else if ("post".equals(type)) {
                nameXml = "<position [\\s\\S]*? posCode=\"(?<nameOne>.*?)\" posName=\"(?<nameTwo>.*?)\" [\\s\\S]*?>";
            } else if ("role".equals(type)) {
                nameXml = "<role [\\s\\S]*? roleCode=\"(?<nameOne>.*?)\" roleName=\"(?<nameTwo>.*?)\">";
            }
            for (Map<String, Object> mapObj : list) {
                List<String> listValue;
                HashMap<String, String> taskMap = new HashMap<String, String>();
                String bpmnXml = mapObj.get("bpmnXml").toString();
                if ("oracle".equals(SQLUtil.getDbType()) || "dm".equals(SQLUtil.getDbType())) {
                    bpmnXml = SQLUtil.ClobToString((Clob)((Clob)mapObj.get("bpmnXml")));
                }
                if ((listValue = this.getSubUtil(bpmnXml, rgexValue)) == null || listValue.isEmpty()) continue;
                Pattern pattern = Pattern.compile(rgexTask);
                Matcher m = pattern.matcher(bpmnXml);
                while (m.find()) {
                    Map<String, String> taskDetail = this.getMapSubUtil(m.group(), taskXml);
                    if (!StringUtil.isNotEmpty((String)taskDetail.get("nameOne"))) continue;
                    taskMap.put(taskDetail.get("nameOne"), taskDetail.get("nameTwo"));
                }
                listValue = listValue.stream().distinct().collect(Collectors.toList());
                for (String strVal : listValue) {
                    ObjectNode json;
                    Map<String, String> mapXml;
                    Map<String, String> mapName = this.getMapSubUtil(strVal, nameXml);
                    if (mapName.size() <= 0 || mapName.get("nameOne").indexOf(val) == -1) continue;
                    if (bpmnXml.indexOf("signNode") != -1) {
                        List<String> listSignScope = this.getSubUtil(bpmnXml, rgexSignScope);
                        for (String strSignScope : listSignScope) {
                            if (strSignScope.indexOf(strVal) == -1) continue;
                            mapXml = this.getMapSubUtil(strSignScope, signXml);
                            json = mapper.createObjectNode();
                            json.put("nodeId", mapXml.get("nameTwo"));
                            if (taskMap.containsKey(mapXml.get("nameTwo"))) {
                                json.put("nodeName", (String)taskMap.get(mapXml.get("nameTwo")));
                            } else {
                                json.put("nodeName", mapXml.get("nameOne"));
                            }
                            json.put("orderNum", String.valueOf(results.size() + 1));
                            json.put("nodeType", "signTask");
                            json.put("defId", mapObj.get("defId").toString());
                            json.put("defName", mapObj.get("defName").toString());
                            json.put("defKey", mapObj.get("defKey").toString());
                            json.put("bpmStatus", mapObj.get("bpmStatus").toString());
                            json.put("isMain", mapObj.get("isMain").toString());
                            json.put("version", mapObj.get("version").toString());
                            results.add((JsonNode)json);
                        }
                    }
                    List<String> listUserScope = this.getSubUtil(bpmnXml, rgexUserScope);
                    for (String strUserScope : listUserScope) {
                        if (strUserScope.indexOf(strVal) == -1) continue;
                        mapXml = this.getMapSubUtil(strUserScope, userXml);
                        json = mapper.createObjectNode();
                        json.put("nodeId", mapXml.get("nameTwo"));
                        if (taskMap.containsKey(mapXml.get("nameTwo"))) {
                            json.put("nodeName", (String)taskMap.get(mapXml.get("nameTwo")));
                        } else {
                            json.put("nodeName", mapXml.get("nameOne"));
                        }
                        json.put("orderNum", String.valueOf(results.size() + 1));
                        json.put("nodeType", "userTask");
                        json.put("defId", mapObj.get("defId").toString());
                        json.put("defName", mapObj.get("defName").toString());
                        json.put("defKey", mapObj.get("defKey").toString());
                        json.put("bpmStatus", mapObj.get("bpmStatus").toString());
                        json.put("isMain", mapObj.get("isMain").toString());
                        json.put("version", mapObj.get("version").toString());
                        results.add((JsonNode)json);
                    }
                }
            }
            objectNode.put("results", results.toString());
            return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)objectNode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u83b7\u53d6\u5931\u8d25");
        }
    }

    @Override
    public CommonResult<String> operatingDefSetting(Map<String, Object> map) throws Exception {
        try {
            String msg = "\u6d41\u7a0b\u914d\u7f6e\u8f6c\u79fb\u6210\u529f";
            String type = map.get("type").toString();
            String paType = map.get("paType").toString();
            List selectDefs = (List)map.get("selectDefs");
            for (Map mapObj : selectDefs) {
                String newXml;
                List<String> list;
                String defId = mapObj.get("defId").toString();
                BpmDefData bpmDefData = (BpmDefData)this.bpmDefDataManager.get((Serializable)((Object)defId));
                String bpmnXml = bpmDefData.getBpmnXml();
                String nodeId = mapObj.get("nodeId").toString();
                String nodeName = mapObj.get("nodeName").toString();
                String nodeType = mapObj.get("nodeType").toString();
                String nameXml = "";
                if ("user".equals(paType)) {
                    nameXml = "<members account=\"(?<nameOne>.*?)\" userName=\"(?<nameTwo>.*?)\"/>";
                } else if ("org".equals(paType)) {
                    nameXml = "<org [\\s\\S]*? orgCode=\"(?<nameOne>.*?)\" orgName=\"(?<nameTwo>.*?)\">";
                } else if ("post".equals(paType)) {
                    nameXml = "<position [\\s\\S]*? posCode=\"(?<nameOne>.*?)\" posName=\"(?<nameTwo>.*?)\" [\\s\\S]*?>";
                } else if ("role".equals(paType)) {
                    nameXml = "<role [\\s\\S]*? roleCode=\"(?<nameOne>.*?)\" roleName=\"(?<nameTwo>.*?)\">";
                }
                String nodeXml = "";
                if ("signTask".equals(nodeType)) {
                    nodeXml = "(<ext:signNode nodeType=\"common\" name=\"" + nodeName + "\" bpmnElement=\"" + nodeId + "\">[\\s\\S]*?</userAssign>)";
                }
                if ("userTask".equals(nodeType)) {
                    nodeXml = "(<ext:userNode nodeType=\"common\" name=\"" + nodeName + "\" bpmnElement=\"" + nodeId + "\">[\\s\\S]*?</userAssign>)";
                }
                if (BeanUtils.isEmpty(list = this.getSubUtil(bpmnXml, nodeXml))) {
                    return new CommonResult(false, "\u9009\u62e9\u7684\u8981\u8f6c\u79fb\u6216\u590d\u5236\u6d41\u7a0b\u914d\u7f6e\u4fe1\u606f\u6709\u8bef");
                }
                String oldXml = list.get(0);
                if ("user".equals(paType)) {
                    Map<String, String> mapName = this.getMapSubUtil(oldXml, nameXml);
                    Map oldUserObj = (Map)map.get("oldUserObj");
                    String oldAccount = oldUserObj.get("oldAccount").toString();
                    String oldUserName = oldUserObj.get("oldUserName").toString();
                    List userArray = (List)map.get("userArray");
                    StringBuilder account = new StringBuilder();
                    StringBuilder fullname = new StringBuilder();
                    for (Map mapUser : userArray) {
                        if (mapName.size() <= 0 || mapName.get("nameOne").contains(mapUser.get("account").toString())) continue;
                        account.append(mapUser.get("account").toString()).append(",");
                        fullname.append(mapUser.get("fullname").toString()).append(",");
                    }
                    if (StringUtil.isNotEmpty((String)account.toString())) {
                        account = new StringBuilder(account.substring(0, account.length() - 1));
                        fullname = new StringBuilder(fullname.substring(0, fullname.length() - 1));
                    }
                    if ("1".equals(type)) {
                        if (oldXml.contains("," + oldUserName) && oldXml.contains(oldUserName + ",")) {
                            oldAccount = "," + oldAccount + ",";
                            oldUserName = "," + oldUserName + ",";
                            if (StringUtil.isNotEmpty((String)account.toString())) {
                                account = new StringBuilder("," + account + ",");
                                fullname = new StringBuilder("," + fullname + ",");
                            } else {
                                account = new StringBuilder(",");
                                fullname = new StringBuilder(",");
                            }
                        } else if (oldXml.indexOf("," + oldUserName) != -1 && oldXml.indexOf(oldUserName + ",") == -1) {
                            oldAccount = "," + oldAccount;
                            oldUserName = "," + oldUserName;
                            if (StringUtil.isNotEmpty((String)account.toString())) {
                                account.insert(0, ",");
                                fullname.insert(0, ",");
                            }
                        } else if (oldXml.indexOf("," + oldUserName) == -1 && oldXml.indexOf(oldUserName + ",") != -1) {
                            oldAccount = oldAccount + ",";
                            oldUserName = oldUserName + ",";
                            if (StringUtil.isNotEmpty((String)account.toString())) {
                                account.append(",");
                                fullname.append(",");
                            }
                        } else if (oldXml.indexOf("," + oldUserName) == -1 && oldXml.indexOf(oldUserName + ",") == -1 && oldXml.indexOf("\"" + oldUserName + "\"") != -1) {
                            oldAccount = "\"" + oldAccount + "\"";
                            if (StringUtil.isNotEmpty((String)account.toString())) {
                                account = new StringBuilder("\"" + account + "\"");
                            }
                        }
                    } else if ("2".equals(type)) {
                        if (StringUtil.isNotEmpty((String)account.toString())) {
                            account.insert(0, oldAccount + ",");
                            fullname.insert(0, oldUserName + ",");
                        } else {
                            account = new StringBuilder(oldAccount);
                            fullname = new StringBuilder(oldUserName);
                        }
                        if (oldXml.indexOf("," + oldUserName) != -1 && oldXml.indexOf(oldUserName + ",") != -1) {
                            oldAccount = "," + oldAccount + ",";
                            oldUserName = "," + oldUserName + ",";
                            account = new StringBuilder("," + account + ",");
                            fullname = new StringBuilder("," + fullname + ",");
                        } else if (oldXml.indexOf("," + oldUserName) != -1 && oldXml.indexOf(oldUserName + ",") == -1) {
                            oldAccount = "," + oldAccount;
                            oldUserName = "," + oldUserName;
                            account.insert(0, ",");
                            fullname.insert(0, ",");
                        } else if (oldXml.indexOf("," + oldUserName) == -1 && oldXml.indexOf(oldUserName + ",") != -1) {
                            oldAccount = oldAccount + ",";
                            oldUserName = oldUserName + ",";
                            account.append(",");
                            fullname.append(",");
                        } else if (oldXml.indexOf("," + oldUserName) == -1 && oldXml.indexOf(oldUserName + ",") == -1 && oldXml.indexOf("\"" + oldUserName + "\"") != -1) {
                            oldAccount = "\"" + oldAccount + "\"";
                            account = new StringBuilder("\"" + account + "\"");
                        }
                    }
                    newXml = oldXml.replace(oldAccount, account.toString()).replace(oldUserName, fullname.toString());
                    bpmnXml = bpmnXml.replace(oldXml, newXml);
                } else {
                    Map oldTeamObj = (Map)map.get("oldTeamObj");
                    String oldCode = oldTeamObj.get("oldCode").toString();
                    String oldName = oldTeamObj.get("oldName").toString();
                    Map teamObj = (Map)map.get("teamObj");
                    String code = teamObj.get("code").toString();
                    String name = teamObj.get("name").toString();
                    Map<String, String> mapName = this.getMapSubUtil(oldXml, nameXml);
                    if (mapName.size() > 0 && mapName.get("nameOne").indexOf(code) == -1) {
                        if (oldXml.indexOf("," + name) == -1 && oldXml.indexOf(name + ",") == -1 && oldXml.indexOf("\"" + name + "\"") != -1) {
                            oldCode = "\"" + oldCode + "\"";
                            code = "\"" + code + "\"";
                        }
                        newXml = oldXml.replace(oldCode, code).replace(oldName, name);
                        bpmnXml = bpmnXml.replace(oldXml, newXml);
                    }
                }
                bpmDefData.setBpmnXml(bpmnXml);
                this.bpmDefinitionManager.updBpmData(defId, bpmDefData);
            }
            if ("2".equals(type)) {
                msg = "\u6d41\u7a0b\u914d\u7f6e\u590d\u5236\u6210\u529f";
            }
            return new CommonResult(true, msg);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25");
        }
    }

    public List<String> getSubUtil(String soap, String rgex) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern pattern = Pattern.compile(rgex);
        Matcher m = pattern.matcher(soap);
        while (m.find()) {
            int i = 1;
            list.add(m.group(i));
            ++i;
        }
        return list;
    }

    public Map<String, String> getMapSubUtil(String soap, String rgex) {
        HashMap<String, String> map = new HashMap<String, String>();
        Pattern pattern = Pattern.compile(rgex);
        Matcher m = pattern.matcher(soap);
        while (m.find()) {
            map.put("nameOne", m.group("nameOne"));
            if (!BeanUtils.isNotEmpty((Object)m.group("nameTwo"))) continue;
            map.put("nameTwo", m.group("nameTwo"));
        }
        return map;
    }

    @Override
    public void saveDefTags(ObjectNode params) {
        String defId = params.get("defId").asText();
        String tags = params.get("tags").asText();
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(DefaultBpmDefinition::getTags, (Object)tags)).eq(DefaultBpmDefinition::getDefId, (Object)defId);
        ((BpmDefinitionDao)this.baseMapper).update(null, (Wrapper)wrapper);
    }

    @Override
    public void physicsRemoveAllVersionByIds(String ids) {
        QueryWrapper defwrapper = new QueryWrapper();
        StringBuilder noAuthDeleteMessage = new StringBuilder();
        defwrapper.in((Object)"def_id_", Arrays.asList(ids.split(",")));
        List defs = this.list((Wrapper)defwrapper);
        HashSet<String> defKeys = new HashSet<String>();
        if (BeanUtils.isEmpty((Object)defs)) {
            return;
        }
        IUser currentUser = ContextUtil.getCurrentUser();
        Map<Object, Object> authorizeRightMap = new HashMap();
        if (!currentUser.isAdmin()) {
            try {
                authorizeRightMap = this.getCommUserCondition(currentUser.getUserId(), QueryFilter.build());
            }
            catch (IOException e) {
                throw new BaseException((Throwable)e);
            }
        }
        for (DefaultBpmDefinition def : defs) {
            if (currentUser.isAdmin() || authorizeRightMap.containsKey(def.getDefKey()) && ((ObjectNode)authorizeRightMap.get(def.getDefKey())).get("m_del").asBoolean()) {
                defKeys.add(def.getDefKey());
                continue;
            }
            noAuthDeleteMessage.append(String.format("\u3010%s\u3011", def.getName()));
        }
        if (BeanUtils.isNotEmpty(defKeys)) {
            List<Map<String, Object>> instIdsByKey = this.bpmProcessInstanceManager.getInstIdByDefKeys(defKeys);
            ArrayList<Map<String, Object>> allInstIds = new ArrayList<Map<String, Object>>();
            this.collcetAllSubInst(instIdsByKey, allInstIds);
            List partition = Lists.partition(allInstIds, (int)1000);
            partition.forEach(li -> {
                ArrayList instIds = new ArrayList();
                ArrayList bpmnIds = new ArrayList();
                li.forEach(inst -> {
                    instIds.add(MapUtil.getStringIgnoreKey((Map)inst, (String)"id_", null));
                    bpmnIds.add(MapUtil.getStringIgnoreKey((Map)inst, (String)"bpmn_inst_id_", null));
                });
                this.delRunTimeDataByInstIds(instIds.stream().filter(val -> StringUtil.isNotEmpty((String)val)).collect(Collectors.toList()), bpmnIds.stream().filter(val -> StringUtil.isNotEmpty((String)val)).collect(Collectors.toList()));
            });
            BpmProBoManager proBoManager = (BpmProBoManager)AppUtil.getBean(BpmProBoManager.class);
            QueryWrapper delWrapper = new QueryWrapper();
            delWrapper.in((Object)"PROCESS_ID_", Arrays.asList(ids.split(",")));
            proBoManager.remove((Wrapper)delWrapper);
            this.bpmDefinitionDao.delActRunVariableByKeys(defKeys);
            this.bpmDefinitionDao.delActRunExecutionByKeys(defKeys);
            this.bpmDefinitionDao.delActByteArrayByKeys(defKeys);
            this.bpmDefinitionDao.delActDeployByKeys(defKeys);
            this.bpmDefinitionDao.delActRunIdentitylinkByKeys(defKeys);
            this.bpmDefinitionDao.delActDefByKeys(defKeys);
            this.bpmDefinitionDao.delActTaskByKeys(defKeys);
            this.bpmDefDataManager.delByDefKeys(defKeys);
            this.bpmDefinitionDao.delByKeys(defKeys);
            defKeys.forEach(arg_0 -> ((UCFeignService)this.ucFeignService).removeMatrixProcRelationByProcDefKey(arg_0));
            this.formFeignService.removeByFlowKeys(defKeys.toArray(new String[0]));
            QueryWrapper defKeywrapper = new QueryWrapper();
            defKeywrapper.in((Object)"DEF_KEY_", defKeys);
            List defByKeys = this.list((Wrapper)defKeywrapper);
            for (DefaultBpmDefinition def : defByKeys) {
                this.publishEvent(def);
            }
        }
        if (noAuthDeleteMessage.length() > 0) {
            throw new BaseException("\u65e0\u4ee5\u4e0b\u6d41\u7a0b\u5220\u9664\u6743\u9650 " + noAuthDeleteMessage.toString());
        }
    }

    private void collcetAllSubInst(List<Map<String, Object>> parentIds, List<Map<String, Object>> allIds) {
        if (parentIds.size() == 0) {
            return;
        }
        allIds.addAll(parentIds);
        List partition = Lists.partition(parentIds, (int)1000);
        ArrayList<Map<String, Object>> subInstIds = new ArrayList<Map<String, Object>>();
        partition.forEach(li -> {
            HashSet<String> idSet = new HashSet<String>();
            li.forEach(inst -> idSet.add(MapUtil.getIgnoreCase((Map)inst, (String)"id_").toString()));
            subInstIds.addAll(this.bpmProcessInstanceManager.getInstIdByParentInstIds(idSet));
        });
        this.collcetAllSubInst(subInstIds, allIds);
    }

    private void delRunTimeDataByInstIds(List<String> instIds, List<String> bpmnInstIds) {
        if (BeanUtils.isNotEmpty(bpmnInstIds)) {
            this.actExecutionManager.delByInstList(bpmnInstIds);
            this.commonManager.batchDelete("act_ru_execution", "id_", bpmnInstIds);
        }
        if (BeanUtils.isNotEmpty(instIds)) {
            this.commonManager.batchDelete("bpm_check_opinion", "proc_inst_id_", instIds);
            this.bpmTaskCandidateManager.delByInstList(instIds);
            this.commonManager.batchDelete("bpm_task", "proc_inst_id_", instIds);
            this.commonManager.batchDelete("bpm_pro_status", "proc_inst_id_", instIds);
            this.commonManager.batchDelete("bpm_pro_cpto", "inst_id_", instIds);
            this.bpmTaskTurnManager.delByInstList(instIds);
            this.commonManager.batchDelete("bpm_task_signdata", "inst_id_", instIds);
            this.commonManager.batchDelete("bpm_task_read", "proc_inst_id_", instIds);
            this.commonManager.batchDelete("bpm_inst_form", "inst_id_", instIds);
            this.commonManager.batchDelete("bpm_task_notice", "PROC_INST_ID_", instIds);
            this.commonManager.batchDelete("bpm_task_notice_done", "PROC_INST_ID_", instIds);
            this.commonManager.batchDelete("bpm_task_turn", "proc_inst_id_", instIds);
            this.commonManager.batchDelete("bpm_pro_inst", "id_", instIds);
        }
    }

    @Override
    public void physicsRemoveAllVersionByKey(List<String> keys) {
        QueryWrapper defwrapper = new QueryWrapper();
        defwrapper.in((Object)"def_key_", keys);
        List defs = this.list((Wrapper)defwrapper);
        HashSet<String> defKeys = new HashSet<String>();
        if (BeanUtils.isEmpty((Object)defs)) {
            return;
        }
        defs.forEach(def -> defKeys.add(def.getDefKey()));
        List<Map<String, Object>> instIdsByKey = this.bpmProcessInstanceManager.getInstIdByDefKeys(defKeys);
        ArrayList<Map<String, Object>> allInstIds = new ArrayList<Map<String, Object>>();
        this.collcetAllSubInst(instIdsByKey, allInstIds);
        List partition = Lists.partition(allInstIds, (int)1000);
        partition.forEach(li -> {
            ArrayList<String> instIds = new ArrayList<String>();
            ArrayList<String> bpmnIds = new ArrayList<String>();
            li.forEach(inst -> {
                instIds.add(MapUtil.getIgnoreCase((Map)inst, (String)"id_").toString());
                bpmnIds.add(MapUtil.getIgnoreCase((Map)inst, (String)"bpmn_inst_id_").toString());
            });
            this.delRunTimeDataByInstIds(instIds, bpmnIds);
        });
        BpmProBoManager proBoManager = (BpmProBoManager)AppUtil.getBean(BpmProBoManager.class);
        QueryWrapper delWrapper = new QueryWrapper();
        delWrapper.in((Object)"process_key_", keys);
        proBoManager.remove((Wrapper)delWrapper);
        this.bpmDefinitionDao.delActRunVariableByKeys(defKeys);
        this.bpmDefinitionDao.delActRunExecutionByKeys(defKeys);
        this.bpmDefinitionDao.delActByteArrayByKeys(defKeys);
        this.bpmDefinitionDao.delActDeployByKeys(defKeys);
        this.bpmDefinitionDao.delActRunIdentitylinkByKeys(defKeys);
        this.bpmDefinitionDao.delActDefByKeys(defKeys);
        this.bpmDefinitionDao.delActTaskByKeys(defKeys);
        this.bpmDefDataManager.delByDefKeys(defKeys);
        this.bpmDefinitionDao.delByKeys(defKeys);
        QueryWrapper defKeywrapper = new QueryWrapper();
        defKeywrapper.in((Object)"DEF_KEY_", defKeys);
        List defByKeys = this.list((Wrapper)defKeywrapper);
        for (DefaultBpmDefinition def2 : defByKeys) {
            this.publishEvent(def2);
        }
    }

    @Override
    public Map<String, Object> webDefDesignByDefKey(String defKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        DefaultBpmDefinition def = this.bpmDefinitionManager.getMainByDefKey(defKey);
        if (BeanUtils.isNotEmpty((Object)def)) {
            map.put("defId", def.getDefId());
            map.put("name", def.getName());
            map.put("desc", def.getDesc());
            map.put("defKey", def.getDefKey());
            map.put("modelId", def.getDefId());
            map.put("model", def.getDefJson());
            map.put("reason", def.getReason());
            map.put("version", def.getVersion());
            map.put("showUrgentState", def.getShowUrgentState());
            map.put("showModifyRecord", def.getShowModifyRecord());
            map.put("isReadRevoke", def.getIsReadRevoke());
            map.put("urgentMailTel", def.getUrgentMailTel());
            map.put("urgentSmsTel", def.getUrgentSmsTel());
            map.put("bpmnXml", def.getBpmnXml());
            map.put("designPattern", def.getDesignPattern());
            ObjectNode type = null;
            if (BeanUtils.isNotEmpty((Object)def.getTypeId())) {
                type = this.portalFeignService.getSysTypeById(def.getTypeId());
            }
            if (BeanUtils.isNotEmpty(type)) {
                map.put("typeId", def.getTypeId());
                map.put("typeName", type.get("name").asText());
            }
        }
        return map;
    }

    @Override
    public HashMap<String, Object> batchDeleteNode(String nodeName, String defIds) throws Exception {
        String[] split;
        ArrayList<DefaultBpmDefinition> noList = new ArrayList<DefaultBpmDefinition>();
        ArrayList<DefaultBpmDefinition> errorList = new ArrayList<DefaultBpmDefinition>();
        ArrayList<DefaultBpmDefinition> okList = new ArrayList<DefaultBpmDefinition>();
        for (String defId : split = defIds.split(",")) {
            DefaultBpmDefinition mainByDefKey = this.bpmDefinitionManager.getById(defId);
            try {
                String attributeValue;
                String bpmnXml = mainByDefKey.getBpmnXml();
                System.out.println(bpmnXml);
                Document document = DocumentHelper.parseText((String)bpmnXml);
                Element rootElement = document.getRootElement();
                Element process = rootElement.element("process");
                List userTasks = process.elements("userTask");
                Element delUserTask = null;
                for (Element elm : userTasks) {
                    String attributeValue2 = elm.attributeValue("name");
                    if (!nodeName.equals(attributeValue2)) continue;
                    delUserTask = elm;
                    break;
                }
                if (BeanUtils.isEmpty(delUserTask)) {
                    noList.add(mainByDefKey);
                    break;
                }
                String delUserTaskId = delUserTask.attributeValue("id");
                userTasks.remove(delUserTask);
                List sequenceFlows = process.elements("sequenceFlow");
                Element delsequenceFlow = null;
                for (Element elm : sequenceFlows) {
                    String attributeValue3 = elm.attributeValue("sourceRef");
                    if (!delUserTaskId.equals(attributeValue3)) continue;
                    delsequenceFlow = elm;
                    break;
                }
                sequenceFlows.remove(delsequenceFlow);
                String nextNodeId = delsequenceFlow.attributeValue("targetRef");
                Element sourceEl = null;
                for (Element elm : sequenceFlows) {
                    attributeValue = elm.attributeValue("targetRef");
                    if (!delUserTaskId.equals(attributeValue)) continue;
                    sourceEl = elm;
                    elm.attributeValue("targetRef", nextNodeId);
                }
                for (Element elm : userTasks) {
                    attributeValue = elm.attributeValue("id");
                    if (!nextNodeId.equals(attributeValue)) continue;
                    Element element = elm.element("incoming");
                    element.setText(sourceEl.attributeValue("id"));
                    break;
                }
                Element BPMNDiagram2 = rootElement.element("BPMNDiagram");
                Element BPMNPlane2 = BPMNDiagram2.element("BPMNPlane");
                List BPMNShapes = BPMNPlane2.elements("BPMNShape");
                Element delShapes = null;
                for (Element elm : BPMNShapes) {
                    String attributeValue4 = elm.attributeValue("bpmnElement");
                    if (!delUserTaskId.equals(attributeValue4)) continue;
                    delShapes = elm;
                    break;
                }
                BPMNShapes.remove(delShapes);
                List BPMNEdge2 = BPMNPlane2.elements("BPMNEdge");
                Element delBPMNEdge = null;
                String delId = delsequenceFlow.attributeValue("id");
                for (Element elm : BPMNEdge2) {
                    String attributeValue5 = elm.attributeValue("bpmnElement");
                    if (!delId.equals(attributeValue5)) continue;
                    delBPMNEdge = elm;
                    break;
                }
                BPMNEdge2.remove(delBPMNEdge);
                List waypoints = delBPMNEdge.elements("waypoint");
                Element waypoint = (Element)waypoints.get(waypoints.size() - 1);
                String x = waypoint.attributeValue("x");
                String y = waypoint.attributeValue("y");
                for (Element elm : BPMNEdge2) {
                    String attributeValue6 = elm.attributeValue("bpmnElement");
                    if (!sourceEl.attributeValue("id").equals(attributeValue6)) continue;
                    List elements = elm.elements("waypoint");
                    Element object = (Element)elements.get(elements.size() - 1);
                    object.attributeValue("x", x);
                    object.attributeValue("y", y);
                }
                Element extProcess = rootElement.element("extProcess");
                Element extNodes = extProcess.element("extNodes");
                List userNodes = extNodes.elements("userNode");
                Element delUserNode = null;
                for (Element elm : userNodes) {
                    String attributeValue7 = elm.attributeValue("bpmnElement");
                    if (!attributeValue7.equals(delUserTaskId)) continue;
                    delUserNode = elm;
                    break;
                }
                userNodes.remove(delUserNode);
                Element repetitionLine = null;
                for (Element elm : sequenceFlows) {
                    String id = elm.attributeValue("id");
                    String sourceRefValue = elm.attributeValue("sourceRef");
                    String targetValue = elm.attributeValue("targetRef");
                    if (id.equals(sourceEl.attributeValue("id")) || !sourceRefValue.equals(sourceEl.attributeValue("sourceRef")) || !targetValue.equals(sourceEl.attributeValue("targetRef"))) continue;
                    repetitionLine = elm;
                }
                if (repetitionLine != null) {
                    sequenceFlows.remove(sourceEl);
                    Element repetitionBPMNEdge = null;
                    for (Element elm : BPMNEdge2) {
                        String attributeValue8 = elm.attributeValue("bpmnElement");
                        if (!sourceEl.attributeValue("id").equals(attributeValue8)) continue;
                        repetitionBPMNEdge = elm;
                    }
                    BPMNEdge2.remove(repetitionBPMNEdge);
                }
                String asXML = document.asXML();
                System.out.println(asXML);
                mainByDefKey.setBpmnXml(asXML);
                boolean deploy = this.deploy(mainByDefKey, null);
                if (deploy) {
                    okList.add(mainByDefKey);
                    continue;
                }
                errorList.add(mainByDefKey);
            }
            catch (Exception e) {
                e.printStackTrace();
                errorList.add(mainByDefKey);
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("error", errorList);
        hashMap.put("noNode", noList);
        hashMap.put("ok", okList);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, Object> batchAddNode(HashMap<String, Object> parmter) throws Exception {
        String[] split;
        String defIds = (String)parmter.get("defIds");
        String nodeKey = (String)parmter.get("nodeKey");
        String nodeName = (String)parmter.get("nodeName");
        String selectNode = (String)parmter.get("selectNode");
        String userJson = (String)parmter.get("userJson");
        String type = (String)parmter.get("type");
        String action = (String)parmter.get("action");
        ArrayList<DefaultBpmDefinition> noList = new ArrayList<DefaultBpmDefinition>();
        ArrayList<ObjectNode> errorList = new ArrayList<ObjectNode>();
        ArrayList<DefaultBpmDefinition> okList = new ArrayList<DefaultBpmDefinition>();
        for (String defId : split = defIds.split(",")) {
            Element selectUserTask = null;
            ArrayList<Element> supLine = new ArrayList<Element>();
            ArrayList<Element> nextLine = new ArrayList<Element>();
            Element userTask = null;
            ArrayList<Object> nextTask = new ArrayList<Object>();
            ArrayList<Object> supTask = new ArrayList<Object>();
            HashMap<String, Element> idUserNodeMap = new HashMap<String, Element>();
            HashMap idNodeMap = new HashMap();
            HashMap<String, ArrayList<Element>> sourceRefSequenceFlowMap = new HashMap<String, ArrayList<Element>>();
            HashMap<String, ArrayList<Element>> targetRefSequenceFlowMap = new HashMap<String, ArrayList<Element>>();
            DefaultBpmDefinition mainByDefKey = this.bpmDefinitionManager.getById(defId);
            String bpmnXml = mainByDefKey.getBpmnXml();
            Document document = DocumentHelper.parseText((String)bpmnXml);
            Element rootElement = document.getRootElement();
            Element process = rootElement.element("process");
            List userTasks = process.elements("userTask");
            for (Element elm : userTasks) {
                String attributeValue = elm.attributeValue("name");
                if (BeanUtils.isEmpty(selectUserTask) && selectNode.equals(attributeValue)) {
                    selectUserTask = elm;
                }
                idUserNodeMap.put(elm.attributeValue("id"), elm);
            }
            if (BeanUtils.isEmpty(selectUserTask)) {
                noList.add(mainByDefKey);
                break;
            }
            try {
                Element endwaypoint;
                List elements;
                Element element;
                Object addElement;
                List elements2 = process.elements();
                for (Element elm2 : elements2) {
                    idUserNodeMap.put(elm2.attributeValue("id"), elm2);
                }
                if (idNodeMap.containsKey(nodeKey)) {
                    throw new RuntimeException("\u5df2\u7ecf\u5b58\u5728\u8fd9\u4e2a\u8282\u70b9key");
                }
                List sequenceFlows = process.elements("sequenceFlow");
                for (Element element2 : sequenceFlows) {
                    String sourceRef = element2.attributeValue("sourceRef");
                    String targetRef = element2.attributeValue("targetRef");
                    ArrayList<Element> targetReflist = (ArrayList<Element>)targetRefSequenceFlowMap.get(targetRef);
                    if (BeanUtils.isEmpty((Object)targetReflist)) {
                        targetReflist = new ArrayList<Element>();
                    }
                    targetReflist.add(element2);
                    targetRefSequenceFlowMap.put(targetRef, targetReflist);
                    ArrayList<Element> sourceReflist = (ArrayList<Element>)sourceRefSequenceFlowMap.get(sourceRef);
                    if (BeanUtils.isEmpty((Object)sourceReflist)) {
                        sourceReflist = new ArrayList<Element>();
                    }
                    sourceReflist.add(element2);
                    sourceRefSequenceFlowMap.put(sourceRef, sourceReflist);
                }
                userTask = process.addElement("userTask");
                if ("1".equals(type)) {
                    supLine.addAll((Collection)targetRefSequenceFlowMap.get(selectUserTask.attributeValue("id")));
                    addElement = process.addElement("sequenceFlow");
                    nextLine.add((Element)addElement);
                    nextTask.add(selectUserTask);
                    for (Element sup : supLine) {
                        supTask.add(idNodeMap.get(sup.attributeValue("sourceRef")));
                    }
                } else {
                    addElement = process.addElement("sequenceFlow");
                    supLine.add((Element)addElement);
                    nextLine.addAll((Collection)sourceRefSequenceFlowMap.get(selectUserTask.attributeValue("id")));
                    supTask.add(selectUserTask);
                    for (Element sup : nextLine) {
                        nextTask.add(idNodeMap.get(sup.attributeValue("targetRef")));
                    }
                }
                if ("1".equals(type)) {
                    for (Element element3 : nextLine) {
                        element3.addAttribute("id", nodeKey + "-" + selectUserTask.attributeValue("id"));
                        element3.addAttribute("sourceRef", nodeKey);
                        element3.addAttribute("targetRef", selectUserTask.attributeValue("id"));
                    }
                    for (Element element4 : supLine) {
                        element4.attributeValue("targetRef", nodeKey);
                    }
                    for (Element element5 : nextTask) {
                        Element element3 = element5.element("incoming");
                        element3.setText(nodeKey + "-" + selectUserTask.attributeValue("id"));
                    }
                } else {
                    for (Element element6 : supLine) {
                        element6.addAttribute("id", selectUserTask.attributeValue("id") + "-" + nodeKey);
                        element6.addAttribute("sourceRef", selectUserTask.attributeValue("id"));
                        element6.addAttribute("targetRef", nodeKey);
                    }
                    for (Element element7 : nextLine) {
                        element7.attributeValue("sourceRef", nodeKey);
                    }
                    for (Element element8 : supTask) {
                        Element element9 = element8.element("outgoing");
                        element9.setText(selectUserTask.attributeValue("id") + "-" + nodeKey);
                    }
                }
                userTask.addAttribute("id", nodeKey);
                userTask.addAttribute("name", nodeName);
                Element extensionElements = userTask.addElement("extensionElements");
                Element element10 = extensionElements.addElement("activiti:taskListener");
                element10.addAttribute("delegateExpression", "${taskCreateListener}");
                element10.addAttribute("event", "create");
                Element addElement2 = extensionElements.addElement("activiti:taskListener");
                addElement2.addAttribute("delegateExpression", "${taskCompleteListener}");
                addElement2.addAttribute("event", "complete");
                for (Element sup2 : supLine) {
                    Element incoming = userTask.addElement("incoming");
                    incoming.setText(sup2.attributeValue("id"));
                }
                for (Element next : nextLine) {
                    Element outgoing = userTask.addElement("outgoing");
                    outgoing.setText(next.attributeValue("id"));
                }
                HashMap<String, Element> idBPMNShapeMap = new HashMap<String, Element>();
                Element BPMNDiagram2 = rootElement.element("BPMNDiagram");
                Element BPMNPlane2 = BPMNDiagram2.element("BPMNPlane");
                List BPMNShapes = BPMNPlane2.elements();
                for (Element elm4 : BPMNShapes) {
                    String attributeValue = elm4.attributeValue("bpmnElement");
                    idBPMNShapeMap.put(attributeValue, elm4);
                }
                Element userNodexy = BPMNPlane2.addElement("bpmndi:BPMNShape");
                userNodexy.addAttribute("id", userTask.attributeValue("id") + "us");
                userNodexy.addAttribute("bpmnElement", userTask.attributeValue("id"));
                Element userNodexyBounds = userNodexy.addElement("omgdc:Bounds");
                String userNodeY = null;
                if ("1".equals(type)) {
                    Element element2 = (Element)idBPMNShapeMap.get(selectUserTask.attributeValue("id"));
                    Element element11 = element2.element("Bounds");
                    userNodexyBounds.addAttribute("x", element11.attributeValue("x"));
                    userNodeY = element11.attributeValue("y");
                    userNodexyBounds.addAttribute("y", userNodeY);
                } else {
                    Element element12 = (Element)idBPMNShapeMap.get(selectUserTask.attributeValue("id"));
                    Element element13 = element12.element("Bounds");
                    userNodexyBounds.addAttribute("x", element13.attributeValue("x"));
                    userNodeY = String.valueOf(Integer.valueOf(element13.attributeValue("y")) + 100);
                    userNodexyBounds.addAttribute("y", userNodeY);
                }
                userNodexyBounds.addAttribute("width", "100");
                userNodexyBounds.addAttribute("height", "46");
                for (Map.Entry entry : idBPMNShapeMap.entrySet()) {
                    if (((String)entry.getKey()).equals(userTask.attributeValue("id"))) continue;
                    Element element4 = (Element)entry.getValue();
                    Object elements3 = element4.elements("waypoint");
                    if (elements3.size() == 0) {
                        elements3 = element4.elements("Bounds");
                    }
                    Iterator iterator = elements3.iterator();
                    while (iterator.hasNext()) {
                        Element el = (Element)iterator.next();
                        String yv = el.attributeValue("y");
                        if (Integer.parseInt(yv) < Integer.parseInt(userNodeY)) continue;
                        el.attributeValue("y", String.valueOf(Integer.parseInt(yv) + 100));
                    }
                }
                Element nextLinexy = BPMNPlane2.addElement("bpmndi:BPMNEdge");
                Element element14 = nextLinexy.addElement("omgdi:waypoint");
                Element nextLinexyEnd = nextLinexy.addElement("omgdi:waypoint");
                if ("1".equals(type)) {
                    nextLinexy.addAttribute("id", ((Element)nextLine.get(0)).attributeValue("id") + "_line");
                    nextLinexy.addAttribute("bpmnElement", ((Element)nextLine.get(0)).attributeValue("id"));
                    element14.addAttribute("x", String.valueOf(Integer.valueOf(userNodexyBounds.attributeValue("x")) + 50));
                    element14.addAttribute("y", String.valueOf(Integer.valueOf(userNodexyBounds.attributeValue("y")) + 46));
                    nextLinexyEnd.addAttribute("x", String.valueOf(Integer.valueOf(userNodexyBounds.attributeValue("x")) + 50));
                    nextLinexyEnd.addAttribute("y", String.valueOf(Integer.valueOf(userNodexyBounds.attributeValue("y")) + 100));
                } else {
                    nextLinexy.addAttribute("id", ((Element)supLine.get(0)).attributeValue("id") + "_line");
                    nextLinexy.addAttribute("bpmnElement", ((Element)supLine.get(0)).attributeValue("id"));
                    element14.addAttribute("x", String.valueOf(Integer.valueOf(userNodexyBounds.attributeValue("x")) + 50));
                    element14.addAttribute("y", String.valueOf(Integer.valueOf(userNodexyBounds.attributeValue("y")) - 100 + 46));
                    nextLinexyEnd.addAttribute("x", String.valueOf(Integer.valueOf(userNodexyBounds.attributeValue("x")) + 50));
                    nextLinexyEnd.addAttribute("y", String.valueOf(Integer.valueOf(userNodexyBounds.attributeValue("y"))));
                }
                if ("1".equals(type)) {
                    for (Element line : supLine) {
                        element = (Element)idBPMNShapeMap.get(line.attributeValue("id"));
                        elements = element.elements("waypoint");
                        endwaypoint = (Element)elements.get(elements.size() - 1);
                        endwaypoint.attributeValue("x", String.valueOf(Integer.valueOf(userNodexyBounds.attributeValue("x")) + 50));
                        endwaypoint.attributeValue("y", userNodexyBounds.attributeValue("y"));
                    }
                } else {
                    for (Element line : nextLine) {
                        element = (Element)idBPMNShapeMap.get(line.attributeValue("id"));
                        elements = element.elements("waypoint");
                        endwaypoint = (Element)elements.get(0);
                        endwaypoint.attributeValue("x", String.valueOf(Integer.valueOf(userNodexyBounds.attributeValue("x")) + 50));
                        endwaypoint.attributeValue("y", String.valueOf(Integer.valueOf(userNodexyBounds.attributeValue("y")) + 46));
                    }
                }
                Element extProcess = rootElement.element("extProcess");
                Element extNodes = extProcess.element("extNodes");
                Element userNode = extNodes.addElement("ext:userNode");
                userNode.addAttribute("userNode", "common");
                userNode.addAttribute("name", nodeName);
                userNode.addAttribute("bpmnElement", nodeKey);
                Element extPlugins = userNode.addElement("ext:extPlugins");
                String asXML = document.asXML();
                System.out.println(asXML);
                mainByDefKey.setBpmnXml(asXML);
                boolean deploy = false;
                deploy = "1".equals(action) ? this.deploy(mainByDefKey, null) : this.bpmDefinitionService.updateBpmDefinition(mainByDefKey);
                if (!deploy) continue;
                String theNode = "";
                if (StringUtil.isNotEmpty((String)userJson)) {
                    ObjectNode objectNode = (ObjectNode)JsonUtil.toJsonNode((String)userJson);
                    Iterator fields = objectNode.fields();
                    HashMap<String, String> userMap = new HashMap<String, String>();
                    while (fields.hasNext()) {
                        Map.Entry ent = (Map.Entry)fields.next();
                        theNode = (String)ent.getKey();
                        userMap.put((String)ent.getKey(), JsonUtil.toJson((Object)objectNode.get((String)ent.getKey())));
                    }
                    UserDefBpmDefXmlHandler userDefBpmDefXmlHandler = (UserDefBpmDefXmlHandler)AppUtil.getBean(UserDefBpmDefXmlHandler.class);
                    DefaultBpmDefinition mainByDefKey2 = this.getMainByDefKey(mainByDefKey.getDefKey());
                    userDefBpmDefXmlHandler.saveNodeXml(mainByDefKey2.getId(), userMap, null);
                }
                okList.add(mainByDefKey);
            }
            catch (Exception e) {
                e.printStackTrace();
                ObjectNode jsonNode = (ObjectNode)JsonUtil.toJsonNode((Object)mainByDefKey);
                jsonNode.put("errMsg", e.getMessage());
                errorList.add(jsonNode);
            }
            finally {
                this.publishEvent(mainByDefKey);
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("error", errorList);
        hashMap.put("noNode", noList);
        hashMap.put("ok", okList);
        return hashMap;
    }

    @Override
    public String creatFreeedomFlow(List<Map<String, String>> freedomData, DefaultBpmDefinition def) throws Exception {
        DefaultBpmDefinition mainByDefKey = this.bpmDefinitionManager.getById(def.getId());
        String bpmnXml = mainByDefKey.getBpmnXml();
        Document document = DocumentHelper.parseText((String)bpmnXml);
        Element rootElement = document.getRootElement();
        Element process = rootElement.element("process");
        List userTasks = process.elements("userTask");
        List startEvents = process.elements("startEvent");
        List endEvents = process.elements("endEvent");
        List sequenceFlows = process.elements("sequenceFlow");
        String defId = UniqueIdUtil.getSuid();
        for (Element el : userTasks) {
            process.remove(el);
        }
        for (Element el : startEvents) {
            process.remove(el);
        }
        for (Element el : endEvents) {
            process.remove(el);
        }
        for (Element el : sequenceFlows) {
            process.remove(el);
        }
        Element BPMNDiagram2 = rootElement.element("BPMNDiagram");
        Element BPMNPlane2 = BPMNDiagram2.element("BPMNPlane");
        List BPMNShapes = BPMNPlane2.elements("BPMNShape");
        List BPMNEdges = BPMNPlane2.elements("BPMNEdge");
        for (Element el : BPMNShapes) {
            BPMNPlane2.remove(el);
        }
        for (Element el : BPMNEdges) {
            BPMNPlane2.remove(el);
        }
        Element extProcess = rootElement.element("extProcess");
        Element extNodes = extProcess.element("extNodes");
        List baseNodes = extNodes.elements("baseNode");
        List userNode = extNodes.elements("userNode");
        for (Element el : baseNodes) {
            extNodes.remove(el);
        }
        for (Element el : userNode) {
            extNodes.remove(el);
        }
        Element startEvent = process.addElement("startEvent");
        startEvent.addAttribute("id", "startEvent");
        startEvent.addAttribute("name", "\u5f00\u59cb");
        Element startEventoutgoing = startEvent.addElement("outgoing");
        startEventoutgoing.setText("start_userTask0_" + defId);
        Element startBPMNShape = BPMNPlane2.addElement("bpmndi:BPMNShape");
        startBPMNShape.addAttribute("id", "startEvent_di");
        startBPMNShape.addAttribute("bpmnElement", "startEvent");
        Element startaddElement = startBPMNShape.addElement("omgdc:Bounds");
        startaddElement.addAttribute("x", "95");
        startaddElement.addAttribute("y", "68");
        startaddElement.addAttribute("width", "30");
        startaddElement.addAttribute("height", "30");
        Element startBPMNLabel = startBPMNShape.addElement("bpmndi:BPMNLabel");
        Element startBounds = startBPMNLabel.addElement("omgdc:Bounds");
        startBounds.addAttribute("x", "99");
        startBounds.addAttribute("y", "101");
        startBounds.addAttribute("width", "22");
        startBounds.addAttribute("height", "14");
        Element startbaseNode = extNodes.addElement("ext:baseNode");
        startbaseNode.addAttribute("nodeType", "common");
        startbaseNode.addAttribute("name", "\u5f00\u59cb");
        startbaseNode.addAttribute("bpmnElement", "startEvent");
        startbaseNode.addElement("ext:extPlugins");
        Element sequenceFlow = process.addElement("sequenceFlow");
        sequenceFlow.addAttribute("id", "start_userTask0_" + defId);
        sequenceFlow.addAttribute("sourceRef", "startEvent");
        sequenceFlow.addAttribute("targetRef", "userTask0_" + defId);
        Element bpmndiBPMNEdge = BPMNPlane2.addElement("bpmndi:BPMNEdge");
        bpmndiBPMNEdge.addAttribute("id", "start_userTask0_" + defId + "_di");
        bpmndiBPMNEdge.addAttribute("bpmnElement", "start_userTask0_" + defId);
        Element addElement = bpmndiBPMNEdge.addElement("omgdi:waypoint");
        addElement.addAttribute("x", "125");
        addElement.addAttribute("y", "83");
        Element addElement1 = bpmndiBPMNEdge.addElement("omgdi:waypoint");
        addElement1.addAttribute("x", "180");
        addElement1.addAttribute("y", "83");
        Element userTask = process.addElement("userTask");
        userTask.addAttribute("id", "userTask0_" + defId);
        userTask.addAttribute("name", "\u53d1\u8d77\u4eba\u8282\u70b9");
        Element extensionElements = userTask.addElement("extensionElements");
        Element taskListener = extensionElements.addElement("activiti:taskListener");
        taskListener.addAttribute("delegateExpression", "${taskCreateListener}");
        taskListener.addAttribute("event", "create");
        Element taskListener1 = extensionElements.addElement("activiti:taskListener");
        taskListener1.addAttribute("delegateExpression", "${taskCompleteListener}");
        taskListener1.addAttribute("event", "complete");
        userTask.addElement("incoming").setText("start_userTask0_" + defId);
        userTask.addElement("outgoing").setText("userTask0_" + defId + "_userTask1_" + defId);
        Element startBPMNShape1 = BPMNPlane2.addElement("bpmndi:BPMNShape");
        startBPMNShape1.addAttribute("id", "userTask0_" + defId + "_di");
        startBPMNShape1.addAttribute("bpmnElement", "userTask0_" + defId);
        Element startaddElement1 = startBPMNShape1.addElement("omgdc:Bounds");
        startaddElement1.addAttribute("x", "180");
        startaddElement1.addAttribute("y", "60");
        startaddElement1.addAttribute("width", "100");
        startaddElement1.addAttribute("height", "46");
        Element userNode1 = extNodes.addElement("ext:userNode");
        userNode1.addAttribute("nodeType", "common");
        userNode1.addAttribute("name", "\u53d1\u8d77\u4eba");
        userNode1.addAttribute("bpmnElement", "userTask0_" + defId);
        Element userNode15 = userNode1.addElement("ext:extPlugins");
        IUser currentUser = ContextUtil.getCurrentUser();
        Element userNode2 = userNode15.addElement("userAssign", "http://www.jee-soft.cn/bpm/plugins/task/userAssign");
        Element userNode3 = userNode2.addElement("userRule", "http://www.jee-soft.cn/bpm/plugins/userCalc/base");
        userNode3.addAttribute("groupNo", "1");
        Element userNode5 = userNode3.addElement("description");
        userNode5.addText("[\u6307\u5b9a\u7528\u6237]" + currentUser.getFullname());
        Element userNode6 = userNode3.addElement("condition");
        userNode6.addText("{\"junction\":\"and\",\"condition\":[]}");
        Element userNode7 = userNode3.addElement("conditionMode");
        Element userNode8 = userNode3.addElement("parentFlowkey");
        userNode8.addText("local_");
        Element userNode9 = userNode3.addElement("type");
        userNode9.addText("user");
        Element userNode10 = userNode3.addElement("calcs");
        Element userNode13 = userNode10.addElement("cusers", "http://www.jee-soft.cn/bpm/plugins/userCalc/cusers");
        userNode13.addAttribute("extract", "no");
        userNode13.addAttribute("logicCal", "or");
        userNode13.addAttribute("source", "spec");
        Element userNode14 = userNode13.addElement("members");
        userNode14.addAttribute("account", currentUser.getAccount());
        userNode14.addAttribute("userId", currentUser.getUserId());
        userNode14.addAttribute("userName", currentUser.getFullname());
        int index = 1;
        int x = 280;
        for (int i = 0; i < freedomData.size(); ++i) {
            String formRightId;
            Element addElement3;
            Element addElement2;
            Element userNode11;
            Element addElement32;
            Element addElement22;
            Map<String, String> freedom = freedomData.get(i);
            String nodeName = freedom.get("nodeName");
            String nodeType = freedom.get("nodeType");
            String userName = freedom.get("userName");
            String userId = freedom.get("userId");
            String account = freedom.get("account");
            Element sequenceFlow1 = process.addElement("sequenceFlow");
            sequenceFlow1.addAttribute("id", "userTask" + (index - 1) + "_" + defId + "_userTask" + index + "_" + defId);
            sequenceFlow1.addAttribute("sourceRef", "userTask" + (index - 1) + "_" + defId);
            sequenceFlow1.addAttribute("targetRef", "userTask" + index + "_" + defId);
            Element bpmndiBPMNEdge1 = BPMNPlane2.addElement("bpmndi:BPMNEdge");
            bpmndiBPMNEdge1.addAttribute("id", "userTask" + (index - 1) + "_" + defId + "_userTask" + index + "_" + defId + "_di");
            bpmndiBPMNEdge1.addAttribute("bpmnElement", "userTask" + (index - 1) + "_" + defId + "_userTask" + index + "_" + defId);
            Element addElement11 = bpmndiBPMNEdge1.addElement("omgdi:waypoint");
            addElement11.addAttribute("x", "" + x);
            addElement11.addAttribute("y", "83");
            Element addElement12 = bpmndiBPMNEdge1.addElement("omgdi:waypoint");
            addElement12.addAttribute("x", "" + (x + 65));
            addElement12.addAttribute("y", "83");
            Element userTask1 = process.addElement("userTask");
            userTask1.addAttribute("id", "userTask" + index + "_" + defId);
            userTask1.addAttribute("name", nodeName);
            Element extensionElements1 = userTask1.addElement("extensionElements");
            Element taskListener11 = extensionElements1.addElement("activiti:taskListener");
            if ("2".equals(nodeType) || "3".equals(nodeType)) {
                taskListener11.addAttribute("delegateExpression", "${taskSignCreateListener}");
            } else {
                taskListener11.addAttribute("delegateExpression", "${taskCreateListener}");
            }
            taskListener11.addAttribute("event", "create");
            Element taskListener111 = extensionElements1.addElement("activiti:taskListener");
            taskListener111.addAttribute("delegateExpression", "${taskCompleteListener}");
            taskListener111.addAttribute("event", "complete");
            userTask1.addElement("incoming").setText("userTask" + (index - 1) + "_" + defId + "_userTask" + index + "_" + defId);
            if (i == freedomData.size() - 1) {
                userTask1.addElement("outgoing").setText("userTask" + index + "_" + defId + "_endEvent");
            } else {
                userTask1.addElement("outgoing").setText("userTask" + index + "_" + defId + "_userTask" + (index + 1) + "_" + defId);
            }
            if ("2".equals(nodeType)) {
                addElement22 = userTask1.addElement("multiInstanceLoopCharacteristics");
                addElement22.addAttribute("activiti:collection", "${actUserService.getSignUser(execution)}");
                addElement22.addAttribute("activiti:elementVariable", "assignee");
                addElement32 = addElement22.addElement("completionCondition");
                addElement32.addAttribute("xsi:type", "tFormalExpression");
                addElement32.addText("${signComplete.isComplete(execution)}");
            } else if ("3".equals(nodeType)) {
                addElement22 = userTask1.addElement("multiInstanceLoopCharacteristics");
                addElement22.addAttribute("isSequential", "true");
                addElement22.addAttribute("activiti:collection", "${actUserService.getSignUser(execution)}");
                addElement22.addAttribute("activiti:elementVariable", "assignee");
                addElement32 = addElement22.addElement("completionCondition");
                addElement32.addAttribute("xsi:type", "tFormalExpression");
                addElement32.addText("${signComplete.isComplete(execution)}");
            }
            Element startBPMNShape11 = BPMNPlane2.addElement("bpmndi:BPMNShape");
            startBPMNShape11.addAttribute("id", "userTask" + index + "_" + defId + "_di");
            startBPMNShape11.addAttribute("bpmnElement", "userTask" + index + "_" + defId);
            Element startaddElement11 = startBPMNShape11.addElement("omgdc:Bounds");
            startaddElement11.addAttribute("x", "" + (x + 65));
            startaddElement11.addAttribute("y", "60");
            startaddElement11.addAttribute("width", "100");
            startaddElement11.addAttribute("height", "46");
            Element addElement4 = null;
            if ("2".equals(nodeType)) {
                userNode11 = extNodes.addElement("ext:signNode");
                userNode11.addAttribute("nodeType", "common");
                userNode11.addAttribute("name", nodeName);
                userNode11.addAttribute("bpmnElement", "userTask" + index + "_" + defId);
                addElement4 = userNode11.addElement("ext:extPlugins");
                addElement2 = userNode11.addElement("ext:signSetting");
                addElement3 = addElement2.addElement("ext:signRule");
                addElement3.addAttribute("decideType", "refuse");
                addElement3.addAttribute("voteType", "amount");
                addElement3.addAttribute("voteAmount", "1");
                addElement3.addAttribute("followMode", "complete");
            } else if ("3".equals(nodeType)) {
                userNode11 = extNodes.addElement("ext:signNode");
                userNode11.addAttribute("nodeType", "common");
                userNode11.addAttribute("name", nodeName);
                userNode11.addAttribute("bpmnElement", "userTask" + index + "_" + defId);
                addElement4 = userNode11.addElement("ext:extPlugins");
                addElement2 = userNode11.addElement("ext:signSetting");
                addElement3 = addElement2.addElement("ext:signRule");
                addElement3.addAttribute("decideType", "refuse");
                addElement3.addAttribute("voteType", "amount");
                addElement3.addAttribute("voteAmount", "1");
                addElement3.addAttribute("followMode", "complete");
            } else {
                userNode11 = extNodes.addElement("ext:userNode");
                userNode11.addAttribute("nodeType", "common");
                userNode11.addAttribute("name", nodeName);
                userNode11.addAttribute("bpmnElement", "userTask" + index + "_" + defId);
                addElement4 = userNode11.addElement("ext:extPlugins");
            }
            if (StringUtil.isNotEmpty((String)userId)) {
                Element addElement23 = addElement4.addElement("userAssign", "http://www.jee-soft.cn/bpm/plugins/task/userAssign");
                Element addElement33 = addElement23.addElement("userRule", "http://www.jee-soft.cn/bpm/plugins/userCalc/base");
                addElement33.addAttribute("groupNo", "1");
                Element addElement5 = addElement33.addElement("description");
                addElement5.addText("[\u6307\u5b9a\u7528\u6237]" + userName);
                Element addElement6 = addElement33.addElement("condition");
                addElement6.addText("{\"junction\":\"and\",\"condition\":[]}");
                Element addElement7 = addElement33.addElement("conditionMode");
                Element addElement8 = addElement33.addElement("parentFlowkey");
                addElement8.addText("local_");
                Element addElement9 = addElement33.addElement("type");
                addElement9.addText("user");
                Element addElement10 = addElement33.addElement("calcs");
                Element addElement13 = addElement10.addElement("cusers", "http://www.jee-soft.cn/bpm/plugins/userCalc/cusers");
                addElement13.addAttribute("extract", "no");
                addElement13.addAttribute("logicCal", "or");
                addElement13.addAttribute("source", "spec");
                Element addElement14 = addElement13.addElement("members");
                addElement14.addAttribute("account", account);
                addElement14.addAttribute("userId", userId);
                addElement14.addAttribute("userName", userName);
            }
            if (StringUtil.isNotEmpty((String)(formRightId = freedom.get("field")))) {
                this.formFeignService.updateFormRightNodeById(formRightId, "userTask" + index + "_" + defId);
            }
            ++index;
            x = x + 100 + 65;
        }
        Element sequenceFlow1 = process.addElement("sequenceFlow");
        sequenceFlow1.addAttribute("id", "userTask" + (index - 1) + "_" + defId + "_endEvent");
        sequenceFlow1.addAttribute("sourceRef", "userTask" + (index - 1) + "_" + defId);
        sequenceFlow1.addAttribute("targetRef", "endEvent");
        Element bpmndiBPMNEdge1 = BPMNPlane2.addElement("bpmndi:BPMNEdge");
        bpmndiBPMNEdge1.addAttribute("id", "userTask" + (index - 1) + "_" + defId + "_endEvent_di");
        bpmndiBPMNEdge1.addAttribute("bpmnElement", "userTask" + (index - 1) + "_" + defId + "_endEvent");
        Element addElement11 = bpmndiBPMNEdge1.addElement("omgdi:waypoint");
        addElement11.addAttribute("x", "" + x);
        addElement11.addAttribute("y", "83");
        Element addElement12 = bpmndiBPMNEdge1.addElement("omgdi:waypoint");
        addElement12.addAttribute("x", "" + (x + 65));
        addElement12.addAttribute("y", "83");
        Element endEvent = process.addElement("endEvent");
        endEvent.addAttribute("id", "endEvent");
        endEvent.addAttribute("name", "\u7ed3\u675f");
        endEvent.addElement("incoming").setText("userTask" + (index - 1) + "_" + defId + "_endEvent");
        Element startBPMNShape11 = BPMNPlane2.addElement("bpmndi:BPMNShape");
        startBPMNShape11.addAttribute("id", "endEvent_di");
        startBPMNShape11.addAttribute("bpmnElement", "endEvent");
        Element startaddElement11 = startBPMNShape11.addElement("omgdc:Bounds");
        startaddElement11.addAttribute("x", "" + (x + 65));
        startaddElement11.addAttribute("y", "68");
        startaddElement11.addAttribute("width", "30");
        startaddElement11.addAttribute("height", "30");
        Element userNode11 = extNodes.addElement("ext:baseNode");
        userNode11.addAttribute("nodeType", "common");
        userNode11.addAttribute("name", "\u7ed3\u675f");
        userNode11.addAttribute("bpmnElement", "endEvent");
        userNode11.addElement("ext:extPlugins");
        String asXML = document.asXML();
        System.out.println(asXML);
        mainByDefKey.setBpmnXml(asXML);
        this.deploy(mainByDefKey, defId);
        DefaultBpmDefinition mainByDefKey2 = this.getMainByDefKey(def.getDefKey());
        this.updMainVersion(def.getDefId(), true);
        return mainByDefKey2.getDefId();
    }

    @Override
    public void exportDefNodeUserByTeam(SearchDefNodeVO searchDefNodeVO, HttpServletResponse httpServletResponse) throws Exception {
        String filename = "";
        long start = System.currentTimeMillis();
        if (BeanUtils.isNotEmpty((Object)searchDefNodeVO.getTitlePre())) {
            filename = filename + String.valueOf(searchDefNodeVO.getTitlePre());
        }
        filename = filename + "_\u6d41\u7a0b\u914d\u7f6e\u4fe1\u606f_" + start;
        CommonResult<ObjectNode> commonResult = this.getAllDefNodeUserByTeam(searchDefNodeVO);
        ArrayList list = new ArrayList();
        if (commonResult.getState().booleanValue() && commonResult.getValue() != null) {
            ObjectNode value = (ObjectNode)commonResult.getValue();
            String resultsStr = JsonUtil.getString((JsonNode)value, (String)"results", (String)"");
            ArrayNode jsonNode = (ArrayNode)JsonUtil.toJsonNode((String)resultsStr);
            for (int i = 0; i < jsonNode.size(); ++i) {
                JsonNode node = jsonNode.get(i);
                if (BeanUtils.isNotEmpty(searchDefNodeVO.getIds()) && !searchDefNodeVO.getIds().stream().collect(Collectors.toSet()).contains(JsonUtil.getString((JsonNode)node, (String)"orderNum", (String)"-"))) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("defName", JsonUtil.getString((JsonNode)node, (String)"defName", (String)""));
                map.put("defKey", JsonUtil.getString((JsonNode)node, (String)"defKey", (String)""));
                map.put("nodeName", JsonUtil.getString((JsonNode)node, (String)"nodeName", (String)""));
                map.put("nodeId", JsonUtil.getString((JsonNode)node, (String)"nodeId", (String)""));
                String nodeType = JsonUtil.getString((JsonNode)node, (String)"nodeType", (String)"");
                map.put("nodeTypeDesc", "signTask".equals(nodeType) ? "\u4f1a\u7b7e\u4efb\u52a1" : "\u7528\u6237\u4efb\u52a1");
                String isMain = JsonUtil.getString((JsonNode)node, (String)"isMain", (String)"");
                map.put("isMainDesc", "Y".equals(isMain) ? "\u662f" : "\u5426");
                String bpmStatus = JsonUtil.getString((JsonNode)node, (String)"bpmStatus", (String)"");
                map.put("bpmStatusDesc", "deploy".equals(bpmStatus) ? "\u53d1\u5e03" : "\u5426");
                map.put("version", JsonUtil.getString((JsonNode)node, (String)"version", (String)""));
                list.add(map);
            }
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("defName", "\u6d41\u7a0b\u540d\u79f0");
        map.put("defKey", "\u6d41\u7a0bKey");
        map.put("nodeName", "\u4efb\u52a1\u8282\u70b9\u540d\u79f0");
        map.put("nodeId", "\u4efb\u52a1\u8282\u70b9key");
        map.put("nodeTypeDesc", "\u4efb\u52a1\u8282\u70b9\u7c7b\u578b");
        map.put("isMainDesc", "\u662f\u5426\u4e3b\u7248\u672c");
        map.put("bpmStatusDesc", "\u6d41\u7a0b\u72b6\u6001");
        map.put("version", "\u6240\u5c5e\u7248\u672c");
        Workbook sheets = ExcelUtils.exportExcel((String)filename, map, list);
        ExcelUtil.downloadExcel((Workbook)sheets, (String)filename, (HttpServletResponse)httpServletResponse);
    }
}

