/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.ThreadMsgUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.TaskFinishCmd;
import com.hotent.bpm.api.constant.MultiInstanceType;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.delegate.BpmDelegateExecution;
import com.hotent.bpm.api.model.delegate.BpmDelegateTask;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.model.process.task.NodeDefTransient;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.engine.inst.DefaultProcessInstCmd;
import com.hotent.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.hotent.bpm.natapi.inst.NatProInstanceService;
import com.hotent.bpm.persistence.dao.BpmExeStackDao;
import com.hotent.bpm.persistence.dao.BpmExeStackRelationDao;
import com.hotent.bpm.persistence.manager.BpmExeStackExecutorManager;
import com.hotent.bpm.persistence.manager.BpmExeStackHisManager;
import com.hotent.bpm.persistence.manager.BpmExeStackManager;
import com.hotent.bpm.persistence.manager.BpmExeStackRelationManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.model.BpmExeStack;
import com.hotent.bpm.persistence.model.BpmExeStackExecutor;
import com.hotent.bpm.persistence.model.BpmExeStackHis;
import com.hotent.bpm.persistence.model.BpmExeStackRelation;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.persistence.util.BpmStackRelationUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="bpmExeStackManager")
public class BpmExeStackManagerImpl
extends BaseManagerImpl<BpmExeStackDao, BpmExeStack>
implements BpmExeStackManager {
    @Resource
    NatProInstanceService natProInstanceService;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmExeStackExecutorManager bpmExeStackExecutorManager;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    BpmTaskManager bpmTaskManager;
    @Resource
    BpmProcessInstanceManager instanceManager;
    @Resource
    BpmExeStackHisManager bpmExeStackHisManager;
    @Resource
    BpmExeStackRelationDao bpmExeStackRelationDao;

    public BpmExeStack constructStack(BpmTask bpmTask, BpmExeStack parentStack) {
        Short interpose = 0;
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        if (actionCmd instanceof TaskFinishCmd && ((TaskFinishCmd)actionCmd).isInterpose()) {
            interpose = 1;
        }
        String id = UniqueIdUtil.getSuid();
        BpmExeStack stack = new BpmExeStack();
        stack.setId(id);
        stack.setPrcoDefId(bpmTask.getProcDefId());
        stack.setNodeId(bpmTask.getNodeId());
        stack.setNodeName(bpmTask.getName());
        stack.setStartTime(LocalDateTime.now());
        stack.setProcInstId(bpmTask.getProcInstId());
        stack.setInterpose(interpose.shortValue());
        if (parentStack == null) {
            stack.setNodePath(id + ".");
            stack.setParentId("0");
        } else {
            String nodePath = parentStack.getNodePath() + id + ".";
            stack.setNodePath(nodePath);
            stack.setParentId(parentStack.getId());
        }
        return stack;
    }

    public BpmExeStack constructStack(String prcoDefId, String procInstId, String nodeId, String nodeName, String nodeType, short isMulitiTask, BpmExeStack parentStack) {
        Short interpose = 0;
        ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
        if (actionCmd instanceof TaskFinishCmd && ((TaskFinishCmd)actionCmd).isInterpose()) {
            interpose = 1;
        }
        String id = UniqueIdUtil.getSuid();
        BpmExeStack stack = new BpmExeStack();
        stack.setId(id);
        stack.setPrcoDefId(prcoDefId);
        stack.setNodeId(nodeId);
        stack.setNodeName(nodeName);
        stack.setStartTime(LocalDateTime.now());
        stack.setProcInstId(procInstId);
        stack.setInterpose(interpose.shortValue());
        stack.setIsMulitiTask(isMulitiTask);
        stack.setNodeType(nodeType);
        if (parentStack == null) {
            stack.setNodePath(id + ".");
            stack.setParentId("0");
        } else {
            String nodePath = parentStack.getNodePath() + id + ".";
            stack.setNodePath(nodePath);
            stack.setParentId(parentStack.getId());
        }
        return stack;
    }

    @Override
    public BpmExeStack getInitStack(String instId) {
        List<BpmExeStack> stacks = ((BpmExeStackDao)this.baseMapper).getInitStack(instId);
        if (BeanUtils.isEmpty(stacks)) {
            return null;
        }
        BpmExeStack startStack = null;
        if (stacks.size() > 1) {
            try {
                List<BpmNodeDef> startNodes = this.bpmDefinitionAccessor.getStartNodes(stacks.get(0).getPrcoDefId());
                for (BpmExeStack bpmExeStack : stacks) {
                    if (!bpmExeStack.getNodeId().equals(startNodes.get(0).getNodeId())) continue;
                    startStack = bpmExeStack;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            startStack = stacks.get(0);
        }
        return startStack;
    }

    @Override
    public BpmExeStack getPrevStack(String instId, String nodeId, String token) {
        List<BpmExeStack> curStackList = ((BpmExeStackDao)this.baseMapper).getByInstNodeToken(instId, nodeId, token);
        if (BeanUtils.isEmpty(curStackList)) {
            throw new RuntimeException("\u56e0\u65e7\u6570\u636e\u7684\u5806\u6808\u4fe1\u606f\u4e3a\u7a7a\uff01\u6682\u4e0d\u80fd\u7528\u6b64\u65b9\u5f0f\u9a73\u56de\u3002<br>\u8bf7\u9009\u62e9\u9a73\u56de\u5230\u53d1\u8d77\u4eba");
        }
        BpmExeStack curStack = curStackList.get(0);
        String parentStackId = curStack.getParentId();
        if (StringUtil.isZeroEmpty((String)parentStackId)) {
            return null;
        }
        BpmExeStack prevStack = (BpmExeStack)super.get((Serializable)((Object)parentStackId));
        return prevStack;
    }

    @Override
    @Transactional
    public void popStack(String instId, String currentNode, String currentToken, String handleMode, String destinationNode, String destinationToken) {
        BpmExeStack bpmExeStack;
        if ("true".equals(ThreadMsgUtil.getMapMsg((String)"inst_end_revoke"))) {
            return;
        }
        if (StringUtil.isEmpty((String)handleMode)) {
            handleMode = "direct";
        }
        BpmExeStack targetStack = null;
        List<BpmExeStack> targetList = ((BpmExeStackDao)this.baseMapper).getByInstNodeToken(instId, destinationNode, destinationToken);
        if (BeanUtils.isEmpty(targetList)) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u76ee\u6807\u8282\u70b9\u5806\u6808\u6570\u636e!");
        }
        if (targetList.size() > 1) {
            for (BpmExeStack stk : targetList) {
                if (stk.getEndTime() == null) continue;
                targetStack = stk;
            }
        }
        if (targetStack == null) {
            targetStack = targetList.get(0);
        }
        if (targetStack != null && BeanUtils.isNotEmpty((Object)((Object)(bpmExeStack = this.bpmExeStackManager.getStack(targetStack.getProcInstId(), targetStack.getNodeId(), null)))) && bpmExeStack.getId().trim().equals(targetStack.getParentId()) && "direct".equals(handleMode)) {
            this.handelTargetStackCurrentExecuter(bpmExeStack, currentNode, currentToken, instId);
        }
        if ("direct".equals(handleMode)) {
            this.handelTargetStackCurrentExecuter(targetStack, currentNode, currentToken, instId);
        } else {
            ((BpmExeStackDao)this.baseMapper).updateTagertNodeByProcInstIdAndNodeId(instId, destinationNode);
            ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
            actionCmd.addTransitVars("targetNodePath", targetStack.getNodePath());
            actionCmd.addTransitVars("isCancleNodePathTask", true);
            if (StringUtil.isNotZeroEmpty((String)targetStack.getParentId())) {
                ActionCmd cmd = ContextThreadUtil.getActionCmd();
                BpmExeStack parentStack = (BpmExeStack)super.get((Serializable)((Object)targetStack.getParentId()));
                if (cmd != null) {
                    cmd.addTransitVars("parentStack", (Object)parentStack);
                }
            }
        }
    }

    @Transactional
    public void handelTargetStackCurrentExecuter(BpmExeStack targetStack, String currentNode, String currentToken, String instId) {
        targetStack.setTargetNode(currentNode);
        targetStack.setTargetToken(currentToken);
        targetStack.setStartTime(LocalDateTime.now());
        targetStack.setEndTime(null);
        super.update((Model)targetStack);
        BpmExeStack currentStack = this.getStack(instId, currentNode, currentToken);
        if (BeanUtils.isEmpty((Object)((Object)currentStack))) {
            return;
        }
        List<BpmExeStackExecutor> executors = this.bpmExeStackExecutorManager.getByStackId(currentStack.getId());
        if (executors.size() == 1) {
            BpmExeStackExecutor executor = executors.get(0);
            executor.setAssigneeId(ContextUtil.getCurrentUserId());
            this.bpmExeStackExecutorManager.update((Model)executor);
        }
    }

    @Override
    @Transactional
    public void popStartStack(String instId, String currentNode, String handleMode) {
        if ("true".equals(ThreadMsgUtil.getMapMsg((String)"inst_end_revoke"))) {
            return;
        }
        BpmExeStack targetStack = this.getInitStack(instId);
        if (StringUtil.isEmpty((String)handleMode)) {
            handleMode = "direct";
        }
        if ("direct".equals(handleMode)) {
            this.handelTargetStackCurrentExecuter(targetStack, currentNode, null, instId);
        } else {
            ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
            if (actionCmd.getTransitVars("IsUnused") == null || !((Boolean)actionCmd.getTransitVars("IsUnused")).booleanValue()) {
                actionCmd.addTransitVars("targetNodePath", targetStack.getNodePath());
                actionCmd.addTransitVars("isCancleNodePathTask", true);
                actionCmd.addTransitVars("HAND_MODE_NORMAL_REJECT_START", true);
            }
        }
    }

    @Override
    public BpmExeStack getStack(String instId, String nodeId, String token) {
        List<BpmExeStack> list = ((BpmExeStackDao)this.baseMapper).getByInstNodeToken(instId, nodeId, token);
        if (BeanUtils.isNotEmpty(list)) {
            for (BpmExeStack stk : list) {
                if (stk.getNodeType().equals(NodeType.SUBSTARTGATEWAY.getKey())) continue;
                return stk;
            }
        }
        return null;
    }

    private boolean isGatewayJoinEvent(ActionCmd cmd) {
        boolean isGatewayUnmetJoinEvent = false;
        if (cmd.getTransitVars("CurrentEventType") != null && cmd.getTransitVars("CurrentEventType").toString().equals("GatewayUnmetJoinEvent")) {
            isGatewayUnmetJoinEvent = true;
        }
        return isGatewayUnmetJoinEvent;
    }

    @Override
    @Transactional
    public void pushStack(BpmDelegateExecution execution) throws Exception {
        if ("true".equals(ThreadMsgUtil.getMapMsg((String)"inst_end_revoke"))) {
            return;
        }
        String defId = (String)execution.getVariable("processDefId_");
        String token = execution.getVariable("token_") != null ? execution.getVariable("token_").toString() : null;
        String instId = (String)execution.getVariable("instanceId_");
        String nodeId = execution.getNodeId();
        MultiInstanceType instType = execution.multiInstanceType();
        BpmTask bpmTask = this.getByTaskId(instId, execution.getId());
        Map<String, Object> commuVars = ContextThreadUtil.getCommuVars();
        if (commuVars.containsKey("instanceId_")) {
            instId = (String)commuVars.get("instanceId_");
        }
        this.pushStack(defId, token, instId, nodeId, instType, bpmTask);
    }

    @Override
    @Transactional
    public void pushStack(BpmDelegateTask task) throws Exception {
        if ("true".equals(ThreadMsgUtil.getMapMsg((String)"inst_end_revoke"))) {
            return;
        }
        String defId = (String)task.getVariable("processDefId_");
        String token = task.getVariable("token_") != null ? task.getVariable("token_").toString() : null;
        String instId = (String)task.getVariable("instanceId_");
        String nodeId = task.getTaskDefinitionKey();
        Object variable = task.getVariable("parallel");
        MultiInstanceType instType = null;
        instType = BeanUtils.isNotEmpty((Object)variable) ? MultiInstanceType.PARALLEL : task.multiInstanceType();
        BpmTask bpmTask = this.getByTaskId(instId, task.getId());
        this.pushStack(defId, token, instId, nodeId, instType, bpmTask);
    }

    @Override
    @Transactional
    public void pushStack(String defId, String token, String instId, String nodeId, MultiInstanceType instType, BpmTask bpmTask) throws Exception {
        List<NodeDefTransient> listGateway;
        BpmProcessInstance topBpmProcessInstance;
        BpmNodeDef bpmNodeDef;
        boolean isGatewayUnmetJoinEvent;
        BpmExeStack bpmExeStack;
        if ("true".equals(ThreadMsgUtil.getMapMsg((String)"inst_end_revoke"))) {
            return;
        }
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        Object isDoneUnused = cmd.getTransitVars("IsDoneUnused");
        Object recordStack = cmd.getTransitVars("record_stack");
        if (recordStack == null && (BeanUtils.isNotEmpty((Object)isDoneUnused) || OpinionStatus.REJECT.getKey().equals(cmd.getActionName()) || OpinionStatus.BACK_TO_START.getKey().equals(cmd.getActionName()) && !"direct".equals(cmd.getTransitVars("backHandMode")))) {
            this.createExecutor(null, bpmTask);
            return;
        }
        BpmExeStack parentStack = null;
        BpmExeStack toStack = null;
        if (cmd instanceof DefaultTaskFinishCmd || cmd instanceof DefaultProcessInstCmd) {
            parentStack = (BpmExeStack)((Object)ContextThreadUtil.getCommuVar("parentStack", cmd.getTransitVars("parentStack")));
            if (parentStack == null) {
                List<BpmExeStack> stackList = ((BpmExeStackDao)this.baseMapper).getByInstNodeToken(instId, nodeId, token);
                if (stackList.size() <= 0) {
                    stackList = ((BpmExeStackDao)this.baseMapper).getByInstNodeToken(instId, nodeId, "");
                }
                if (BeanUtils.isNotEmpty(stackList)) {
                    toStack = stackList.get(0);
                    if ("direct".equals(cmd.getTransitVars("backHandMode")) && BeanUtils.isNotEmpty((Object)cmd.getTransitVars("target_node")) && "callActivity".equals(toStack.getNodeType())) {
                        toStack.setTargetNode(String.valueOf(cmd.getTransitVars("target_node")));
                    }
                    toStack.setStartTime(LocalDateTime.now());
                    toStack.setEndTime(null);
                    super.update((Model)toStack);
                    this.createExecutor(toStack, bpmTask);
                    return;
                }
            } else if (StringUtil.isNotEmpty((String)parentStack.getTargetNode())) {
                parentStack.setTargetNode("");
                if ("direct".equals(cmd.getTransitVars("backHandMode")) && BeanUtils.isNotEmpty((Object)cmd.getTransitVars("target_node")) && "callActivity".equals(parentStack.getNodeType())) {
                    parentStack.setTargetNode(String.valueOf(cmd.getTransitVars("target_node")));
                }
                parentStack.setTargetToken("");
                parentStack.setEndTime(LocalDateTime.now());
                super.update((Model)parentStack);
                List<BpmExeStack> stacks = ((BpmExeStackDao)this.baseMapper).getByInstNodeToken(instId, nodeId, token);
                if (BeanUtils.isEmpty(stacks)) {
                    stacks = ((BpmExeStackDao)this.baseMapper).getByInstNodeToken(instId, nodeId, "");
                }
                if (BeanUtils.isNotEmpty(stacks)) {
                    toStack = stacks.get(0);
                    if (StringUtil.isNotEmpty((String)cmd.getDestination()) && !cmd.getDestination().equals(toStack.getNodeId()) && NodeType.SIGNTASK.getKey().equals(toStack.getNodeType())) {
                        toStack.setTargetNode(cmd.getDestination());
                    }
                    toStack.setStartTime(LocalDateTime.now());
                    toStack.setEndTime(null);
                    super.update((Model)toStack);
                    this.createExecutor(toStack, bpmTask);
                    return;
                }
            }
        }
        if (parentStack != null && BeanUtils.isNotEmpty((Object)((Object)(bpmExeStack = this.bpmExeStackManager.getStack(parentStack.getProcInstId(), parentStack.getNodeId(), null)))) && bpmExeStack.getId().trim().equals(parentStack.getParentId())) {
            bpmExeStack.setTargetNode("");
            super.update((Model)bpmExeStack);
        }
        if (isGatewayUnmetJoinEvent = this.isGatewayJoinEvent(cmd)) {
            nodeId = bpmTask.getNodeId();
        }
        if (BeanUtils.isEmpty((Object)(bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId))) && isGatewayUnmetJoinEvent && BeanUtils.isNotEmpty((Object)(topBpmProcessInstance = this.instanceManager.getTopBpmProcessInstance(bpmTask.getProcInstId())))) {
            defId = topBpmProcessInstance.getProcDefId();
            bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        }
        if (BeanUtils.isNotEmpty(listGateway = BpmStackRelationUtil.getInComeGateway(defId, nodeId, parentStack)) && cmd instanceof DefaultTaskFinishCmd) {
            short isMulitiTask = (short)(!MultiInstanceType.NO.equals((Object)instType) ? 1 : 0);
            int n = listGateway.size();
            for (int i = n - 1; i >= 0; --i) {
                NodeDefTransient fromGateNode = listGateway.get(i);
                BpmExeStack stack = this.buildStack(fromGateNode, bpmTask, isMulitiTask, parentStack);
                BpmStackRelationUtil.createBpmExeStackRelation(instId, parentStack, stack);
                parentStack = stack;
            }
            toStack = this.constructStack(bpmTask, parentStack);
            toStack.setIsMulitiTask(isMulitiTask);
            toStack.setTaskToken(token);
            toStack.setNodeType(bpmNodeDef.getType().toString());
            if (this.getStack(instId, nodeId, token) == null) {
                super.create((Model)toStack);
                this.setParentStack(toStack);
            }
            BpmStackRelationUtil.createBpmExeStackRelation(instId, parentStack, toStack);
        } else {
            String targetNodeType = bpmNodeDef.getType().toString();
            if (isGatewayUnmetJoinEvent) {
                targetNodeType = cmd.getTransitVars("GatewayUnmetNoteType").toString();
                nodeId = bpmTask.getNodeId();
            }
            if (MultiInstanceType.NO.equals((Object)instType)) {
                toStack = this.constructStack(bpmTask, parentStack);
                toStack.setIsMulitiTask((short)0);
                toStack.setTaskToken(token);
                toStack.setNodeType(targetNodeType);
                if (isGatewayUnmetJoinEvent) {
                    List<BpmExeStack> dbGatewaysStacks = ((BpmExeStackDao)this.baseMapper).getByInstNodeToken(bpmTask.getProcInstId(), nodeId, "");
                    if (BeanUtils.isNotEmpty(dbGatewaysStacks)) {
                        toStack.setId(dbGatewaysStacks.get(0).getId());
                    } else {
                        super.create((Model)toStack);
                        this.setParentStack(toStack);
                    }
                } else {
                    super.create((Model)toStack);
                    this.setParentStack(toStack);
                }
            } else {
                toStack = this.getStack(instId, nodeId, token);
                if (toStack == null || recordStack != null) {
                    toStack = this.constructStack(bpmTask, parentStack);
                    toStack.setIsMulitiTask((short)1);
                    toStack.setTaskToken(token);
                    toStack.setNodeType(targetNodeType);
                    super.create((Model)toStack);
                    this.setParentStack(toStack);
                }
            }
            BpmStackRelationUtil.createBpmExeStackRelation(instId, parentStack, toStack);
        }
        if (isGatewayUnmetJoinEvent) {
            return;
        }
        this.createExecutor(toStack, bpmTask);
    }

    private void setParentStack(BpmExeStack toStack) {
        if (NodeType.SIGNTASK.getKey().equals(toStack.getNodeType()) || NodeType.CUSTOMSIGNTASK.getKey().equals(toStack.getNodeType())) {
            ContextThreadUtil.putCommonVars("parentStack", (Object)toStack);
        }
    }

    @Transactional
    public void createExecutor(BpmExeStack toStack, BpmTask bpmTask) {
        BpmExeStackExecutor executor;
        BpmExeStackExecutor bpmExeStackExecutor;
        if ("true".equals(ThreadMsgUtil.getMapMsg((String)"inst_end_revoke"))) {
            return;
        }
        String stackId = null;
        if (BeanUtils.isNotEmpty((Object)((Object)toStack))) {
            stackId = toStack.getId();
        }
        if (BeanUtils.isEmpty((Object)((Object)(bpmExeStackExecutor = this.bpmExeStackExecutorManager.getByTaskId((executor = this.getBpmExeStackExecutor(stackId, bpmTask.getId(), bpmTask.getAssigneeId())).getTaskId()))))) {
            this.bpmExeStackExecutorManager.create((Model)executor);
        }
    }

    @Transactional
    public BpmExeStack buildStack(NodeDefTransient gatewayNode, BpmTask bpmTask, short isMulitiTask, BpmExeStack parentStack) {
        BpmExeStack stack = new BpmExeStack();
        stack = this.constructStack(bpmTask.getProcDefId(), bpmTask.getProcInstId(), gatewayNode.getNodeId(), gatewayNode.getName(), gatewayNode.getType().toString(), isMulitiTask, parentStack);
        List<BpmExeStack> dbGatewaysStacks = ((BpmExeStackDao)this.baseMapper).getByInstNodeToken(bpmTask.getProcInstId(), gatewayNode.getNodeId(), "");
        if (BeanUtils.isNotEmpty(dbGatewaysStacks)) {
            gatewayNode.setBpmGatewayStackId(dbGatewaysStacks.get(0).getId());
            stack.setId(dbGatewaysStacks.get(0).getId());
            stack.setNodePath(dbGatewaysStacks.get(0).getNodePath());
        } else {
            gatewayNode.setBpmGatewayStackId(stack.getId());
            super.create((Model)stack);
        }
        return stack;
    }

    private BpmExeStackExecutor getBpmExeStackExecutor(String stackId, String taskId, String assignee) {
        BpmExeStackExecutor executor = new BpmExeStackExecutor();
        if (BeanUtils.isNotEmpty((Object)ContextThreadUtil.getActionCmd()) && ContextThreadUtil.getActionCmd().getTransitVars().containsKey("target_node")) {
            executor.setTargetNode((String)ContextThreadUtil.getActionCmd().getTransitVars().get("target_node"));
        }
        executor.setStackId(stackId);
        executor.setTaskId(taskId);
        if (StringUtil.isEmpty((String)assignee)) {
            assignee = "0";
        }
        executor.setAssigneeId(assignee);
        executor.setStatus(0);
        executor.setCreateTime(LocalDateTime.now());
        return executor;
    }

    private BpmTask getByTaskId(String instId, String taskId) {
        BpmTask bpmTask2 = null;
        Set<BpmTask> taskSet = ContextThreadUtil.getByInstId(instId);
        for (BpmTask bpmTask2 : taskSet) {
            if (bpmTask2.getTaskId().equals(taskId)) break;
        }
        return bpmTask2;
    }

    @Override
    public List<BpmExeStack> getPreStacksByInstIdNodeId(String procInstId, String nodeId) {
        List<BpmExeStack> exeStacks = ((BpmExeStackDao)this.baseMapper).getByInstNodeToken(procInstId, nodeId, "");
        if (BeanUtils.isEmpty(exeStacks)) {
            return Collections.emptyList();
        }
        String path = exeStacks.get(0).getNodePath();
        String[] ids = (path = path.replace(exeStacks.get(0).getId() + ".", "")).split("\\.");
        if (ids.length == 0) {
            return Collections.emptyList();
        }
        return ((BpmExeStackDao)this.baseMapper).getByIds(ids);
    }

    @Override
    public String getToTaskIdByFromTaskId(String fromTaskId) {
        return ((BpmExeStackDao)this.baseMapper).getToTaskIdByFromTaskId(fromTaskId);
    }

    @Override
    public String getCurrentTaskFromNodeId(String taskId) {
        return ((BpmExeStackDao)this.baseMapper).getCurrentTaskFromNodeId(taskId);
    }

    @Override
    public String getCurrentTaskFromUserNodeId(List<BpmNodeDef> allNodeDef, String taskId) throws Exception {
        BpmExeStackExecutor stackExecutor = this.bpmExeStackExecutorManager.getByTaskId(taskId);
        if (BeanUtils.isEmpty((Object)((Object)stackExecutor))) {
            return "";
        }
        DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
        Assert.notNull((Object)defaultBpmTask, (String)String.format("\u6839\u636e\u4efb\u52a1id[%s]\u672a\u67e5\u627e\u5230\u4efb\u52a1", taskId));
        if (BeanUtils.isEmpty(allNodeDef)) {
            allNodeDef = this.bpmDefinitionAccessor.getAllNodeDef(defaultBpmTask.getProcDefId());
        }
        if (BeanUtils.isEmpty(allNodeDef)) {
            return "";
        }
        HashSet userNodeIdSet = new HashSet();
        allNodeDef.forEach(node -> {
            if (NodeType.USERTASK.getKey().equals(node.getType().getKey()) || NodeType.SIGNTASK.getKey().equals(node.getType().getKey())) {
                userNodeIdSet.add(node.getNodeId());
            }
        });
        BpmExeStackRelationManager stackRelationManager = (BpmExeStackRelationManager)AppUtil.getBean(BpmExeStackRelationManager.class);
        List<BpmExeStackRelation> relations = stackRelationManager.getListByProcInstId(defaultBpmTask.getProcInstId());
        HashMap relationMap = new HashMap();
        relations.forEach(r -> {
            if (!relationMap.containsKey(r.getToStackId())) {
                relationMap.put(r.getToStackId(), r);
            }
        });
        String lastStackId = stackExecutor.getStackId();
        for (int count = 0; count < 100; ++count) {
            if (!relationMap.containsKey(lastStackId)) continue;
            BpmExeStackRelation preRelation = (BpmExeStackRelation)((Object)relationMap.get(lastStackId));
            if (userNodeIdSet.contains(preRelation.getFromNodeId())) {
                return preRelation.getFromNodeId();
            }
            lastStackId = preRelation.getFromStackId();
        }
        return "";
    }

    @Override
    public void removeActRuExeCution(String instId, Set<String> nodeIds, String notIncludeExecuteIds) {
        ((BpmExeStackDao)this.baseMapper).removeActRuVariableCution(instId, nodeIds, notIncludeExecuteIds);
        ((BpmExeStackDao)this.baseMapper).removeActRuExeCution(instId, nodeIds, notIncludeExecuteIds);
    }

    @Override
    @Transactional
    public void removeActRuExeCutionByPath(String instId, String targetNodePath, String notIncludeExecuteIds) {
        ((BpmExeStackDao)this.baseMapper).removeActRuVariableCutionByPath(instId, targetNodePath, notIncludeExecuteIds);
        ((BpmExeStackDao)this.baseMapper).removeActRuExeCutionByPath(instId, targetNodePath, notIncludeExecuteIds);
    }

    @Override
    @Transactional
    public void removeBpmTaskCandidateByPath(String instId, Set<String> nodeIds) {
        List<String> taskIds = this.bpmTaskManager.getTaskIdsByInstIdAndNodeIds(instId, nodeIds);
        if (BeanUtils.isNotEmpty(taskIds)) {
            ((BpmExeStackDao)this.baseMapper).removeBpmTaskCandidateByPath(taskIds);
        }
    }

    @Override
    @Transactional
    public void removeBpmTaskByPath(String instId, Set<String> nodeIds) {
        ((BpmExeStackDao)this.baseMapper).removeBpmTaskByPath(instId, nodeIds);
    }

    @Override
    public BpmExeStack getByInstIdAndTargetNodePath(String instId, String targetNodePath) {
        return ((BpmExeStackDao)this.baseMapper).getByInstIdAndTargetNodePath(instId, targetNodePath);
    }

    @Override
    @Transactional
    public void removeHisByInstId(String instId) {
        ((BpmExeStackDao)this.baseMapper).removeHisByInstId(instId);
    }

    @Override
    @Transactional
    public void removeStackRelationHisByInstId(String instId) {
        HashSet<String> instIds = new HashSet<String>(Arrays.asList(instId));
        ArrayList<String> procInstIds = new ArrayList<String>();
        procInstIds.add(instId);
        List<Map<String, Object>> subInstIds = this.instanceManager.getInstIdByParentInstIds(instIds);
        if (BeanUtils.isNotEmpty(subInstIds)) {
            subInstIds.forEach(m -> {
                Object obj = m.get("ID_");
                procInstIds.add(obj.toString());
            });
        }
        ((BpmExeStackDao)this.baseMapper).removeStackRelationHisByInstId(procInstIds.toArray(new String[procInstIds.size()]));
    }

    private List<BpmExeStackHis> conver2His(List<BpmExeStack> bpmExeStacks) {
        ArrayList<BpmExeStackHis> bpmExeStackHisList = new ArrayList<BpmExeStackHis>();
        bpmExeStacks.forEach(bpmExeStack -> {
            try {
                BpmExeStackHis bpmExeStackHis = new BpmExeStackHis();
                BeanUtils.copyNotNullProperties((Object)((Object)bpmExeStackHis), (Object)bpmExeStack);
                bpmExeStackHisList.add(bpmExeStackHis);
            }
            catch (Exception e) {
                throw new BaseException("\u514b\u9686BpmExeStack\u5bf9\u8c61\u5f02\u5e38", (Throwable)e);
            }
        });
        return bpmExeStackHisList;
    }

    @Override
    @Transactional
    public void stack2HisByPath(String instId, String targetNodePath) {
        List<BpmExeStack> bpmExeStacks = ((BpmExeStackDao)this.baseMapper).stack2HisByPath(instId, targetNodePath);
        if (BeanUtils.isNotEmpty(bpmExeStacks)) {
            this.bpmExeStackHisManager.saveBatch(this.conver2His(bpmExeStacks));
        }
    }

    @Override
    @Transactional
    public void removeBpmExeStackRelationInToStackId(String instId, String targetNodePath) {
        List<String> stackIds = ((BpmExeStackDao)this.baseMapper).getStackIdByInstIdAndNodePath(instId, targetNodePath);
        if (BeanUtils.isNotEmpty(stackIds)) {
            ((BpmExeStackDao)this.baseMapper).removeBpmExeStackRelationInToStackId(stackIds);
        }
    }

    @Override
    @Transactional
    public void removeBpmExeStackRelationInFromStackId(String instId, String targetNodePath) {
        List<String> stackIds = ((BpmExeStackDao)this.baseMapper).getStackIdByInstIdAndNodePath(instId, targetNodePath);
        if (BeanUtils.isNotEmpty(stackIds)) {
            ((BpmExeStackDao)this.baseMapper).removeBpmExeStackRelationInFromStackId(stackIds);
        }
    }

    @Override
    @Transactional
    public void removeByPath(String instId, String targetNodePath) {
        ((BpmExeStackDao)this.baseMapper).removeByPath(instId, targetNodePath);
    }

    @Override
    @Transactional
    public void multipleInstancesRejectAdjustOnActTask(String rejectSingleExecutionId) {
        ((BpmExeStackDao)this.baseMapper).multipleInstancesRejectAdjustOnActTask(rejectSingleExecutionId);
    }

    @Override
    @Transactional
    public void multipleInstancesRejectAdjustOnActExecution(String actProcInstanceId) {
        ((BpmExeStackDao)this.baseMapper).multipleInstancesRejectAdjustOnActExecution(actProcInstanceId);
    }

    @Override
    @Transactional
    public void multipleInstancesRejectAdjustOnBpmTask(String rejectAfterExecutionId) {
        ((BpmExeStackDao)this.baseMapper).multipleInstancesRejectAdjustOnBpmTask(rejectAfterExecutionId);
    }

    @Override
    @Transactional
    public void updateTagertNode(String instId, String revokeNodeId) {
        ((BpmExeStackDao)this.baseMapper).updateTagertNode(instId, revokeNodeId);
    }

    @Override
    public List<BpmExeStack> getByBpmTaskByPath(String instId, String targetNodePath) {
        return ((BpmExeStackDao)this.baseMapper).getByBpmTaskByPath(instId, targetNodePath);
    }

    @Override
    public List<BpmExeStack> getHisByInstId(String instId) {
        return ((BpmExeStackDao)this.baseMapper).getHisByInstId(instId);
    }

    @Override
    public void updateStackTaskIdWhenEndRevoke(String oldTaskId, String newTaskId) {
        ((BpmExeStackDao)this.baseMapper).updateStackExecutorTaskId(oldTaskId, newTaskId);
    }

    @Override
    public void removeActRuTaskByPath(String instId, String path, String notIncludeExecuteIds) {
        ((BpmExeStackDao)this.baseMapper).removeActRuTaskByPath(instId, path, notIncludeExecuteIds);
    }
}

