/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.constant.NodeStatus;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.persistence.dao.BpmProStatusDao;
import com.hotent.bpm.persistence.manager.BpmProStatusManager;
import com.hotent.bpm.persistence.model.DefaultBpmProStatus;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.transaction.annotation.Transactional;

public class BpmProStatusManagerImpl
extends BaseManagerImpl<BpmProStatusDao, DefaultBpmProStatus>
implements BpmProStatusManager {
    private Map<String, String> statusColorMap = new HashMap<String, String>();

    @Override
    public List<DefaultBpmProStatus> queryHistorys(String procInstId) {
        return ((BpmProStatusDao)this.baseMapper).queryHistorys(procInstId);
    }

    @Override
    @Transactional
    public void archiveHistory(String procInstId) {
        ArrayList<String> instList = new ArrayList<String>();
        instList.add(procInstId);
        ((BpmProStatusDao)this.baseMapper).delByInstList(instList);
        ((BpmProStatusDao)this.baseMapper).archiveHistory(procInstId);
    }

    @Override
    @Transactional
    public void createOrUpd(String instId, String defId, String nodeId, String nodeName, NodeStatus nodeStatus) {
        DefaultBpmProStatus rtn = ((BpmProStatusDao)this.baseMapper).getByInstNodeId(instId, nodeId);
        if (rtn == null) {
            String userId = BeanUtils.isNotEmpty((Object)ContextUtil.getCurrentUser()) ? ContextUtil.getCurrentUser().getUserId() : "-1";
            DefaultBpmProStatus proStatus = new DefaultBpmProStatus(instId, defId, nodeId, nodeName, nodeStatus.getKey(), userId);
            this.create((Model)proStatus);
        } else {
            rtn.setStatus(nodeStatus.getKey());
            rtn.setRecycleNode("0");
            ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
            if (BeanUtils.isNotEmpty((Object)actionCmd) && actionCmd.getTransitVars().containsKey("bpmTask_") && StringUtil.isEmpty((String)((BpmTask)actionCmd.getTransitVars("bpmTask_")).getTargetNode())) {
                rtn.setLastUpdate(LocalDateTime.now());
            }
            super.update((Model)rtn);
        }
    }

    @Override
    @Transactional
    public void delByInstList(List<String> instList) {
        ((BpmProStatusDao)this.baseMapper).delByInstList(instList);
    }

    @Override
    public DefaultBpmProStatus getByInstNodeId(String instId, String nodeId) {
        return ((BpmProStatusDao)this.baseMapper).getByInstNodeId(instId, nodeId);
    }

    @Override
    @Transactional
    public void updStatusByInstList(List<String> list, NodeStatus status) {
        ((BpmProStatusDao)this.baseMapper).updStatusByInstList(list, status.getKey());
    }

    public void setStatusColor(Map<String, String> statusColorMap) {
        this.statusColorMap = statusColorMap;
    }

    @Override
    public Map<String, String> getStatusColorMap() {
        return this.statusColorMap;
    }

    public void setStatusColorMap(Map<String, String> statusColorMap) {
        this.statusColorMap = statusColorMap;
    }

    @Override
    public Map<String, String> getProcessInstanceStatus(String bpmnInstId) {
        return this.getProcessInstanceStatus(bpmnInstId, 0);
    }

    @Override
    public Map<String, String> getProcessInstanceStatus(String bpmnInstId, int isForbidden) {
        QueryFilter filter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE)).withQuery(new QueryField("proc_inst_id_", (Object)bpmnInstId, QueryOP.EQUAL));
        PageList list = this.query(filter);
        List<DefaultBpmProStatus> statusList = list.getRows();
        if (BeanUtils.isEmpty((Object)statusList)) {
            statusList = this.queryHistorys(bpmnInstId);
        }
        HashMap<String, String> colourMap = new HashMap<String, String>();
        if (BeanUtils.isEmpty(statusList)) {
            return colourMap;
        }
        for (DefaultBpmProStatus bpmProStatus : statusList) {
            String nodeId = bpmProStatus.getNodeId();
            String status = bpmProStatus.getStatus();
            if (isForbidden == 1 && "pending".equals(bpmProStatus.getStatus())) {
                status = "hangUp";
            }
            String color = this.statusColorMap.get(status);
            colourMap.put(nodeId, color);
        }
        return colourMap;
    }

    @Override
    public void updateRecycleNode(String instId, Set<String> fromStartNodeIds, String recycleNode) {
        if (BeanUtils.isEmpty(fromStartNodeIds)) {
            return;
        }
        ((BpmProStatusDao)this.baseMapper).updateRecycleNode(instId, fromStartNodeIds, recycleNode);
    }

    @Override
    public List<String> getByInstIdAndRecycleNode(String instId, String recycleNode) {
        return ((BpmProStatusDao)this.baseMapper).getByInstIdAndRecycleNode(instId, recycleNode);
    }
}

