/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.hotent.base.annotation.AsyncThreadClean;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.persistence.dao.BpmServiceLogDao;
import com.hotent.bpm.persistence.manager.BpmServiceLogManager;
import com.hotent.bpm.persistence.model.BpmServiceLog;
import java.time.LocalDateTime;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class BpmServiceLogManagerImpl
extends BaseManagerImpl<BpmServiceLogDao, BpmServiceLog>
implements BpmServiceLogManager {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;

    @Override
    @Async(value="asyncExecutor")
    @AsyncThreadClean
    public void checkAndSave(String subject, String defId, String instId, String nodeId, int status) throws Exception {
        BpmProcessDef<BpmProcessDefExt> bpmProcessDefExt = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        List<BpmNodeDef> bpmnNodeDefs = bpmProcessDefExt.getBpmnNodeDefs();
        for (BpmNodeDef bpmnNodeDef : bpmnNodeDefs) {
            if (!NodeType.SERVICETASK.equals((Object)bpmnNodeDef.getType()) || !bpmnNodeDef.getNodeId().equals(nodeId)) continue;
            ((BpmServiceLogDao)this.baseMapper).delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BpmServiceLog::getProcInstId, (Object)instId)).eq(BpmServiceLog::getNodeId, (Object)nodeId));
            BpmServiceLog bpmServiceLog = new BpmServiceLog(UniqueIdUtil.getSuid(), subject, defId, instId, nodeId, status);
            bpmServiceLog.setCreateTime(LocalDateTime.now());
            super.save((Object)bpmServiceLog);
        }
    }
}

