/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.bpm.persistence.dao.BpmTaskUrgentDao;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.BpmTaskManager;
import com.hotent.bpm.persistence.manager.BpmTaskUrgentManager;
import com.hotent.bpm.persistence.model.BpmTaskUrgent;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.i18n.util.I18nUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service(value="bpmTaskUrgentManager")
public class BpmTaskUrgentManagerImpl
extends BaseManagerImpl<BpmTaskUrgentDao, BpmTaskUrgent>
implements BpmTaskUrgentManager {
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmTaskManager bpmTaskManager;

    @Override
    public PageList<BpmTaskUrgent> getUrgrntById(QueryFilter queryFilter) {
        List instIdQueryField = queryFilter.getQuerys().stream().filter(r -> "appointee_id_".equals(r.getProperty().toLowerCase())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(instIdQueryField)) {
            try {
                QueryField queryField1 = new QueryField();
                BeanUtils.copyNotNullProperties((Object)queryField1, instIdQueryField.get(0));
                queryField1.setOperation(QueryOP.LIKE);
                queryField1.setValue((Object)(queryField1.getValue() + ","));
                QueryField queryField2 = new QueryField();
                BeanUtils.copyNotNullProperties((Object)queryField2, instIdQueryField.get(0));
                queryField2.setOperation(QueryOP.LIKE);
                queryField2.setValue((Object)("," + queryField2.getValue()));
                queryFilter.getQuerys().add(queryField1);
                queryFilter.getQuerys().add(queryField2);
                PageList list = this.query(queryFilter);
                Locale locale = LocaleContextHolder.getLocale();
                if (!Locale.SIMPLIFIED_CHINESE.equals(locale)) {
                    String instId = null;
                    List querys = queryFilter.getQuerys();
                    for (QueryField q : querys) {
                        String property = q.getProperty();
                        if (!"INST_ID_".equals(property)) continue;
                        instId = q.getValue().toString();
                        break;
                    }
                    DefaultBpmProcessInstance defaultBpmProcessInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instId));
                    String procDefKey = defaultBpmProcessInstance.getProcDefKey();
                    for (BpmTaskUrgent bpmTaskUrgent : list.getRows()) {
                        String mes;
                        String taskId = bpmTaskUrgent.getTaskId();
                        DefaultBpmTask defaultBpmTask = (DefaultBpmTask)this.bpmTaskManager.get((Serializable)((Object)taskId));
                        String key = "flow." + procDefKey + "." + defaultBpmTask.getNodeId();
                        if (key.equals(mes = I18nUtil.getMessage((String)key, (Locale)locale))) continue;
                        bpmTaskUrgent.setNodeName(mes);
                    }
                }
                return list;
            }
            catch (Exception e) {
                throw new BaseException((Throwable)e);
            }
        }
        return null;
    }
}

