/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.exception.WorkFlowException;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.model.HtJsonNodeFactory;
import com.hotent.base.model.HtObjectNode;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.constant.ProcessInstanceStatus;
import com.hotent.bpm.api.context.BpmContextUtil;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.helper.identity.UserQueryPluginHelper;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.NodeProperties;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.hotent.bpm.api.plugin.core.context.BpmPluginContext;
import com.hotent.bpm.api.plugin.core.factory.BpmPluginSessionFactory;
import com.hotent.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.exception.ApproveTaskException;
import com.hotent.bpm.exception.BusinessException;
import com.hotent.bpm.params.PreviewProcessVo;
import com.hotent.bpm.persistence.manager.BpmDefinitionManager;
import com.hotent.bpm.persistence.manager.BpmProcessInstanceManager;
import com.hotent.bpm.persistence.manager.PreviewProcessService;
import com.hotent.bpm.persistence.model.DefaultBpmDefinition;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.plugin.core.util.UserAssignRuleQueryHelper;
import com.hotent.bpm.plugin.execution.message.def.HtmlSetting;
import com.hotent.bpm.plugin.execution.message.def.MessagePluginDef;
import com.hotent.bpm.util.BoDataUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PreviewProcessServiceImpl
implements PreviewProcessService {
    private static Logger logger = LoggerFactory.getLogger(PreviewProcessServiceImpl.class);
    @Resource
    BpmProcessInstanceManager bpmProcessInstanceManager;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    UCFeignService ucFeignService;

    @Override
    public Map<String, Object> previewProcess(PreviewProcessVo previewProcessVo) throws Exception {
        DefaultBpmDefinition def;
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        DefaultBpmProcessInstance processInstance = null;
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String gearNodeId = null;
        StringBuilder toNodeId = new StringBuilder();
        List<BpmNodeDef> allNodeDef = null;
        processInstance = (DefaultBpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)previewProcessVo.getInstId()));
        if (ProcessInstanceStatus.STATUS_DRAFT.getKey().equals(processInstance.getStatus()) && BeanUtils.isNotEmpty((Object)(def = this.bpmDefinitionManager.getMainByDefKey(processInstance.getProcDefKey()))) && !processInstance.getProcDefId().equals(def.getId())) {
            processInstance.setProcDefId(def.getDefId());
            processInstance.setTypeId(def.getTypeId());
            processInstance.setProcDefKey(def.getDefKey());
            processInstance.setBpmnDefId(def.getBpmnDefId());
            processInstance.setProcDefName(def.getName());
            processInstance.setSupportMobile(def.getSupportMobile());
            this.bpmProcessInstanceManager.update((Model)processInstance);
        }
        List<ObjectNode> boDatas = this.getFormDataObjectNodes(previewProcessVo.getFormData(), processInstance);
        BpmContextUtil.setBoToContext(boDatas);
        BpmContextUtil.setBoToThreadContext(boDatas);
        String startNodeId = this.getPreviewProcessStartNodeId(previewProcessVo.getNodeId(), processInstance);
        allNodeDef = this.bpmDefinitionAccessor.getAllNodeDef(processInstance.getProcDefId());
        Map<Object, Object> variables = new HashMap();
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        if (BeanUtils.isNotEmpty((Object)cmd) && BeanUtils.isNotEmpty(cmd.getVariables())) {
            variables = cmd.getVariables();
        }
        String startUserID = StringUtil.isEmpty((String)processInstance.getCreateBy()) ? ContextUtil.getCurrentUserId() : processInstance.getCreateBy();
        variables.put("businessKey_", processInstance.getBizKey());
        variables.put("processDefId_", processInstance.getProcDefId());
        variables.put("flowKey_", processInstance.getProcDefKey());
        variables.put("subject_", processInstance.getSubject());
        variables.put("instanceId_", processInstance.getId());
        variables.put("processInstance", processInstance);
        variables.put("startUser", startUserID);
        JsonNode jsonNode = this.ucFeignService.getMainOrgByUserIdAndCurOrgId(startUserID, processInstance.getCreateOrgId());
        variables.put("startUserOrgId", JsonUtil.getStrByPath((JsonNode)jsonNode, (String)"startUserOrgId"));
        variables.put("startUserOrgCode", JsonUtil.getStrByPath((JsonNode)jsonNode, (String)"startUserOrgCode"));
        variables.put("startUserOrgName", JsonUtil.getStrByPath((JsonNode)jsonNode, (String)"startUserOrgName"));
        variables.put("not_request_uc", "true");
        variables.put("processInstance", processInstance);
        ContextThreadUtil.setCmdDataThreadLocal(variables);
        ArrayList<String> exclusiveGatewayId = new ArrayList<String>();
        ArrayList<String> exclusiveGatewayName = new ArrayList<String>();
        this.calcNextNode(allNodeDef, startNodeId, result, boDatas, variables, gearNodeId, toNodeId, exclusiveGatewayId, exclusiveGatewayName);
        if (result.size() > 2) {
            try {
                String endNodeId = this.getEndNodeId(result);
                if (StringUtil.isEmpty((String)endNodeId)) {
                    throw new RuntimeException("\u672a\u83b7\u53d6\u5230\u7ec8\u5ba1\u8282\u70b9\uff01");
                }
                ContextThreadUtil.setNewVars("endNode_" + processInstance.getId(), endNodeId);
            }
            catch (Exception e) {
                throw new RuntimeException("\u83b7\u53d6\u7ec8\u5ba1\u8282\u70b9\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        for (int i = 0; i < result.size() - 1; ++i) {
            Map nodeMap = (Map)result.get(i);
            try {
                BpmNodeDef bpmNodeDef = null;
                for (BpmNodeDef nodeDef : allNodeDef) {
                    if (!nodeDef.getNodeId().equals(nodeMap.get("nodeId").toString())) continue;
                    bpmNodeDef = nodeDef;
                    break;
                }
                if (bpmNodeDef == null) continue;
                ContextThreadUtil.setNewVars("currentNode_" + processInstance.getId(), bpmNodeDef.getNodeId());
                ContextThreadUtil.setNewVars("currentNodeName_" + processInstance.getId(), bpmNodeDef.getName());
                ContextThreadUtil.setNewVars("currentNodeType_" + processInstance.getId(), bpmNodeDef.getType().getKey());
                UserQueryPluginHelper userQueryPluginHelper = (UserQueryPluginHelper)AppUtil.getBean(UserQueryPluginHelper.class);
                List<BpmPluginContext> bpmPluginContexts = bpmNodeDef.getBpmPluginContexts();
                List<BpmIdentity> bpmIdentities = null;
                if (NodeType.SERVICETASK.equals((Object)bpmNodeDef.getType())) {
                    if (bpmPluginContexts.size() > 0) {
                        MessagePluginDef bpmPluginDef = (MessagePluginDef)bpmPluginContexts.get(0).getBpmPluginDef();
                        HtmlSetting htmlSetting = bpmPluginDef.getHtmlSetting();
                        BpmPluginSessionFactory bpmPluginSessionFactory = (BpmPluginSessionFactory)AppUtil.getBean(BpmPluginSessionFactory.class);
                        BpmUserCalcPluginSession bpmUserCalcPluginSession = bpmPluginSessionFactory.buildBpmUserCalcPluginSession(variables);
                        bpmIdentities = UserAssignRuleQueryHelper.queryExtract(htmlSetting.getRuleList(), bpmUserCalcPluginSession);
                    }
                } else {
                    variables.put("nodeId", bpmNodeDef.getNodeId());
                    variables.put("nodeName", bpmNodeDef.getName());
                    bpmIdentities = userQueryPluginHelper.query(bpmPluginContexts, variables, "user");
                }
                if (NodeType.USERTASK.equals((Object)bpmNodeDef.getType()) || NodeType.SIGNTASK.equals((Object)bpmNodeDef.getType())) {
                    // empty if block
                }
                nodeMap.put("excutorList", bpmIdentities);
                continue;
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u5ba1\u6279\u8def\u5f84\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            }
        }
        UCFeignService ucFeignService = (UCFeignService)AppUtil.getBean(UCFeignService.class);
        if (BeanUtils.isNotEmpty(result)) {
            result = ucFeignService.calculateNodeUsers(result);
        }
        returnData.put("proInststatus", processInstance.getStatus());
        returnData.put("pathList", result);
        BpmContextUtil.clearBoInThreadContext();
        ContextThreadUtil.clearCmdDataThreadLocal();
        return returnData;
    }

    private List<ObjectNode> getFormDataObjectNodes(String formData, DefaultBpmProcessInstance processInstance) throws Exception {
        if (StringUtil.isNotEmpty((String)formData)) {
            String formDataDecode = Base64.getFromBase64((String)formData);
            List<ObjectNode> boDatas = BoDataUtil.converFormData(formDataDecode);
            return boDatas;
        }
        List<ObjectNode> boDatas = this.boDataService.getDataByInst(processInstance);
        return boDatas;
    }

    private String getPreviewProcessStartNodeId(String nodeId, DefaultBpmProcessInstance processInstance) {
        if (StringUtil.isNotEmpty((String)nodeId)) {
            return nodeId;
        }
        BpmNodeDef startNode = null;
        try {
            List<BpmNodeDef> startNodes = this.bpmDefinitionAccessor.getStartNodes(processInstance.getProcDefId());
            if (BeanUtils.isNotEmpty(startNodes)) {
                startNode = startNodes.get(0);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5f00\u59cb\u8282\u70b9\u5931\u8d25", (Throwable)e);
            throw new ApproveTaskException("\u83b7\u53d6\u5f00\u59cb\u8282\u70b9\u5931\u8d25");
        }
        return startNode.getNodeId();
    }

    private void calcNextNode(List<BpmNodeDef> allNodeDef, String nodeId, List<Map<String, Object>> result, List<ObjectNode> boDatas, Map<String, Object> vars, String gearNodeId, StringBuilder toNodeId, List<String> exclusiveGatewayId, List<String> exclusiveGatewayName) {
        if (StringUtil.isEmpty((String)nodeId)) {
            return;
        }
        for (BpmNodeDef bpmNodeDef : allNodeDef) {
            if (!nodeId.equals(bpmNodeDef.getNodeId())) continue;
            try {
                if (!NodeType.EXCLUSIVEGATEWAY.getKey().equals(bpmNodeDef.getType().getKey())) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("nodeName", bpmNodeDef.getName());
                    if (NodeType.END.getKey().equals(bpmNodeDef.getType().getKey())) {
                        map.put("nodeName", "\u7ed3\u675f");
                    }
                    if (NodeType.SIGNTASK.getKey().equals(bpmNodeDef.getType().getKey())) {
                        SignNodeDef signNodeDef = (SignNodeDef)bpmNodeDef;
                        String extraProp = signNodeDef.isParallel() ? "parallel" : "sequential";
                        map.put("extraProp", extraProp);
                    }
                    map.put("nodeId", bpmNodeDef.getNodeId());
                    map.put("nodeType", bpmNodeDef.getType().getKey());
                    boolean canSkip = true;
                    boolean emptySkip = true;
                    List<NodeProperties> nodeProperties = bpmNodeDef.getNodeProperties();
                    if (BeanUtils.isNotEmpty(nodeProperties)) {
                        NodeProperties nodeProperties2 = nodeProperties.get(0);
                        emptySkip = nodeProperties2.isSkipExecutorEmpty();
                        canSkip = nodeProperties2.isPopWin();
                    }
                    map.put("canSkip", canSkip);
                    map.put("emptySkip", emptySkip);
                    result.add(map);
                }
                if (NodeType.EXCLUSIVEGATEWAY.getKey().equals(bpmNodeDef.getType().getKey()) && bpmNodeDef.getNodeId().equals(gearNodeId)) {
                    exclusiveGatewayId.add(nodeId);
                    exclusiveGatewayName.add(bpmNodeDef.getName());
                }
                List<BpmNodeDef> outcomeNodes = bpmNodeDef.getOutcomeNodes();
                nodeId = "";
                if (outcomeNodes.size() > 1) {
                    if (StringUtil.isNotEmpty((String)gearNodeId) && bpmNodeDef.getNodeId().equals(gearNodeId)) {
                        Map<String, String> conditions = null;
                        nodeId = BeanUtils.isEmpty(conditions) ? outcomeNodes.get(0).getNodeId() : this.evaluate(conditions, boDatas, vars);
                        toNodeId.append(nodeId);
                    } else {
                        Map<String, String> conditions = bpmNodeDef.getConditions();
                        nodeId = BeanUtils.isEmpty(conditions) ? outcomeNodes.get(0).getNodeId() : this.evaluate(conditions, boDatas, vars);
                    }
                } else if (outcomeNodes.size() == 1) {
                    nodeId = outcomeNodes.get(0).getNodeId();
                }
                this.calcNextNode(allNodeDef, nodeId, result, boDatas, vars, gearNodeId, toNodeId, exclusiveGatewayId, exclusiveGatewayName);
                break;
            }
            catch (Exception e) {
                logger.error("\u5ba1\u6279\u8def\u5f84\u63a8\u6f14\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8868\u5355\u6570\u636e\u6216\u8054\u7cfbIT\u7ba1\u7406\u5458\u3002", (Throwable)e);
                throw new WorkFlowException("\u5ba1\u6279\u8def\u5f84\u63a8\u6f14\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8868\u5355\u6570\u636e\u6216\u8054\u7cfbIT\u7ba1\u7406\u5458\u3002", (Throwable)e);
            }
        }
    }

    private String getEndNodeId(List<Map<String, Object>> result) {
        String endNodeId = "";
        for (int i = result.size() - 1; i > -1; --i) {
            Map<String, Object> node = result.get(i);
            String nodeType = node.get("nodeType").toString();
            if (!nodeType.equals(NodeType.USERTASK.getKey()) && !nodeType.equals(NodeType.SIGNTASK.getKey())) continue;
            return node.get("nodeId").toString();
        }
        return endNodeId;
    }

    private String evaluate(Map<String, String> conditions, List<ObjectNode> boDatas, Map<String, Object> vars) {
        Map<String, ObjectNode> boMap;
        Map<Object, Object> maps = new HashMap();
        if (BeanUtils.isNotEmpty(vars)) {
            maps = vars;
        }
        if (BeanUtils.isNotEmpty(boMap = BpmContextUtil.getBoFromThreadContext())) {
            HashMap<String, HtObjectNode> newMap = new HashMap<String, HtObjectNode>();
            for (Map.Entry<String, ObjectNode> next : boMap.entrySet()) {
                newMap.put(next.getKey(), HtJsonNodeFactory.build().htObjectNode(next.getValue()));
            }
            maps.putAll(newMap);
        }
        GroovyScriptEngine engine = (GroovyScriptEngine)AppUtil.getBean(GroovyScriptEngine.class);
        Set<Map.Entry<String, String>> entrySet = conditions.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String nodeId = entry.getKey();
            String script = this.replaceSpecialChar(entry.getValue());
            try {
                if (StringUtil.isEmpty((String)script)) {
                    return nodeId;
                }
                boolean flag = engine.executeBoolean(script, maps);
                if (!flag) continue;
                return nodeId;
            }
            catch (BusinessException e) {
                logger.error("\u6761\u4ef6\u811a\u672c\u89e3\u6790\u5f02\u5e38\uff01\u8bf7\u8054\u7cfbIT\u62a5\u4e8b\u3002", (Throwable)e);
                throw new ApproveTaskException(e.getMessage());
            }
            catch (Exception e) {
                logger.error("\u6761\u4ef6\u811a\u672c\u89e3\u6790\u5f02\u5e38\uff01\u8bf7\u8054\u7cfbIT\u62a5\u4e8b\u3002", (Throwable)e);
                StringBuilder message = new StringBuilder("\u6761\u4ef6\u811a\u672c\u89e3\u6790\u5f02\u5e38\uff01\u8bf7\u8054\u7cfbIT\u62a5\u4e8b\u3002");
                message.append("<br/><br/>\u8282\u70b9\uff1a" + nodeId);
                message.append("<br/><br/>\u811a\u672c\uff1a" + script);
                message.append("<br/><br/>\u6d41\u7a0b\u53d8\u91cf\uff1a" + maps.toString());
                throw new ApproveTaskException(message.toString());
            }
        }
        return "";
    }

    private String replaceSpecialChar(String str) {
        if (StringUtil.isEmpty((String)str)) {
            return "";
        }
        if ((str = str.trim()).startsWith("${")) {
            return str.substring(2, str.length() - 1);
        }
        return str;
    }
}

