/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.core.cmd;

import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.constant.EventType;
import com.hotent.bpm.api.constant.NodeType;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.event.StartNewFlowEvent;
import com.hotent.bpm.api.model.delegate.BpmDelegateExecution;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.plugin.core.cmd.ExecutionCommand;
import com.hotent.bpm.api.plugin.core.context.BpmPluginContext;
import com.hotent.bpm.api.plugin.core.def.BpmExecutionPluginDef;
import com.hotent.bpm.api.plugin.core.def.BpmPluginDef;
import com.hotent.bpm.api.plugin.core.factory.BpmPluginFactory;
import com.hotent.bpm.api.plugin.core.factory.BpmPluginSessionFactory;
import com.hotent.bpm.api.plugin.core.runtime.BpmExecutionPlugin;
import com.hotent.bpm.api.plugin.core.session.BpmExecutionPluginSession;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.plugin.core.session.DefaultBpmExecutionPluginSession;
import com.hotent.bpm.plugin.task.startnewflow.def.StartNewFlowPluginDef;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.ApplicationEvent;

public class PluginExecutionCommand
implements ExecutionCommand {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmPluginFactory bpmPluginFactory;
    @Resource
    BpmPluginSessionFactory bpmPluginSessionFactory;
    @Resource
    BpmDefinitionService bpmDefinitionService;

    @Override
    public void execute(EventType eventType, BpmDelegateExecution execution) throws Exception {
        List<BpmPluginContext> nodePluginList;
        BpmNodeDef bpmNodeDef;
        String bpmnDefId = execution.getBpmnDefId();
        String defId = this.bpmDefinitionService.getDefIdByBpmnDefId(bpmnDefId);
        BpmExecutionPluginSession bpmExecutionPluginSession = this.bpmPluginSessionFactory.buildBpmExecutionPluginSession(execution);
        ((DefaultBpmExecutionPluginSession)bpmExecutionPluginSession).setEventType(eventType);
        BpmProcessDef<BpmProcessDefExt> bpmProcessDef = this.bpmDefinitionAccessor.getBpmProcessDef(defId);
        List<BpmPluginContext> pluginContextList = bpmProcessDef.getProcessDefExt().getBpmPluginContexts();
        if (BeanUtils.isNotEmpty(pluginContextList)) {
            for (BpmPluginContext bpmPluginContext : pluginContextList) {
                this.executeContext(bpmPluginContext, bpmExecutionPluginSession, eventType);
            }
        }
        if (StringUtil.isNotEmpty((String)execution.getNodeId()) && BeanUtils.isNotEmpty((Object)(bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, execution.getNodeId()))) && !bpmNodeDef.getType().equals((Object)NodeType.PARALLELGATEWAY) && BeanUtils.isNotEmpty(nodePluginList = bpmNodeDef.getBpmPluginContexts())) {
            for (BpmPluginContext bpmPluginContext : nodePluginList) {
                this.executeContext(bpmPluginContext, bpmExecutionPluginSession, eventType);
            }
        }
    }

    private void executeContext(BpmPluginContext bpmPluginContext, BpmExecutionPluginSession bpmExecutionPluginSession, EventType eventType) throws Exception {
        BpmPluginDef bpmPluginDef = bpmPluginContext.getBpmPluginDef();
        if (bpmPluginDef instanceof BpmExecutionPluginDef) {
            BpmExecutionPluginDef bpmExecutionPluginDef = (BpmExecutionPluginDef)bpmPluginDef;
            BpmExecutionPlugin bpmExecutionPlugin = this.bpmPluginFactory.buildExecutionPlugin(bpmPluginContext, eventType);
            if (bpmExecutionPlugin != null && bpmPluginContext.getEventTypes().contains((Object)eventType)) {
                bpmExecutionPlugin.execute(bpmExecutionPluginSession, bpmExecutionPluginDef);
            }
        } else if ((EventType.START_POST_EVENT.getKey().equals(eventType.getKey()) || EventType.END_POST_EVENT.getKey().equals(eventType.getKey())) && bpmPluginDef instanceof StartNewFlowPluginDef) {
            ActionCmd actionCmd = ContextThreadUtil.getActionCmd();
            DefaultBpmProcessInstance instance = (DefaultBpmProcessInstance)actionCmd.getTransitVars("processInstance");
            BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(instance.getProcDefId(), bpmExecutionPluginSession.getBpmDelegateExecution().getNodeId());
            StartNewFlowEvent event = new StartNewFlowEvent(bpmNodeDef);
            AppUtil.publishEvent((ApplicationEvent)event);
        }
    }
}

