/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.core.runtime;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.constant.MultiInstanceType;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.exception.ProcessDefException;
import com.hotent.bpm.api.model.delegate.BpmDelegateTask;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.def.BpmProcessDef;
import com.hotent.bpm.api.model.process.def.BpmProcessDefExt;
import com.hotent.bpm.api.model.process.nodedef.BpmNodeDef;
import com.hotent.bpm.api.model.process.nodedef.MultiInstanceDef;
import com.hotent.bpm.api.model.process.nodedef.ext.SubProcessNodeDef;
import com.hotent.bpm.api.plugin.core.def.BpmTaskPluginDef;
import com.hotent.bpm.api.plugin.core.session.BpmTaskPluginSession;
import com.hotent.bpm.api.service.BpmDefinitionAccessor;
import com.hotent.bpm.api.service.BpmDefinitionService;
import com.hotent.bpm.plugin.core.runtime.AbstractBpmTaskPlugin;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

public abstract class BaseUserAssignPlugin
extends AbstractBpmTaskPlugin {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmDefinitionService bpmDefinitionService;

    public abstract void executeExt(BpmTaskPluginSession var1, BpmTaskPluginDef var2) throws Exception;

    @Override
    public Void execute(BpmTaskPluginSession pluginSession, BpmTaskPluginDef pluginDef) throws Exception {
        BpmDelegateTask bpmTask = pluginSession.getBpmDelegateTask();
        ActionCmd taskCmd = ContextThreadUtil.getActionCmd();
        String nodeId = bpmTask.getTaskDefinitionKey();
        boolean isSubProcessMulti = this.handSubProcessUser(bpmTask);
        if (isSubProcessMulti) {
            return null;
        }
        boolean isExtProcessMulti = this.handExtSubProcessUser(bpmTask);
        if (isExtProcessMulti) {
            return null;
        }
        Map<String, List<BpmIdentity>> identityMap = taskCmd.getBpmIdentities();
        List<BpmIdentity> identityList = identityMap.get(nodeId);
        if (BeanUtils.isNotEmpty(identityList)) {
            return null;
        }
        this.executeExt(pluginSession, pluginDef);
        return null;
    }

    private boolean handSubProcessUser(BpmDelegateTask delegateTask) throws Exception {
        String bpmnDefId = delegateTask.getBpmnDefId();
        BpmNodeDef bpmNodeDef = this.bpmDefinitionService.getBpmNodeDef(bpmnDefId, delegateTask.getTaskDefinitionKey());
        BpmNodeDef parentBpmNodeDef = bpmNodeDef.getParentBpmNodeDef();
        if (parentBpmNodeDef == null) {
            return false;
        }
        if (!(parentBpmNodeDef instanceof MultiInstanceDef)) {
            return false;
        }
        MultiInstanceDef multiDef = (MultiInstanceDef)((Object)parentBpmNodeDef);
        if (!multiDef.supportMuliInstance()) {
            return false;
        }
        SubProcessNodeDef subDef = (SubProcessNodeDef)multiDef;
        BpmProcessDef<? extends BpmProcessDefExt> subProcessDef = subDef.getChildBpmProcessDef();
        List<BpmNodeDef> nodeList = subProcessDef.getStartNodes();
        BpmNodeDef startNode = nodeList.get(0);
        if (!startNode.getNodeId().equals(delegateTask.getTaskDefinitionKey())) {
            return false;
        }
        BpmIdentity bpmIdentity = (BpmIdentity)delegateTask.getVariable("assignee");
        if (bpmIdentity != null) {
            delegateTask.addExecutor(bpmIdentity);
            delegateTask.removeVariable("assignee");
            return true;
        }
        return false;
    }

    private boolean handExtSubProcessUser(BpmDelegateTask delegateTask) throws Exception {
        String nodeId = delegateTask.getTaskDefinitionKey();
        String supperExeId = delegateTask.getSupperExecutionId();
        if (StringUtil.isEmpty((String)supperExeId)) {
            return false;
        }
        MultiInstanceType multiType = delegateTask.supperMultiInstanceType();
        if (multiType.equals((Object)MultiInstanceType.NO)) {
            return false;
        }
        String bpmnDefId = delegateTask.getBpmnDefId();
        BpmNodeDef bpmNodeDef = this.bpmDefinitionService.getBpmNodeDef(bpmnDefId, nodeId);
        BpmProcessDef<?> procDef = bpmNodeDef.getBpmProcessDef();
        List<BpmNodeDef> bpmNodeDefList = procDef.getStartNodes();
        if (bpmNodeDefList.size() > 1) {
            throw new ProcessDefException("\u591a\u5b9e\u4f8b\u5b50\u6d41\u7a0b\u53d1\u8d77\u8282\u70b9\u540e\u53ea\u80fd\u6709\u4e00\u4e2a\u7528\u6237\u4efb\u52a1\u8282\u70b9");
        }
        BpmNodeDef startNode = bpmNodeDefList.get(0);
        if (!startNode.getNodeId().equals(nodeId)) {
            return false;
        }
        BpmIdentity bpmIdentity = (BpmIdentity)delegateTask.getSupperVariable("assignee");
        if (bpmIdentity != null) {
            delegateTask.addExecutor(bpmIdentity);
            return true;
        }
        return false;
    }
}

