/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.task.reminders.plugin;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.time.DateFormatUtil;
import com.hotent.base.util.time.DateUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.bpm.api.constant.EventType;
import com.hotent.bpm.api.context.BpmContextUtil;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.helper.identity.BpmIdentityExtractService;
import com.hotent.bpm.api.model.delegate.BpmDelegateTask;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.plugin.core.def.BpmTaskPluginDef;
import com.hotent.bpm.api.plugin.core.session.BpmTaskPluginSession;
import com.hotent.bpm.api.service.RestfulService;
import com.hotent.bpm.persistence.manager.BpmCheckOpinionManager;
import com.hotent.bpm.persistence.manager.BpmReminderHistoryManager;
import com.hotent.bpm.persistence.manager.BpmTaskReminderManager;
import com.hotent.bpm.persistence.model.BpmReminderHistory;
import com.hotent.bpm.persistence.model.BpmTaskReminder;
import com.hotent.bpm.persistence.model.DefaultBpmCheckOpinion;
import com.hotent.bpm.plugin.core.runtime.AbstractBpmTaskPlugin;
import com.hotent.bpm.plugin.task.reminders.def.Reminder;
import com.hotent.bpm.plugin.task.reminders.def.RemindersPluginDef;
import com.hotent.bpm.plugin.task.reminders.def.WarningSet;
import com.hotent.uc.api.model.IUser;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.transaction.annotation.Transactional;

public class RemindersPlugin
extends AbstractBpmTaskPlugin {
    @Resource
    GroovyScriptEngine groovyScriptEngine;
    @Resource
    BpmTaskReminderManager bpmTaskReminderManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    PortalFeignService portalFeignService;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    BpmReminderHistoryManager bpmReminderHistoryManager;
    @Resource
    RestfulService restfulService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Void execute(BpmTaskPluginSession pluginSession, BpmTaskPluginDef pluginDef) throws Exception {
        if (pluginSession.getEventType() == EventType.TASK_COMPLETE_EVENT) {
            this.bpmTaskReminderManager.deleteByTaskId(pluginSession.getBpmDelegateTask().getId());
            return null;
        }
        RemindersPluginDef reminderDef = (RemindersPluginDef)pluginDef;
        List<Reminder> reminderList = reminderDef.getReminderList();
        for (Reminder reminder : reminderList) {
            this.createReminder(reminder, pluginSession);
        }
        return null;
    }

    private void createReminder(Reminder reminder, BpmTaskPluginSession pluginSession) throws Exception {
        Boolean isSendMsg;
        Object object;
        BpmDelegateTask task = pluginSession.getBpmDelegateTask();
        String condition = reminder.getCondition();
        if (StringUtil.isNotEmpty((String)condition) && (object = this.executeScript(pluginSession, condition)) instanceof Boolean && !((Boolean)object).booleanValue()) {
            return;
        }
        BpmTaskReminder taskReminder = new BpmTaskReminder();
        taskReminder.setName(reminder.getName());
        taskReminder.setTaskId(task.getId());
        taskReminder.setDueAction(reminder.getDueAction());
        taskReminder.setDueScript(reminder.getDueScript());
        taskReminder.setDuration(reminder.getDueTime().longValue());
        taskReminder.setDateType(reminder.getDateType());
        taskReminder.setTransferId(reminder.getTransferId());
        taskReminder.setTransferName(reminder.getTransferName());
        taskReminder.setDirectUser(reminder.getDirectUser() != false ? 1 : 0);
        taskReminder.setDirectLeader(reminder.getDirectLeader() != false ? 1 : 0);
        taskReminder.setMainOrgLeader(reminder.getMainOrgLeader() != false ? 1 : 0);
        taskReminder.setDirectUserIds(reminder.getDirectUserIds());
        taskReminder.setDirectUserNames(reminder.getDirectUserNames());
        if ("2".equals(reminder.getDateScriptType())) {
            taskReminder.setTypeScript(reminder.getTypeScript());
            JsonNode type = null;
            if (StringUtil.isNotEmpty((String)reminder.getTypeScript())) {
                type = (JsonNode)this.executeScript(pluginSession, reminder.getTypeScript());
            }
            if (BeanUtils.isNotEmpty(type)) {
                reminder.setDateType(type.asText());
            } else {
                reminder.setDateType("caltime");
            }
        }
        if ("2".equals(reminder.getDurationType())) {
            taskReminder.setDurationScript(reminder.getDurationScript());
            Double duration = null;
            if (StringUtil.isNotEmpty((String)reminder.getDurationScript())) {
                duration = Double.valueOf(this.executeScript(pluginSession, reminder.getDurationScript()).toString());
            }
            if (BeanUtils.isNotEmpty(duration)) {
                duration = duration * 60.0;
                reminder.setDueTime(duration.intValue());
                taskReminder.setDuration(reminder.getDueTime().longValue());
            } else {
                reminder.setDueTime(0);
                taskReminder.setDuration(reminder.getDueTime().longValue());
            }
        }
        if ("2".equals(reminder.getRelTimeType())) {
            taskReminder.setRelTimeScript(reminder.getRelTimeScript());
            Double relTime = null;
            if (StringUtil.isNotEmpty((String)reminder.getRelTimeScript())) {
                relTime = Double.valueOf(this.executeScript(pluginSession, reminder.getRelTimeScript()).toString());
            }
            if (BeanUtils.isNotEmpty(relTime)) {
                relTime = relTime * 60.0;
                reminder.setMsgSendTime(relTime.intValue());
            } else {
                reminder.setMsgSendTime(0);
            }
        }
        int sendMsg = (isSendMsg = reminder.getIsSendMsg()) != false ? 1 : 0;
        taskReminder.setIsSendMsg(sendMsg);
        if (sendMsg == 1) {
            taskReminder.setHtmlMsg(reminder.getHtmlMsg());
            taskReminder.setPlainMsg(reminder.getPlainMsg());
            taskReminder.setMsgCount(reminder.getMsgCount());
            taskReminder.setMsgType(reminder.getMsgType());
            taskReminder.setMsgInterval(reminder.getMsgInterval());
            taskReminder.setSendPerson(reminder.getSendPerson());
        }
        this.calcReminderDates(task, reminder, taskReminder);
    }

    void calcReminderDates(BpmDelegateTask task, Reminder reminder, BpmTaskReminder taskReminder) throws Exception {
        LocalDateTime relDate = null;
        String relNodeId = reminder.getRelNodeId();
        String relNodeEvent = reminder.getRelNodeEvent();
        boolean isRelCreateEvent = "create".equals(relNodeEvent);
        if (task.getTaskDefinitionKey().equals(relNodeId) && isRelCreateEvent) {
            relDate = task.getCreateTime();
        } else {
            List<DefaultBpmCheckOpinion> dpcOpinions = this.bpmCheckOpinionManager.getByInstNodeId(ContextThreadUtil.getActionCmd().getInstId(), relNodeId);
            if (BeanUtils.isEmpty(dpcOpinions)) {
                return;
            }
            DefaultBpmCheckOpinion dpcOpinion = dpcOpinions.get(dpcOpinions.size() - 1);
            if (isRelCreateEvent) {
                relDate = dpcOpinion.getCreateTime();
            } else {
                relDate = dpcOpinion.getCompleteTime();
                if (relDate == null) {
                    throw new RuntimeException("\u50ac\u529e\u76f8\u5bf9\u8282\u70b9\u4e0d\u80fd\u9009\u62e9\u540e\u7f6e\u6216\u5e73\u884c\u8282\u70b9");
                }
            }
        }
        if (relDate == null || TimeUtil.getTimeMillis((LocalDateTime)relDate) > TimeUtil.getTimeMillis((LocalDateTime)LocalDateTime.now()) + 2000L) {
            throw new RuntimeException("\u50ac\u529e\u63d2\u4ef6\u76f8\u5bf9\u65f6\u95f4\u8ba1\u7b97\u51fa\u73b0\u5f02\u5e38");
        }
        LocalDateTime msgBeginDate = null;
        List<BpmIdentity> list = task.getExecutors();
        if (BeanUtils.isEmpty(list)) {
            Map<String, Object> vars = task.getVariables();
            BpmIdentity taskExecutor = (BpmIdentity)vars.get("assignee");
            list.add(taskExecutor);
        }
        long sendTime = DateUtil.getCurrentTimeInMillis();
        long msgSendTime = DateUtil.getCurrentTimeInMillis();
        BpmIdentityExtractService bpmIdentityExtractService = (BpmIdentityExtractService)AppUtil.getBean(BpmIdentityExtractService.class);
        List<IUser> userList = bpmIdentityExtractService.extractUser(list);
        if (BeanUtils.isNotEmpty(userList)) {
            for (IUser item : userList) {
                LocalDateTime dueDate;
                if ("caltime".equals(reminder.getDateType())) {
                    dueDate = TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)1, (int)reminder.getDueTime(), (long)TimeUtil.getTimeMillis((LocalDateTime)relDate)));
                    if (reminder.getIsSendMsg().booleanValue()) {
                        msgBeginDate = TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)1, (int)reminder.getMsgSendTime(), (long)TimeUtil.getTimeMillis((LocalDateTime)relDate)));
                    }
                } else {
                    sendTime = this.ucFeignService.computeSendDate(item.getUserId(), (long)reminder.getDueTime().intValue());
                    dueDate = LocalDateTime.ofEpochSecond(sendTime / 1000L, 0, ZoneOffset.ofHours(8));
                    if (reminder.getIsSendMsg().booleanValue()) {
                        msgSendTime = this.ucFeignService.computeSendDate(item.getUserId(), (long)reminder.getMsgSendTime().intValue());
                    }
                    msgBeginDate = LocalDateTime.ofEpochSecond(msgSendTime / 1000L, 0, ZoneOffset.ofHours(8));
                }
                taskReminder.setDueDate(dueDate);
                taskReminder.setTriggerDate(dueDate);
                if (reminder.getIsSendMsg().booleanValue()) {
                    taskReminder.setMsgSendDate(msgBeginDate);
                    if (msgBeginDate.isBefore(dueDate)) {
                        taskReminder.setTriggerDate(msgBeginDate);
                    }
                }
                if (BeanUtils.isNotEmpty(reminder.getWarningSetList())) {
                    this.getWarningSet(reminder, task.getExecutors(), relDate, taskReminder);
                }
                taskReminder.setRelDate(relDate);
                taskReminder.setSendPerson("1");
                taskReminder.setSendUserId(item.getUserId());
                taskReminder.setId(UniqueIdUtil.getSuid());
                this.bpmTaskReminderManager.create((Model)taskReminder);
                this.createReminderHistory(taskReminder, "create");
            }
        }
    }

    private void getWarningSet(Reminder reminder, List<BpmIdentity> executors, LocalDateTime relDate, BpmTaskReminder taskReminder) throws Exception {
        ArrayNode warings = JsonUtil.getMapper().createArrayNode();
        for (WarningSet waringSet : reminder.getWarningSetList()) {
            ObjectNode jsonObject = (ObjectNode)JsonUtil.toJsonNode((Object)waringSet);
            LocalDateTime warnDate = null;
            int warnTime = jsonObject.get("warnTime").asInt();
            if ("caltime".equals(reminder.getDateType())) {
                warnDate = TimeUtil.getLocalDateTimeByMills((long)TimeUtil.getNextTime((int)1, (int)warnTime, (long)TimeUtil.getTimeMillis((LocalDateTime)relDate)));
            } else {
                ObjectNode params = JsonUtil.getMapper().createObjectNode();
                params.put("userId", executors.get(0).getId());
                if (BeanUtils.isNotEmpty((Object)relDate)) {
                    params.put("startTime", DateFormatUtil.formaDatetTime((LocalDateTime)relDate));
                }
                params.put("time", warnTime);
                String warnDateDateStr = this.portalFeignService.getEndTimeByUser(params);
                warnDate = DateFormatUtil.parse((String)warnDateDateStr);
            }
            if (taskReminder.getTriggerDate() == null || warnDate.isBefore(taskReminder.getTriggerDate())) {
                taskReminder.setTriggerDate(warnDate);
            }
            jsonObject.put("warnDate", TimeUtil.getDateTimeString((LocalDateTime)warnDate));
            warings.add((JsonNode)jsonObject);
        }
        taskReminder.setWarningset(warings.toString());
    }

    private Object executeScript(BpmTaskPluginSession pluginSession, String script) {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.putAll(pluginSession.getBpmDelegateTask().getVariables());
        Map<String, ObjectNode> boDatas = BpmContextUtil.getBoFromContext();
        vars.putAll(boDatas);
        return this.groovyScriptEngine.executeObject(script, vars);
    }

    private void createReminderHistory(BpmTaskReminder reminder, String type) {
        BpmReminderHistory history = new BpmReminderHistory();
        history.setExecuteDate(reminder.getDueDate());
        history.setRemindType(type);
        history.setNote("\u50ac\u529e\u521b\u5efa");
        history.setId(UniqueIdUtil.getSuid());
        history.setTaskId(reminder.getTaskId());
        this.bpmReminderHistoryManager.create((Model)history);
    }
}

