/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.task.tasknotify.plugin;

import com.hotent.base.util.AppUtil;
import com.hotent.bpm.api.constant.EventType;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.process.task.BpmTask;
import com.hotent.bpm.api.plugin.core.def.BpmTaskPluginDef;
import com.hotent.bpm.api.plugin.core.session.BpmTaskPluginSession;
import com.hotent.bpm.api.service.BpmTaskService;
import com.hotent.bpm.plugin.core.runtime.AbstractBpmTaskPlugin;
import com.hotent.bpm.plugin.task.tasknotify.def.TaskNotifyPluginDef;
import com.hotent.bpm.plugin.task.tasknotify.def.model.NotifyItem;
import com.hotent.bpm.plugin.task.tasknotify.def.model.NotifyVo;
import com.hotent.bpm.plugin.task.tasknotify.helper.NotifyHelper;
import com.hotent.bpm.util.PortalDataUtil;
import java.util.Map;
import java.util.Set;

public class TaskNotifyPlugin
extends AbstractBpmTaskPlugin {
    private NotifyHelper notifyHelper = (NotifyHelper)AppUtil.getBean(NotifyHelper.class);

    @Override
    public Void execute(BpmTaskPluginSession pluginSession, BpmTaskPluginDef pluginDef) throws Exception {
        String baseUrl = PortalDataUtil.getPropertyByAlias("baseUrl");
        String front = PortalDataUtil.getPropertyByAlias("frontBaseUrl");
        String manage = PortalDataUtil.getPropertyByAlias("manageBaseUrl");
        String mobile = PortalDataUtil.getPropertyByAlias("mobileBaseUrl");
        Map<String, Object> variables = pluginSession.getBpmDelegateTask().getVariables();
        variables.put("baseUrl", baseUrl);
        variables.put("manageBaseUrl", manage);
        variables.put("frontBaseUrl", front);
        variables.put("mobileBaseUrl", mobile);
        String procInstId = (String)variables.get("instanceId_");
        if (this.isSkip(procInstId, pluginSession.getBpmDelegateTask().getId())) {
            return null;
        }
        NotifyVo notifyVo = ((TaskNotifyPluginDef)pluginDef).getNotifyVos().get((Object)pluginSession.getEventType());
        if (notifyVo == null) {
            return null;
        }
        variables.put("nodeName", pluginSession.getBpmDelegateTask().getName());
        for (NotifyItem notifyItem : notifyVo.getNotifyItemList()) {
            if (notifyVo.getEventType().equals((Object)EventType.TASK_POST_CREATE_EVENT)) {
                this.notifyHelper.notify(notifyItem, "taskCreate", variables);
                continue;
            }
            if (!notifyVo.getEventType().equals((Object)EventType.TASK_COMPLETE_EVENT)) continue;
            this.notifyHelper.notify(notifyItem, "taskComplete", variables);
        }
        return null;
    }

    private boolean isSkip(String procInstId, String currentTaskId) throws Exception {
        boolean isSkip = false;
        Set<BpmTask> bpmTaskSet = ContextThreadUtil.getByInstId(procInstId);
        if (bpmTaskSet != null && bpmTaskSet.size() > 0) {
            BpmTask currentTask = null;
            for (BpmTask bpmTask : bpmTaskSet) {
                if (!bpmTask.getTaskId().equals(currentTaskId)) continue;
                currentTask = bpmTask;
                break;
            }
            BpmTaskService taskService = (BpmTaskService)AppUtil.getBean(BpmTaskService.class);
            taskService.setTaskSkip(currentTask);
        }
        return isSkip;
    }
}

