/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.usercalc.matrix.runtime;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.groovy.GroovyScriptEngine;
import com.hotent.base.model.HtJsonNodeFactory;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.constant.ExtractType;
import com.hotent.bpm.api.context.BpmContextUtil;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.api.plugin.core.def.BpmPluginDef;
import com.hotent.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.hotent.bpm.api.service.BoDataService;
import com.hotent.bpm.api.service.BpmInstService;
import com.hotent.bpm.model.identity.DefaultBpmIdentity;
import com.hotent.bpm.plugin.core.runtime.AbstractUserCalcPlugin;
import com.hotent.bpm.plugin.usercalc.matrix.def.MatrixPluginDef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;

public class MatrixPlugin
extends AbstractUserCalcPlugin {
    @Resource
    UCFeignService ucFeignService;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmInstService bpmInstService;

    @Override
    public List<BpmIdentity> queryByPluginDef(BpmUserCalcPluginSession pluginSession, BpmPluginDef pluginDef) {
        MatrixPluginDef def = (MatrixPluginDef)pluginDef;
        String matrixCode = def.getCode();
        String roleCode = def.getRoleCode();
        JsonNode params = def.getParams();
        ArrayList<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
        if (StringUtil.isEmpty((String)matrixCode) || StringUtil.isEmpty((String)roleCode)) {
            return identityList;
        }
        if (BeanUtils.isEmpty((Object)params)) {
            return identityList;
        }
        JsonNode matrixNode = this.ucFeignService.getMatrixByCode(matrixCode);
        if (BeanUtils.isEmpty((Object)matrixNode) || matrixNode.get("enabled").asInt() == 0) {
            return identityList;
        }
        try {
            Map<String, Object> varMap = this.initVarMap();
            String generateSql = this.generateSql(matrixCode, roleCode, (ArrayNode)params, varMap);
            List<ObjectNode> userList = this.queryMatrixData(generateSql);
            if (BeanUtils.isEmpty(userList)) {
                return identityList;
            }
            String outputCtrlType = this.getOutputCtrlType(roleCode, matrixNode);
            String userJson = JsonUtil.getStringIgnoreKey((JsonNode)((JsonNode)userList.get(0)), (String)("ROLE_" + roleCode), (String)"[]");
            ArrayNode userArr = JsonUtil.createArrayNode();
            if (StringUtil.isNotEmpty((String)userJson)) {
                userArr = (ArrayNode)JsonUtil.toJsonNode((String)userJson);
            }
            for (JsonNode user : userArr) {
                DefaultBpmIdentity identity;
                if ("user".equals(outputCtrlType)) {
                    identity = new DefaultBpmIdentity(user.get("id").asText(), user.get("fullname").asText(), "user");
                } else {
                    identity = new DefaultBpmIdentity(user.get("id").asText(), user.get("name").asText(), "group");
                    identity.setGroupType(outputCtrlType);
                }
                identityList.add(identity);
            }
            return this.extract(identityList, ExtractType.EXACT_EXACT_USER);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89d2\u8272\u77e9\u9635\u83b7\u53d6\u5ba1\u6279\u4eba\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    private String getOutputCtrlType(String roleCode, JsonNode matrixNode) {
        ArrayNode roleList = (ArrayNode)matrixNode.get("roleList");
        AtomicReference ctrlType = new AtomicReference();
        roleList.forEach(role -> {
            String code = JsonUtil.getString((JsonNode)role, (String)"code", (String)"");
            if (code.equals(roleCode)) {
                ctrlType.set(JsonUtil.getString((JsonNode)role, (String)"ctrlType", (String)""));
            }
        });
        return BeanUtils.isEmpty(ctrlType.get()) ? "user" : (String)ctrlType.get();
    }

    private Map<String, Object> initVarMap() throws Exception {
        HashMap<String, Object> varMap;
        block7: {
            ActionCmd cmd;
            block6: {
                Map<String, ObjectNode> boMap;
                varMap = new HashMap<String, Object>();
                cmd = ContextThreadUtil.getActionCmd();
                if (BeanUtils.isNotEmpty((Object)cmd)) {
                    varMap.putAll(cmd.getVariables());
                }
                if (BeanUtils.isEmpty(boMap = BpmContextUtil.getBoFromContext())) {
                    BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(varMap.get("instanceId_").toString());
                    List<ObjectNode> list = this.boDataService.getDataByInst(bpmProcessInstance);
                    BpmContextUtil.setBoToContext(list);
                    boMap = BpmContextUtil.getBoFromContext();
                }
                if (!BeanUtils.isNotEmpty(boMap)) break block6;
                for (Map.Entry entry : boMap.entrySet()) {
                    varMap.put((String)entry.getKey(), HtJsonNodeFactory.build().htObjectNode((ObjectNode)entry.getValue()));
                }
                break block7;
            }
            if (!BeanUtils.isNotEmpty((Object)cmd) || !BeanUtils.isNotEmpty((Object)cmd.getBusData())) break block7;
            try {
                JsonNode dataNode = JsonUtil.toJsonNode((String)cmd.getBusData());
                Iterator iterator = dataNode.fields();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    varMap.put((String)entry.getKey(), HtJsonNodeFactory.build().htObjectNode((ObjectNode)entry.getValue()));
                }
            }
            catch (Exception e) {
                System.out.println("\u89e3\u6790\u6d41\u7a0b\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return varMap;
    }

    private String generateSql(String matrixCode, String roleCode, ArrayNode params, Map<String, Object> varMap) {
        String resultField = "role_" + roleCode;
        StringBuilder sql = new StringBuilder("select " + resultField + " from UC_MATRIX_" + matrixCode + " where 1=1 ");
        GroovyScriptEngine scriptEngine = (GroovyScriptEngine)AppUtil.getBean(GroovyScriptEngine.class);
        for (JsonNode jsonNode : params) {
            String valueType = jsonNode.get("valueType").asText();
            String value = jsonNode.get("value").asText();
            String code = jsonNode.get("code").asText();
            if ("0".equals(valueType)) {
                value = scriptEngine.executeString(value, varMap);
                sql.append(String.format(" and CONDK_%s = '%s'", code, value));
                continue;
            }
            if ("1".equals(valueType)) {
                sql.append(String.format(" and CONDK_%s = '%s'", code, value));
                continue;
            }
            if (!"2".equals(valueType)) continue;
            sql.append(String.format(" and (CONDK_%s is null or CONDK_%s = '' )", code, code));
        }
        return sql.toString();
    }

    private List<ObjectNode> queryMatrixData(String sql) throws IOException {
        String base64 = Base64.getBase64((String)sql);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sql", base64);
        ArrayNode userList = this.ucFeignService.getMatrixRoleUsers(map);
        return JsonUtil.arrayToList((ArrayNode)userList);
    }
}

