/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.plugin.usercalc.org.runtime;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.ExtractType;
import com.hotent.bpm.api.model.identity.BpmIdentity;
import com.hotent.bpm.api.plugin.core.def.BpmPluginDef;
import com.hotent.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.hotent.bpm.plugin.core.runtime.AbstractUserCalcPlugin;
import com.hotent.bpm.plugin.usercalc.org.def.OrgPluginDef;
import com.hotent.uc.api.constant.GroupTypeConstant;
import com.hotent.uc.api.model.IGroup;
import com.hotent.uc.api.service.IOrgService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OrgPlugin
extends AbstractUserCalcPlugin {
    @Override
    public List<BpmIdentity> queryByPluginDef(BpmUserCalcPluginSession pluginSession, BpmPluginDef pluginDef) {
        List<BpmIdentity> identityList = new ArrayList<BpmIdentity>();
        OrgPluginDef def = (OrgPluginDef)pluginDef;
        String orgCode = def.getOrgCode();
        if (StringUtil.isEmpty((String)orgCode)) {
            return identityList;
        }
        String[] orgCodes = orgCode.split(",");
        IOrgService orgEngine = pluginSession.getOrgEngine();
        List groups = orgEngine.getUserGroupService().getGroupsByIdsOrCodes(GroupTypeConstant.ORG.key(), Stream.of(orgCodes).collect(Collectors.toList()));
        if (BeanUtils.isEmpty((Object)groups)) {
            return identityList;
        }
        for (IGroup group : groups) {
            BpmIdentity bpmIdentity = this.getBpmIdentityConverter().convertGroup(group);
            bpmIdentity.setType("group");
            bpmIdentity.setGroupType("org");
            identityList.add(bpmIdentity);
            Boolean currLevelOrSubLevel = def.getCurrLevelOrSubLevel();
            if (!currLevelOrSubLevel.booleanValue()) continue;
            this.getAndSetSubGroup(orgEngine, identityList, group.getGroupId());
        }
        if (ExtractType.EXACT_EXACT_USER.equals((Object)def.getExtract())) {
            identityList = this.extract(identityList, ExtractType.EXACT_EXACT_USER);
        }
        return identityList;
    }

    private void getAndSetSubGroup(IOrgService orgEngine, List<BpmIdentity> identityList, String parentId) {
        List subGroups = orgEngine.getUserGroupService().getSubGroupByIdOrCode(parentId);
        if (BeanUtils.isEmpty((Object)subGroups)) {
            return;
        }
        for (IGroup subGroup : subGroups) {
            if (BeanUtils.isEmpty((Object)subGroup)) continue;
            BpmIdentity bpmIdentity = this.getBpmIdentityConverter().convertGroup(subGroup);
            bpmIdentity.setType("group");
            bpmIdentity.setGroupType("org");
            identityList.add(bpmIdentity);
        }
    }
}

