/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.util;

import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.jms.JmsActor;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.jms.Notice;
import com.hotent.base.jms.NoticeMessageType;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.BaseActionCmd;
import com.hotent.bpm.api.event.NodeNotifyEvent;
import com.hotent.bpm.api.event.NodeNotifyModel;
import com.hotent.bpm.api.event.NotifyTaskModel;
import com.hotent.bpm.api.model.process.inst.BpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmProcessInstance;
import com.hotent.bpm.persistence.model.DefaultBpmTask;
import com.hotent.bpm.util.BpmUtil;
import com.hotent.bpm.util.PortalDataUtil;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationEvent;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MessageUtil {
    private static final String sysCode = "sysCode";

    public static Map<String, String> getHandlerTypes() {
        HashMap<String, String> map = new HashMap<String, String>();
        EnumSet<NoticeMessageType> it = EnumSet.allOf(NoticeMessageType.class);
        for (NoticeMessageType type : it) {
            map.put(type.key(), type.label());
        }
        return map;
    }

    public static boolean isSupportHtml(String notifyType) {
        EnumSet<NoticeMessageType> it = EnumSet.allOf(NoticeMessageType.class);
        for (NoticeMessageType type : it) {
            if (!type.key().equals(notifyType)) continue;
            return type.isPlain() == false;
        }
        return false;
    }

    public static NoticeMessageType[] parseNotifyType(List<String> nofifyTypes) {
        ArrayList<NoticeMessageType> messageTypeArrays = new ArrayList<NoticeMessageType>();
        EnumSet<NoticeMessageType> it = EnumSet.allOf(NoticeMessageType.class);
        for (NoticeMessageType type : it) {
            if (nofifyTypes.indexOf(type.key()) <= -1) continue;
            messageTypeArrays.add(type);
        }
        NoticeMessageType[] messageTypes = new NoticeMessageType[messageTypeArrays.size()];
        messageTypeArrays.toArray(messageTypes);
        return messageTypes;
    }

    public static NoticeMessageType[] parseNotifyType(String notifyType) {
        if (notifyType == null) {
            notifyType = "";
        }
        String[] arys = notifyType.split(",");
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(arys));
        return MessageUtil.parseNotifyType(list);
    }

    public static String[] parseAccountOfUser(List<IUser> users) {
        ArrayList<String> receiverAccounts = new ArrayList<String>();
        for (IUser receiver : users) {
            if (StringUtil.isEmpty((String)receiver.getAccount()) && StringUtil.isNotEmpty((String)receiver.getUserId())) {
                receiverAccounts.add(receiver.getUserId());
                continue;
            }
            receiverAccounts.add(receiver.getAccount());
        }
        String[] receivers = new String[receiverAccounts.size()];
        receiverAccounts.toArray(receivers);
        return receivers;
    }

    public static void notify(DefaultBpmTask bpmTask, String opinion, IUser receiver, String notifyType, String typeKey) throws Exception {
        if (BeanUtils.isNotEmpty((Object)bpmTask) && StringUtil.isEmpty((String)notifyType)) {
            notifyType = BpmUtil.getNotifyType(bpmTask);
        }
        NotifyTaskModel model = new NotifyTaskModel();
        String baseUrl = PortalDataUtil.getPropertyByAlias("baseUrl");
        String front = PortalDataUtil.getPropertyByAlias("frontBaseUrl");
        String manage = PortalDataUtil.getPropertyByAlias("manageBaseUrl");
        String mobile = PortalDataUtil.getPropertyByAlias("mobileBaseUrl");
        model.addVars("baseUrl", baseUrl).addVars("taskSubject", bpmTask.getSubject()).addVars("instSubject", bpmTask.getSubject()).addVars("taskId", bpmTask.getId()).addVars("nodeName", bpmTask.getName()).addVars("cause", opinion).addVars("nodeName", bpmTask.getName()).addVars("receiverId", receiver.getUserId()).addVars("receiver", receiver.getFullname()).addVars("frontBaseUrl", front).addVars("manageBaseUrl", manage).addVars("mobileBaseUrl", mobile);
        ArrayList<IUser> identitys = new ArrayList<IUser>();
        identitys.add(receiver);
        model.setIdentitys(identitys);
        MessageUtil.send(model, notifyType, typeKey);
    }

    private static Map<String, Object> getVars(BpmProcessInstance instance, String opinion) {
        String baseUrl = PortalDataUtil.getPropertyByAlias("baseUrl");
        String front = PortalDataUtil.getPropertyByAlias("frontBaseUrl");
        String manage = PortalDataUtil.getPropertyByAlias("manageBaseUrl");
        String mobile = PortalDataUtil.getPropertyByAlias("mobileBaseUrl");
        IUser user = ContextUtil.getCurrentUser();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("delegate", BeanUtils.isNotEmpty((Object)user) ? user.getFullname() : "\u7cfb\u7edf\u6267\u884c\u4eba");
        map.put("taskSubject", instance.getSubject());
        map.put("instSubject", instance.getSubject());
        map.put("baseUrl", baseUrl);
        map.put("manageBaseUrl", manage);
        map.put("frontBaseUrl", front);
        map.put("mobileBaseUrl", mobile);
        map.put("cause", opinion);
        map.put("instId", instance.getId());
        return map;
    }

    public static void sendMsg(String typeKey, String notifyType, List<IUser> recievers, DefaultBpmProcessInstance processInstance, String opinion) throws Exception {
        MessageUtil.sendMsg(typeKey, notifyType, recievers, MessageUtil.getVars(processInstance, opinion));
    }

    public static void send(NotifyTaskModel model, String notifyType, String typeKey) throws Exception {
        List<Object> userList = model.getIdentitys();
        if (!CollectionUtils.isEmpty(userList)) {
            userList = userList.stream().distinct().collect(Collectors.toList());
        }
        MessageUtil.sendMsg(typeKey, notifyType, userList, model.getVars());
    }

    public static void sendMsg(String typeKey, String notifyType, List<IUser> recievers, Map<String, Object> vars) throws Exception {
        if (StringUtils.isEmpty((Object)notifyType)) {
            return;
        }
        NoticeMessageType[] messageTypes = MessageUtil.parseNotifyType(notifyType);
        List<JmsActor> recieverAccounts = MessageUtil.parseJmsActor(recievers);
        IUser sender = ContextUtil.getCurrentUser();
        vars.put("sender", BeanUtils.isNotEmpty((Object)sender) ? sender.getFullname() : "\u7cfb\u7edf\u6267\u884c\u4eba");
        vars.put("senderId", BeanUtils.isNotEmpty((Object)sender) ? sender.getUserId() : "-1");
        if (recievers.size() == 1) {
            vars.put("receiver", recievers.get(0).getFullname());
        }
        Notice notice = new Notice();
        notice.setUseTemplate(true);
        notice.setMessageTypes(messageTypes);
        notice.setSender(sender.getAccount());
        notice.setSenderId(sender.getUserId());
        notice.setTemplateType(typeKey);
        notice.setVars(vars);
        notice.setReceiver(recieverAccounts);
        JmsProducer jmsProducer = (JmsProducer)AppUtil.getBean(JmsProducer.class);
        jmsProducer.sendToQueue((Object)notice);
        if (vars.get(sysCode) != null) {
            PortalFeignService feignService = (PortalFeignService)AppUtil.getBean(PortalFeignService.class);
            feignService.sendMsgToExternalQueue(notice, (String)vars.get(sysCode));
        }
    }

    public static List<JmsActor> parseJmsActor(List<IUser> users) {
        ArrayList<JmsActor> actors = new ArrayList<JmsActor>();
        for (IUser user : users) {
            JmsActor actor = new JmsActor();
            actor.setId(user.getUserId());
            actor.setAccount(user.getAccount());
            actor.setName(user.getFullname());
            actor.setEmail(user.getEmail());
            actor.setMobile(user.getMobile());
            actor.setWeixin(user.getWeixin());
            actor.setClientId(user.getClientId());
            actor.setClientToken(user.getClientToken());
            actors.add(actor);
        }
        return actors;
    }

    public static void sendMsgNoTemplate(String notifyType, List<IUser> recievers, String subject, String content) throws Exception {
        if (StringUtils.isEmpty((Object)notifyType)) {
            return;
        }
        NoticeMessageType[] messageTypes = MessageUtil.parseNotifyType(notifyType);
        List<JmsActor> recieverAccounts = MessageUtil.parseJmsActor(recievers);
        IUser sender = ContextUtil.getCurrentUser();
        Notice notice = new Notice();
        notice.setUseTemplate(false);
        notice.setVars(new HashMap());
        notice.setSubject(subject);
        notice.setContent(content);
        notice.setMessageTypes(messageTypes);
        notice.setSender(sender.getAccount());
        notice.setReceiver(recieverAccounts);
        JmsProducer jmsProducer = (JmsProducer)AppUtil.getBean(JmsProducer.class);
        jmsProducer.sendToQueue((Object)notice);
    }

    public static void sendNodeBtnNotify(String btnName, String nodeId, String procInstId, String busData, ActionCmd cmd) throws Exception {
        NodeNotifyModel model = new NodeNotifyModel(btnName, nodeId, procInstId);
        if (BeanUtils.isEmpty((Object)cmd) && StringUtil.isNotEmpty((String)busData)) {
            cmd = new BaseActionCmd();
            cmd.setBusData(busData);
        }
        model.setActionCmd(cmd);
        model.setJustBtn(true);
        NodeNotifyEvent ev = new NodeNotifyEvent(model);
        AppUtil.publishEvent((ApplicationEvent)ev);
    }
}

