/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.api.context;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.model.HtJsonNodeFactory;
import com.hotent.base.util.BeanUtils;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.cmd.BaseActionCmd;
import com.hotent.bpm.api.context.ContextThreadUtil;
import com.hotent.bpm.util.BoDataUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BpmContextUtil {
    public static Map<String, ObjectNode> getBoFromContext() {
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        HashMap<String, ObjectNode> map = new HashMap<String, ObjectNode>();
        if (cmd == null || cmd.getTransitVars("bo_inst_") == null) {
            return map;
        }
        Map boDatas = (Map)cmd.getTransitVars("bo_inst_");
        for (Map.Entry next : boDatas.entrySet()) {
            ObjectNode obj = (ObjectNode)next.getValue();
            if (obj.hasNonNull("data") && obj.get("data") instanceof ObjectNode) {
                obj = (ObjectNode)obj.get("data");
            }
            map.put((String)next.getKey(), (ObjectNode)HtJsonNodeFactory.build().htObjectNode(obj));
        }
        return map;
    }

    public static void setBoToContext(List<ObjectNode> boDatas) throws Exception {
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        if (BeanUtils.isEmpty((Object)cmd)) {
            cmd = new BaseActionCmd();
            ContextThreadUtil.setActionCmd(cmd);
        }
        cmd.addTransitVars("bo_inst_", BoDataUtil.converBodataListToMap(boDatas));
    }

    public static void setBoToThreadContext(List<ObjectNode> boDatas) throws Exception {
        HashMap<String, ObjectNode> boMap = new HashMap<String, ObjectNode>();
        for (ObjectNode data : boDatas) {
            JsonNode jsonNode;
            String code = data.get("boDefAlias").asText();
            boMap.put(code, data);
            if (!data.has("data") || !(jsonNode = data.get("data")).isObject()) continue;
            boMap.put(code, (ObjectNode)jsonNode);
        }
        ContextThreadUtil.setBoDataThreadLocal(boMap);
    }

    public static Map<String, ObjectNode> getBoFromThreadContext() {
        if (ContextThreadUtil.getBoDataThreadLocal() != null) {
            return ContextThreadUtil.getBoDataThreadLocal().get();
        }
        return new HashMap<String, ObjectNode>();
    }

    public static void clearBoInThreadContext() {
        if (ContextThreadUtil.getBoDataThreadLocal() != null) {
            ContextThreadUtil.getBoDataThreadLocal().remove();
        }
    }
}

