/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.api.context;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ContextThread;
import com.hotent.bpm.api.cmd.ActionCmd;
import com.hotent.bpm.api.model.process.task.BpmTask;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class ContextThreadUtil
implements ContextThread {
    private static ThreadLocal<ActionCmd> actionCmdLocal = new ThreadLocal();
    private static ThreadLocal<Map<String, Object>> commuVars = new ThreadLocal();
    private static ThreadLocal<Map<String, Set<BpmTask>>> tasksMap = new ThreadLocal();
    private static ThreadLocal<Map<String, ObjectNode>> boDataThreadLocal = new ThreadLocal();
    private static ThreadLocal<Map<String, Object>> cmdDataThreadLocal = new ThreadLocal();
    private static ThreadLocal<Map<String, Object>> REVOKE_VARS = new ThreadLocal();
    private static ThreadLocal<Map<String, Object>> newVars = new ThreadLocal();

    public static Map<String, Object> getNewVars() {
        return newVars.get();
    }

    public static void setNewVars(Map<String, Object> newVars_) {
        newVars.set(newVars_);
    }

    public static void clearNewVars() {
        newVars.remove();
    }

    public static Object getNewVars(String key) {
        Map<String, Object> vars = newVars.get();
        if (BeanUtils.isNotEmpty(vars) && vars.containsKey(key)) {
            return vars.get(key);
        }
        return null;
    }

    public static void setNewVars(String key, Object value) {
        Map<String, Object> vars = newVars.get();
        if (BeanUtils.isEmpty(vars)) {
            vars = new HashMap<String, Object>();
        }
        vars.put(key, value);
        newVars.set(vars);
    }

    public static void clearNewVars(String key) {
        Map<String, Object> vars = newVars.get();
        if (BeanUtils.isNotEmpty(vars) && vars.containsKey(key)) {
            vars.remove(key);
        }
    }

    public static void setCommuVars(Map<String, Object> commuVars_) {
        commuVars.set(commuVars_);
    }

    public static Map<String, Object> getCommuVars() {
        if (commuVars.get() == null) {
            ContextThreadUtil.setCommuVars(new HashMap<String, Object>());
        }
        return commuVars.get();
    }

    public static Object getCommuVar(String key, Object defaultValue) {
        Map<String, Object> map;
        if (commuVars.get() == null) {
            ContextThreadUtil.setCommuVars(new HashMap<String, Object>());
        }
        if ((map = commuVars.get()).containsKey(key)) {
            return map.get(key);
        }
        return defaultValue;
    }

    public static void putCommonVars(String key, Object value) {
        Map<String, Object> vars = ContextThreadUtil.getCommuVars();
        vars.put(key, value);
    }

    public static void cleanCommuVars() {
        commuVars.remove();
    }

    public static void setActionCmd(ActionCmd cmd) {
        actionCmdLocal.set(cmd);
    }

    public static ActionCmd getActionCmd() {
        return actionCmdLocal.get();
    }

    public static void addTask(BpmTask task) {
        Map<String, Set<BpmTask>> map = tasksMap.get();
        if (map == null) {
            map = new HashMap<String, Set<BpmTask>>();
            HashSet<BpmTask> set = new HashSet<BpmTask>();
            set.add(task);
            map.put(task.getProcInstId(), set);
            tasksMap.set(map);
        } else if (map.containsKey(task.getProcInstId())) {
            Set<BpmTask> set = map.get(task.getProcInstId());
            if (set.contains(task)) {
                set.remove(task);
                set.add(task);
            } else {
                set.add(task);
            }
        } else {
            HashSet<BpmTask> set = new HashSet<BpmTask>();
            set.add(task);
            map.put(task.getProcInstId(), set);
        }
    }

    public static Set<BpmTask> getByInstId(String instId) {
        Map<String, Set<BpmTask>> map = tasksMap.get();
        if (map == null) {
            return null;
        }
        if (map.get(instId) == null) {
            return null;
        }
        return map.get(instId);
    }

    public static Map<String, Set<BpmTask>> getTaskMap() {
        return tasksMap.get();
    }

    public static void clearTaskMap() {
        tasksMap.remove();
    }

    public static void clearTaskByInstId(String instId) {
        Map<String, Set<BpmTask>> map = tasksMap.get();
        if (map == null) {
            return;
        }
        map.remove(instId);
    }

    public static ThreadLocal<Map<String, ObjectNode>> getBoDataThreadLocal() {
        return boDataThreadLocal;
    }

    public static void setBoDataThreadLocal(Map<String, ObjectNode> calcCmdLocal_) {
        boDataThreadLocal.set(calcCmdLocal_);
    }

    public static Map<String, Object> getCmdDataThreadLocal() {
        return cmdDataThreadLocal.get();
    }

    public static void setCmdDataThreadLocal(Map<String, Object> cmdDataThreadLocal_) {
        cmdDataThreadLocal.set(cmdDataThreadLocal_);
    }

    public static void clearCmdDataThreadLocal() {
        cmdDataThreadLocal.remove();
    }

    public static void setNewVars(String s, String nodeId) {
    }

    public static void putRevokeVars(String key, Object value) {
        Map<String, Object> vars = REVOKE_VARS.get();
        if (BeanUtils.isEmpty(vars)) {
            vars = new HashMap<String, Object>(16);
        }
        vars.put(key, value);
        REVOKE_VARS.set(vars);
    }

    public static Object getRevokeVars(String key, String defaultValue) {
        Map<String, Object> map;
        if (REVOKE_VARS.get() == null) {
            ContextThreadUtil.setRevokeVars(new HashMap<String, Object>(16));
        }
        if ((map = REVOKE_VARS.get()).containsKey(key)) {
            return map.get(key);
        }
        return defaultValue;
    }

    public static void setRevokeVars(Map<String, Object> vars) {
        REVOKE_VARS.set(vars);
    }

    public void cleanAll() {
        actionCmdLocal.remove();
        commuVars.remove();
        tasksMap.remove();
        boDataThreadLocal.remove();
        REVOKE_VARS.remove();
    }
}

