/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.bpm.chart.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.bpm.api.constant.OpinionStatus;
import com.hotent.bpm.chart.IChart;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component(value="handle_efficiency")
public class HandleEfficiencyChart
implements IChart {
    @Override
    public String getQuerySql(String flowType, String dimension, String ids, String orgIds, String startTime, String endTime, String orgType, String dbType) {
        String[] idArray;
        String idCode;
        StringBuilder sql = new StringBuilder();
        String whereIds = "org".equals(dimension) ? ids : orgIds;
        StringBuilder whereSql = new StringBuilder();
        String string = idCode = "2".equals(orgType) ? "CREATE_BY_" : "CREATE_ORG_ID_";
        if ("oracle".equals(dbType)) {
            whereSql.append(" AND opinion.STATUS_ IS NOT NULL AND opinion.COMPLETE_TIME_ between to_date('" + startTime + "','YYYY-MM-DD HH24:MI:SS') and to_date('" + endTime + "','YYYY-MM-DD HH24:MI:SS')");
        } else {
            whereSql.append(" AND opinion.STATUS_ IS NOT NULL AND opinion.COMPLETE_TIME_>='" + startTime + "' AND opinion.COMPLETE_TIME_<='" + endTime + "' ");
        }
        if (StringUtil.isNotEmpty((String)whereIds)) {
            idArray = whereIds.split(",");
            if ("org".equals(dimension)) {
                if ("1".equals(flowType)) {
                    whereSql.append(" AND " + StringUtil.idsInSql((String[])idArray, (String)"inst.PROC_DEF_ID_"));
                } else if ("2".equals(flowType)) {
                    whereSql.append(" AND " + StringUtil.idsInSql((String[])idArray, (String)"inst.TYPE_ID_"));
                }
            } else {
                idCode = !"2".equals(orgType) ? "ORG_ID_" : "AUDITOR_";
                whereSql.append(" AND " + StringUtil.idsInSql((String[])idArray, (String)("opinion." + idCode)));
            }
        }
        if (StringUtil.isNotEmpty((String)orgIds) && "org".equals(dimension)) {
            String[] orgIdArray = orgIds.split(",");
            boolean isFirst = false;
            for (String id : orgIdArray) {
                if (!isFirst) {
                    isFirst = true;
                } else {
                    sql.append(" UNION ");
                }
                String baseSql = this.getBaseSql(id, flowType, dimension, whereSql.toString(), orgType, dbType);
                sql.append(baseSql);
            }
        } else if (StringUtil.isNotEmpty((String)ids) && "flow".equals(dimension)) {
            idArray = ids.split(",");
            boolean isFirst = false;
            for (String id : idArray) {
                if (!isFirst) {
                    isFirst = true;
                } else {
                    sql.append(" UNION ");
                }
                String baseSql = this.getBaseSql(id, flowType, dimension, whereSql.toString(), orgType, dbType);
                sql.append(baseSql);
            }
        } else {
            String baseSql = this.getBaseSql("", flowType, dimension, whereSql.toString(), orgType, dbType);
            sql.append(baseSql);
        }
        return sql.toString();
    }

    private String getBaseSql(String orgId, String flowType, String dimension, String whereSql, String orgType, String dbType) {
        String orgSql = this.getOrgSql(flowType, orgType, orgId, dimension);
        String havingSql = " having count(1) >0 ";
        if ("oracle".equals(dbType) || "postgresql".equals(dbType) || "kingbasees".equals(dbType)) {
            String idCode = "2".equals(orgType) ? "AUDITOR_" : "ORG_ID_";
            String groupBySql = " GROUP BY opinion." + idCode;
            if ("flow".equals(dimension)) {
                groupBySql = "1".equals(flowType) ? " GROUP BY inst.PROC_DEF_ID_  " : " GROUP BY inst.TYPE_ID_ ";
            }
            havingSql = groupBySql + " having count(1) >0 ";
        }
        HashMap<String, String[]> statusMap = new HashMap<String, String[]>(4);
        statusMap.put("average", new String[]{"*"});
        statusMap.put("approval", new String[]{OpinionStatus.AGREE.getKey(), OpinionStatus.OPPOSE.getKey(), OpinionStatus.ABANDON.getKey(), OpinionStatus.REJECT.getKey()});
        statusMap.put("feedback", new String[]{OpinionStatus.FEEDBACK.getKey()});
        statusMap.put("deliverto", new String[]{OpinionStatus.DELIVERTO_AGREE.getKey(), OpinionStatus.DELIVERTO_OPPOSE.getKey()});
        StringBuilder baseSql = new StringBuilder();
        for (Map.Entry row : statusMap.entrySet()) {
            StringBuilder otherSql = new StringBuilder();
            otherSql.append(this.getApprovalSelectSql(flowType, orgType, dimension, "bpm_check_opinion_hi", (String)row.getKey()));
            if (!"*".equals(((String[])row.getValue())[0])) {
                otherSql.append(" and opinion.STATUS_ IN ('").append(String.join((CharSequence)"', '", (CharSequence[])row.getValue())).append("') ");
            }
            otherSql.append(orgSql);
            otherSql.append(whereSql);
            otherSql.append(havingSql);
            otherSql.append(" UNION ");
            otherSql.append(this.getApprovalSelectSql(flowType, orgType, dimension, "bpm_check_opinion", (String)row.getKey()));
            if (!"*".equals(((String[])row.getValue())[0])) {
                otherSql.append(" and opinion.STATUS_ IN ('").append(String.join((CharSequence)"', '", (CharSequence[])row.getValue())).append("') ");
            }
            otherSql.append(orgSql);
            otherSql.append(whereSql);
            otherSql.append(havingSql);
            if (!baseSql.toString().isEmpty()) {
                baseSql.append(" UNION ");
            }
            baseSql.append(" select SUM(a.count) as count, SUM(a.totalTime) AS durMs, a.id as id,'" + (String)row.getKey() + "' as status from ( ");
            baseSql.append(otherSql.toString());
            baseSql.append(" ) a ");
            if (!"oracle".equals(dbType) && !"postgresql".equals(dbType) && !"kingbasees".equals(dbType)) continue;
            baseSql.append(" GROUP BY a.id ");
        }
        return baseSql.toString();
    }

    private String getOrgSql(String flowType, String orgType, String orgId, String dimension) {
        String orgSql;
        String idCode = "2".equals(orgType) ? "AUDITOR_" : "ORG_ID_";
        String string = orgSql = StringUtil.isNotEmpty((String)orgId) ? " AND opinion." + idCode + " ='" + orgId + "' " : " ";
        if ("flow".equals(dimension)) {
            orgSql = "1".equals(flowType) ? (StringUtil.isNotEmpty((String)orgId) ? " AND inst.PROC_DEF_ID_ ='" + orgId + "' " : " ") : (StringUtil.isNotEmpty((String)orgId) ? " AND inst.TYPE_ID_ ='" + orgId + "' " : " ");
        }
        return orgSql;
    }

    private String getApprovalSelectSql(String flowType, String orgType, String dimension, String table, String status) {
        String idCode = "2".equals(orgType) ? "AUDITOR_" : "ORG_ID_";
        String selectSql = "select count(1) as count,opinion." + idCode + " as id, SUM(opinion.DUR_MS_) AS totalTime, '" + status + "' as status FROM " + table + " opinion LEFT JOIN bpm_pro_inst inst on opinion.PROC_INST_ID_=inst.ID_ where opinion." + idCode + " is not null ";
        if ("flow".equals(dimension)) {
            selectSql = "1".equals(flowType) ? "select count(1) as count,inst.PROC_DEF_ID_ as id, SUM(opinion.DUR_MS_) AS totalTime, '" + status + "' as status FROM " + table + " opinion LEFT JOIN bpm_pro_inst inst on opinion.PROC_INST_ID_=inst.ID_ where 1=1 " : "select count(1) as count,inst.TYPE_ID_ as id, SUM(opinion.DUR_MS_) AS totalTime, '" + status + "' as status FROM " + table + " opinion LEFT JOIN bpm_pro_inst inst on opinion.PROC_INST_ID_=inst.ID_ where 1=1 ";
        }
        return selectSql;
    }

    @Override
    public String getDesc() {
        return "\u529e\u4ef6\u6548\u7387";
    }

    @Override
    public List<String> getLegend() {
        return Arrays.asList("\u529e\u4ef6\u5e73\u5747\u8017\u65f6\uff08\u5c0f\u65f6\uff09", "\u5ba1\u6279\u5e73\u5747\u8017\u65f6\uff08\u5c0f\u65f6\uff09", "\u6c9f\u901a\u5e73\u5747\u8017\u65f6\uff08\u5c0f\u65f6\uff09", "\u8f6c\u529e\u5e73\u5747\u8017\u65f6\uff08\u5c0f\u65f6\uff09");
    }

    @Override
    public ArrayNode getSeries(List<String> legend, List<Map<String, Object>> selectList, Map<String, String> map) throws Exception {
        ArrayNode array = JsonUtil.getMapper().createArrayNode();
        String defType = "bar";
        for (String le : legend) {
            ObjectNode node = JsonUtil.getMapper().createObjectNode();
            node.put("name", le);
            node.put("type", defType);
            List<Object> data = this.getSeriesData(le, selectList, map);
            node.set("data", JsonUtil.toJsonNode(data));
            array.add((JsonNode)node);
        }
        return array;
    }

    private List<Object> getSeriesData(String le, List<Map<String, Object>> selectList, Map<String, String> map) throws Exception {
        ArrayList<Object> data = new ArrayList<Object>();
        String status = this.getLegendCode(le);
        for (String key : map.keySet()) {
            double isValue = 0.0;
            long durMs = 0L;
            for (Map<String, Object> obj : selectList) {
                if (!BeanUtils.isNotEmpty(obj)) continue;
                ObjectNode oNode = (ObjectNode)JsonUtil.toJsonNode(obj);
                if (BeanUtils.isNotEmpty((Object)oNode.get("id")) && key.equals(oNode.get("id").asText()) && status.equals(oNode.get("status").asText())) {
                    JsonNode countNode = Optional.ofNullable(oNode.get("count")).orElse(oNode.get("COUNT"));
                    double count = BeanUtils.isNotEmpty((Object)countNode) ? countNode.asDouble() : 0.0;
                    isValue += count;
                } else if (BeanUtils.isNotEmpty((Object)oNode.get("ID")) && key.equals(oNode.get("ID").asText()) && status.equals(oNode.get("STATUS").asText())) {
                    double count = BeanUtils.isNotEmpty((Object)oNode.get("COUNT")) ? oNode.get("COUNT").asDouble() : 0.0;
                    isValue += count;
                }
                if (BeanUtils.isNotEmpty((Object)oNode.get("durMs")) && oNode.get("id") != null && key.equals(oNode.get("id").asText()) && oNode.get("status") != null && status.equals(oNode.get("status").asText())) {
                    durMs += oNode.get("durMs").asLong();
                    continue;
                }
                if (!BeanUtils.isNotEmpty((Object)oNode.get("DURMS")) || oNode.get("ID") == null || !key.equals(oNode.get("ID").asText()) || oNode.get("STATUS") == null || !status.equals(oNode.get("STATUS").asText())) continue;
                durMs += oNode.get("DURMS").asLong();
            }
            if (isValue > 0.0 && durMs > 0L) {
                BigDecimal b1 = new BigDecimal(Double.toString((double)durMs / isValue));
                BigDecimal b2 = new BigDecimal(Double.toString(3600000.0));
                double num = b1.divide(b2, 2, 4).doubleValue();
                data.add(num);
                continue;
            }
            data.add(0);
        }
        return data;
    }

    private String getLegendCode(String desc) {
        String status;
        switch (desc) {
            case "\u529e\u4ef6\u5e73\u5747\u8017\u65f6\uff08\u5c0f\u65f6\uff09": {
                status = "average";
                break;
            }
            case "\u5ba1\u6279\u5e73\u5747\u8017\u65f6\uff08\u5c0f\u65f6\uff09": {
                status = "approval";
                break;
            }
            case "\u6c9f\u901a\u5e73\u5747\u8017\u65f6\uff08\u5c0f\u65f6\uff09": {
                status = "feedback";
                break;
            }
            case "\u8f6c\u529e\u5e73\u5747\u8017\u65f6\uff08\u5c0f\u65f6\uff09": {
                status = "deliverto";
                break;
            }
            default: {
                status = "";
            }
        }
        return status;
    }
}

